/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.point;

import com.tridium.rdb.BResultSetTable;
import java.util.HashMap;
import javax.baja.collection.Column;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.point.BRdbmsPointFolder;
import javax.baja.rdb.point.BRdbmsProxyExt;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BRdbmsPointQuery
extends BRdbmsPointFolder {
    public static final Property status = BRdbmsPointQuery.newProperty((int)3, (BValue)BStatus.nullStatus, null);
    public static final Property faultCause = BRdbmsPointQuery.newProperty((int)3, (String)"", null);
    public static final Property enabled = BRdbmsPointQuery.newProperty((int)0, (boolean)true, null);
    public static final Property updateFrequency = BRdbmsPointQuery.newProperty((int)0, (BValue)BRelTime.HOUR, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    public static final Property lastUpdate = BRdbmsPointQuery.newProperty((int)3, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Property sql = BRdbmsPointQuery.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property keyColumn1 = BRdbmsPointQuery.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"rdb:RdbmsColumnNamePickerFE"));
    public static final Property keyColumn2 = BRdbmsPointQuery.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"rdb:RdbmsColumnNamePickerFE"));
    public static final Action execute = BRdbmsPointQuery.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$point$BRdbmsPointQuery == null ? (class$javax$baja$rdb$point$BRdbmsPointQuery = BRdbmsPointQuery.class$("javax.baja.rdb.point.BRdbmsPointQuery")) : class$javax$baja$rdb$point$BRdbmsPointQuery));
    private Clock.Ticket updateTicket;
    private static final BIcon icon = BIcon.std((String)"widgets/table.png");
    private Column[] resultColumns;
    HashMap pollGroup = new HashMap();
    static /* synthetic */ Class class$javax$baja$rdb$point$BRdbmsPointQuery;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BRelTime getUpdateFrequency() {
        return (BRelTime)this.get(updateFrequency);
    }

    public void setUpdateFrequency(BRelTime v) {
        this.set(updateFrequency, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public BFormat getSql() {
        return (BFormat)this.get(sql);
    }

    public void setSql(BFormat v) {
        this.set(sql, (BValue)v, null);
    }

    public String getKeyColumn1() {
        return this.getString(keyColumn1);
    }

    public void setKeyColumn1(String v) {
        this.setString(keyColumn1, v, null);
    }

    public String getKeyColumn2() {
        return this.getString(keyColumn2);
    }

    public void setKeyColumn2(String v) {
        this.setString(keyColumn2, v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(sql)) {
            this.execute();
        }
        if (prop.equals(updateFrequency) || prop.equals(enabled) || prop.getName().startsWith("keyColumn")) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.isSubscribed()) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateFrequency(), (Action)execute, null);
                this.invoke(execute, null);
            }
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        BRdbms rdbms;
        if (action == execute && (rdbms = (BRdbms)this.getDevice()) != null && rdbms.isRunning()) {
            return rdbms.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    public BResultSetTable getData() {
        String sql;
        try {
            sql = this.getSql().format((Object)this);
            sql = sql.replace('\n', ' ');
        }
        catch (Exception e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid formatting");
            this.getLog().error("Invalid formatting.", (Throwable)e);
            return null;
        }
        BOrd ord = BOrd.make((BOrd)this.getDevice().getAbsoluteOrd(), (String)("sql:" + sql));
        try {
            this.getLog().trace("Executing query: " + sql);
            return (BResultSetTable)ord.get((BObject)this.getDevice(), null);
        }
        catch (Exception e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Unable to execute query.");
            this.getLog().error("Unable to execute query.", (Throwable)e);
            return null;
        }
    }

    public void doExecute() {
        if (!this.isRunning()) {
            return;
        }
        Log log = this.getLog();
        log.trace("Executing query " + this.getName());
        BRdbms rdbms = (BRdbms)this.getDevice();
        BStatus status = rdbms.getStatus();
        if (!status.isValid()) {
            if (log.isTraceOn()) {
                log.trace("Cannot execute query: database status is " + status);
            }
            this.setStatus(rdbms.getStatus());
            return;
        }
        BResultSetTable table = this.getData();
        if (table == null) {
            if (log.isTraceOn()) {
                log.trace("Cannot execute query: result set table is null");
            }
            return;
        }
        this.setStatus(rdbms.getStatus());
        this.setFaultCause(rdbms.getFaultCause());
        this.setLastUpdate(BAbsTime.now());
        int controlPoints = this.executeChildren(table);
        if ((double)controlPoints > (double)table.size() * 1.5 && table.size() > 15) {
            this.getLog().warning("Query " + this.getName() + " returned more data than neccessary.");
        }
        this.resultColumns = table.getColumns().list();
    }

    public String getColumnName(Object columnIndex, Context unused) {
        if (this.resultColumns != null && this.resultColumns.length > 0) {
            return this.resultColumns[((BInteger)columnIndex).getInt()].getName();
        }
        return null;
    }

    public int getColumnCount(Object unused1, Context unused2) {
        if (this.resultColumns != null && this.resultColumns.length > 0) {
            return this.resultColumns.length;
        }
        return 0;
    }

    public void subscribed() {
        if (this.getEnabled()) {
            if (this.updateTicket == null && this.isRunning()) {
                if (this.getLastUpdate().add(this.getUpdateFrequency()).isBefore(BAbsTime.now())) {
                    this.invoke(execute, null);
                }
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateFrequency(), (Action)execute, null);
            }
        } else if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
    }

    public void unsubscribed() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
        super.unsubscribed();
    }

    Log getLog() {
        BRdbms device = (BRdbms)this.getDevice();
        if (device != null) {
            return device.getLog();
        }
        return null;
    }

    public void addToPollGroup(BRdbmsProxyExt rdbmsProxyExt) {
        this.pollGroup.put(rdbmsProxyExt, rdbmsProxyExt);
        this.subscribed();
    }

    public void removeFromPollGroup(BRdbmsProxyExt rdbmsProxyExt) {
        this.pollGroup.remove((Object)rdbmsProxyExt);
        if (this.pollGroup.size() == 0) {
            this.unsubscribed();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

