/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Column;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.rdb.ddl.DdlCommand;

public class CreateTable
implements DdlCommand {
    private final String tableName;
    private final Column[] columns;
    private final Constraint[] constraints;

    public CreateTable(String tableName, Column[] columns, Constraint[] constraints) {
        this.tableName = tableName;
        this.columns = columns;
        this.constraints = constraints;
    }

    public String getDdl(RdbmsContext context) {
        int i;
        RdbmsDialect dialect = (RdbmsDialect)context;
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(this.tableName).append(" (");
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[i].getDdl(dialect));
        }
        for (i = 0; i < this.constraints.length; ++i) {
            sql.append(", ");
            sql.append(this.constraints[i].getDdl(dialect, this.tableName));
        }
        sql.append(")");
        return sql.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }
}

