/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util.history;

import com.tridium.rdb.jdbc.trans.BSqlType;
import com.tridium.rdb.util.BRdbmsUpdater;
import com.tridium.rdb.util.BStoredTimeZone;
import com.tridium.rdb.util.BTimezoneUpdateJob;
import com.tridium.rdb.util.history.BHistoryTimezoneUpdater;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BHistoryTimezoneUpdateJob
extends BTimezoneUpdateJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$util$history$BHistoryTimezoneUpdateJob == null ? (class$com$tridium$rdb$util$history$BHistoryTimezoneUpdateJob = BHistoryTimezoneUpdateJob.class$("com.tridium.rdb.util.history.BHistoryTimezoneUpdateJob")) : class$com$tridium$rdb$util$history$BHistoryTimezoneUpdateJob));
    private BHistoryTimezoneUpdater historyUpdater;
    private static final String HISTORY_CONFIG_TABLE = "HISTORY_CONFIG";
    private static final String HISTORY_TYPE_MAP_TABLE = "HISTORY_TYPE_MAP";
    private static final String RECORD_TYPE_COLUMN = "RECORDTYPE";
    private static final String TABLE_NAME_COLUMN = "TABLE_NAME";
    private static final String HISTORY_ID_COLUMN = "ID_";
    private static final String HISTORY_CONFIG_TIMEZONE_COLUMN = "TIMEZONE";
    private static final String DB_TIMEZONE_COLUMN = "DB_TIMEZONE";
    private static final String UTC_OFFSET_COLUMN = "UTC_OFFSET";
    private static final String TIMESTAMP_COLUMN = "TIMESTAMP";
    private static final String ID_COLUMN = "ID";
    private static final Calendar UTC_CALENDER = Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone());
    static /* synthetic */ Class class$com$tridium$rdb$util$history$BHistoryTimezoneUpdateJob;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public BHistoryTimezoneUpdateJob() {
    }

    public BHistoryTimezoneUpdateJob(BRdbmsUpdater updater) {
        super(updater);
        this.historyUpdater = (BHistoryTimezoneUpdater)updater;
    }

    protected void updateEnding() {
        super.updateEnding();
        if (this.transactionCommitted) {
            this.database.setTimestampStorage(BRdbmsTimestampStorage.utcTimestamp);
            BRdbmsHistoryDeviceExt historyDeviceExt = (BRdbmsHistoryDeviceExt)this.database.get("histories");
            historyDeviceExt.setUseLastTimestamp(false);
            historyDeviceExt.setUseHistoryConfigTimeZone(false);
        }
    }

    protected String[] getTableNamesToUpdate() throws Exception {
        Array tableNames = new Array(class$java$lang$String == null ? (class$java$lang$String = BHistoryTimezoneUpdateJob.class$("java.lang.String")) : class$java$lang$String);
        if (this.dialect.tableExists(this.database, this.conn, HISTORY_CONFIG_TABLE)) {
            tableNames.add((Object)HISTORY_CONFIG_TABLE);
        }
        if (this.dialect.tableExists(this.database, this.conn, HISTORY_TYPE_MAP_TABLE)) {
            tableNames.add((Object)HISTORY_TYPE_MAP_TABLE);
        }
        return (String[])tableNames.trim();
    }

    private String[] getHistoryTableNames(String metaTableName) throws Exception {
        Array historyTableNames = new Array(class$java$lang$String == null ? (class$java$lang$String = BHistoryTimezoneUpdateJob.class$("java.lang.String")) : class$java$lang$String);
        String sql = "SELECT * FROM " + metaTableName;
        ResultSet rs = this.statement.executeQuery(sql);
        while (rs.next()) {
            historyTableNames.add((Object)rs.getString(TABLE_NAME_COLUMN));
        }
        rs.close();
        return (String[])historyTableNames.trim();
    }

    protected void updateTable(String tableName) throws Exception {
        if (tableName.equals(HISTORY_CONFIG_TABLE)) {
            this.upgradeHistoryConfigTable();
        } else if (tableName.equals(HISTORY_TYPE_MAP_TABLE)) {
            this.upgradeHistoryTypeMapTable();
        }
    }

    private void upgradeHistoryConfigTable() throws SQLException {
        if (this.schemaUpgradeRequired(HISTORY_CONFIG_TABLE)) {
            String addDbTimeZomeColumnSql = this.getAddDbTimezoneColumnSql(HISTORY_CONFIG_TABLE);
            this.statement.execute(addDbTimeZomeColumnSql);
            BTimeZone timezone = this.historyUpdater.getCurrentTimestampStoragePolicy().equals((Object)BStoredTimeZone.stationTimeZone) ? BTimeZone.getLocal() : null;
            String newTimezoneValue = timezone == null ? HISTORY_CONFIG_TIMEZONE_COLUMN : "'" + timezone + "'";
            String updateTimezoneSql = "UPDATE HISTORY_CONFIG SET DB_TIMEZONE = " + newTimezoneValue;
            this.statement.execute(updateTimezoneSql);
        } else {
            this.log().message("No schema upgrades required for table HISTORY_CONFIG");
        }
        this.addUtcOffsetsForMetaTable(HISTORY_CONFIG_TABLE);
        String updateTimezoneSql = "UPDATE HISTORY_CONFIG SET DB_TIMEZONE = '" + BTimeZone.UTC + "'";
        this.statement.execute(updateTimezoneSql);
    }

    private void upgradeHistoryTypeMapTable() throws SQLException {
        if (this.schemaUpgradeRequired(HISTORY_TYPE_MAP_TABLE)) {
            ResultSet rs = null;
            Array tableEntries = new Array(class$java$lang$String == null ? (class$java$lang$String = BHistoryTimezoneUpdateJob.class$("java.lang.String")) : class$java$lang$String);
            String queryTableSql = "SELECT * FROM HISTORY_TYPE_MAP";
            rs = this.statement.executeQuery(queryTableSql);
            while (rs.next()) {
                tableEntries.add((Object)(rs.getString(TABLE_NAME_COLUMN) + "&" + rs.getString(RECORD_TYPE_COLUMN)));
            }
            rs.close();
            this.statement.execute("DELETE FROM HISTORY_TYPE_MAP");
            String addHistoryIdColumnSql = this.dialect.makeAddColumnSql(HISTORY_TYPE_MAP_TABLE, HISTORY_ID_COLUMN, BSqlType.sqlNVarchar, 100, "<id>");
            String addHistoryConfigTimezoneColumnSql = this.dialect.makeAddColumnSql(HISTORY_TYPE_MAP_TABLE, HISTORY_CONFIG_TIMEZONE_COLUMN, BSqlType.sqlNVarchar, 100, BTimeZone.NULL.toString());
            this.statement.addBatch(addHistoryIdColumnSql);
            this.statement.addBatch(addHistoryConfigTimezoneColumnSql);
            this.statement.addBatch(this.getAddDbTimezoneColumnSql(HISTORY_TYPE_MAP_TABLE));
            this.statement.executeBatch();
            String[] metaTableEntries = (String[])tableEntries.trim();
            HashMap<String, String[]> tableEntryToHistoryIds = new HashMap<String, String[]>();
            for (int i = 0; i < metaTableEntries.length; ++i) {
                String metaTableEntry = metaTableEntries[i];
                int seperatorIndex = metaTableEntries[i].lastIndexOf("&");
                String historyTableName = metaTableEntries[i].substring(0, seperatorIndex);
                Array historyIds = new Array(class$java$lang$String == null ? BHistoryTimezoneUpdateJob.class$("java.lang.String") : class$java$lang$String);
                String distinctIdsSql = "SELECT DISTINCT HISTORY_ID FROM " + historyTableName;
                rs = this.statement.executeQuery(distinctIdsSql);
                while (rs.next()) {
                    historyIds.add((Object)rs.getString("HISTORY_ID"));
                }
                rs.close();
                String[] distinctHistoryIds = (String[])historyIds.trim();
                tableEntryToHistoryIds.put(metaTableEntry, distinctHistoryIds);
            }
            Iterator it = tableEntryToHistoryIds.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String tableEntry = entry.getKey().toString();
                int seperatorIndex = tableEntry.lastIndexOf("&");
                String table = tableEntry.substring(0, seperatorIndex);
                String recordType = tableEntry.substring(seperatorIndex + 1);
                BTimeZone historyConfigTimezone = BTimeZone.NULL;
                BStoredTimeZone timeZoneBase = this.historyUpdater.getCurrentTimestampStoragePolicy();
                BTimeZone dbTimeZone = timeZoneBase.equals((Object)BStoredTimeZone.stationTimeZone) ? BTimeZone.getLocal() : (timeZoneBase.equals((Object)BStoredTimeZone.historyConfigTimeZone) ? historyConfigTimezone : BTimeZone.NULL);
                String[] distinctHistoryIds = (String[])entry.getValue();
                for (int i = 0; i < distinctHistoryIds.length; ++i) {
                    String historyId = distinctHistoryIds[i];
                    BIHistory history = this.getHistorySpace().getHistory(BHistoryId.make((String)historyId));
                    if (history != null) {
                        historyConfigTimezone = history.getConfig().getTimeZone();
                    }
                    String[] columns = new String[]{RECORD_TYPE_COLUMN, TABLE_NAME_COLUMN, HISTORY_ID_COLUMN, HISTORY_CONFIG_TIMEZONE_COLUMN, DB_TIMEZONE_COLUMN};
                    BString[] columnValues = new BString[]{BString.make((String)recordType), BString.make((String)table), BString.make((String)historyId), BString.make((String)historyConfigTimezone.toString()), BString.make((String)dbTimeZone.toString())};
                    BFacets[] columnFacets = new BFacets[columnValues.length];
                    PreparedStatement ps = this.conn.prepareStatement(this.dialect.makeInsertSql(HISTORY_TYPE_MAP_TABLE, new Property[0], columns));
                    this.dialect.insertRecord(ps, null, new Property[0], (BObject[])columnValues, columnFacets);
                    ps.executeBatch();
                    ps.close();
                }
            }
        } else {
            this.log().message("No schema upgrades required for table HISTORY_TYPE_MAP");
        }
        this.addUtcOffsetsForMetaTable(HISTORY_TYPE_MAP_TABLE);
        String updateTimezoneSql = "UPDATE HISTORY_TYPE_MAP SET DB_TIMEZONE = '" + BTimeZone.UTC + "'";
        this.statement.execute(updateTimezoneSql);
    }

    private void addUtcOffsetsForMetaTable(String metaTableName) throws SQLException {
        ResultSet rs = this.statement.executeQuery("SELECT DISTINCT TABLE_NAME, DB_TIMEZONE FROM " + metaTableName);
        HashMap<String, String> tableNameToTimezoneMap = new HashMap<String, String>();
        while (rs.next()) {
            tableNameToTimezoneMap.put(rs.getString(TABLE_NAME_COLUMN), rs.getString(DB_TIMEZONE_COLUMN));
        }
        rs.close();
        Iterator it = tableNameToTimezoneMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String tableName = entry.getKey().toString();
            String timezone = entry.getValue().toString();
            this.addUtcOffsetsToTable(tableName, timezone);
        }
    }

    private void addUtcOffsetsToTable(String tableName, String timezone) throws SQLException {
        if (!this.dialect.supportsTimestamp()) {
            this.log().message("UTC offset column update not required for table " + tableName);
            return;
        }
        String timezoneId = timezone.substring(0, timezone.indexOf("(")).trim();
        TimeZone tz = TimeZone.getTimeZone(timezoneId);
        Calendar calender = Calendar.getInstance(tz);
        PreparedStatement ps = this.conn.prepareStatement("UPDATE " + tableName + " SET " + TIMESTAMP_COLUMN + " = ? WHERE ID = ?");
        String sql = "SELECT ID, TIMESTAMP FROM " + tableName;
        ResultSet rs = this.statement.executeQuery(sql);
        while (rs.next()) {
            int id = rs.getInt(ID_COLUMN);
            Timestamp ts = rs.getTimestamp(TIMESTAMP_COLUMN, calender);
            ps.setTimestamp(1, ts, UTC_CALENDER);
            ps.setInt(2, id);
            ps.addBatch();
        }
        rs.close();
        ps.executeBatch();
        ps.close();
    }

    private boolean schemaUpgradeRequired(String tableName) throws SQLException {
        ResultSet rs = this.metadata.getColumns(null, null, tableName, DB_TIMEZONE_COLUMN);
        boolean schemaUpgradeRequired = !rs.next();
        rs.close();
        return schemaUpgradeRequired;
    }

    private String getAddDbTimezoneColumnSql(String tableName) {
        return this.dialect.makeAddColumnSql(tableName, DB_TIMEZONE_COLUMN, BSqlType.sqlNVarchar, 100, BTimeZone.NULL.toString());
    }

    private String getAddUtcOffsetColumnSql(String tableName) {
        return this.dialect.makeAddColumnSql(tableName, UTC_OFFSET_COLUMN, BSqlType.sqlLong, -1, "0");
    }

    private BHistorySpace getHistorySpace() {
        BHistoryService hs = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        return hs.getDatabase();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

