/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.rdb.util.BJobMonitorPane;
import com.tridium.rdb.util.BRdbmsUpdater;
import com.tridium.rdb.util.BStoredTimeZone;
import com.tridium.rdb.util.history.BHistoryTimezoneUpdater;
import com.tridium.rdb.util.history.BHistoryUnicodeUpdater;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.StepWizardModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.ui.wizard.step.util.WizardHeaderUiHandler;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;

public class RdbmsUpdateWizard {
    private BWidget owner;
    private BRdbmsNetwork rdbmsNetwork;
    private Context cx;
    private static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$rdb$util$RdbmsUpdateWizard == null ? (class$com$tridium$rdb$util$RdbmsUpdateWizard = RdbmsUpdateWizard.class$("com.tridium.rdb.util.RdbmsUpdateWizard")) : class$com$tridium$rdb$util$RdbmsUpdateWizard));
    private static final BImage WIZARD_ICON = BImage.make((BIcon)BIcon.std((String)"wizard.png"));
    private static final BImage DATABASE_ICON = BImage.make((BIcon)BIcon.std((String)"database.png"));
    private static final String WIZARD_DIALOG_TITLE = lex.getText("rdb.wizard.dialog.title");
    private static final String STEP1_TITLE = lex.getText("rdb.wizard.step1.title");
    private static final String STEP1_DESC = lex.getText("rdb.wizard.step1.description");
    private static final String STEP2_UNICODE_TITLE = lex.getText("rdb.wizard.step2.unicode.title");
    private static final String STEP2_UNICODE_DESC = lex.getText("rdb.wizard.step2.unicode.description");
    private static final String STEP2_TIMEZONE_TITLE = lex.getText("rdb.wizard.step2.timezone.title");
    private static final String STEP2_TIMEZONE_DESC = lex.getText("rdb.wizard.step2.timezone.description");
    private static final String STEP3_UNICODE_TITLE = lex.getText("rdb.wizard.step3.unicode.title");
    private static final String STEP3_UNICODE_DESC = lex.getText("rdb.wizard.step3.unicode.description");
    private static final String STEP3_TIMEZONE_TITLE = lex.getText("rdb.wizard.step3.timezone.title");
    private static final String STEP3_TIMEZONE_DESC = lex.getText("rdb.wizard.step3.timezone.description");
    private static final String STEP4_TIMEZONE_TITLE = lex.getText("rdb.wizard.step4.timezone.title");
    private static final String STEP4_TIMEZONE_DESC = lex.getText("rdb.wizard.step4.timezone.description");
    private BCheckBox step1UnicodeUpdateCb = new BCheckBox(lex.getText("rdb.wizard.step1.unicodeCbLabel"));
    private BCheckBox step1TimezoneUpdateCb = new BCheckBox(lex.getText("rdb.wizard.step1.timezoneCbLabel"));
    private BCheckList unicodeDbList = new BCheckList();
    private BCheckList timezoneDbList = new BCheckList();
    private BRadioButton stationTzRb;
    private BRadioButton historyConfigTzRb;
    private static final String STATION_TIMEZONE_STORAGE = "Timestamps are being stored using the station timezone";
    private static final String HISTORY_CONFIG_TIMEZONE_STORAGE = "Timestamps are being stored using the history config timezone";
    static /* synthetic */ Class class$javax$baja$naming$BOrd;
    static /* synthetic */ Class class$javax$baja$rdb$BRdbms;
    static /* synthetic */ Class class$com$tridium$rdb$util$RdbmsUpdateWizard;

    private RdbmsUpdateWizard(BWidget owner, BRdbmsNetwork rdbms, Context cx) {
        this.owner = owner;
        this.rdbmsNetwork = rdbms;
        this.cx = cx;
    }

    public static RdbmsUpdateWizard make(BWidget owner, BRdbmsNetwork rdbms, Context cx) {
        return new RdbmsUpdateWizard(owner, rdbms, cx);
    }

    public CommandArtifact doInvoke() {
        BWizard.open((BWidget)this.owner, (WizardModel)this.makeWizardModel());
        return null;
    }

    private WizardModel makeWizardModel() {
        final WizardStep step1 = RdbmsUpdateWizard.makeStep(STEP1_TITLE, STEP1_DESC, this.makeStep1Widget());
        final WizardStep unicodeSelectDbStep = RdbmsUpdateWizard.makeStep(STEP2_UNICODE_TITLE, STEP2_UNICODE_DESC, this.makeSelectDbsWidget(this.unicodeDbList));
        final WizardStep timezoneSelectDbStep = RdbmsUpdateWizard.makeStep(STEP2_TIMEZONE_TITLE, STEP2_TIMEZONE_DESC, this.makeSelectDbsWidget(this.timezoneDbList));
        WizardStep timezoneStorageStep = RdbmsUpdateWizard.makeStep(STEP3_TIMEZONE_TITLE, STEP3_TIMEZONE_DESC, this.makeSpecifyTimezonePolicyWidget());
        timezoneSelectDbStep.setNext(timezoneStorageStep);
        step1.setRouter(new WizardStep.IRouter(){

            public WizardStep next(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
                return RdbmsUpdateWizard.this.step1UnicodeUpdateCb.isSelected() ? unicodeSelectDbStep : (RdbmsUpdateWizard.this.step1TimezoneUpdateCb.isSelected() ? timezoneSelectDbStep : step1);
            }
        });
        unicodeSelectDbStep.setRouter(new WizardStep.IRouter(){

            public WizardStep next(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
                WizardStep unicodeProgressStep = RdbmsUpdateWizard.makeStep(STEP3_UNICODE_TITLE, STEP3_UNICODE_DESC, RdbmsUpdateWizard.this.makeJobProgressWidget(RdbmsUpdateWizard.this.unicodeDbList, new BHistoryUnicodeUpdater()));
                if (RdbmsUpdateWizard.this.step1TimezoneUpdateCb.isSelected()) {
                    unicodeProgressStep.setNext(timezoneSelectDbStep);
                }
                return unicodeProgressStep;
            }
        });
        timezoneStorageStep.setRouter(new WizardStep.IRouter(){

            public WizardStep next(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
                BHistoryTimezoneUpdater updater = new BHistoryTimezoneUpdater();
                updater.setCurrentTimestampStoragePolicy(RdbmsUpdateWizard.this.stationTzRb.isSelected() ? BStoredTimeZone.stationTimeZone : BStoredTimeZone.historyConfigTimeZone);
                WizardStep timezoneProgressStep = RdbmsUpdateWizard.makeStep(STEP4_TIMEZONE_TITLE, STEP4_TIMEZONE_DESC, RdbmsUpdateWizard.this.makeJobProgressWidget(RdbmsUpdateWizard.this.timezoneDbList, updater));
                return timezoneProgressStep;
            }
        });
        StepModel stepModel = StepModel.make((WizardStep)step1);
        StepWizardModel wizardModel = new StepWizardModel(stepModel, WIZARD_DIALOG_TITLE);
        return wizardModel;
    }

    private static WizardStep makeStep(String title, String desc, BWidget widget) {
        WizardHeaderUiHandler uiHandler = new WizardHeaderUiHandler(WIZARD_ICON, title, desc, (WizardStep.IUiHandler)new WidgetUiHandler(widget));
        WizardStep step = new WizardStep((WizardStep.IUiHandler)uiHandler);
        return step;
    }

    private BWidget makeStep1Widget() {
        BGridPane gp = new BGridPane(1, new BWidget[]{this.step1UnicodeUpdateCb, new BNullWidget(), this.step1TimezoneUpdateCb});
        gp.setHalign(BHalign.left);
        gp.setValign(BValign.top);
        BBorderPane bp = new BBorderPane((BWidget)gp, BInsets.make((double)10.0));
        return bp;
    }

    private BWidget makeSelectDbsWidget(BCheckList checkList) {
        BRdbms[] dbs = this.getDatabases();
        for (int i = 0; i < dbs.length; ++i) {
            checkList.addItem(DATABASE_ICON, (Object)new DbEntry(dbs[i].getDisplayName(null), dbs[i].getHandleOrd()));
        }
        BBorderPane bp = new BBorderPane((BWidget)checkList, BInsets.make((double)10.0));
        return bp;
    }

    private BWidget makeJobProgressWidget(BCheckList list, BRdbmsUpdater updater) {
        BOrdList dbOrdList = RdbmsUpdateWizard.getDbOrdList(list);
        updater.setDatabaseOrds(dbOrdList);
        return new BJobMonitorPane(updater, this.rdbmsNetwork);
    }

    private BWidget makeSpecifyTimezonePolicyWidget() {
        ToggleCommandGroup tcg = new ToggleCommandGroup();
        this.stationTzRb = new BRadioButton(tcg, STATION_TIMEZONE_STORAGE, true);
        this.historyConfigTzRb = new BRadioButton(tcg, HISTORY_CONFIG_TIMEZONE_STORAGE);
        BGridPane gp = new BGridPane(1, new BWidget[]{this.stationTzRb, this.historyConfigTzRb});
        gp.setHalign(BHalign.left);
        gp.setValign(BValign.top);
        BBorderPane bp = new BBorderPane((BWidget)gp, BInsets.make((double)10.0));
        return bp;
    }

    private static BOrdList getDbOrdList(BCheckList checkList) {
        Object[] selectedEntries = checkList.getSelectedItems();
        Array dbOrds = new Array(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = RdbmsUpdateWizard.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
        for (int i = 0; i < selectedEntries.length; ++i) {
            DbEntry entry = (DbEntry)selectedEntries[i];
            dbOrds.add((Object)entry.dbOrd);
        }
        return BOrdList.make((BOrd[])((BOrd[])dbOrds.trim()));
    }

    private BRdbms[] getDatabases() {
        if (this.rdbmsNetwork == null) {
            return new BRdbms[0];
        }
        Array databases = new Array(class$javax$baja$rdb$BRdbms == null ? (class$javax$baja$rdb$BRdbms = RdbmsUpdateWizard.class$("javax.baja.rdb.BRdbms")) : class$javax$baja$rdb$BRdbms);
        databases.addAll((Object[])this.rdbmsNetwork.getDevices());
        return (BRdbms[])databases.trim();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DbEntry {
        private BOrd dbOrd;
        private String displayName;

        DbEntry(String displayName, BOrd dbOrd) {
            this.displayName = displayName;
            this.dbOrd = dbOrd;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

