/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.ui;

import com.tridium.collection.BEmptyTable;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.rdb.BResultSetTable;
import com.tridium.workbench.util.BCollectionTable;
import java.sql.SQLException;
import javax.baja.naming.BOrd;
import javax.baja.rdb.point.BRdbmsPointQuery;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BFormat;
import javax.baja.workbench.view.BWbView;

public class BRdbmsQueryView
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$ui$BRdbmsQueryView == null ? (class$com$tridium$rdb$ui$BRdbmsQueryView = BRdbmsQueryView.class$("com.tridium.rdb.ui.BRdbmsQueryView")) : class$com$tridium$rdb$ui$BRdbmsQueryView));
    BCollectionTable resultsTable;
    BTextEditor queryEditor;
    static /* synthetic */ Class class$com$tridium$rdb$ui$BRdbmsQueryView;

    public Type getType() {
        return TYPE;
    }

    private BResultSetTable runQuery(BRdbmsPointQuery query) throws Exception {
        return this.runQuery(query, query.getSql());
    }

    private BResultSetTable runQuery(BRdbmsPointQuery query, BFormat formattedSql) throws Exception {
        String sql = formattedSql.format((Object)query);
        sql = sql.replace('\n', ' ');
        BOrd ord = BOrd.make((BOrd)query.getDevice().getAbsoluteOrd(), (String)("sql:" + sql));
        BResultSetTable tableData = (BResultSetTable)ord.get((BObject)query.getDevice(), null);
        return tableData;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BRdbmsPointQuery query = (BRdbmsPointQuery)value;
        this.resultsTable = new BCollectionTable();
        ((BTitlePane)this.resultsTable.getContent()).setTitle("Query Results");
        this.resultsTable.loadValue((BObject)this.runQuery(query));
        this.queryEditor = new BTextEditor(query.getSql().toString(cx), true);
        BTextEditorPane queryEditorPane = new BTextEditorPane();
        queryEditorPane.setContent((BWidget)this.queryEditor);
        BButtonPane buttonPane = new BButtonPane(new Command[]{new RefreshCommand((BWidget)this, query), new SaveCommand((BWidget)this, query)});
        BBorderPane buttonBorderPane = new BBorderPane();
        buttonBorderPane.setContent((BWidget)buttonPane);
        BEdgePane edgePane = new BEdgePane();
        edgePane.setCenter((BWidget)queryEditorPane);
        edgePane.setBottom((BWidget)buttonBorderPane);
        BSplitPane splitPane = new BSplitPane(BOrientation.vertical, 20.0);
        splitPane.setWidget1((BWidget)edgePane);
        splitPane.setWidget2((BWidget)this.resultsTable);
        this.setContent((BWidget)splitPane);
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SaveCommand
    extends Command {
        BRdbmsPointQuery query;

        public SaveCommand(BWidget owner, BRdbmsPointQuery query) {
            super(owner, "Save", null, null, "Save changes to the Sql query.");
            this.query = query;
        }

        public CommandArtifact doInvoke() {
            this.query.setSql(BFormat.make((String)BRdbmsQueryView.this.queryEditor.getText()));
            return null;
        }
    }

    private class RefreshCommand
    extends Command {
        BRdbmsPointQuery query;

        public RefreshCommand(BWidget owner, BRdbmsPointQuery query) {
            super(owner, "Run", null, null, "Run the Sql query and return the results.");
            this.query = query;
        }

        public CommandArtifact doInvoke() {
            Object collection;
            try {
                collection = BRdbmsQueryView.this.runQuery(this.query, BFormat.make((String)BRdbmsQueryView.this.queryEditor.getText()));
            }
            catch (Exception e) {
                Throwable thrown;
                collection = new BEmptyTable();
                for (thrown = e; thrown != null && !(thrown instanceof SQLException); thrown = thrown.getCause()) {
                }
                BDialog.open((BWidget)this.getOwner(), (String)"SQL Error", (Object)new BLabel(thrown.getMessage()), (int)1, null, (Throwable)thrown);
            }
            BRdbmsQueryView.this.resultsTable.loadValue((BObject)collection);
            return null;
        }
    }
}

