/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStringTranslator
extends BColumnTranslator {
    private static final String CLOB = "clob";
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$jdbc$trans$BStringTranslator == null ? (class$com$tridium$rdb$jdbc$trans$BStringTranslator = BStringTranslator.class$("com.tridium.rdb.jdbc.trans.BStringTranslator")) : class$com$tridium$rdb$jdbc$trans$BStringTranslator));
    static /* synthetic */ Class class$com$tridium$rdb$jdbc$trans$BStringTranslator;

    public BStringTranslator(RdbmsDialect dialect, BValue defaultValue) {
        super(dialect, defaultValue);
    }

    public BSqlType getSqlType() {
        return BSqlType.sqlVarchar;
    }

    public void setPreparedStatementValue(RdbmsPreparedStatement prep, int index, BValue value, Context context) {
        String str = ((BString)value).getString();
        if (context != null && context.getFacets().getb(CLOB, false)) {
            if (this.getDialect().usesDefaultClobTranslator()) {
                prep.setCharacterStream(index, new StringReader(str), str.length());
            } else {
                this.getDialect().setClobValue(prep, index, str);
            }
        } else {
            prep.setString(index, str);
        }
    }

    public BValue getResultSetValue(RdbmsResultSet rs, int index, Context context) {
        if (context != null && context.getFacets().getb(CLOB, false)) {
            try {
                int n;
                Reader reader = rs.getCharacterStream(index);
                if (reader == null) {
                    return BString.DEFAULT;
                }
                StringBuffer sb = new StringBuffer();
                char[] buf = new char[1024];
                while ((n = reader.read(buf, 0, 1024)) >= 0) {
                    sb.append(buf, 0, n);
                }
                return BString.make((String)sb.toString());
            }
            catch (IOException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        String str = rs.getString(index);
        if (str == null) {
            str = "";
        }
        return BString.make((String)str);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

