/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.exception.PasswordCipherException;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import javax.baja.log.Log;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPasswordTranslator
extends BColumnTranslator {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$jdbc$trans$BPasswordTranslator == null ? (class$com$tridium$rdb$jdbc$trans$BPasswordTranslator = BPasswordTranslator.class$("com.tridium.rdb.jdbc.trans.BPasswordTranslator")) : class$com$tridium$rdb$jdbc$trans$BPasswordTranslator));
    private static final Log LOG = Log.getLog((String)"rdb");
    static /* synthetic */ Class class$com$tridium$rdb$jdbc$trans$BPasswordTranslator;

    public BPasswordTranslator(RdbmsDialect dialect, BValue defaultValue) {
        super(dialect, defaultValue);
    }

    public BSqlType getSqlType() {
        return BSqlType.sqlVarchar;
    }

    public void setPreparedStatementValue(RdbmsPreparedStatement prep, int index, BValue input, Context context) {
        try {
            String value;
            BPassword password = input != null && input instanceof BPassword ? (BPassword)input : null;
            String string = value = password != null ? password.getValue() : "";
            if ("".equals(value)) {
                prep.setNull(index, 12);
            } else {
                AesSysKeyEncoder aesSysKeyEncoder = this.getDialect().getAesEncoder();
                prep.setString(index, aesSysKeyEncoder.encrypt(value));
            }
        }
        catch (Exception e) {
            LOG.error("Error in encoding the input string.", (Throwable)e);
            throw new PasswordCipherException(this.getLexicon().getText("rdb.passwordCipherException.message"));
        }
    }

    public BValue getResultSetValue(RdbmsResultSet rs, int index, Context context) {
        String encodedValue = null;
        try {
            String dbValue = rs.getString(index);
            AesSysKeyEncoder aesSysKeyEncoder = this.getDialect().getAesEncoder();
            encodedValue = aesSysKeyEncoder.decrypt(dbValue);
        }
        catch (Exception e) {
            LOG.error("Error in decoding the value, probably the key is bad.", (Throwable)e);
            throw new PasswordCipherException(this.getLexicon().getText("rdb.passwordCipherException.message"));
        }
        return BPassword.make((String)(encodedValue == null ? BPassword.DEFAULT.getValue() : encodedValue));
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

