/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAbsTimeTranslator
extends BColumnTranslator {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$jdbc$trans$BAbsTimeTranslator == null ? (class$com$tridium$rdb$jdbc$trans$BAbsTimeTranslator = BAbsTimeTranslator.class$("com.tridium.rdb.jdbc.trans.BAbsTimeTranslator")) : class$com$tridium$rdb$jdbc$trans$BAbsTimeTranslator));
    private static Calendar utcCalendar;
    static /* synthetic */ Class class$com$tridium$rdb$jdbc$trans$BAbsTimeTranslator;

    public BAbsTimeTranslator(RdbmsDialect dialect, BValue defaultValue) {
        super(dialect, defaultValue);
    }

    public BSqlType getSqlType() {
        return BSqlType.sqlTimestamp;
    }

    public void setPreparedStatementValue(RdbmsPreparedStatement prep, int index, BValue value, Context context) {
        long millis = ((BAbsTime)value).getMillis();
        if (this.getDialect().supportsMillisecondTimestamp()) {
            if (this.getDialect().useUtcTimestamps()) {
                prep.setTimestamp(index, new Timestamp(millis), BAbsTimeTranslator.getUtcCalendar());
            } else {
                prep.setTimestamp(index, new Timestamp(millis));
            }
        } else {
            prep.setLong(index, millis);
        }
    }

    public static Calendar getUtcCalendar() {
        if (utcCalendar == null) {
            utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
        return utcCalendar;
    }

    public BValue getResultSetValue(RdbmsResultSet rs, int index, Context context) {
        if (this.getDialect().supportsMillisecondTimestamp()) {
            if (this.getDialect().useUtcTimestamps()) {
                return BAbsTime.make((long)rs.getTimestamp(index, BAbsTimeTranslator.getUtcCalendar()).getTime());
            }
            return BAbsTime.make((long)rs.getTimestamp(index).getTime());
        }
        return BAbsTime.make((long)rs.getLong(index));
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

