/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.orm;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.orm.OrmColumn;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.security.BPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.BTypeSpec;

public class OrmSession {
    private static Log LOG = Log.getLog((String)"rdb.jdbc");
    private final BRdbms rdbms;
    private final RdbmsDialect dialect;
    private final boolean defaultUser;
    private final String userName;
    private final BPassword password;
    private Connection conn;
    static /* synthetic */ Class class$java$lang$String;

    public OrmSession(BRdbms rdbms) {
        this.rdbms = rdbms;
        this.dialect = (RdbmsDialect)rdbms.getRdbmsContext();
        this.defaultUser = true;
        this.userName = null;
        this.password = null;
    }

    public OrmSession(BRdbms rdbms, String userName, BPassword password) {
        this.rdbms = rdbms;
        this.dialect = (RdbmsDialect)rdbms.getRdbmsContext();
        this.defaultUser = false;
        this.userName = userName;
        this.password = password;
    }

    public void open() {
        try {
            this.conn = this.defaultUser ? this.rdbms.getConnection() : this.rdbms.getConnection(this.userName, this.password);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setAutoCommit(boolean flag) {
        try {
            this.conn.setAutoCommit(flag);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public boolean tableExists(String tableName) {
        try {
            BTypeSpec spec;
            if (LOG.isTraceOn()) {
                LOG.trace("tableExists: " + tableName);
            }
            if ((spec = this.rdbms.getType().getTypeSpec()).equals((Object)BTypeSpec.make((String)"rdbHsqlDb:HsqlDatabase")) || spec.equals((Object)BTypeSpec.make((String)"rdbOracle:OracleDatabase")) || spec.equals((Object)BTypeSpec.make((String)"rdbDb2:Db2Database"))) {
                tableName = tableName.toUpperCase();
            }
            DatabaseMetaData md = this.conn.getMetaData();
            ResultSet tables = md.getTables(null, null, tableName, null);
            boolean exists = tables.next();
            tables.close();
            return exists;
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static String makeExistsSql(String tableName, OrmColumn[] keys) {
        return "SELECT * FROM " + tableName + " WHERE " + OrmSession.paramNames(keys);
    }

    public static String makeReadSql(String tableName, OrmColumn[] keys, OrmColumn[] columns) {
        return "SELECT " + OrmSession.commaNames(columns) + " FROM " + tableName + " WHERE " + OrmSession.paramNames(keys);
    }

    public static String makeScanSql(String tableName, OrmColumn[] columns) {
        return "SELECT " + OrmSession.commaNames(columns) + " FROM " + tableName;
    }

    public static String makeQuerySql(String tableName, OrmColumn[] columns, String sqlSuffix) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(OrmSession.commaNames(columns));
        sql.append(" FROM ");
        sql.append(tableName);
        if (sqlSuffix != null) {
            sql.append(" ").append(sqlSuffix);
        }
        return sql.toString();
    }

    public static String makeInsertSql(String tableName, OrmColumn[] columns) {
        Array arr = new Array(class$java$lang$String == null ? (class$java$lang$String = OrmSession.class$("java.lang.String")) : class$java$lang$String);
        for (int i = 0; i < columns.length; ++i) {
            arr.add((Object)"?");
        }
        return "INSERT INTO " + tableName + " " + "(" + OrmSession.commaNames(columns) + ") " + "VALUES " + "(" + TextUtil.join((String[])((String[])arr.trim()), (char)',') + ")";
    }

    public static String makeUpdateSql(String tableName, OrmColumn[] keys, OrmColumn[] columns) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(tableName).append(" SET ");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(columns[i].getName()).append(" = ?");
        }
        sql.append(" WHERE ").append(OrmSession.paramNames(keys));
        return sql.toString();
    }

    public static String makeDeleteSql(String tableName, OrmColumn[] keys) {
        return "DELETE FROM " + tableName + " WHERE " + OrmSession.paramNames(keys);
    }

    public boolean exists(String tableName, OrmColumn[] keys) {
        return this.exists(new RdbmsPreparedStatement(this.conn, OrmSession.makeExistsSql(tableName, keys)), keys);
    }

    public boolean read(String tableName, OrmColumn[] keys, OrmColumn[] columns) {
        return this.read(new RdbmsPreparedStatement(this.conn, OrmSession.makeReadSql(tableName, keys, columns)), keys, columns);
    }

    public RdbmsResultSet scan(String tableName, OrmColumn[] columns) {
        return this.scan(new RdbmsPreparedStatement(this.conn, OrmSession.makeScanSql(tableName, columns)));
    }

    public RdbmsResultSet query(String tableName, OrmColumn[] columns, String predicate, OrmColumn[] predicateParams) {
        return this.query(new RdbmsPreparedStatement(this.conn, OrmSession.makeQuerySql(tableName, columns, predicate)), predicateParams);
    }

    public void insert(String tableName, OrmColumn[] columns) {
        this.insert(new RdbmsPreparedStatement(this.conn, OrmSession.makeInsertSql(tableName, columns)), columns);
    }

    public void insertIdentity(String tableName, OrmColumn identity, OrmColumn[] columns) {
        this.insertIdentity(this.makeInsertIdentityStatement(tableName, identity, columns), identity, columns);
    }

    public RdbmsPreparedStatement makeInsertIdentityStatement(String tableName, OrmColumn identity, OrmColumn[] columns) {
        switch (this.dialect.getInsertionMode()) {
            case 1: {
                return new RdbmsPreparedStatement(this.conn, OrmSession.makeInsertSql(tableName, columns), 1);
            }
        }
        throw new IllegalStateException();
    }

    public void update(String tableName, OrmColumn[] keys, OrmColumn[] columns) {
        this.update(new RdbmsPreparedStatement(this.conn, OrmSession.makeUpdateSql(tableName, keys, columns)), keys, columns);
    }

    public void delete(String tableName, OrmColumn[] keys) {
        this.delete(new RdbmsPreparedStatement(this.conn, OrmSession.makeDeleteSql(tableName, keys)), keys);
    }

    public void invokeDdl(DdlCommand command) {
        String ddl = command.getDdl(this.dialect);
        RdbmsPreparedStatement prep = new RdbmsPreparedStatement(this.conn, ddl);
        prep.executeUpdate();
    }

    public boolean exists(RdbmsPreparedStatement prep, OrmColumn[] keys) {
        try {
            for (int i = 0; i < keys.length; ++i) {
                keys[i].setPreparedValue(prep, i + 1, keys[i].getValue(), null);
            }
            ResultSet rs = prep.executeQuery();
            return rs.next();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public boolean read(RdbmsPreparedStatement prep, OrmColumn[] keys, OrmColumn[] columns) {
        for (int i = 0; i < keys.length; ++i) {
            keys[i].setPreparedValue(prep, i + 1, keys[i].getValue(), null);
        }
        RdbmsResultSet rs = new RdbmsResultSet(prep.executeQuery());
        if (rs.next()) {
            for (int i = 0; i < columns.length; ++i) {
                OrmColumn c = columns[i];
                c.setValue(c.getResultValue(rs, i + 1, null));
            }
            return true;
        }
        return false;
    }

    public RdbmsResultSet scan(RdbmsPreparedStatement prep) {
        return new RdbmsResultSet(prep.executeQuery());
    }

    public RdbmsResultSet query(RdbmsPreparedStatement prep, OrmColumn[] predicateParams) {
        if (predicateParams != null) {
            for (int i = 0; i < predicateParams.length; ++i) {
                predicateParams[i].setPreparedValue(prep, i + 1, predicateParams[i].getValue(), null);
            }
        }
        return new RdbmsResultSet(prep.executeQuery());
    }

    public void insert(RdbmsPreparedStatement prep, OrmColumn[] columns) {
        OrmSession.loadPrepStatement(prep, columns);
        prep.executeUpdate();
    }

    public void insertIdentity(RdbmsPreparedStatement prep, OrmColumn identity, OrmColumn[] columns) {
        switch (this.dialect.getInsertionMode()) {
            case 1: {
                this.insertViaIdentity(prep, identity, columns);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void update(RdbmsPreparedStatement prep, OrmColumn[] keys, OrmColumn[] columns) {
        int i;
        int n = 1;
        for (i = 0; i < columns.length; ++i) {
            OrmColumn c = columns[i];
            c.setPreparedValue(prep, n++, c.getValue(), null);
        }
        for (i = 0; i < keys.length; ++i) {
            keys[i].setPreparedValue(prep, n++, keys[i].getValue(), null);
        }
        prep.executeUpdate();
    }

    public void delete(RdbmsPreparedStatement prep, OrmColumn[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            keys[i].setPreparedValue(prep, i + 1, keys[i].getValue(), null);
        }
        prep.executeUpdate();
    }

    private void insertViaIdentity(RdbmsPreparedStatement prep, OrmColumn identity, OrmColumn[] columns) {
        OrmSession.loadPrepStatement(prep, columns);
        prep.executeUpdate();
        OrmSession.retrieveIdentityKey(prep, identity);
    }

    private static void retrieveIdentityKey(RdbmsPreparedStatement prep, OrmColumn identity) {
        RdbmsResultSet genKey = new RdbmsResultSet(prep.getGeneratedKeys());
        genKey.next();
        identity.setValue(identity.getResultValue(genKey, 1));
    }

    private static String commaNames(OrmColumn[] columns) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(columns[i].getName());
        }
        return sb.toString();
    }

    private static String paramNames(OrmColumn[] columns) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append("(").append(columns[i].getName()).append(" = ?)");
        }
        return sb.toString();
    }

    private static void loadPrepStatement(RdbmsPreparedStatement prep, OrmColumn[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            OrmColumn c = columns[i];
            c.setPreparedValue(prep, i + 1, c.getValue(), null);
        }
    }

    public BRdbms getRdbms() {
        return this.rdbms;
    }

    public RdbmsDialect getDialect() {
        return this.dialect;
    }

    public Connection getConnection() {
        return this.conn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

