/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;

public class RdbmsPreparedStatement {
    private static Log LOG = Log.getLog((String)"rdb.jdbc");
    private Array fieldValues = new Array(class$java$lang$String == null ? (class$java$lang$String = RdbmsPreparedStatement.class$("java.lang.String")) : class$java$lang$String);
    private final Connection conn;
    private final String sql;
    private final PreparedStatement prep;
    static /* synthetic */ Class class$java$lang$String;

    public RdbmsPreparedStatement(Connection conn, String sql) {
        try {
            this.conn = conn;
            this.prep = conn.prepareStatement(sql);
            this.sql = sql;
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public RdbmsPreparedStatement(Connection conn, String sql, int autoKey) {
        try {
            this.conn = conn;
            this.prep = conn.prepareStatement(sql, autoKey);
            this.sql = sql;
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setInt(int idx, int val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)Integer.toString(val));
            this.prep.setInt(idx, val);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setLong(int idx, long val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)Long.toString(val));
            this.prep.setLong(idx, val);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setFloat(int idx, float val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)Float.toString(val));
            if (Float.isNaN(val)) {
                this.prep.setNull(idx, 7);
            } else {
                this.prep.setFloat(idx, val);
            }
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setDouble(int idx, double val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)Double.toString(val));
            if (Double.isNaN(val)) {
                this.prep.setNull(idx, 6);
            } else {
                this.prep.setDouble(idx, val);
            }
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setBoolean(int idx, boolean val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)Boolean.toString(val));
            this.prep.setBoolean(idx, val);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setTimestamp(int idx, Timestamp val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)val.toString());
            this.prep.setTimestamp(idx, val);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setTimestamp(int idx, Timestamp val, Calendar cal) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)val.toString());
            this.prep.setTimestamp(idx, val, cal);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setDate(int idx, Date val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)val.toString());
            this.prep.setDate(idx, val);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setString(int idx, String val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)val);
            this.prep.setString(idx, val);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setBytes(int idx, byte[] val) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)"<bytes>");
            this.prep.setBytes(idx, val);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setNull(int idx, int jdbcType) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)"<null>");
            this.prep.setNull(idx, jdbcType);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setBinaryStream(int idx, InputStream stream, int length) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)"<BinaryStream>");
            this.prep.setBinaryStream(idx, stream, length);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setCharacterStream(int idx, Reader reader, int length) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, idx);
            this.fieldValues.set(idx - 1, (Object)"<CharacterStream>");
            this.prep.setCharacterStream(idx, reader, length);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setFieldDebugString(int idx, String str) {
        this.fieldValues.set(idx - 1, (Object)str);
    }

    public int executeUpdate() {
        try {
            if (LOG.isTraceOn()) {
                LOG.trace(this.sql + ": " + this.fieldValues);
            }
            return this.prep.executeUpdate();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public ResultSet executeQuery() {
        try {
            if (LOG.isTraceOn()) {
                LOG.trace(this.sql + ": " + this.fieldValues);
            }
            return this.prep.executeQuery();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public ResultSet getGeneratedKeys() {
        try {
            return this.prep.getGeneratedKeys();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void addBatch() {
        try {
            this.prep.addBatch();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void executeBatch() {
        try {
            if (LOG.isTraceOn()) {
                LOG.trace("executeBatch: " + this.sql);
            }
            this.prep.executeBatch();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private static void grow(Array arr, int idx) {
        while (arr.size() < idx) {
            arr.add(null);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public PreparedStatement getStatement() {
        return this.prep;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

