/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.aes;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.aes.BPassKey;
import java.security.SecureRandom;
import javax.baja.log.Log;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.BNotification;
import javax.baja.util.Lexicon;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class BRdbSecuritySettings
extends BComponent {
    public static final Property passkey = BRdbSecuritySettings.newProperty((int)1, (BValue)BPassword.make((String)"niagara"), null);
    public static final Property saltString = BRdbSecuritySettings.newProperty((int)5, (String)BString.DEFAULT.getString(), null);
    public static final Action enterPassKey = BRdbSecuritySettings.newAction((int)0, (BValue)new BPassKey(), null);
    public static final Topic changeOfPassKey = BRdbSecuritySettings.newTopic((int)0, null);
    public static final Topic resetOfPassKey = BRdbSecuritySettings.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$aes$BRdbSecuritySettings == null ? (class$com$tridium$rdb$aes$BRdbSecuritySettings = BRdbSecuritySettings.class$("com.tridium.rdb.aes.BRdbSecuritySettings")) : class$com$tridium$rdb$aes$BRdbSecuritySettings));
    public static final BIcon ICON = BIcon.std((String)"keys.png");
    public static final Log LOG = Log.getLog((String)"rdb");
    public static final Lexicon lex = Lexicon.make((String)"rdb");
    public static final BPasswordStrength RDB_PASSWORD_STRENGTH = new BPasswordStrength(10, 1, 1, 1, 0);
    private AesSysKeyEncoder encoder;
    private SecretKey secretKey;
    private int symmetricKeyIterationCount = 65536;
    private int keySize = 256;
    private static final String UTF_8 = "UTF-8";
    private static final String SECRET_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA1";
    static /* synthetic */ Class class$com$tridium$rdb$aes$BRdbSecuritySettings;

    public BPassword getPasskey() {
        return (BPassword)this.get(passkey);
    }

    public void setPasskey(BPassword v) {
        this.set(passkey, (BValue)v, null);
    }

    public String getSaltString() {
        return this.getString(saltString);
    }

    public void setSaltString(String v) {
        this.setString(saltString, v, null);
    }

    public void enterPassKey(BPassKey changePassKey) {
        this.invoke(enterPassKey, (BValue)changePassKey, null);
    }

    public void fireChangeOfPassKey(BPassword event) {
        this.fire(changeOfPassKey, (BValue)event, null);
    }

    public void fireResetOfPassKey(BPassword event) {
        this.fire(resetOfPassKey, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void changeSecretKey(String userKey) throws Exception {
        this.secretKey = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM).generateSecret(new PBEKeySpec(userKey.toCharArray(), this.getSaltString().getBytes(UTF_8), this.symmetricKeyIterationCount, this.keySize));
        this.encoder.setSecretKey(this.secretKey);
    }

    public AesSysKeyEncoder getEncoder() {
        try {
            if (BString.DEFAULT.getString().equals(this.getSaltString())) {
                this.setSaltString(this.generateSalt());
            }
            if (this.secretKey == null) {
                this.secretKey = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM).generateSecret(new PBEKeySpec(this.getPasskey().getValue().toCharArray(), this.getSaltString().getBytes(UTF_8), this.symmetricKeyIterationCount, this.keySize));
            }
            if (this.encoder == null) {
                this.encoder = new AesSysKeyEncoder(this.secretKey);
            }
        }
        catch (Exception e) {
            LOG.error(lex.getText("rdb.rdbSecuritySettings.encoderException.message"), (Throwable)e);
        }
        return this.encoder;
    }

    private String generateSalt() throws Exception {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return new String(bytes);
    }

    public void doEnterPassKey(BPassKey changePassKey, Context cx) throws Exception {
        String message = null;
        String passKey = this.getPasskey().getValue();
        String userPassword = changePassKey.getUserPassword().getValue();
        String newPassKey = changePassKey.getNewPassKey().getValue();
        String confirmPassKey = changePassKey.getConfirmPassKey().getValue();
        if (!cx.getUser().getPassword().validate(userPassword)) {
            message = lex.getText("rdb.rdbSecuritySettings.incorrectPassword.message");
        } else if (newPassKey.equals(passKey)) {
            message = lex.getText("rdb.rdbSecuritySettings.samePassKey.message");
        } else if (newPassKey.equals("")) {
            message = lex.getText("rdb.rdbSecuritySettings.blankPassKey.message");
        } else if (!newPassKey.equals(confirmPassKey)) {
            message = lex.getText("rdb.rdbSecuritySettings.noMatchPassKey.message");
        } else {
            try {
                RDB_PASSWORD_STRENGTH.isPasswordValid(newPassKey);
            }
            catch (Exception e) {
                message = e.getMessage();
            }
        }
        if (message != null) {
            throw new ActionInvokeException(message, (Throwable)new IllegalArgumentException());
        }
        this.fireChangeOfPassKey(changePassKey.getNewPassKey());
        BNotification notify = new BNotification();
        notify.add("title", (BValue)BString.make((String)lex.getText("rdb.rdbSecuritySettings.restartStation.title")));
        notify.add("message", (BValue)BString.make((String)lex.getText("rdb.rdbSecuritySettings.restartStation.message")));
        notify.raise(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

