/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.aes;

import com.tridium.rdb.exception.PasswordCipherException;
import java.security.Key;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesSysKeyEncoder {
    private static final Log LOG = Log.getLog((String)"rdb");
    private SecretKey secretKey;
    private static final String UTF_8 = "UTF-8";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public AesSysKeyEncoder(SecretKey secretKey) {
        try {
            this.secretKey = secretKey;
        }
        catch (Exception e) {
            LOG.error("Problem in initializing class.", (Throwable)e);
            throw new PasswordCipherException("Problem in initializing specification.");
        }
    }

    public synchronized String encrypt(String plainText) throws Exception {
        Cipher encryptionCipher = Cipher.getInstance(CIPHER_ALGORITHM);
        encryptionCipher.init(1, new SecretKeySpec(this.secretKey.getEncoded(), CIPHER_ALGORITHM));
        byte[] encryptionIvBytes = ((IvParameterSpec)encryptionCipher.getParameters().getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = AesSysKeyEncoder.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)).getIV();
        return ByteArrayUtil.toHexString((byte[])encryptionIvBytes) + ":" + ByteArrayUtil.toHexString((byte[])encryptionCipher.doFinal(plainText.getBytes(UTF_8)));
    }

    public synchronized String decrypt(String encryptedText) throws Exception {
        String decodedValue = null;
        try {
            String[] stringArray = encryptedText.split(":");
            if (stringArray.length != 2) {
                throw new PasswordCipherException("User Pin cannot be decrypted.");
            }
            byte[] encryptedBytes = ByteArrayUtil.hexStringToBytes((String)stringArray[1]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKey.getEncoded(), CIPHER_ALGORITHM);
            String ivHexString = stringArray[0];
            byte[] ivBytes = ByteArrayUtil.hexStringToBytes((String)ivHexString);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
            Cipher decryptionCipher = Cipher.getInstance(CIPHER_ALGORITHM);
            decryptionCipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            decodedValue = new String(decryptionCipher.doFinal(encryptedBytes));
        }
        catch (Exception e) {
            LOG.error("Problem in parsing, probably the text is bad.", (Throwable)e);
            throw new PasswordCipherException("Problem in initializing specification.");
        }
        return decodedValue;
    }

    public void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

