/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.collection.BGenericTable;
import com.tridium.rdb.RdbmsUtil;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BAbsTimeTranslator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.baja.history.BTrendFlags;
import javax.baja.nre.util.Array;
import javax.baja.rdb.RdbmsContext;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BResultSetTable
extends BGenericTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$BResultSetTable == null ? (class$com$tridium$rdb$BResultSetTable = BResultSetTable.class$("com.tridium.rdb.BResultSetTable")) : class$com$tridium$rdb$BResultSetTable));
    static /* synthetic */ Class class$com$tridium$rdb$BResultSetTable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BResultSetTable(Connection conn, String sql, RdbmsContext cx) {
        super(BResultSetTable.load(conn, sql, cx));
    }

    private static BComponent[] load(Connection conn, String sql, RdbmsContext cx) {
        try {
            ResultSet rs = conn.createStatement().executeQuery(sql);
            ResultSetMetaData meta = rs.getMetaData();
            BResultSetTable.checkFieldTypes(meta);
            Array arr = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BResultSetTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
            while (rs.next()) {
                arr.add((Object)BResultSetTable.makeComponent(meta, rs, cx));
            }
            rs.close();
            return (BComponent[])arr.trim();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private static void checkFieldTypes(ResultSetMetaData meta) throws SQLException {
        block3: for (int i = 1; i <= meta.getColumnCount(); ++i) {
            Object type = null;
            switch (meta.getColumnType(i)) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 93: {
                    continue block3;
                }
                default: {
                    System.out.println("WARNING: Column " + meta.getColumnName(i) + ": " + "Converting unknown SQL Type '" + meta.getColumnTypeName(i) + "' (" + meta.getColumnType(i) + ") to String.");
                }
            }
        }
    }

    private static BComponent makeComponent(ResultSetMetaData meta, ResultSet rs, RdbmsContext cx) throws SQLException {
        BComponent comp = new BComponent();
        block11: for (int i = 1; i <= meta.getColumnCount(); ++i) {
            String colName = meta.getColumnName(i);
            if (colName.equals("")) {
                colName = "column" + i;
            }
            if (RdbmsUtil.isBlacklistProperty(colName.toLowerCase())) continue;
            switch (meta.getColumnType(i)) {
                case -1: 
                case 1: 
                case 12: {
                    String str = rs.getString(i);
                    comp.add(colName, (BValue)BString.make((String)(str == null ? "" : str)));
                    continue block11;
                }
                case -7: {
                    comp.add(colName, (BValue)BBoolean.make((boolean)rs.getBoolean(i)));
                    continue block11;
                }
                case 2: {
                    if (colName.equals("TRENDFLAGS")) {
                        comp.add(colName, (BValue)BTrendFlags.make((int)rs.getInt(i)));
                        continue block11;
                    }
                    if (colName.equals("STATUS")) {
                        comp.add(colName, (BValue)BStatus.make((int)rs.getInt(i)));
                        continue block11;
                    }
                    comp.add(colName, (BValue)BDouble.make((double)rs.getDouble(i)));
                    continue block11;
                }
                case 3: 
                case 6: 
                case 8: {
                    comp.add(colName, (BValue)BDouble.make((double)rs.getDouble(i)));
                    continue block11;
                }
                case 7: {
                    comp.add(colName, (BValue)BFloat.make((float)rs.getFloat(i)));
                    continue block11;
                }
                case -5: {
                    comp.add(colName, (BValue)BLong.make((long)rs.getLong(i)));
                    continue block11;
                }
                case -6: 
                case 4: 
                case 5: {
                    if (colName.equals("TRENDFLAGS")) {
                        comp.add(colName, (BValue)BTrendFlags.make((int)rs.getInt(i)));
                        continue block11;
                    }
                    if (colName.equals("STATUS")) {
                        comp.add(colName, (BValue)BStatus.make((int)rs.getInt(i)));
                        continue block11;
                    }
                    comp.add(colName, (BValue)BInteger.make((int)rs.getInt(i)));
                    continue block11;
                }
                case 91: 
                case 93: {
                    RdbmsDialect dialect;
                    boolean deprecatedDialect = true;
                    Timestamp timestamp = null;
                    if (cx instanceof RdbmsDialect && meta.getColumnType(i) == 93 && (dialect = (RdbmsDialect)cx).useUtcTimestamps()) {
                        deprecatedDialect = false;
                        timestamp = rs.getTimestamp(i, BAbsTimeTranslator.getUtcCalendar());
                    }
                    if (deprecatedDialect) {
                        timestamp = rs.getTimestamp(i);
                    }
                    comp.add(colName, (BValue)(timestamp == null ? BAbsTime.NULL : BAbsTime.make((long)timestamp.getTime())));
                    continue block11;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] b = rs.getBytes(i);
                    comp.add(colName, (BValue)BBlob.make((byte[])(b == null ? new byte[]{} : b)));
                    continue block11;
                }
                default: {
                    String str = rs.getString(i);
                    comp.add(colName, (BValue)BString.make((String)(str == null ? "" : str)));
                }
            }
        }
        return comp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

