/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.rdb.BRdbmsDiscoveredTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.SlotPath;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.security.BPassword;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRdbmsDiscoverTablesJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$BRdbmsDiscoverTablesJob == null ? (class$com$tridium$rdb$BRdbmsDiscoverTablesJob = BRdbmsDiscoverTablesJob.class$("com.tridium.rdb.BRdbmsDiscoverTablesJob")) : class$com$tridium$rdb$BRdbmsDiscoverTablesJob));
    private static BIcon icon = BIcon.std((String)"find.png");
    private static String[] typeFilter = new String[]{"TABLE"};
    BRdbmsHistoryDeviceExt histDevExt;
    boolean discoverCanceled = false;
    static /* synthetic */ Class class$com$tridium$rdb$BRdbmsDiscoverTablesJob;

    public Type getType() {
        return TYPE;
    }

    public BRdbmsDiscoverTablesJob(BRdbmsHistoryDeviceExt histDevExt) {
        this.histDevExt = histDevExt;
    }

    public BRdbmsDiscoverTablesJob() {
    }

    public void doCancel(Context cx) {
        this.discoverCanceled = true;
        super.doCancel(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.histDevExt == null) {
            throw new IllegalStateException("Must submit through RdbmsHistoryDeviceExt.submitRdbTableDiscoveryJob()");
        }
        if (this.discoverCanceled) {
            throw new JobCancelException();
        }
        this.progress(0);
        this.log().start("Rdb Table Discovery");
        this.removeAll();
        Connection con = null;
        ResultSet rs = null;
        try {
            BPassword password;
            BRdbms db = (BRdbms)this.histDevExt.getDevice();
            String userName = db.getUserName();
            if (userName == null) {
                userName = "";
            }
            if ((password = db.getPassword()) == null) {
                password = BPassword.DEFAULT;
            }
            con = db.getConnection(userName, password);
            this.log().message("  Finding catalogs...");
            DatabaseMetaData metaData = con.getMetaData();
            rs = metaData.getCatalogs();
            Vector<String> searchList = new Vector<String>();
            searchList.addElement("");
            while (rs.next()) {
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                String catalog = rs.getString("TABLE_CAT");
                this.log().message("    Found catalog: " + catalog);
                if (catalog == null) continue;
                searchList.addElement(catalog);
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.progress(10);
            int numCatalogs = searchList.size();
            this.log().message("  Found " + (numCatalogs - 1) + " total catalogs.");
            this.log().message("  Finding tables in each catalog...");
            Vector<String> tableList = new Vector<String>();
            Vector<Object> catalogList = new Vector<Object>();
            Vector<Object> schemaList = new Vector<Object>();
            for (int i = 0; i < numCatalogs; ++i) {
                this.progress((int)((float)i / (float)numCatalogs * 20.0f) + 10);
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                try {
                    rs = metaData.getTables((String)searchList.elementAt(i), null, null, typeFilter);
                }
                catch (SQLException e) {
                    this.log().failed("    Encountered problem finding tables for catalog " + searchList.elementAt(i), (Throwable)e);
                    if (rs == null) continue;
                    try {
                        rs.close();
                    }
                    catch (Exception ex) {}
                    continue;
                }
                while (rs.next()) {
                    if (this.discoverCanceled) {
                        throw new JobCancelException();
                    }
                    tableList.addElement(rs.getString("TABLE_NAME"));
                    String catalog = rs.getString("TABLE_CAT");
                    catalogList.addElement(catalog != null ? catalog : new Object());
                    String schema = rs.getString("TABLE_SCHEM");
                    schemaList.addElement(schema != null ? schema : new Object());
                }
                if (rs == null) continue;
                try {
                    rs.close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.progress(30);
            int numTables = tableList.size();
            this.log().message("  Found " + numTables + " total tables.");
            this.log().message("  Finding columns for each table...");
            for (int i = 0; i < numTables; ++i) {
                this.progress((int)((float)i / (float)numTables * 70.0f) + 30);
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                String tableName = (String)tableList.elementAt(i);
                if (tableName == null) continue;
                BRdbmsDiscoveredTable discovery = new BRdbmsDiscoveredTable(tableName);
                Object catalog = catalogList.elementAt(i);
                boolean nonNullCatalog = catalog instanceof String;
                discovery.setCatalogName(nonNullCatalog ? (String)catalog : "");
                Object schema = schemaList.elementAt(i);
                boolean nonNullSchema = schema instanceof String;
                discovery.setSchemaName(nonNullSchema ? (String)schema : "");
                try {
                    rs = metaData.getColumns(nonNullCatalog ? (String)catalog : null, nonNullSchema ? (String)schema : null, tableName, null);
                }
                catch (SQLException e) {
                    this.log().failed("    Encountered problem finding columns for table " + tableName + " (catalog=" + (nonNullCatalog ? (String)catalog : "null") + ", schema=" + (nonNullSchema ? (String)schema : "null") + ")", (Throwable)e);
                    if (rs == null) continue;
                    try {
                        rs.close();
                    }
                    catch (Exception ex) {}
                    continue;
                }
                Vector<String> columnList = new Vector<String>();
                while (rs.next()) {
                    if (this.discoverCanceled) {
                        throw new JobCancelException();
                    }
                    columnList.addElement(rs.getString("COLUMN_NAME"));
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                int numColumns = columnList.size();
                String[] colEnumTags = null;
                BEnumRange range = null;
                if (numColumns > 0) {
                    colEnumTags = new String[numColumns];
                    for (int j = 0; j < numColumns; ++j) {
                        colEnumTags[j] = SlotPath.escape((String)((String)columnList.elementAt(j)));
                    }
                    range = BEnumRange.make((String[])colEnumTags);
                    discovery.setTimestampColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                    discovery.setValueColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                    discovery.setStatusColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                }
                this.add("s" + i, (BValue)discovery, 1);
            }
            this.progress(100);
            this.log().message("  Finished finding columns for each table.");
            this.log().success("Rdb Table Discovery complete (" + numTables + " tables found).");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

