/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.BIAgent;
import javax.baja.history.BTrendFlags;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public abstract class BRdbmsDeprecatedDialect
extends BObject
implements BIAgent {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$BRdbmsDeprecatedDialect == null ? (class$com$tridium$rdb$BRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.class$("com.tridium.rdb.BRdbmsDeprecatedDialect")) : class$com$tridium$rdb$BRdbmsDeprecatedDialect));
    private static final int VARCHAR_SIZE = 500;
    public static final String WIDTH = "width";
    private BTimeZone timeZone = null;
    private Calendar historyConfigCalendar = null;
    private static final Calendar utcCalender = Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone());
    private static final Calendar localCalender = Calendar.getInstance(BTimeZone.getLocal().getJavaTimeZone());
    protected BRdbms database;
    static /* synthetic */ Class class$com$tridium$rdb$BRdbmsDeprecatedDialect;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public static BRdbmsDeprecatedDialect make(Type dbType) {
        AgentInfo info = Sys.getRegistry().getAgents(dbType.getTypeInfo()).filter(AgentFilter.is((Type)TYPE)).getDefault();
        return (BRdbmsDeprecatedDialect)info.getAgentType().getTypeSpec().getInstance();
    }

    public static BRdbmsDeprecatedDialect make(BRdbms database) {
        BRdbmsDeprecatedDialect dialect = BRdbmsDeprecatedDialect.make(database.getType());
        dialect.database = database;
        return dialect;
    }

    public abstract boolean tableExists(BRdbms var1, Connection var2, String var3) throws SQLException;

    public String getSqlType(Property prop) {
        return this.getSqlType(prop.getType(), prop.getFacets());
    }

    public abstract String getSqlType(Type var1, BFacets var2);

    public abstract long getTimestampAccuracy();

    public abstract String getPrimaryKeySql();

    public abstract int getMaxTableName();

    public abstract int getMaxIndexName();

    public abstract int getMaxColumnName();

    public abstract int getMaxSequenceName();

    public abstract boolean hasSequences();

    public abstract boolean allowsUnicode();

    protected String makeColumnName(String name) {
        return "\"" + name + "\"";
    }

    public boolean supportsTimestamp() {
        return true;
    }

    public int getVarcharSize(BFacets facets) {
        if (facets != null && !facets.isNull()) {
            return facets.geti(WIDTH, 500);
        }
        return 500;
    }

    public String makeCreateTableSql(String name, Property[] template, String[] extraFields, Type[] extraFieldTypes, BFacets[] extraFacets) {
        return this.makeCreateTableSql(name, true, template, extraFields, extraFieldTypes, extraFacets);
    }

    public String makeCreateTableSql(String name, boolean autoKey, Property[] template, String[] extraFields, Type[] extraFieldTypes, BFacets[] extraFacets) {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(name);
        sql.append(" (");
        if (autoKey) {
            sql.append("ID ").append(this.getPrimaryKeySql());
        }
        String[] fieldNames = this.getTemplateColumnNames(template, extraFields);
        for (i = 0; i < template.length; ++i) {
            if (i > 0 || autoKey) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(fieldNames[i]));
            sql.append(" ").append(this.getSqlType(template[i]));
        }
        for (i = 0; i < extraFields.length; ++i) {
            sql.append(", ").append(this.makeColumnName(extraFields[i]));
            sql.append(" ").append(this.getSqlType(extraFieldTypes[i], extraFacets[i]));
        }
        sql.append(")");
        return sql.toString();
    }

    public String makeInsertSql(String tableName, Property[] template, String[] extraFields) {
        return this.makeInsertSql(tableName, true, template, extraFields);
    }

    public String makeInsertSql(String tableName, boolean autokey, Property[] template, String[] extraFields) {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        int n = 0;
        sql.append(" (");
        if (this.hasSequences() && autokey) {
            sql.append("ID");
            ++n;
        }
        String[] fieldNames = this.getTemplateColumnNames(template, extraFields);
        for (i = 0; i < template.length; ++i) {
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(fieldNames[i]));
        }
        for (i = 0; i < extraFields.length; ++i) {
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(extraFields[i]));
        }
        sql.append(")");
        n = 0;
        sql.append(" VALUES (");
        if (this.hasSequences() && autokey) {
            sql.append(tableName + "_Q.NEXTVAL");
            ++n;
        }
        for (i = 0; i < template.length; ++i) {
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        for (i = 0; i < extraFields.length; ++i) {
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }

    public String makeUpdateSql(String tableName, Property[] template, String[] extraFields, String keyName) {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(tableName);
        int n = 0;
        sql.append(" SET ");
        String[] fieldNames = this.getTemplateColumnNames(template, extraFields);
        for (i = 0; i < template.length; ++i) {
            if (fieldNames[i].equals(keyName)) continue;
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(fieldNames[i]));
            sql.append(" = ?");
        }
        for (i = 0; i < extraFields.length; ++i) {
            if (extraFields[i].equals(keyName)) continue;
            if (n++ > 0) {
                sql.append(", ");
            }
            sql.append(this.makeColumnName(extraFields[i]));
            sql.append(" = ?");
        }
        sql.append(" WHERE ");
        sql.append(keyName);
        sql.append(" = ?");
        return sql.toString();
    }

    public String makeAddColumnSql(String tableName, String columnName, BSqlType columnType, int columnSize, String defaultValue) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ").append(tableName).append(" ");
        sql.append("ADD ").append(columnName).append(" ").append(this.getDataType(columnType));
        if (columnSize > -1) {
            sql.append("(" + columnSize + ") ");
        } else {
            sql.append(" ");
        }
        sql.append("NOT NULL DEFAULT ");
        if (columnType.equals((Object)BSqlType.sqlVarchar) || columnType.equals((Object)BSqlType.sqlNVarchar)) {
            defaultValue = "'" + defaultValue + "'";
        }
        sql.append(defaultValue);
        return sql.toString();
    }

    public abstract String makeAlterColumnTypeSql(String var1, String var2, BSqlType var3, int var4);

    public abstract String makeDropIndexSql(String var1, String var2);

    public String getDataType(BSqlType type) {
        switch (type.getOrdinal()) {
            case 0: {
                return this.getSqlType(BInteger.TYPE, null);
            }
            case 1: {
                return this.getSqlType(BLong.TYPE, null);
            }
            case 2: {
                return this.getSqlType(BFloat.TYPE, null);
            }
            case 3: {
                return this.getSqlType(BDouble.TYPE, null);
            }
            case 5: {
                return this.getSqlType(BAbsTime.TYPE, null);
            }
        }
        String stringType = this.getSqlType(BString.TYPE, null);
        return stringType.substring(0, stringType.indexOf("("));
    }

    public void loadField(PreparedStatement ps, int paramIdx, BObject field, BFacets facets) throws SQLException {
        Type type = field.getType();
        if (field instanceof BString) {
            ps.setString(paramIdx, TextUtil.truncate((String)((BString)field).getString(), (int)this.getVarcharSize(facets)));
        } else if (field instanceof BInteger) {
            ps.setInt(paramIdx, ((BInteger)field).getInt());
        } else if (field instanceof BLong) {
            ps.setLong(paramIdx, ((BLong)field).getLong());
        } else if (field instanceof BFloat) {
            float floatVal = ((BFloat)field).getFloat();
            if (Float.isNaN(floatVal)) {
                ps.setNull(paramIdx, 7);
            } else {
                ps.setFloat(paramIdx, floatVal);
            }
        } else if (field instanceof BDouble) {
            double doubleVal = ((BDouble)field).getDouble();
            if (Double.isNaN(doubleVal)) {
                ps.setNull(paramIdx, 6);
            } else {
                ps.setDouble(paramIdx, doubleVal);
            }
        } else if (field instanceof BAbsTime) {
            if (this.supportsTimestamp()) {
                Timestamp ts = new Timestamp(((BAbsTime)field).getMillis());
                RdbmsDialect context = (RdbmsDialect)this.database.getRdbmsContext();
                Calendar tsCalender = context.useUtcTimestamps() ? utcCalender : (this.timeZone != null ? this.historyConfigCalendar : localCalender);
                ps.setTimestamp(paramIdx, ts, tsCalender);
            } else {
                BAbsTime time = (BAbsTime)field;
                long utcMillis = time.getMillis();
                ps.setLong(paramIdx, utcMillis);
            }
        } else if (field instanceof BRelTime) {
            ps.setLong(paramIdx, ((BRelTime)field).getMillis());
        } else if (field instanceof BBoolean) {
            ps.setBoolean(paramIdx, ((BBoolean)field).getBoolean());
        } else if (field instanceof BStatus) {
            ps.setInt(paramIdx, ((BStatus)field).getBits());
        } else if (field instanceof BTrendFlags) {
            ps.setInt(paramIdx, ((BTrendFlags)field).getBits());
        } else if (field instanceof BTimeZone) {
            ps.setString(paramIdx, TextUtil.truncate((String)field.toString(), (int)this.getVarcharSize(facets)));
        } else if (field instanceof BSimple) {
            try {
                ps.setString(paramIdx, ((BSimple)field).encodeToString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ps.setString(paramIdx, TextUtil.truncate((String)field.toString(), (int)this.getVarcharSize(facets)));
        }
    }

    public void insertRecord(PreparedStatement ps, BComplex comp, Property[] template, BObject[] extraValues, BFacets[] extraFacets) throws SQLException {
        int i;
        int n = 1;
        if (comp != null) {
            for (i = 0; i < template.length; ++i) {
                this.loadField(ps, n++, (BObject)comp.get(template[i]), template[i].getFacets());
            }
        }
        for (i = 0; i < extraValues.length; ++i) {
            this.loadField(ps, n++, extraValues[i], extraFacets[i]);
        }
        ps.addBatch();
    }

    public void updateRecord(PreparedStatement ps, BComplex comp, Property[] template, BObject[] extraValues, BFacets[] extraFacets, String keyName, BObject keyValue) throws SQLException {
        int i;
        int n = 1;
        String[] fieldNames = this.getTemplateColumnNames(template, new String[0]);
        for (i = 0; i < template.length; ++i) {
            if (fieldNames[i].equals(keyName)) continue;
            this.loadField(ps, n++, (BObject)comp.get(template[i]), template[i].getFacets());
        }
        for (i = 0; i < extraValues.length; ++i) {
            this.loadField(ps, n++, extraValues[i], extraFacets[i]);
        }
        this.loadField(ps, n++, keyValue, BFacets.NULL);
        ps.addBatch();
    }

    public String[] getTemplateColumnNames(Property[] template, String[] extraFields) {
        int max = this.getMaxColumnName();
        Array arr = new Array(class$java$lang$String == null ? (class$java$lang$String = BRdbmsDeprecatedDialect.class$("java.lang.String")) : class$java$lang$String, template.length);
        HashSet<String> set = new HashSet<String>();
        set.addAll(new Array((Object[])extraFields).list());
        for (int i = 0; i < template.length; ++i) {
            String fullName = this.mangleIdentifier(template[i].getName());
            String name = TextUtil.truncate((String)fullName, (int)max);
            if (set.contains(name)) {
                String nn;
                int n = 1;
                while (set.contains(name = TextUtil.truncate((String)fullName, (int)(max - (nn = Integer.toString(n++)).length())) + nn)) {
                }
            }
            set.add(name);
            arr.add((Object)name);
        }
        return (String[])arr.trim();
    }

    public String mangleIdentifier(String name) {
        if ((name = name.toUpperCase()).equals("ID")) {
            return "ID_";
        }
        if (name.equals("SCHEMA")) {
            return "SCHEMA_";
        }
        if (name.equals("INTERVAL")) {
            return "INTERVAL_";
        }
        StringBuffer sb = new StringBuffer();
        char c = name.charAt(0);
        if (this.allowsUnicode() && Character.isLetter(c) || BRdbmsDeprecatedDialect.isAsciiLetter(c) || c == '_') {
            sb.append(c);
        }
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            if ((!this.allowsUnicode() || !Character.isLetterOrDigit(c)) && !BRdbmsDeprecatedDialect.isAsciiLetterOrDigit(c) && c != '_') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isAsciiLetter(char c) {
        return 'A' <= c && c <= 'Z';
    }

    private static boolean isAsciiLetterOrDigit(char c) {
        return 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    public void setTimeZone(BTimeZone timeZone) {
        this.timeZone = timeZone;
        this.historyConfigCalendar = new GregorianCalendar(timeZone.getJavaTimeZone());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

