/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractConnectionPool
extends BComponent {
    public static final Property maxActive = BAbstractConnectionPool.newProperty((int)0, (int)30, null);
    public static final Property maxIdle = BAbstractConnectionPool.newProperty((int)0, (int)10, null);
    public static final Property maxWait = BAbstractConnectionPool.newProperty((int)0, (int)5000, null);
    public static final Property loginTimeout = BAbstractConnectionPool.newProperty((int)0, (int)0, null);
    public static final Property updatePeriod = BAbstractConnectionPool.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Property numActive = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    public static final Property peakNumActive = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    public static final Property numIdle = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    public static final Action updateConnectionStats = BAbstractConnectionPool.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$BAbstractConnectionPool == null ? (class$com$tridium$rdb$BAbstractConnectionPool = BAbstractConnectionPool.class$("com.tridium.rdb.BAbstractConnectionPool")) : class$com$tridium$rdb$BAbstractConnectionPool));
    private static final Log LOG = Log.getLog((String)"rdb");
    private Clock.Ticket updateTicket;
    private Object lock = new Object();
    static /* synthetic */ Class class$com$tridium$rdb$BAbstractConnectionPool;

    public int getMaxActive() {
        return this.getInt(maxActive);
    }

    public void setMaxActive(int v) {
        this.setInt(maxActive, v, null);
    }

    public int getMaxIdle() {
        return this.getInt(maxIdle);
    }

    public void setMaxIdle(int v) {
        this.setInt(maxIdle, v, null);
    }

    public int getMaxWait() {
        return this.getInt(maxWait);
    }

    public void setMaxWait(int v) {
        this.setInt(maxWait, v, null);
    }

    public int getLoginTimeout() {
        return this.getInt(loginTimeout);
    }

    public void setLoginTimeout(int v) {
        this.setInt(loginTimeout, v, null);
    }

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    public int getNumActive() {
        return this.getInt(numActive);
    }

    public void setNumActive(int v) {
        this.setInt(numActive, v, null);
    }

    public int getPeakNumActive() {
        return this.getInt(peakNumActive);
    }

    public void setPeakNumActive(int v) {
        this.setInt(peakNumActive, v, null);
    }

    public int getNumIdle() {
        return this.getInt(numIdle);
    }

    public void setNumIdle(int v) {
        this.setInt(numIdle, v, null);
    }

    public void updateConnectionStats() {
        this.invoke(updateConnectionStats, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == updatePeriod) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
            }
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateConnectionStats, null);
        }
    }

    public void subscribed() {
        this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateConnectionStats, null);
    }

    public void unsubscribed() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
        }
    }

    public abstract void doUpdateConnectionStats();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getConnection(String userName, String password) throws SQLException {
        int timeout = this.getLoginTimeout();
        LOG.trace("pool.getConnection, timeout: " + timeout);
        if (timeout < 0) {
            throw new BajaRuntimeException("loginTimeout cannot be less than zero.");
        }
        if (timeout == 0) {
            Object object = this.lock;
            synchronized (object) {
                return this.obtainConnection(userName, password);
            }
        }
        Producer producer = new Producer(this, userName, password);
        new Thread(producer).start();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!producer.isFinished()) {
            LOG.trace("pool.getConnection, timed out, timeout: " + timeout);
            throw new BajaRuntimeException("pool.getConnection, timed out, timeout: " + timeout);
        }
        if (producer.getException() == null) {
            return producer.getConnection();
        }
        throw producer.getException();
    }

    protected abstract Connection obtainConnection(String var1, String var2) throws SQLException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Producer
    extends Thread {
        private final BAbstractConnectionPool pool;
        private final String userName;
        private final String password;
        private boolean finished;
        private Connection connection;
        private SQLException exception;

        private Producer(BAbstractConnectionPool pool, String userName, String password) {
            this.pool = pool;
            this.userName = userName;
            this.password = password;
            this.finished = false;
            this.connection = null;
            this.exception = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.pool.lock;
                synchronized (object) {
                    this.connection = this.pool.obtainConnection(this.userName, this.password);
                    this.finished = true;
                    this.pool.lock.notifyAll();
                }
            }
            catch (SQLException e) {
                Producer producer = this;
                synchronized (producer) {
                    this.exception = e;
                }
            }
        }

        private synchronized boolean isFinished() {
            return this.finished;
        }

        private synchronized SQLException getException() {
            return this.exception;
        }

        private synchronized Connection getConnection() {
            return this.connection;
        }
    }
}

