/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.util;

import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XNetVariable;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUtil;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class SnvtUtil {
    public static BLonData getLonData(int n, int n2) {
        BLonData bLonData = SnvtUtil.getLonData(n);
        if (bLonData != null) {
            return bLonData;
        }
        return new BLonData(BLonByteArray.make(n2), BLonElementQualifiers.make(BLonElementType.na, n2), null);
    }

    public static BLonData getLonData(int n) {
        return SnvtUtil.getLonData(n, false);
    }

    public static BLonData getLonData(int n, boolean bl) {
        XLonInterfaceFile xLonInterfaceFile = XUtil.getStandard();
        Vector vector = xLonInterfaceFile.types;
        String string = "0," + Integer.toString(n);
        int n2 = 0;
        while (n2 < vector.size()) {
            XTypeDef xTypeDef = (XTypeDef)vector.elementAt(n2);
            if (!xTypeDef.isCpType() && xTypeDef.getTypeScope().equals(string)) {
                BLonData bLonData = xTypeDef.getLonData(xLonInterfaceFile);
                if (bl) {
                    SnvtUtil.makeDiff(bLonData);
                }
                return bLonData;
            }
            ++n2;
        }
        return null;
    }

    public static Object getStandard() {
        return XUtil.getStandard();
    }

    public static BLonData getLonData(Object object, Object object2) {
        return XUtil.getLonDataNv((XNetVariable)object, (XLonInterfaceFile)object2);
    }

    public static BLonEnum getStandardEnum(String string) {
        XLonInterfaceFile xLonInterfaceFile = XUtil.getStandard();
        XEnumDef xEnumDef = xLonInterfaceFile.resolveEnumDef(string);
        if (xEnumDef == null) {
            throw new RuntimeException("No enumType " + string);
        }
        return xEnumDef.getEnum();
    }

    private static final void makeDiff(BLonData bLonData) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            Property property = slotCursor.property();
            Type type = property.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                BFacets bFacets = property.getFacets();
                BUnit bUnit = (BUnit)bFacets.get("units");
                if (!SnvtUtil.isTemp(bUnit)) continue;
                bLonData.setFacets((Slot)property, SnvtUtil.makeNewUnits(bFacets, SnvtUtil.makeTempDiff(bUnit)));
                continue;
            }
            if (!type.is(BLonData.TYPE)) continue;
            SnvtUtil.makeDiff((BLonData)slotCursor.get());
        }
    }

    private static final BUnit makeTempDiff(BUnit bUnit) {
        return UnitDatabase.getUnit((String)(bUnit.getUnitName() + " degrees"));
    }

    private static final boolean isTemp(BUnit bUnit) {
        UnitDatabase.Quantity quantity = UnitDatabase.getDefault().getQuantity(bUnit);
        return quantity.getName().equals("temperature");
    }

    private static final boolean isTempDiff(BUnit bUnit) {
        UnitDatabase.Quantity quantity = UnitDatabase.getDefault().getQuantity(bUnit);
        return quantity.getName().equals("temperature differential");
    }

    private static final BFacets makeNewUnits(BFacets bFacets, BUnit bUnit) {
        BFacets bFacets2 = BFacets.makeRemove((BFacets)bFacets, (String)"units");
        return BFacets.make((BFacets)bFacets2, (String)"units", (BIDataValue)bUnit);
    }
}

