/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.util;

import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.file.LonFileReadWrite;
import com.tridium.lonworks.file.LonFileTransfer;
import com.tridium.lonworks.file.NoDirectoryException;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonException;

public abstract class LonFile {
    public static final boolean ALLOW_RANDOM_ACCESS = true;
    public static final boolean NO_RANDOM_ACCESS = false;
    public static final boolean CREATE_FILE = true;
    public static final boolean ACCESS_FILE = false;
    public static final int CONFIG_TEMPLATE_FILE = 0;
    public static final int READ_WRITE_CONFIG_FILE = 1;
    public static final int READ_ONLY_CONFIG_FILE = 2;
    public static final int CONFIG_PARAM_TEMPLATE_FILE = 2;
    public static final int CONFIG_PARAM_VALUE_FILE = 1;

    public static LonFile createFile(BLonDevice bLonDevice) throws LonException {
        LonFile lonFile = null;
        BINetworkVariable[] bINetworkVariableArray = bLonDevice.getNetworkVariables();
        BNetworkVariable bNetworkVariable = LonFile.findNvByObjectAndType(bLonDevice, bINetworkVariableArray, 114);
        if (bNetworkVariable != null) {
            lonFile = new LonFileReadWrite(bLonDevice, bNetworkVariable);
        } else {
            BNetworkVariable bNetworkVariable2;
            BNetworkVariable bNetworkVariable3 = LonFile.findNvByObjectAndType(bLonDevice, bINetworkVariableArray, 73);
            if (bNetworkVariable3 != null && (bNetworkVariable2 = LonFile.findNvByObjectAndType(bLonDevice, bINetworkVariableArray, 74)) != null) {
                BNetworkVariable bNetworkVariable4 = LonFile.findNvByObjectAndType(bLonDevice, bINetworkVariableArray, 90);
                try {
                    lonFile = new LonFileTransfer(bLonDevice, bNetworkVariable3, bNetworkVariable2, bNetworkVariable4);
                }
                catch (NoDirectoryException noDirectoryException) {
                    bLonDevice.log().warning(bLonDevice.getDisplayName(null) + " has file snvts but reports no file directory");
                    return null;
                }
            } else {
                return null;
            }
        }
        return lonFile;
    }

    private static final BNetworkVariable findNvByObjectAndType(BLonDevice bLonDevice, BINetworkVariable[] bINetworkVariableArray, int n) {
        int n2 = DeviceFacets.getNodeObjectIndex(bLonDevice);
        int n3 = 0;
        while (n3 < bINetworkVariableArray.length) {
            BNetworkVariable bNetworkVariable;
            if (bINetworkVariableArray[n3] != null && bINetworkVariableArray[n3].isNetworkVariable() && (bNetworkVariable = (BNetworkVariable)bINetworkVariableArray[n3]).getNvProps().getObjectIndex() == n2 && bNetworkVariable.getSnvtType() == n) {
                return bNetworkVariable;
            }
            ++n3;
        }
        return null;
    }

    public abstract LonFile copy();

    public abstract void open(int var1, boolean var2, boolean var3) throws LonException;

    public abstract byte[] read(int var1, int var2) throws LonException;

    public abstract byte[] read(int var1) throws LonException;

    public abstract byte[] read() throws LonException;

    public abstract void write(byte[] var1, int var2) throws LonException;

    public abstract void write(byte[] var1) throws LonException;

    public abstract void close() throws LonException;

    public abstract void flush() throws LonException;

    public abstract String getDirectoryString() throws LonException;

    public abstract int findFileNum(int var1);

    public abstract int findFileNum(int var1, int var2);

    public abstract boolean isOpen();

    public boolean supportsRandomAccess() {
        return true;
    }
}

