/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.proxy;

import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.proxy.BLonPointDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BLonProxyExt
extends BProxyExt {
    public static final Property tuningPolicyName = BLonProxyExt.newProperty((int)5, (String)"defaultProxyPolicy", null);
    public static final Property status = BLonProxyExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property deviceFacets = BLonProxyExt.newProperty((int)1, (BValue)BFacets.NULL, null);
    public static final Property targetComp = BLonProxyExt.newProperty((int)8, (String)"value", null);
    public static final Property targetName = BLonProxyExt.newProperty((int)8, (String)"value", null);
    public static final Property linkType = BLonProxyExt.newProperty((int)0, (BValue)BLonLinkType.standard, null);
    public static final Property priority = BLonProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    private static final String RESOLVE_FAULT_MSG = "Can not resolve target: ";
    Worker wrkr;
    ProxyRequest req;
    protected BLonData datPnt;
    protected Property targetProp;
    private boolean isDataPointWriteable;
    private int dataPntMismatchCount;
    private boolean dataPntSubscribed;
    static /* synthetic */ Class class$javax$baja$lonworks$proxy$BLonProxyExt;

    public String getTargetComp() {
        return this.getString(targetComp);
    }

    public void setTargetComp(String string) {
        this.setString(targetComp, string, null);
    }

    public String getTargetName() {
        return this.getString(targetName);
    }

    public void setTargetName(String string) {
        this.setString(targetName, string, null);
    }

    public BLonLinkType getLinkType() {
        return (BLonLinkType)this.get(linkType);
    }

    public void setLinkType(BLonLinkType bLonLinkType) {
        this.set(linkType, (BValue)bLonLinkType, null);
    }

    public boolean getPriority() {
        return this.getBoolean(priority);
    }

    public void setPriority(boolean bl) {
        this.setBoolean(priority, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    private final BLonDevice getLonDevice(BComponent bComponent) {
        while (!(bComponent instanceof BLonDevice)) {
            bComponent = (BComponent)bComponent.getParent();
        }
        return (BLonDevice)bComponent;
    }

    public Type getDeviceExtType() {
        return BLonPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.isDataPointWriteable ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public final void readSubscribed(Context context) throws Exception {
        BLonData bLonData = this.getDataPoint();
        if (bLonData != null && !this.dataPntSubscribed) {
            bLonData.readSubscribed();
            this.dataPntSubscribed = true;
        }
    }

    public final void readUnsubscribed(Context context) throws Exception {
        BLonData bLonData = this.datPnt;
        if (bLonData != null && this.dataPntSubscribed) {
            bLonData.readUnsubscribed();
            this.dataPntSubscribed = false;
        }
    }

    public boolean write(Context context) throws Exception {
        if (!this.isDataPointWriteable || this.isUnoperational()) {
            return false;
        }
        Worker worker = this.getProxyQueue();
        if (worker == null || !worker.isRunning()) {
            return false;
        }
        try {
            ((Queue)worker.getTodo()).enqueue((Object)this.getRequest(context));
        }
        catch (Throwable throwable) {
            this.doProxyWrite(context);
        }
        return false;
    }

    public final void forceUpdate() {
        this.doProxyWrite(BLonNetwork.lonNoWrite);
    }

    private final void doProxyWrite(Context context) {
        if (this.isUnoperational()) {
            return;
        }
        try {
            boolean bl;
            BStatusValue bStatusValue = this.getWriteValue();
            if (bStatusValue.getStatus().isNull()) {
                return;
            }
            BLonData bLonData = this.getDataPoint();
            if (bLonData == null) {
                return;
            }
            BLonPrimitive bLonPrimitive = this.getPrimitiveValue(bStatusValue);
            if (bLonPrimitive == null) {
                this.writeFail("Unable to convert status value to lonPrimitive.");
                return;
            }
            boolean bl2 = false;
            if (context == BTuningPolicy.maxWriteTimeContext || context == BTuningPolicy.writeOnStartContext || context == BTuningPolicy.writeOnUpContext || context == BTuningPolicy.writeOnEnabledContext) {
                bl2 = true;
            }
            if (!(bl = bl2)) {
                bLonData.set(this.targetProp, (BValue)bLonPrimitive, context);
            }
        }
        catch (Throwable throwable) {
            this.writeFail(throwable.toString());
        }
    }

    private final Worker getProxyQueue() {
        if (this.wrkr == null) {
            this.wrkr = ((BLonNetwork)((BLonDevice)this.getDevice()).getNetwork()).getProxyQueue();
        }
        return this.wrkr;
    }

    private final Runnable getRequest(Context context) {
        if (this.req == null) {
            this.req = new ProxyRequest();
        }
        this.req.setContext(context);
        return this.req;
    }

    public final void started() throws Exception {
        BLonComponent bLonComponent;
        super.started();
        this.setStale(false, null);
        this.registerProxy(this.getDataPoint());
        this.checkIfWriteable();
        this.extStarted();
        if (this.getLinkType() == BLonLinkType.unknown && (bLonComponent = this.getLonComponent()) != null && bLonComponent.isNetworkVariable()) {
            this.setLinkType(NvDev.getLinkType((BNetworkVariable)bLonComponent));
        }
    }

    protected void extStarted() {
        this.setReadValue(this.getStatusValue());
    }

    public final void stopped() throws Exception {
        try {
            this.unregisterProxy();
        }
        catch (Throwable throwable) {}
        super.stopped();
    }

    private final void registerProxy(BLonData bLonData) {
        if (bLonData != null) {
            if (this.isSubscribedDesired() && !this.dataPntSubscribed) {
                bLonData.readSubscribed();
                this.dataPntSubscribed = true;
            }
            bLonData.registerProxyExt(this);
        }
    }

    private final void unregisterProxy() {
        BLonData bLonData = this.datPnt;
        if (bLonData != null) {
            if (this.dataPntSubscribed) {
                bLonData.readUnsubscribed();
                this.dataPntSubscribed = false;
            }
            bLonData.unregisterProxyExt(this);
        }
    }

    public boolean isReadWriteProxy() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        block6: {
            block5: {
                try {
                    if (!this.isRunning()) {
                        Object var4_3 = null;
                        break block5;
                    }
                    if (property == targetName || property == targetComp) {
                        this.renew();
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    super.changed(property, context);
                    throw throwable;
                }
            }
            super.changed(property, context);
            return;
        }
        Object var4_5 = null;
        super.changed(property, context);
    }

    public BLonComponent getLonComponent() {
        BLonData bLonData = this.datPnt;
        if (bLonData == null) {
            return null;
        }
        return bLonData.getLonComponent();
    }

    public void renew() {
        this.renew(false);
    }

    public void renew(boolean bl) {
        this.unregisterProxy();
        this.datPnt = null;
        if (bl) {
            this.deviceFacetsChanged();
        }
        this.registerProxy(this.getDataPoint());
    }

    protected void deviceFacetsChanged() {
    }

    public BLonData getDataPoint() {
        BLonData bLonData = this.datPnt;
        this.resolveProxyLink();
        if (bLonData != null && this.datPnt != null && bLonData != this.datPnt) {
            System.out.println(NmUtil.timeStamp() + " resolveProxyLink found new object orig=" + bLonData.getHandle() + " isMounted=" + bLonData.isMounted() + " new=" + this.datPnt.getHandle() + " isMounted=" + this.datPnt.isMounted());
            ++((BLonNetwork)this.getLonDevice((BComponent)this).getNetwork()).dataPntMismatchCount;
            ++this.dataPntMismatchCount;
            this.registerProxy(this.datPnt);
        }
        return this.datPnt;
    }

    private final void resolveProxyLink() {
        BComponent bComponent = null;
        try {
            BLonDevice bLonDevice = this.getLonDevice((BComponent)this);
            BOrd bOrd = BOrd.make((String)("slot:" + this.getTargetComp()));
            bComponent = (BComponent)bOrd.get((BObject)bLonDevice);
            this.targetProp = bComponent.getProperty(this.getTargetName());
        }
        catch (Throwable throwable) {
            bComponent = null;
        }
        if (bComponent == null || this.targetProp == null) {
            if (this.datPnt != null) {
                System.out.println("\nunable to re-resolve proxy reference for " + this.getDevice().getDisplayName(null) + ':' + this.getParent().getDisplayName(null) + ':' + this.datPnt.getDisplayName(null));
                System.out.println("getTargetComp()=" + this.getTargetComp() + " getTargetName()=" + this.getTargetName());
                System.out.println("previous datPnt.isMounted()=" + this.datPnt.isMounted() + " handle=" + this.datPnt.getHandle());
                System.out.println();
            }
            this.datPnt = null;
            this.setFaultCause(RESOLVE_FAULT_MSG + this.toString(null));
            this.setStatus(BStatus.fault);
            this.executePoint();
            throw new UnresolvedException("Cannot resolve proxyLink in " + this.getDevice().getDisplayName(null) + ':' + this.getParent().getDisplayName(null));
        }
        if (this.getStatus().isFault() && this.getFaultCause().indexOf(RESOLVE_FAULT_MSG) >= 0) {
            this.setFaultCause("");
            this.setStatus(BStatus.ok);
            this.getTuning().writeDesired();
        }
        this.datPnt = (BLonData)bComponent;
    }

    protected abstract BLonPrimitive getPrimitiveValue(BStatusValue var1);

    public final BStatusValue getStatusValue() {
        BLonPrimitive bLonPrimitive = this.getTarget();
        if (bLonPrimitive == null) {
            return null;
        }
        return this.getStatusValue(bLonPrimitive);
    }

    protected final BLonPrimitive getTarget() {
        BLonPrimitive bLonPrimitive;
        BLonData bLonData = this.getDataPoint();
        if (bLonData == null || this.targetProp == null) {
            return null;
        }
        try {
            bLonPrimitive = (BLonPrimitive)bLonData.get(this.targetProp);
        }
        catch (Exception exception) {
            System.out.println("ERROR: no property " + this.targetProp.getName() + " in " + bLonData.getDisplayName(null));
            return null;
        }
        return bLonPrimitive;
    }

    public abstract BStatusValue getStatusValue(BLonPrimitive var1);

    public String toString(Context context) {
        return this.getTargetComp() + '/' + this.getTargetName();
    }

    private final void checkIfWriteable() {
        BLonComponent bLonComponent = this.getLonComponent();
        boolean bl = false;
        if (this.getParentPoint().isWritablePoint() && bLonComponent.isWriteable()) {
            bl = true;
        }
        this.isDataPointWriteable = bl;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        BLonData bLonData = this.datPnt;
        spyWriter.startProps();
        spyWriter.trTitle((Object)"LonProxyExt", 2);
        BLonComponent bLonComponent = this.getLonComponent();
        spyWriter.prop((Object)"lonComponent", (Object)(bLonComponent == null ? "null" : bLonComponent.getName()));
        if (bLonData == null) {
            spyWriter.prop((Object)"dataPoint", (Object)"null");
        } else {
            spyWriter.prop((Object)"dataPoint", (Object)bLonData.getName());
            spyWriter.prop((Object)"dataPoint.handle", bLonData.getHandle());
            spyWriter.prop((Object)"dataPoint.isMounted", bLonData.isMounted());
            String string = bLonData.getName();
            string = "<a href='/nav/localhost/station" + bLonData.getSlotPath().getBody() + "'>" + string + "</a>";
            this.spySlot_(spyWriter, string, this.getFlags((Slot)this.targetProp), (Object)bLonData);
        }
        spyWriter.prop((Object)"targetProp", (Object)(this.targetProp == null ? "null" : this.targetProp.getName()));
        spyWriter.prop((Object)"isDataPointWriteable", this.isDataPointWriteable);
        if (bLonData != null && this.targetProp != null) {
            spyWriter.prop((Object)"primitive val", (Object)bLonData.get(this.targetProp).toString(null));
        }
        spyWriter.prop((Object)"dataPntMismatchCount", this.dataPntMismatchCount);
        spyWriter.prop((Object)"dataPointSubscribed", this.dataPntSubscribed);
        spyWriter.endProps();
    }

    private final void spySlot_(SpyWriter spyWriter, String string, int n, Object object) {
        spyWriter.w((Object)"<tr><td align='left' nowrap='true'><b>").w((Object)string).w((Object)"</b>");
        if (n == 0) {
            spyWriter.w((Object)"{0}");
        } else {
            spyWriter.w((Object)" {").w((Object)Flags.encodeToString((int)n)).w((Object)"}");
        }
        spyWriter.w((Object)"</td><td align='left' nowrap='true'>").w(object).w((Object)"</td></tr>\n");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.wrkr = null;
        this.req = null;
        this.datPnt = null;
        this.targetProp = null;
        this.isDataPointWriteable = true;
        this.dataPntMismatchCount = 0;
        this.dataPntSubscribed = false;
    }

    public BLonProxyExt() {
        this.this();
    }

    public BLonProxyExt(OrdTarget ordTarget) {
        this.this();
        BComponent bComponent = ordTarget.getComponent();
        BLonDevice bLonDevice = this.getLonDevice(bComponent);
        String string = bComponent.getSlotPath().toString().substring(bLonDevice.getSlotPath().toString().length() + 1);
        this.setTargetComp(string);
        this.setTargetName(ordTarget.getSlotInComponent().getName());
    }

    static {
        Class clazz = class$javax$baja$lonworks$proxy$BLonProxyExt;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$proxy$BLonProxyExt = BLonProxyExt.class("[Ljavax.baja.lonworks.proxy.BLonProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ProxyRequest
    implements Runnable {
        Context cx;

        public void run() {
            BLonProxyExt.this.doProxyWrite(this.cx);
        }

        public void setContext(Context context) {
            this.cx = context;
        }

        private final /* synthetic */ void this() {
            this.cx = null;
        }

        private ProxyRequest() {
            this.this();
        }
    }
}

