/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.util.HashMap;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonFacetsUtil {
    public static final String TYPE = "type";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String RES = "res";
    public static final String OFF = "off";
    public static final String BYT = "byt";
    public static final String BIT = "bit";
    public static final String LEN = "len";
    public static final String INVLD = "invld";
    public static final String UNITS = "units";
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonData;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonPrimitive;

    public static BLonElementQualifiers getElementQualifiers(BLonData bLonData, Property property) throws LonException {
        BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(property.getFacets());
        if (bLonElementQualifiers.hasOffset()) {
            return bLonElementQualifiers;
        }
        return BLonElementQualifiers.make(bLonElementQualifiers.getElemtype(), bLonElementQualifiers.hasMinimum(), bLonElementQualifiers.getMinimum(), bLonElementQualifiers.hasMaximum(), bLonElementQualifiers.getMaximum(), bLonElementQualifiers.getResolution(), bLonElementQualifiers.getOffset(), true, LonFacetsUtil.getByteOffset(bLonData, property), 0, bLonElementQualifiers.hasInvalidValue(), bLonElementQualifiers.getInvalidValue(), bLonElementQualifiers.getLength());
    }

    private static final int getByteOffset(BLonData bLonData, Property property) {
        EqSearch eqSearch = new EqSearch();
        eqSearch.sLd = bLonData;
        eqSearch.prop = property;
        BLonData bLonData2 = bLonData;
        while (bLonData2.getParent() instanceof BLonData) {
            bLonData2 = (BLonData)bLonData2.getParent();
        }
        LonFacetsUtil.getByteOffset(eqSearch, bLonData2);
        return eqSearch.offset;
    }

    private static final void getByteOffset(EqSearch eqSearch, BLonData bLonData) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Class clazz = class$javax$baja$lonworks$londata$BLonData;
            if (clazz == null) {
                clazz = LonFacetsUtil.class("[Ljavax.baja.lonworks.londata.BLonData;", false);
            }
            if (clazz.isInstance(bObject)) {
                LonFacetsUtil.getByteOffset(eqSearch, (BLonData)bObject);
                if (!eqSearch.found) continue;
                return;
            }
            Class clazz2 = class$javax$baja$lonworks$londata$BLonPrimitive;
            if (clazz2 == null) {
                clazz2 = LonFacetsUtil.class("[Ljavax.baja.lonworks.londata.BLonPrimitive;", false);
            }
            if (!clazz2.isInstance(bObject)) continue;
            Property property = slotCursor.property();
            if (property == eqSearch.prop && bLonData == eqSearch.sLd) {
                eqSearch.found = true;
                return;
            }
            BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(property.getFacets());
            if (bLonElementQualifiers.hasOffset()) {
                eqSearch.offset = bLonElementQualifiers.getByteOffset();
            }
            try {
                eqSearch.offset += bLonElementQualifiers.getDataByteLength();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public static BLonElementQualifiers getQualifiers(BFacets bFacets) {
        BLonElementQualifiers bLonElementQualifiers = (BLonElementQualifiers)((Object)bFacets.getPickle());
        if (bLonElementQualifiers == null) {
            bLonElementQualifiers = LonFacetsUtil.makeLonQualifiers(bFacets, -1);
            BFacets.makePickle((BFacets)bFacets, (Object)((Object)bLonElementQualifiers));
        }
        return bLonElementQualifiers;
    }

    public static BFacets makeFacets(BLonElementQualifiers bLonElementQualifiers, BUnit bUnit) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (bUnit != null) {
            hashMap.put(UNITS, bUnit);
        }
        BLonElementType bLonElementType = bLonElementQualifiers.getElemtype();
        hashMap.put(TYPE, BString.make((String)bLonElementType.getTag()));
        if (bLonElementQualifiers.getByteOffset() > 0) {
            hashMap.put(BYT, BInteger.make((int)bLonElementQualifiers.getByteOffset()));
        }
        switch (bLonElementType.getOrdinal()) {
            case 0: 
            case 6: 
            case 7: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                float f = bLonElementQualifiers.getResolution();
                if (f != 0.0f && f != 1.0f) {
                    hashMap.put(RES, BFloat.make((float)bLonElementQualifiers.getResolution()));
                }
                if (bLonElementQualifiers.getOffset() != 0.0f) {
                    hashMap.put(OFF, BFloat.make((float)bLonElementQualifiers.getOffset()));
                }
                LonFacetsUtil.addMinMax(hashMap, bLonElementQualifiers);
                LonFacetsUtil.addPrec(hashMap, bLonElementQualifiers);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                hashMap.put(BIT, BInteger.make((int)bLonElementQualifiers.getBitOffset()));
                hashMap.put(LEN, BInteger.make((int)bLonElementQualifiers.getLength()));
                break;
            }
            case 12: 
            case 13: {
                hashMap.put(BIT, BInteger.make((int)bLonElementQualifiers.getBitOffset()));
                hashMap.put(LEN, BInteger.make((int)bLonElementQualifiers.getLength()));
                LonFacetsUtil.addMinMax(hashMap, bLonElementQualifiers);
                hashMap.put("precision", BInteger.make((int)0));
                break;
            }
            case 14: 
            case 15: {
                hashMap.put(LEN, BInteger.make((int)bLonElementQualifiers.getLength()));
                break;
            }
            default: {
                System.out.println("LonFacetsUtil.makeFacets did not handle elemtype=" + (Object)((Object)bLonElementType));
            }
        }
        return BFacets.make(hashMap);
    }

    private static final void addMinMax(HashMap hashMap, BLonElementQualifiers bLonElementQualifiers) {
        hashMap.put(MIN, bLonElementQualifiers.hasMinimum() ? LonFacetsUtil.toBNumber(bLonElementQualifiers.getMinimumN()) : LonFacetsUtil.getMinimumMin(bLonElementQualifiers));
        hashMap.put(MAX, bLonElementQualifiers.hasMaximum() ? LonFacetsUtil.toBNumber(bLonElementQualifiers.getMaximumN()) : LonFacetsUtil.getMaximumMax(bLonElementQualifiers));
        if (bLonElementQualifiers.hasInvalidValue()) {
            hashMap.put(INVLD, LonFacetsUtil.toBNumber(bLonElementQualifiers.getInvalidValueN()));
        }
    }

    private static final BNumber getMaximumMax(BLonElementQualifiers bLonElementQualifiers) {
        double d = 0.0;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 1: {
                d = 127.0;
                break;
            }
            case 2: {
                d = 255.0;
                break;
            }
            case 3: {
                d = 32767.0;
                break;
            }
            case 4: {
                d = 65535.0;
                break;
            }
            case 5: {
                d = 2.147483647E9;
                break;
            }
            case 16: {
                d = 4.294967295E9;
                break;
            }
            case 18: {
                d = Math.pow(2, 63.0) - 1.0;
                break;
            }
            case 19: {
                d = 1.844674407370955E19;
                break;
            }
            case 8: {
                d = Double.POSITIVE_INFINITY;
                break;
            }
            case 17: {
                d = Double.POSITIVE_INFINITY;
                break;
            }
            case 12: {
                d = (1 << bLonElementQualifiers.getLength()) - 1;
                break;
            }
            case 13: {
                d = (1 << bLonElementQualifiers.getLength() - 1) - 1;
                break;
            }
            default: {
                d = Double.POSITIVE_INFINITY;
            }
        }
        if (d == (double)bLonElementQualifiers.getInvalidValue()) {
            d -= 1.0;
        }
        if ((d = d * (double)bLonElementQualifiers.getResolution() - (double)bLonElementQualifiers.getOffset()) < 3.4028234663852886E38) {
            return BFloat.make((float)((float)d));
        }
        return BDouble.make((double)d);
    }

    private static final BNumber getMinimumMin(BLonElementQualifiers bLonElementQualifiers) {
        double d = 0.0;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 1: {
                d = -128.0;
                break;
            }
            case 3: {
                d = -32768.0;
                break;
            }
            case 5: {
                d = -2.147483648E9;
                break;
            }
            case 18: {
                d = -9.223372036854776E18;
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 16: 
            case 19: {
                d = 0.0;
                break;
            }
            case 13: {
                d = -(1 << bLonElementQualifiers.getLength() - 1);
                break;
            }
            case 17: {
                d = Double.NEGATIVE_INFINITY;
                break;
            }
            default: {
                d = Double.NEGATIVE_INFINITY;
            }
        }
        d = d * (double)bLonElementQualifiers.getResolution() - (double)bLonElementQualifiers.getOffset();
        if (d > (double)1.4E-45f) {
            return BFloat.make((float)((float)d));
        }
        return BDouble.make((double)d);
    }

    private static final void addPrec(HashMap hashMap, BLonElementQualifiers bLonElementQualifiers) {
        int n;
        float f = bLonElementQualifiers.getResolution();
        int n2 = n = bLonElementQualifiers.getElemtype().equals((Object)BLonElementType.f32) ? 2 : 0;
        if (f < 1.0f) {
            n = (int)Math.ceil(-(Math.log(f) / Math.log(10.0)));
        }
        hashMap.put("precision", BInteger.make((int)n));
    }

    private static final BLonElementQualifiers makeLonQualifiers(BFacets bFacets, int n) {
        float f = 1.0f;
        float f2 = 0.0f;
        boolean bl = false;
        Number number = new Float(0.0f);
        boolean bl2 = false;
        Number number2 = new Float(0.0f);
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl4 = false;
        Number number3 = new Float(Float.NaN);
        int n4 = 0;
        BLonElementType bLonElementType = (BLonElementType)BLonElementType.na.getRange().get(((BString)bFacets.getFacet(TYPE)).getString());
        if (bLonElementType == null) {
            return BLonElementQualifiers.NONE;
        }
        BObject bObject = bFacets.getFacet(RES);
        if (bObject != null) {
            f = ((BFloat)bObject).getFloat();
        }
        if ((bObject = bFacets.getFacet(OFF)) != null) {
            f2 = ((BFloat)bObject).getFloat();
        }
        if ((bObject = bFacets.getFacet(MIN)) != null) {
            number = LonFacetsUtil.parseNumber(bObject);
            bl = true;
        }
        if ((bObject = bFacets.getFacet(MAX)) != null) {
            number2 = LonFacetsUtil.parseNumber(bObject);
            bl2 = true;
        }
        if ((bObject = bFacets.getFacet(BYT)) != null && (n3 = ((BInteger)bObject).getInt()) > 0) {
            bl3 = true;
        }
        if ((bObject = bFacets.getFacet(BIT)) != null) {
            n2 = ((BInteger)bObject).getInt();
            bl3 = true;
        }
        if ((bObject = bFacets.getFacet(LEN)) != null) {
            n4 = ((BInteger)bObject).getInt();
        }
        if ((bObject = bFacets.getFacet(INVLD)) != null) {
            number3 = LonFacetsUtil.parseNumber(bObject);
            bl4 = true;
        }
        if (!bl3 && n >= 0) {
            n3 = n;
            bl3 = true;
        }
        return BLonElementQualifiers.make(bLonElementType, bl, number, bl2, number2, f, f2, bl3, n3, n2, bl4, number3, n4);
    }

    private static final Number parseNumber(BObject bObject) {
        if (bObject instanceof BLong) {
            return new Long(((BLong)bObject).getLong());
        }
        if (bObject instanceof BDouble) {
            return new Double(((BDouble)bObject).getDouble());
        }
        return new Float(((BFloat)bObject).getFloat());
    }

    private static final BNumber toBNumber(Number number) {
        if (number instanceof Long) {
            return BLong.make((long)((Long)number));
        }
        if (number instanceof Double) {
            return BDouble.make((double)((Double)number));
        }
        return BFloat.make((float)((Float)number).floatValue());
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, BUnit bUnit) {
        return LonFacetsUtil.makeFacets(BLonElementQualifiers.make(bLonElementType, 0), bUnit);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, int n, BUnit bUnit) {
        return LonFacetsUtil.makeFacets(BLonElementQualifiers.make(bLonElementType, n), bUnit);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, boolean bl, float f, boolean bl2, float f2, float f3, float f4, boolean bl3, int n, int n2, boolean bl4, float f5, int n3, BUnit bUnit) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(TYPE, BString.make((String)bLonElementType.getTag()));
        if (bUnit != null) {
            hashMap.put(UNITS, bUnit);
        }
        if (bl3) {
            hashMap.put(BYT, BInteger.make((int)n));
        }
        switch (bLonElementType.getOrdinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 16: 
            case 17: {
                if (f3 != 0.0f && f3 != 1.0f) {
                    hashMap.put(RES, BFloat.make((float)f3));
                }
                if (f4 != 0.0f) {
                    hashMap.put(OFF, BFloat.make((float)f4));
                }
                if (bl) {
                    hashMap.put(MIN, BFloat.make((float)f));
                }
                if (bl2) {
                    hashMap.put(MAX, BFloat.make((float)f2));
                }
                if (!bl4) break;
                hashMap.put(INVLD, BFloat.make((float)f5));
                break;
            }
            case 12: {
                if (!bl) {
                    hashMap.put(MIN, BFloat.make((float)0.0f));
                }
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                hashMap.put(BIT, BInteger.make((int)n2));
                hashMap.put(LEN, BInteger.make((int)n3));
                if (bl) {
                    hashMap.put(MIN, BFloat.make((float)f));
                }
                if (bl2) {
                    hashMap.put(MAX, BFloat.make((float)f2));
                }
                if (!bl4) break;
                hashMap.put(INVLD, BFloat.make((float)f5));
                break;
            }
            case 14: 
            case 15: {
                hashMap.put(LEN, BInteger.make((int)n3));
                break;
            }
        }
        return BFacets.make(hashMap);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, float f, float f2, float f3, BUnit bUnit) {
        BLonElementQualifiers bLonElementQualifiers = BLonElementQualifiers.make(bLonElementType, true, f, true, f2, f3, 0.0f, false, 0, 0, false, 0.0f, 0);
        return LonFacetsUtil.makeFacets(bLonElementQualifiers, bUnit);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, float f, float f2, float f3, int n, BUnit bUnit) {
        BLonElementQualifiers bLonElementQualifiers = BLonElementQualifiers.make(bLonElementType, true, f, true, f2, f3, 0.0f, false, n, 0, false, 0.0f, 0);
        return LonFacetsUtil.makeFacets(bLonElementQualifiers, bUnit);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, float f, BUnit bUnit) {
        BLonElementQualifiers bLonElementQualifiers = BLonElementQualifiers.make(bLonElementType, true, f, false, 0.0f, 1.0f, 0.0f, false, 0, 0, false, 0.0f, 0);
        return LonFacetsUtil.makeFacets(bLonElementQualifiers, bUnit);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, int n) {
        BLonElementQualifiers bLonElementQualifiers = BLonElementQualifiers.make(bLonElementType, false, 0.0f, false, 0.0f, 1.0f, 0.0f, false, n, 0, false, 0.0f, 0);
        return LonFacetsUtil.makeFacets(bLonElementQualifiers, null);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, int n, int n2, int n3, BUnit bUnit) {
        BLonElementQualifiers bLonElementQualifiers = BLonElementQualifiers.make(bLonElementType, false, 0.0f, false, 0.0f, 1.0f, 0.0f, false, n, n2, false, 0.0f, n3);
        return LonFacetsUtil.makeFacets(bLonElementQualifiers, bUnit);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, float f, float f2, float f3, float f4, BUnit bUnit) {
        BLonElementQualifiers bLonElementQualifiers = BLonElementQualifiers.make(bLonElementType, true, f, true, f2, f3, 0.0f, false, 0, 0, true, f4, 0);
        return LonFacetsUtil.makeFacets(bLonElementQualifiers, bUnit);
    }

    public static BFacets makeFacets(BLonElementType bLonElementType, float f, float f2, float f3, float f4, int n, int n2, BUnit bUnit) {
        BLonElementQualifiers bLonElementQualifiers = BLonElementQualifiers.make(bLonElementType, true, f, true, f2, f3, 0.0f, false, n, n2, true, f4, 0);
        return LonFacetsUtil.makeFacets(bLonElementQualifiers, bUnit);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class EqSearch {
        BLonData sLd;
        Property prop;
        int offset;
        boolean found;

        private final /* synthetic */ void this() {
            this.offset = 0;
            this.found = false;
        }

        private EqSearch() {
            this.this();
        }
    }
}

