/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonString
extends BLonPrimitive {
    public static final BLonString DEFAULT = new BLonString("");
    public static final Type TYPE;
    private String value;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonString;

    public static final BLonString make(String string) {
        return new BLonString(string);
    }

    public final String getString() {
        return this.value;
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof BLonString) {
            return this.value.equals(((BLonString)((Object)object)).value);
        }
        return false;
    }

    public final int compareTo(Object object) {
        return this.value.compareTo(((BLonString)((Object)object)).getString());
    }

    public final String toString(Context context) {
        return this.value;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        if (string.equals("")) {
            return DEFAULT;
        }
        return new BLonString(string);
    }

    public final String encodeToString() throws IOException {
        return this.value;
    }

    public final BObject decodeFromString(String string) throws IOException {
        if (string.equals("")) {
            return DEFAULT;
        }
        return new BLonString(string);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 14: {
                lonOutputStream.writeCharArray(this.value, bLonElementQualifiers.getLength());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonString.");
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        String string;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 14: {
                string = lonInputStream.readCharArray(bLonElementQualifiers.getLength());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonString.");
            }
        }
        if (this.value.equals(string)) {
            return this;
        }
        return BLonString.make(string);
    }

    public final double getDataAsDouble() {
        double d = Double.NaN;
        try {
            d = Double.valueOf(this.value);
        }
        catch (Throwable throwable) {}
        return d;
    }

    public final BLonPrimitive makeFromDouble(double d, BLonElementQualifiers bLonElementQualifiers) {
        return BLonString.make(Double.toString(d));
    }

    public final boolean getDataAsBoolean() {
        return Boolean.valueOf(this.value);
    }

    public final BLonPrimitive makeFromBoolean(boolean bl) {
        return BLonString.make(bl ? "true" : "false");
    }

    public final String getDataAsString() {
        return this.value;
    }

    public final BLonPrimitive makeFromString(String string) {
        return BLonString.make(string);
    }

    public final BEnum getDataAsEnum(BEnum bEnum) {
        BEnumRange bEnumRange = bEnum.getRange();
        if (!bEnumRange.isTag(this.value)) {
            String string = "";
            try {
                string = bEnum.encodeToString();
            }
            catch (Throwable throwable) {}
            throw new BajaRuntimeException("Cannot map tag (" + this.value + ") to enum.\n" + string);
        }
        return bEnumRange.get(this.value);
    }

    public final BLonPrimitive makeFromEnum(BEnum bEnum) {
        return new BLonString(bEnum.getTag());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLonString(String string) {
        if (string == null) {
            string = "";
        } else {
            this.value = string;
        }
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonString;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonString = BLonString.class("[Ljavax.baja.lonworks.londata.BLonString;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

