/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonLong
extends BLonPrimitive
implements BINumeric {
    public static final BLonLong DEFAULT = new BLonLong(0L, false);
    public static final Type TYPE;
    private long value;
    private boolean invalid;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonLong;

    public static final BLonLong make(long l, boolean bl) {
        return new BLonLong(l, bl);
    }

    public final long getLong() {
        return this.value;
    }

    public final float getFloat() {
        return this.value;
    }

    public final int hashCode() {
        return (int)this.value;
    }

    public final boolean equals(Object object) {
        if (object instanceof BLonLong) {
            boolean bl = false;
            if (((BLonLong)((Object)object)).value == this.value) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int compareTo(Object object) {
        long l = this.value;
        long l2 = ((BNumber)object).getLong();
        if (l == l2) {
            return 0;
        }
        if (l < l2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return this.encodeToString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.value);
        dataOutput.writeBoolean(this.invalid);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BLonLong.make(dataInput.readLong(), dataInput.readBoolean());
    }

    public final String encodeToString() {
        return BLonLong.encodeToString(this.value, this.invalid);
    }

    public static final String encodeToString(long l, boolean bl) {
        return Long.toString(l) + (bl ? "/invalid" : "");
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            int n = string.indexOf("/");
            if (n < 0) {
                return BLonLong.make(Long.parseLong(string), false);
            }
            return BLonLong.make(Long.parseLong(string.substring(0, n)), true);
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid long: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        long l = this.value;
        if ((!bLonElementQualifiers.hasInvalidValue() || this.value != bLonElementQualifiers.getInvalidValueL()) && bLonElementQualifiers.getOffset() > 0.0f) {
            l = (long)((float)l + bLonElementQualifiers.getOffset());
        }
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 5: {
                lonOutputStream.writeSigned32((int)l);
                break;
            }
            case 16: {
                lonOutputStream.writeUnsigned32(l);
                break;
            }
            case 18: {
                lonOutputStream.writeSigned64(l);
                break;
            }
            default: {
                throw new InvalidTypeException("Invalue id datatype for LonLong.");
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        long l;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 5: {
                l = lonInputStream.readSigned32();
                break;
            }
            case 16: {
                l = lonInputStream.readUnsigned32();
                break;
            }
            case 18: {
                l = lonInputStream.readSigned64();
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonLong.");
            }
        }
        boolean bl = bLonElementQualifiers.isInvalid(l);
        if (!bl && bLonElementQualifiers.getOffset() > 0.0f) {
            l = (long)((float)l - bLonElementQualifiers.getOffset());
        }
        if (this.value == l) {
            return this;
        }
        return BLonLong.make(l, bl);
    }

    public final double getDataAsDouble() {
        if (this.invalid) {
            return Double.NaN;
        }
        return this.value;
    }

    public final BLonPrimitive makeFromDouble(double d, BLonElementQualifiers bLonElementQualifiers) {
        if (Double.isNaN(d) && bLonElementQualifiers != null && bLonElementQualifiers.hasInvalidValue()) {
            return BLonLong.make(bLonElementQualifiers.getInvalidValueL(), true);
        }
        return BLonLong.make((long)d, false);
    }

    public final boolean isNumeric() {
        return true;
    }

    public final boolean getDataAsBoolean() {
        boolean bl = false;
        if (this.value != 0L) {
            bl = true;
        }
        return bl;
    }

    public final BLonPrimitive makeFromBoolean(boolean bl) {
        return BLonLong.make((long)bl, false);
    }

    public final String getDataAsString() {
        return Long.toString(this.value);
    }

    public final BLonPrimitive makeFromString(String string) {
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        return BLonLong.make(l, false);
    }

    public final double getNumeric() {
        return this.getDataAsDouble();
    }

    public final BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.invalid = false;
    }

    private BLonLong(long l, boolean bl) {
        this.this();
        this.value = l;
        this.invalid = bl;
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonLong;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonLong = BLonLong.class("[Ljavax.baja.lonworks.londata.BLonLong;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

