/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonByteArray
extends BLonPrimitive {
    private static final String DELIMITER = " ";
    private static final int RADIX = 16;
    public static final BLonByteArray DEFAULT = new BLonByteArray(1);
    public static final Type TYPE;
    private byte[] value;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonByteArray;

    public static final BLonByteArray make(int n) {
        return new BLonByteArray(n);
    }

    public static final BLonByteArray make(byte[] byArray) {
        return new BLonByteArray(byArray);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BLonByteArray)) {
            return false;
        }
        BLonByteArray bLonByteArray = (BLonByteArray)((Object)object);
        return this.compare(bLonByteArray.value);
    }

    private final boolean compare(byte[] byArray) {
        if (byArray.length != this.value.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != this.value[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final String toString(Context context) {
        int n = this.value.length;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(DELIMITER);
            }
            stringBuffer.append(Integer.toString(this.value[n2] & 0xFF, 16));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        int n = this.value.length;
        dataOutput.writeInt(n);
        if (n > 0) {
            dataOutput.write(this.value);
        }
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        if (n > 0) {
            dataInput.readFully(byArray);
        }
        return new BLonByteArray(byArray);
    }

    public final String encodeToString() {
        return this.toString(null);
    }

    public final BObject decodeFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        int n = stringTokenizer.countTokens();
        byte[] byArray = new byte[n];
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
                ++n2;
            }
        }
        if (this.compare(byArray)) {
            return this;
        }
        return new BLonByteArray(byArray);
    }

    public final Type getType() {
        return TYPE;
    }

    public final byte[] getBytes() {
        return this.value;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 15: {
                lonOutputStream.writeByteArray(this.value, bLonElementQualifiers.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonString.");
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        BLonByteArray bLonByteArray;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 15: {
                bLonByteArray = new BLonByteArray(lonInputStream.readByteArray(bLonElementQualifiers.getSize()));
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonString.");
            }
        }
        return bLonByteArray;
    }

    public final String getDataAsString() {
        return this.encodeToString();
    }

    public final BLonPrimitive makeFromString(String string) {
        return (BLonPrimitive)this.decodeFromString(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLonByteArray(byte[] byArray) {
        this.value = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.value, 0, this.value.length);
    }

    private BLonByteArray(int n) {
        this.value = new byte[n];
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonByteArray;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonByteArray = BLonByteArray.class("[Ljavax.baja.lonworks.londata.BLonByteArray;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

