/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonBigInteger
extends BLonPrimitive
implements BINumeric {
    public static final BLonBigInteger DEFAULT = new BLonBigInteger(BigInteger.ZERO, false);
    public static final Type TYPE;
    private BigInteger value;
    private boolean invalid;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonBigInteger;

    public static final BLonBigInteger make(BigInteger bigInteger, boolean bl) {
        return new BLonBigInteger(bigInteger, bl);
    }

    public final BigInteger getBigInteger() {
        return this.value;
    }

    public final long getLong() {
        return this.value.longValue();
    }

    public final float getFloat() {
        return this.value.floatValue();
    }

    public final int hashCode() {
        return this.value.intValue();
    }

    public final boolean equals(Object object) {
        if (object instanceof BLonBigInteger) {
            boolean bl = false;
            if (((BLonBigInteger)((Object)object)).value == this.value) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int compareTo(Object object) {
        return this.value.compareTo((BigInteger)object);
    }

    public final String toString(Context context) {
        return this.encodeToString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.value.toString());
        dataOutput.writeBoolean(this.invalid);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BLonBigInteger.make(new BigInteger(dataInput.readUTF()), dataInput.readBoolean());
    }

    public final String encodeToString() {
        return BLonBigInteger.encodeToString(this.value, this.invalid);
    }

    public static final String encodeToString(BigInteger bigInteger, boolean bl) {
        return bigInteger.toString() + (bl ? "/invalid" : "");
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            int n = string.indexOf("/");
            if (n < 0) {
                return BLonBigInteger.make(new BigInteger(string), false);
            }
            return BLonBigInteger.make(new BigInteger(string.substring(0, n)), true);
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid BigInteger: " + string);
        }
    }

    public static final BigInteger bigIntegerFromString(String string) throws IOException {
        try {
            return new BigInteger(string);
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid BigInteger: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        BigInteger bigInteger = this.value;
        if (!this.invalid && bLonElementQualifiers.getOffset() > 0.0f) {
            bigInteger = bigInteger.add(BigInteger.valueOf((long)bLonElementQualifiers.getOffset()));
        }
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 19: {
                lonOutputStream.writeUnsigned64(bigInteger);
                break;
            }
            default: {
                throw new InvalidTypeException("Invalue id datatype for LonLong.");
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        BigInteger bigInteger;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 19: {
                bigInteger = lonInputStream.readUnsigned64();
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonLong.");
            }
        }
        boolean bl = bLonElementQualifiers.isInvalid(bigInteger.longValue());
        if (!bl && bLonElementQualifiers.getOffset() > 0.0f) {
            bigInteger = bigInteger.subtract(BigInteger.valueOf((long)bLonElementQualifiers.getOffset()));
        }
        if (this.value == bigInteger) {
            return this;
        }
        return BLonBigInteger.make(bigInteger, bl);
    }

    public final double getDataAsDouble() {
        if (this.invalid) {
            return Double.NaN;
        }
        return this.value.doubleValue();
    }

    public final BLonPrimitive makeFromDouble(double d, BLonElementQualifiers bLonElementQualifiers) {
        if (Double.isNaN(d) && bLonElementQualifiers != null && bLonElementQualifiers.hasInvalidValue()) {
            return BLonBigInteger.make(BigInteger.valueOf(bLonElementQualifiers.getInvalidValueL()), true);
        }
        DecimalFormat decimalFormat = new DecimalFormat("#0");
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = decimalFormat.format(d, new StringBuffer(), fieldPosition);
        String string = stringBuffer.toString();
        BigInteger bigInteger = new BigInteger(string);
        return BLonBigInteger.make(bigInteger, false);
    }

    public final boolean isNumeric() {
        return true;
    }

    public final boolean getDataAsBoolean() {
        boolean bl = false;
        if (this.value.longValue() != 0L) {
            bl = true;
        }
        return bl;
    }

    public final BLonPrimitive makeFromBoolean(boolean bl) {
        return BLonBigInteger.make(bl ? BigInteger.ONE : BigInteger.ZERO, false);
    }

    public final String getDataAsString() {
        return this.value.toString();
    }

    public final BLonPrimitive makeFromString(String string) {
        BigInteger bigInteger = BigInteger.ZERO;
        try {
            bigInteger = new BigInteger(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        return BLonBigInteger.make(bigInteger, false);
    }

    public final double getNumeric() {
        return this.getDataAsDouble();
    }

    public final BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLonBigInteger(BigInteger bigInteger, boolean bl) {
        this.value = bigInteger;
        this.invalid = bl;
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonBigInteger;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonBigInteger = BLonBigInteger.class("[Ljavax.baja.lonworks.londata.BLonBigInteger;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

