/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.io;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import javax.baja.sys.BajaRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonOutputStream
extends ByteArrayOutputStream {
    int bitFieldMark;

    public void writeByteArray(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void writeByteArray(byte[] byArray, int n) {
        int n2 = byArray.length > n ? n : byArray.length;
        this.write(byArray, 0, n2);
        while (n2 < n) {
            this.write(0);
            ++n2;
        }
    }

    public void writeCharArray(String string, int n) {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            if (n2 < cArray.length) {
                this.write(cArray[n2]);
            } else {
                this.write(0);
            }
            ++n2;
        }
    }

    public void writeString(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            this.write(cArray[n]);
            ++n;
        }
        this.write(0);
    }

    public void writeBooleanBit(boolean bl, int n, int n2, int n3) {
        this.writeBit(bl ? 1 : 0, n, n2, n3);
    }

    public void writeBit(int n, int n2, int n3, int n4) {
        int n5 = this.bitFieldMark + n2;
        while (this.count <= n5) {
            this.write(0);
        }
        int n6 = 1;
        while (--n4 > 0) {
            n6 = n6 << 1 | 1;
        }
        if (n5 < 0 || n5 >= this.buf.length) {
            System.out.println("*********\nwriteBit byteOffset = " + n5 + "  len = " + this.buf.length);
            Thread.dumpStack();
            return;
        }
        int n7 = n5;
        this.buf[n7] = (byte)(this.buf[n7] | (n & n6) << n3);
    }

    public void writeSignedBit(int n, int n2, int n3, int n4) {
        this.writeBit(n, n2, n3, n4);
    }

    public void writeBoolean(boolean bl) {
        this.write(bl ? 1 : 0);
    }

    public void writeSigned16(int n) {
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        this.write(n2);
        this.write(n3);
    }

    public void writeUnsigned16(int n) {
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        this.write(n2);
        this.write(n3);
    }

    public void writeSigned8(int n) {
        this.write(n & 0xFF);
    }

    public void writeUnsigned8(int n) {
        this.write(n & 0xFF);
    }

    public void writeSigned32(int n) {
        this.write((n & 0xFF000000) >> 24);
        this.write((n & 0xFF0000) >> 16);
        this.write((n & 0xFF00) >> 8);
        this.write(n & 0xFF);
    }

    public void writeUnsigned32(long l) {
        this.write((int)(l & 0xFFFFFFFFFF000000L) >> 24);
        this.write((int)(l & 0xFF0000L) >> 16);
        this.write((int)(l & 0xFF00L) >> 8);
        this.write((int)(l & 0xFFL));
    }

    public void writeSigned64(long l) {
        this.write((int)((l & 0xFF00000000000000L) >> 56));
        this.write((int)((l & 0xFF000000000000L) >> 48));
        this.write((int)((l & 0xFF0000000000L) >> 40));
        this.write((int)((l & 0xFF00000000L) >> 32));
        this.write((int)((l & 0xFF000000L) >> 24));
        this.write((int)((l & 0xFF0000L) >> 16));
        this.write((int)((l & 0xFF00L) >> 8));
        this.write((int)(l & 0xFFL));
    }

    public void writeUnsigned64(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        int n2 = 0;
        while (byArray[n2] == 0 && n - n2 > 8) {
            ++n2;
        }
        if (n - n2 > 8) {
            throw new BajaRuntimeException("LonOutputStream.writeUnsigned64() error:" + bigInteger + " greater than 64 bits.");
        }
        int n3 = 0;
        while (n3 < 8 - n + n2) {
            this.write(0);
            ++n3;
        }
        n3 = n2;
        while (n3 < n) {
            this.write(byArray[n3]);
            ++n3;
        }
    }

    public void writeFloat(float f) {
        int n = Float.floatToIntBits(f);
        this.write((n & 0xFF000000) >> 24);
        this.write((n & 0xFF0000) >> 16);
        this.write((n & 0xFF00) >> 8);
        this.write(n & 0xFF);
    }

    public void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.write((int)((l & 0xFF00000000000000L) >> 56));
        this.write((int)((l & 0xFF000000000000L) >> 48));
        this.write((int)((l & 0xFF0000000000L) >> 40));
        this.write((int)((l & 0xFF00000000L) >> 32));
        this.write((int)((l & 0xFF000000L) >> 24));
        this.write((int)((l & 0xFF0000L) >> 16));
        this.write((int)((l & 0xFF00L) >> 8));
        this.write((int)(l & 0xFFL));
    }

    public int setBitFieldMark() {
        int n = this.bitFieldMark;
        this.bitFieldMark = this.count;
        return n;
    }

    public void resetBitFieldMark(int n) {
        this.bitFieldMark = n;
    }

    public void setPosition(int n) {
        while (this.count < n) {
            this.write(0);
        }
    }

    private final /* synthetic */ void this() {
        this.bitFieldMark = 0;
    }

    public LonOutputStream() {
        this.this();
    }

    public LonOutputStream(int n) {
        super(n);
        this.this();
    }
}

