/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.enums.BLonMfgId;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BProgramId
extends BSimple {
    private static final byte[] defaultId = new byte[8];
    public static final BProgramId DEFAULT = new BProgramId(defaultId);
    public static final BProgramId TRIDIUM_PID = BProgramId.make(9, BLonMfgId.tridium, 259, 32768, 3);
    public static final int PROGRAM_ID_LENGTH = 8;
    public static final Type TYPE;
    private byte[] programId;
    static /* synthetic */ Class class$javax$baja$lonworks$datatypes$BProgramId;

    public static final BProgramId make(byte[] byArray) {
        return new BProgramId(byArray);
    }

    public static final BProgramId make(int n, BLonMfgId bLonMfgId, int n2, int n3, int n4) {
        byte[] byArray = new byte[8];
        int n5 = bLonMfgId.getOrdinal();
        byArray[0] = (byte)((n << 4 & 0xF0) + (n5 >> 16 & 0xF));
        byArray[1] = (byte)(n5 >> 8 & 0xFF);
        byArray[2] = (byte)(n5 & 0xFF);
        byArray[3] = (byte)(n2 >> 8 & 0xFF);
        byArray[4] = (byte)(n2 & 0xFF);
        byArray[5] = (byte)(n3 >> 8 & 0xFF);
        byArray[6] = (byte)(n3 & 0xFF);
        byArray[7] = (byte)(n4 & 0xFF);
        return BProgramId.make(byArray);
    }

    public final byte[] getByteArray() {
        byte[] byArray = new byte[8];
        System.arraycopy(this.programId, 0, byArray, 0, 8);
        return byArray;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BProgramId)) {
            return false;
        }
        BProgramId bProgramId = (BProgramId)((Object)object);
        int n = 0;
        while (n < bProgramId.programId.length) {
            if (this.programId[n] != bProgramId.programId[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final boolean isZero() {
        int n = 0;
        while (n < this.programId.length) {
            if (this.programId[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final String toString(Context context) {
        return LonByteArrayUtil.toString(this.programId);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.programId);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[8];
        dataInput.readFully(byArray, 0, 8);
        return new BProgramId(byArray);
    }

    public final String encodeToString() throws IOException {
        return this.toString(null);
    }

    public final BObject decodeFromString(String string) throws IOException {
        return new BProgramId(LonByteArrayUtil.getBytes(string, 8));
    }

    public final BLonMfgId getMfgId() {
        int n = this.programId[0] & 0xF;
        n = (n << 8) + (this.programId[1] & 0xFF);
        n = (n << 8) + (this.programId[2] & 0xFF);
        try {
            return BLonMfgId.make(n);
        }
        catch (Throwable throwable) {
            return BLonMfgId.unknown;
        }
    }

    private final int getDeviceClass() {
        return (this.programId[3] & 0xFF) << 8 | this.programId[4] & 0xFF;
    }

    public final int getFormat() {
        return (this.programId[0] & 0xF0) >> 4;
    }

    public final int getDeviceSubclass() {
        return this.programId[5] & 0xFF;
    }

    public final int getDeviceChannelType() {
        return this.programId[6] & 0xFF;
    }

    public final int getModelNumber() {
        return this.programId[7] & 0xFF;
    }

    public final boolean isRouter() {
        boolean bl = false;
        if (this.getDeviceClass() == 257) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return (this.programId[0] & 0x80) << 23 | ((this.programId[1] ^ this.programId[2]) & 0x7F) << 23 | (this.programId[3] ^ this.programId[4]) << 16 | (this.programId[5] ^ this.programId[6]) << 8 | this.programId[7];
    }

    public final boolean hasChangeableNvs() {
        boolean bl = false;
        if (this.isLonMarkCompliant() && (this.getDeviceSubclass() & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isLonMarkCompliant() {
        int n = this.getFormat();
        boolean bl = false;
        if (n == 8 || n == 9) {
            bl = true;
        }
        return bl;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BProgramId(byte[] byArray) {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Invalid array length in BProgramId constructor. " + LonByteArrayUtil.toString(byArray));
        }
        this.programId = byArray;
    }

    static {
        Class clazz = class$javax$baja$lonworks$datatypes$BProgramId;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$datatypes$BProgramId = BProgramId.class("[Ljavax.baja.lonworks.datatypes.BProgramId;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

