/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import com.tridium.lonworks.datatypes.BLinkDescriptor;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.NmUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BAddressType;
import javax.baja.lonworks.enums.BLonReceiveTimer;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BExtAddressEntry
extends BSimple
implements BIAddressEntry {
    public static final BExtAddressEntry DEFAULT = new BExtAddressEntry();
    private static final int ADDRESS_ENTRY_LENGTH = 7;
    public static final Type TYPE;
    private byte[] addressEntry;
    private int descriptor;
    static /* synthetic */ Class class$javax$baja$lonworks$datatypes$BExtAddressEntry;

    public static final BExtAddressEntry make(byte[] byArray) {
        return new BExtAddressEntry(byArray, 0);
    }

    public static final BExtAddressEntry make(BAddressType bAddressType, int n, int n2, int n3, int n4) {
        return BExtAddressEntry.make(bAddressType, n, n2, n3, n4, 0);
    }

    public static final BExtAddressEntry make(BAddressType bAddressType, int n, int n2, int n3, int n4, int n5) {
        return BExtAddressEntry.make(bAddressType, n, n2, n3, n4, n5, new BLinkDescriptor());
    }

    public static final BExtAddressEntry make(BAddressType bAddressType, int n, int n2, int n3, int n4, int n5, BLinkDescriptor bLinkDescriptor) {
        return new BExtAddressEntry(bAddressType, n, n2, n3, n4, n5, bLinkDescriptor.getRepeatTimer(), bLinkDescriptor.getRetries(), bLinkDescriptor.getReceiveTimer(), bLinkDescriptor.getTransmitTimer());
    }

    public static final BExtAddressEntry make(BAddressType bAddressType, int n, int n2, int n3, int n4, int n5, BLonRepeatTimer bLonRepeatTimer, int n6, BLonReceiveTimer bLonReceiveTimer, BLonRepeatTimer bLonRepeatTimer2) {
        return new BExtAddressEntry(bAddressType, n, n2, n3, n4, n5, bLonRepeatTimer, n6, bLonReceiveTimer, bLonRepeatTimer2);
    }

    public static final BExtAddressEntry makeSubnetNodeEntry(BSubnetNode bSubnetNode, int n) {
        return BExtAddressEntry.make(BAddressType.subnetNode, 0, bSubnetNode.getSubnetId(), bSubnetNode.getNodeId(), n);
    }

    public static final BExtAddressEntry makeSubnetNodeEntry(BSubnetNode bSubnetNode, int n, int n2, BLinkDescriptor bLinkDescriptor) {
        return BExtAddressEntry.make(BAddressType.subnetNode, 0, bSubnetNode.getSubnetId(), bSubnetNode.getNodeId(), n, n2, bLinkDescriptor);
    }

    public static final BExtAddressEntry make(BIAddressEntry bIAddressEntry) {
        if (bIAddressEntry.isExtended()) {
            return (BExtAddressEntry)bIAddressEntry;
        }
        BAddressEntry bAddressEntry = (BAddressEntry)bIAddressEntry;
        return new BExtAddressEntry(bAddressEntry.getAddressType(), bAddressEntry.getSize(), bAddressEntry.getGroupOrSubnet(), bAddressEntry.getMemberOrNode(), bAddressEntry.getDescriptor(), bAddressEntry.getDomain(), bAddressEntry.getRepeatTimer(), bAddressEntry.getRetries(), bAddressEntry.getReceiveTimer(), bAddressEntry.getTransmitTimer());
    }

    public final BAddressType getAddressType() {
        if (this.addressEntry[0] == 0) {
            return this.addressEntry[1] == 0 ? BAddressType.none : BAddressType.turnaround;
        }
        if (this.addressEntry[0] == 1) {
            return BAddressType.subnetNode;
        }
        if (this.addressEntry[0] == 3) {
            return BAddressType.broadcast;
        }
        return BAddressType.group;
    }

    public final boolean isGroupAddress() {
        boolean bl = false;
        if ((this.addressEntry[0] & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isSubnetNodeAddress() {
        boolean bl = false;
        if (this.addressEntry[0] == 1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isTurnAroundAddress() {
        boolean bl = false;
        if (this.addressEntry[0] == 0 && this.addressEntry[1] != 0) {
            bl = true;
        }
        return bl;
    }

    private final void setAddressType(BAddressType bAddressType) {
        switch (bAddressType.getOrdinal()) {
            case 1: {
                this.addressEntry[0] = (byte)(this.addressEntry[0] | 0x80);
                break;
            }
            case 2: {
                this.addressEntry[0] = 1;
                break;
            }
            case 3: {
                this.addressEntry[0] = 3;
                break;
            }
            case 4: {
                this.addressEntry[0] = 0;
                this.addressEntry[1] = 1;
                break;
            }
            default: {
                this.addressEntry[0] = 0;
                this.addressEntry[1] = 0;
            }
        }
    }

    public final int getSize() {
        return this.addressEntry[0] & 0x7F;
    }

    private final void setSize(int n) {
        if (n > 64) {
            n = 0;
        }
        this.addressEntry[0] = (byte)(n & 0x7F | this.addressEntry[0] & 0x80);
    }

    public final int getGroupOrSubnet() {
        return this.addressEntry[4] & 0xFF;
    }

    private final void setGroupOrSubnet(int n) {
        this.addressEntry[4] = (byte)n;
    }

    public final int getMemberOrNode() {
        return this.addressEntry[1] & 0x7F;
    }

    private final void setMemberOrNode(int n) {
        this.addressEntry[1] = (byte)(n & 0x7F | this.addressEntry[1] & 0x80);
    }

    public final int getDomain() {
        return this.addressEntry[5] << 8 & this.addressEntry[6];
    }

    private final void setDomain(int n) {
        this.addressEntry[5] = (byte)(n >> 8 & 0xFF);
        this.addressEntry[6] = (byte)(n & 0xFF);
    }

    public final BLonRepeatTimer getRepeatTimer() {
        return BLonRepeatTimer.make((this.addressEntry[2] & 0xF0) >> 4);
    }

    private final void setRepeatTimer(BLonRepeatTimer bLonRepeatTimer) {
        this.addressEntry[2] = (byte)(bLonRepeatTimer.getOrdinal() << 4 & 0xF0 | this.addressEntry[2] & 0xF);
    }

    public final int getRetries() {
        return this.addressEntry[2] & 0xF;
    }

    private final void setRetries(int n) {
        this.addressEntry[2] = (byte)(n & 0xF | this.addressEntry[2] & 0xF0);
    }

    public final BLonReceiveTimer getReceiveTimer() {
        return BLonReceiveTimer.make((this.addressEntry[3] & 0xF0) >> 4);
    }

    private final void setReceiveTimer(BLonReceiveTimer bLonReceiveTimer) {
        this.addressEntry[3] = (byte)(bLonReceiveTimer.getOrdinal() << 4 & 0xF0 | this.addressEntry[3] & 0xF);
    }

    public final BLonRepeatTimer getTransmitTimer() {
        return BLonRepeatTimer.make(this.addressEntry[3] & 0xF);
    }

    private final void setTransmitTimer(BLonRepeatTimer bLonRepeatTimer) {
        this.addressEntry[3] = (byte)(bLonRepeatTimer.getOrdinal() & 0xF | this.addressEntry[3] & 0xF0);
    }

    public final int getDescriptor() {
        return this.descriptor;
    }

    public final boolean isExtended() {
        return true;
    }

    public final BSubnetNode getSubnetNodeAddress() {
        return BSubnetNode.make(this.getGroupOrSubnet(), this.getMemberOrNode());
    }

    public final byte[] getRawAddress() {
        return this.addressEntry;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BExtAddressEntry)) {
            return false;
        }
        BExtAddressEntry bExtAddressEntry = (BExtAddressEntry)object;
        if (this.descriptor != bExtAddressEntry.descriptor) {
            return false;
        }
        if (this.addressEntry.length != bExtAddressEntry.addressEntry.length) {
            return false;
        }
        int n = 0;
        while (n < 7) {
            if (this.addressEntry[n] != bExtAddressEntry.addressEntry[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final boolean isSameAddress(BIAddressEntry bIAddressEntry) {
        boolean bl = false;
        if (this.getAddressType() == bIAddressEntry.getAddressType() && this.isGroupAddress() == bIAddressEntry.isGroupAddress() && this.isSubnetNodeAddress() == bIAddressEntry.isSubnetNodeAddress() && this.isTurnAroundAddress() == bIAddressEntry.isTurnAroundAddress() && this.getSize() == bIAddressEntry.getSize() && this.getGroupOrSubnet() == bIAddressEntry.getGroupOrSubnet() && this.getMemberOrNode() == bIAddressEntry.getMemberOrNode() && this.getDescriptor() == bIAddressEntry.getDescriptor() && this.getDomain() == bIAddressEntry.getDomain()) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.addressEntry[0] == 0) {
            if (this.addressEntry[1] == 0) {
                return "Not In Use";
            }
            stringBuffer.append("Turnaround");
        } else if (this.addressEntry[0] == 1) {
            stringBuffer.append("Subnet ").append(this.getGroupOrSubnet());
            stringBuffer.append(" Node ").append(this.getMemberOrNode());
        } else if (this.addressEntry[0] == 3) {
            stringBuffer.append("Broadcast on subnet ").append(this.getGroupOrSubnet());
        } else {
            stringBuffer.append("Group# ").append(this.getGroupOrSubnet());
            stringBuffer.append(" Member# ").append(this.getMemberOrNode());
            stringBuffer.append(" size ").append(this.getSize());
        }
        stringBuffer.append(" Domain ").append(this.getDomain());
        stringBuffer.append(" ").append((Object)NmUtil.getLinkType(this.descriptor));
        return stringBuffer.toString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.descriptor);
        dataOutput.writeInt(7);
        dataOutput.write(this.addressEntry);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        byte[] byArray = new byte[n2];
        dataInput.readFully(byArray, 0, n2);
        return new BExtAddressEntry(byArray, n);
    }

    public final String encodeToString() throws IOException {
        return "" + this.descriptor + '/' + this.addressEntry.length + '/' + LonByteArrayUtil.toString(this.addressEntry);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            int n = string.indexOf("/");
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = string.indexOf("/", n + 1);
            int n4 = Integer.parseInt(string.substring(n + 1, n3));
            byte[] byArray = LonByteArrayUtil.getBytes(string.substring(n3 + 1), n4);
            return new BExtAddressEntry(byArray, n2);
        }
        catch (Throwable throwable) {
            System.out.println("FORMATE ERROR {" + string + "}\n" + throwable);
            return DEFAULT;
        }
    }

    public final void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeByteArray(this.addressEntry);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        byte[] byArray = new byte[7];
        byArray[2] = 3;
        byArray[3] = 6;
        this.addressEntry = byArray;
        this.descriptor = 0;
    }

    private BExtAddressEntry(byte[] byArray, int n) {
        this.this();
        int n2 = byArray.length;
        if (n2 != 7) {
            throw new BajaRuntimeException("Invalid array length " + n2 + " in BExtAddressEntry make.");
        }
        this.addressEntry = new byte[n2];
        System.arraycopy(byArray, 0, this.addressEntry, 0, n2);
        this.descriptor = n;
    }

    private BExtAddressEntry() {
        this.this();
    }

    private BExtAddressEntry(BAddressType bAddressType, int n, int n2, int n3, int n4, int n5, BLonRepeatTimer bLonRepeatTimer, int n6, BLonReceiveTimer bLonReceiveTimer, BLonRepeatTimer bLonRepeatTimer2) {
        this.this();
        this.setAddressType(bAddressType);
        this.descriptor = n4;
        if (this.addressEntry[0] == 0) {
            return;
        }
        if (bAddressType.equals((Object)BAddressType.group)) {
            this.setSize(n);
        }
        this.setGroupOrSubnet(n2);
        this.setMemberOrNode(n3);
        this.setDomain(n5);
        this.setRepeatTimer(bLonRepeatTimer);
        this.setRetries(n6);
        this.setReceiveTimer(bLonReceiveTimer);
        this.setTransmitTimer(bLonRepeatTimer2);
    }

    static {
        Class clazz = class$javax$baja$lonworks$datatypes$BExtAddressEntry;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$datatypes$BExtAddressEntry = BExtAddressEntry.class("[Ljavax.baja.lonworks.datatypes.BExtAddressEntry;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

