/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BDomainId
extends BSimple {
    public static final int MAX_DOMAIN_LENGTH = 6;
    public static final BDomainId DEFAULT = new BDomainId();
    public static final Type TYPE;
    private byte[] domainId;
    private int domainLength;
    static /* synthetic */ Class class$javax$baja$lonworks$datatypes$BDomainId;

    public static final BDomainId make(int n, byte[] byArray) {
        return new BDomainId(n, byArray);
    }

    public final BDomainId makeFrom(int n, byte[] byArray) {
        if (this.compare(n, byArray)) {
            return this;
        }
        return new BDomainId(n, byArray);
    }

    public final byte[] getDomainId() {
        byte[] byArray = new byte[this.domainLength];
        System.arraycopy(this.domainId, 0, byArray, 0, this.domainLength);
        return byArray;
    }

    public final int getLength() {
        return this.domainLength;
    }

    public final boolean isZeroLength() {
        boolean bl = false;
        if (this.domainLength == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BDomainId)) {
            return false;
        }
        BDomainId bDomainId = (BDomainId)((Object)object);
        return this.compare(bDomainId.domainLength, bDomainId.domainId);
    }

    private final boolean compare(int n, byte[] byArray) {
        if (this.domainLength != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.domainId[n2] != byArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final String toString(Context context) {
        return "len=" + this.domainLength + ':' + LonByteArrayUtil.toString(this.domainId, '.', this.domainLength);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.domainLength);
        int n = 0;
        while (n < this.domainLength) {
            dataOutput.writeInt(this.domainId[n]);
            ++n;
        }
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte[] byArray = new byte[6];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)dataInput.readInt();
            ++n2;
        }
        return new BDomainId(n, byArray);
    }

    public final String encodeToString() throws IOException {
        return this.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        if (string.length() == 0) {
            return DEFAULT;
        }
        String string2 = string.substring(string.indexOf(61) + 1, string.indexOf(58)).trim();
        int n = Integer.parseInt(string2);
        if (n == 0) {
            return DEFAULT;
        }
        if (!this.isValidLength(n)) {
            throw new RuntimeException("Invalid DomainId length.");
        }
        String string3 = string.substring(string.indexOf(58) + 1);
        byte[] byArray = LonByteArrayUtil.getBytes(string3, n);
        return new BDomainId(n, byArray);
    }

    private final boolean isValidLength(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.domainId = new byte[6];
        this.domainLength = 0;
    }

    private BDomainId(int n, byte[] byArray) {
        this.this();
        if (!this.isValidLength(n)) {
            throw new RuntimeException("Invalid DomainId length.");
        }
        this.domainLength = n;
        System.arraycopy(byArray, 0, this.domainId, 0, n);
    }

    private BDomainId() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$lonworks$datatypes$BDomainId;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$datatypes$BDomainId = BDomainId.class("[Ljavax.baja.lonworks.datatypes.BDomainId;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

