/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.device.BDownloadJob;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.lonworks.BILonLoadable;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BLonObjectFolder;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonObject
extends BComponent
implements BINvContainer,
BIStatus,
BILonLoadable {
    public static final int UNASSIGNED_ID = -1;
    public static final Property status = BLonObject.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BLonObject.newProperty((int)67, (String)"", null);
    public static final Property objectId = BLonObject.newProperty((int)1, (int)-1, null);
    public static final Property objectType = BLonObject.newProperty((int)1, (String)"", null);
    public static final Action upload = BLonObject.newAction((int)0, (BValue)new BUploadParameters(), null);
    public static final Action download = BLonObject.newAction((int)0, (BValue)new BDownloadParameters(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private boolean objUploadInProgress;
    boolean linkUpdateDone;
    NvDev.SaveNv snv;
    BNetworkVariable saveNv;
    Property nvProp;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonObject;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public int getObjectId() {
        return this.getInt(objectId);
    }

    public void setObjectId(int n) {
        this.setInt(objectId, n, null);
    }

    public String getObjectType() {
        return this.getString(objectType);
    }

    public void setObjectType(String string) {
        this.setString(objectType, string, null);
    }

    public void upload(BUploadParameters bUploadParameters) {
        this.invoke(upload, (BValue)bUploadParameters, null);
    }

    public void download(BDownloadParameters bDownloadParameters) {
        this.invoke(download, (BValue)bDownloadParameters, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent.getType().is(BLonDevice.TYPE) || bComponent.getType().is(BLonObjectFolder.TYPE)) {
            bl = true;
        }
        return bl;
    }

    public BLonNetwork getLonNetwork() {
        return this.getLonDevice().getLonNetwork();
    }

    public BLonDevice getLonDevice() {
        return (BLonDevice)NmUtil.getParent(this, BLonDevice.TYPE);
    }

    public BDeviceData getDeviceData() {
        return this.getLonDevice().getDeviceData();
    }

    public BINetworkVariable[] getNetworkVariables() {
        return this.getLonDevice().getNetworkVariables();
    }

    public boolean isLonObject() {
        return true;
    }

    public final void doUpload(BUploadParameters bUploadParameters, Context context) throws Exception {
        this.checkState();
        this.getLonDevice().checkState();
        this.checkUpload();
        new BUploadJob(this, bUploadParameters, context).submit(context);
    }

    public void checkState() {
        if (this.getStatus().isDown()) {
            throw new BajaRuntimeException("Object is down. Can't perform operation.");
        }
        if (this.getStatus().isDisabled()) {
            throw new BajaRuntimeException("Object is disabled. Can't perform operation.");
        }
        if (this.getStatus().isFault()) {
            throw new BajaRuntimeException("Object is in fault. Can't perform operation.");
        }
    }

    public final void doDownload(BDownloadParameters bDownloadParameters, Context context) throws Exception {
        this.checkState();
        this.getLonDevice().checkState();
        this.checkDownload();
        new BDownloadJob(this, bDownloadParameters, context).submit(context);
    }

    public void checkUpload() {
    }

    public void beginUpload() {
        BLonDevice bLonDevice = this.getLonDevice();
        if (!bLonDevice.isUpLoadInProgress()) {
            bLonDevice.initUpload(true);
            this.objUploadInProgress = true;
        }
    }

    public void endUpload() {
        BLonDevice bLonDevice = this.getLonDevice();
        if (this.objUploadInProgress) {
            bLonDevice.cleanupUpload();
            this.objUploadInProgress = false;
        }
    }

    public void checkDownload() {
    }

    public void beginDownload() {
        BLonDevice bLonDevice = this.getLonDevice();
        if (!bLonDevice.isDownLoadInProgress()) {
            bLonDevice.initDownload(true);
        }
    }

    public void endDownload() {
        BLonDevice bLonDevice = this.getLonDevice();
        if (!bLonDevice.isDownLoadInProgress()) {
            bLonDevice.cleanupDownload();
        }
    }

    public BLink makeLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        if (!NvDev.requiresLonLink(slot2)) {
            return super.makeLink(bComponent, slot, slot2, context);
        }
        return NvDev.makeLonLink(bComponent, slot, this, slot2, context);
    }

    protected LinkCheck doCheckLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        return NvDev.doNvCheckLink(bComponent, slot, this, slot2, context);
    }

    public void linkUpdate() {
        if (this.linkUpdateDone) {
            return;
        }
        this.getComponentSpace().update((BComponent)this, 1);
        this.getComponentSpace().update((BComponent)this.getLonDevice().getDeviceData(), 2);
        this.linkUpdateDone = true;
    }

    public void renamed(Property property, String string, Context context) {
        super.renamed(property, string, context);
        if (property.getType().is(BLonComponent.TYPE)) {
            BLonDevice.lonComponentRenamed(this.getLonDevice(), property.getName(), string, context);
        }
    }

    public void knobAdded(Knob knob, Context context) {
        super.knobAdded(knob, context);
        NvDev.knobAdded(this, knob, context);
    }

    public void knobRemoved(Knob knob, Context context) {
        super.knobRemoved(knob, context);
        NvDev.knobRemoved(this, knob, context);
    }

    public void checkRemove(Property property, Context context) {
        this.snv = NvDev.checkRemove(this, property, context);
        super.checkRemove(property, context);
    }

    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        NvDev.removed(this, this.snv, property, bValue, context);
        this.snv = null;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (property.getType().is(BLonLink.TYPE)) {
            BLonLink bLonLink = (BLonLink)this.get(property);
            if (this.isRunning() && !bLonLink.getMessageTag()) {
                bLonLink.getDestinationNv().lonLinkAdded();
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.objUploadInProgress = false;
        this.linkUpdateDone = false;
        this.snv = null;
        this.saveNv = null;
        this.nvProp = null;
    }

    public BLonObject() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$lonworks$BLonObject;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonObject = BLonObject.class("[Ljavax.baja.lonworks.BLonObject;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/object.png");
    }
}

