/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.NetMessageReceiver;
import com.tridium.lonworks.NvManager;
import com.tridium.lonworks.datatypes.BUtilCmdJob;
import com.tridium.lonworks.datatypes.BUtilitiesCommand;
import com.tridium.lonworks.device.BDownloadJob;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.ui.device.BLonDeviceManager;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.TimedCoalesceQueue;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonDeviceFolder;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.datatypes.BLonCommConfig;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.ext.BLonPollService;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.tuning.BLonTuningPolicy;
import javax.baja.lonworks.tuning.BLonTuningPolicyMap;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonNetwork
extends BDeviceNetwork
implements BIService {
    public static final Property lonCommConfig = BLonNetwork.newProperty((int)0, (BValue)new BLonCommConfig(), null);
    public static final Property pollService = BLonNetwork.newProperty((int)0, (BValue)new BLonPollService(), null);
    public static final Property lonNetmgmt = BLonNetwork.newProperty((int)0, (BValue)new BLonNetmgmt(), null);
    public static final Property tuningPolicies = BLonNetwork.newProperty((int)0, (BValue)new BLonTuningPolicyMap(), null);
    public static final Property localLonDevice = BLonNetwork.newProperty((int)0, (BValue)new BLocalLonDevice(), null);
    public static final Action upload = BLonNetwork.newAction((int)0, (BValue)new BUploadParameters(), null);
    public static final Action download = BLonNetwork.newAction((int)0, (BValue)new BDownloadParameters(), null);
    public static final Action executeCommand = BLonNetwork.newAction((int)4, (BValue)new BUtilitiesCommand(), null);
    public static final Action makeNvsNonCritical = BLonNetwork.newAction((int)0, null);
    public static final Topic deviceChange = BLonNetwork.newTopic((int)0, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    private static BFacets noWrite;
    private static BFacets noPropagate;
    public static final Context lonNoWrite;
    public static final Context lonNoPropagate;
    public static final Context lonNoPropagateNoWrite;
    private boolean firstPass;
    private boolean disabledAtStart;
    private boolean serviceRunning;
    protected Worker workQueue;
    protected Worker coalesceQueue;
    protected Worker proxyQueue;
    protected Worker timedQueue;
    public int dataPntMismatchCount;
    private Log log;
    private NetMessageReceiver netMessageReceiver;
    private NLonComm lonComm;
    private NvManager nvManager;
    private AddressManager addressManager;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonNetwork;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonDevice;
    static /* synthetic */ Class class$javax$baja$driver$point$BTuningPolicy;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public BLonCommConfig getLonCommConfig() {
        return (BLonCommConfig)this.get(lonCommConfig);
    }

    public void setLonCommConfig(BLonCommConfig bLonCommConfig) {
        this.set(lonCommConfig, (BValue)bLonCommConfig, null);
    }

    public BLonPollService getPollService() {
        return (BLonPollService)this.get(pollService);
    }

    public void setPollService(BLonPollService bLonPollService) {
        this.set(pollService, (BValue)bLonPollService, null);
    }

    public BLonNetmgmt getLonNetmgmt() {
        return (BLonNetmgmt)this.get(lonNetmgmt);
    }

    public void setLonNetmgmt(BLonNetmgmt bLonNetmgmt) {
        this.set(lonNetmgmt, (BValue)bLonNetmgmt, null);
    }

    public BLonTuningPolicyMap getTuningPolicies() {
        return (BLonTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BLonTuningPolicyMap bLonTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bLonTuningPolicyMap, null);
    }

    public BLocalLonDevice getLocalLonDevice() {
        return (BLocalLonDevice)this.get(localLonDevice);
    }

    public void setLocalLonDevice(BLocalLonDevice bLocalLonDevice) {
        this.set(localLonDevice, (BValue)bLocalLonDevice, null);
    }

    public void upload(BUploadParameters bUploadParameters) {
        this.invoke(upload, (BValue)bUploadParameters, null);
    }

    public void download(BDownloadParameters bDownloadParameters) {
        this.invoke(download, (BValue)bDownloadParameters, null);
    }

    public BOrd executeCommand(BUtilitiesCommand bUtilitiesCommand) {
        return (BOrd)this.invoke(executeCommand, (BValue)bUtilitiesCommand, null);
    }

    public void makeNvsNonCritical() {
        this.invoke(makeNvsNonCritical, null, null);
    }

    public void fireDeviceChange(BValue bValue) {
        this.fire(deviceChange, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "lonworks");
    }

    public final BOrd doExecuteCommand(BUtilitiesCommand bUtilitiesCommand) {
        return new BUtilCmdJob(this, bUtilitiesCommand).submit(null);
    }

    public final Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList = NvDev.fixWireSheet(agentList, context);
        AgentInfo[] agentInfoArray = agentList.list();
        int n = 0;
        while (n < agentInfoArray.length) {
            if (agentInfoArray[n].getAgentType().is(BLonDeviceManager.TYPE) && n != 0) {
                agentList.toTop(n);
            }
            ++n;
        }
        return this.modifyAgentList(agentList, context);
    }

    protected AgentList modifyAgentList(AgentList agentList, Context context) {
        return agentList;
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BLonNetwork ^ true;
    }

    public void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        if (bValue instanceof BLocalLonDevice) {
            throw new LocalizableRuntimeException("lonworks", "addLocalDeviceError");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void added(Property property, Context context) {
        block7: {
            block6: {
                try {
                    if (!this.isRunning()) {
                        Object var4_3 = null;
                        break block6;
                    }
                    if (property.getType().is(BLonDevice.TYPE)) {
                        this.netmgmt().deviceAdded((BLonDevice)this.get(property));
                        break block7;
                    }
                    if (property.getType().is(BLonRouter.TYPE)) {
                        this.netmgmt().routerAdded((BLonRouter)this.get(property));
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    super.added(property, context);
                    throw throwable;
                }
            }
            super.added(property, context);
            return;
        }
        Object var4_5 = null;
        super.added(property, context);
    }

    public final Type getDeviceType() {
        return BLonDevice.TYPE;
    }

    public final Type getDeviceFolderType() {
        return BLonDeviceFolder.TYPE;
    }

    public final void doUpload(BUploadParameters bUploadParameters, Context context) throws Exception {
        new BUploadJob((BIDeviceFolder)this, bUploadParameters, context).submit(context);
    }

    public final void doDownload(BDownloadParameters bDownloadParameters, Context context) throws Exception {
        new BDownloadJob((BIDeviceFolder)this, bDownloadParameters, context).submit(context);
    }

    protected IFuture postPing() {
        return this.postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
    }

    public void doPing() throws Exception {
        Class clazz = class$javax$baja$lonworks$BLonDevice;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonDevice = BLonNetwork.class("[Ljavax.baja.lonworks.BLonDevice;", false);
        }
        Object[] objectArray = NmUtil.getDecendantsByClass((BComponent)this, clazz);
        int n = 0;
        while (n < objectArray.length) {
            ((BLonDevice)objectArray[n]).doPing();
            ++n;
        }
        this.pingOk();
    }

    public void doMakeNvsNonCritical() {
        BLonDevice[] bLonDeviceArray = this.getLonDevices();
        int n = 0;
        while (n < bLonDeviceArray.length) {
            BINetworkVariable[] bINetworkVariableArray = bLonDeviceArray[n].getNetworkVariables();
            int n2 = 0;
            while (n2 < bINetworkVariableArray.length) {
                if (bINetworkVariableArray[n2].isNetworkVariable() || bINetworkVariableArray[n2].isLocalNv()) {
                    DynaDev.setNonCritical((BLonData)((Object)bINetworkVariableArray[n2]));
                }
                ++n2;
            }
            ++n;
        }
    }

    public final void serviceStarted() {
        if (this.firstPass) {
            this.fixTunning();
            this.lonComm = new NLonComm(this);
            this.netMessageReceiver = new NetMessageReceiver(this);
            this.nvManager = new NvManager(this);
            this.addressManager = new NAddressManager(this);
            this.workQueue = new Worker((Worker.ITodo)new Queue(1000));
            this.coalesceQueue = new Worker((Worker.ITodo)new CoalesceQueue(1000));
            this.proxyQueue = new Worker((Worker.ITodo)new Queue(1000));
            this.timedQueue = new Worker((Worker.ITodo)new TimedCoalesceQueue(1000));
            this.firstPass = false;
        }
        if (this.isDisabled()) {
            return;
        }
        this.disabledAtStart = false;
        try {
            this.lonComm.start();
            this.workQueue.start(this.getLogName() + ".Async");
            this.coalesceQueue.start(this.getLogName() + ".AsyncEvent");
            this.proxyQueue.start(this.getLogName() + ".Proxy");
            this.timedQueue.start(this.getLogName() + ".Delay");
            this.log().message("Service started on " + this.getLonCommConfig().getDeviceName());
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)false));
            this.serviceRunning = true;
            this.configOk();
        }
        catch (Throwable throwable) {
            this.log().error("Error initializing LonNetwork " + this.getDisplayName(null), throwable);
            this.configFail(throwable.getMessage());
        }
    }

    public final void serviceStopped() {
        this.serviceRunning = false;
        this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
        this.workQueue.stop();
        this.coalesceQueue.stop();
        this.proxyQueue.stop();
        this.timedQueue.stop();
        this.lonComm.stop();
        this.log().message("Service stopped on " + this.getLonCommConfig().getDeviceName());
    }

    public boolean isServiceRunning() {
        return this.serviceRunning;
    }

    /*
     * Unable to fully structure code
     */
    private final void fixTunning() {
        var1_1 = this.getTuningPolicies();
        var2_2 = var1_1.getProperties();
        if (true) ** GOTO lbl8
        do {
            if (!((var3_3 = (BTuningPolicy)var2_2.get()) instanceof BLonTuningPolicy)) {
                var4_4 = new BLonTuningPolicy(var3_3.getMinWriteTime(), var3_3.getMaxWriteTime(), var3_3.getWriteOnStart(), var3_3.getWriteOnUp(), var3_3.getWriteOnEnabled(), var3_3.getStaleTime());
                var1_1.set(var2_2.property(), (BValue)var4_4, null);
            }
lbl8:
            // 4 sources

            if ((v0 = BLonNetwork.class$javax$baja$driver$point$BTuningPolicy) != null) continue;
            v0 = BLonNetwork.class("[Ljavax.baja.driver.point.BTuningPolicy;", false);
        } while (var2_2.next(v0));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void started() throws Exception {
        try {
            if (!(this.isServiceRunning() || this.isDisabled() || this.getStatus().isFault())) {
                this.serviceStarted();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.started();
            throw throwable;
        }
        {
            Object var2_3 = null;
        }
        super.started();
    }

    public void changed(Property property, Context context) {
        block16: {
            block17: {
                super.changed(property, context);
                if (!this.isRunning()) {
                    return;
                }
                if (property == enabled) {
                    boolean bl = false;
                    if (!this.isDisabled() && !this.isServiceRunning()) {
                        if (this.disabledAtStart) {
                            bl = true;
                        }
                        this.serviceStarted();
                    }
                    if (this.isDisabled() && this.isServiceRunning()) {
                        this.serviceStopped();
                    }
                    if (bl) {
                        Class clazz = class$javax$baja$lonworks$BLonDevice;
                        if (clazz == null) {
                            clazz = class$javax$baja$lonworks$BLonDevice = BLonNetwork.class("[Ljavax.baja.lonworks.BLonDevice;", false);
                        }
                        BLonDevice[] bLonDeviceArray = (BLonDevice[])NmUtil.getDecendantsByClass((BComponent)this, clazz);
                        int n = 0;
                        while (n < bLonDeviceArray.length) {
                            try {
                                bLonDeviceArray[n].started();
                            }
                            catch (Exception exception) {}
                            ++n;
                        }
                    }
                }
                if (property != lonCommConfig) break block16;
                if (this.isServiceRunning() || this.isDisabled()) break block17;
                this.serviceStarted();
                if (!this.isServiceRunning()) break block16;
                Class clazz = class$javax$baja$lonworks$BLonDevice;
                if (clazz == null) {
                    clazz = class$javax$baja$lonworks$BLonDevice = BLonNetwork.class("[Ljavax.baja.lonworks.BLonDevice;", false);
                }
                BLonDevice[] bLonDeviceArray = (BLonDevice[])NmUtil.getDecendantsByClass((BComponent)this, clazz);
                int n = 0;
                while (n < bLonDeviceArray.length) {
                    try {
                        bLonDeviceArray[n].started();
                    }
                    catch (Exception exception) {}
                    ++n;
                }
                break block16;
            }
            if (!this.isServiceRunning()) break block16;
            try {
                this.lonComm.verifySettings();
                this.configOk();
            }
            catch (Throwable throwable) {
                this.log().error("Error initializing LonNetwork " + this.getDisplayName(null), throwable);
                this.configFail(throwable.getMessage());
            }
        }
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Class clazz = class$javax$baja$nav$BINavNode;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BINavNode = BLonNetwork.class("[Ljavax.baja.nav.BINavNode;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)this.getLocalLonDevice());
        int n = 0;
        while (n < bINavNodeArray.length) {
            array.add((Object)bINavNodeArray[n]);
            ++n;
        }
        return (BINavNode[])array.trim();
    }

    public String getLogName() {
        return this.getLonCommConfig().getDeviceName().toLowerCase();
    }

    public final IFuture postAsync(Runnable runnable) {
        if (!this.isServiceRunning()) {
            return null;
        }
        if (this.workQueue == null || !this.workQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.workQueue.getTodo()).enqueue((Object)runnable);
        return null;
    }

    public final IFuture postWrite(Runnable runnable) {
        if (!this.isServiceRunning()) {
            return null;
        }
        if (this.coalesceQueue == null || !this.coalesceQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.coalesceQueue.getTodo()).enqueue((Object)runnable);
        return null;
    }

    public final Worker getProxyQueue() {
        return this.proxyQueue;
    }

    public final Worker getTimedQueue() {
        return this.timedQueue;
    }

    public final LonComm lonComm() {
        return this.lonComm;
    }

    public final NetMessageReceiver netMessageReceiver() {
        return this.netMessageReceiver;
    }

    public final NvManager nvManager() {
        return this.nvManager;
    }

    public final AddressManager addressManager() {
        return this.addressManager;
    }

    public final BLonNetmgmt netmgmt() {
        return this.getLonNetmgmt();
    }

    public final BLonRouter[] getLonRouters() {
        return NmUtil.getLonRouters((BIDeviceFolder)this);
    }

    public final BLonDevice[] getLonDevices() {
        return NmUtil.getLonDevices((BIDeviceFolder)this);
    }

    public final BLonDevice findDevice(BNeuronId bNeuronId) {
        BLonDevice[] bLonDeviceArray = this.getLonDevices();
        int n = 0;
        while (n < bLonDeviceArray.length) {
            if (bLonDeviceArray[n].getNeuronIdAddress().equals(bNeuronId)) {
                return bLonDeviceArray[n];
            }
            ++n;
        }
        return null;
    }

    public final BLonRouter findRouter(BNeuronId bNeuronId) {
        BLonRouter[] bLonRouterArray = this.getLonRouters();
        int n = 0;
        while (n < bLonRouterArray.length) {
            if (bLonRouterArray[n].getNeuronIdAddress().equals(bNeuronId)) {
                return bLonRouterArray[n];
            }
            ++n;
        }
        return null;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps("BLonNetwork");
        spyWriter.prop((Object)"serviceRunning", this.serviceRunning);
        spyWriter.prop((Object)"dataPntMismatchCount", this.dataPntMismatchCount);
        spyWriter.endProps();
        if (this.workQueue != null) {
            spyWriter.trTitle((Object)"Async Queue", 1);
            this.workQueue.spy(spyWriter);
        }
        if (this.coalesceQueue != null) {
            spyWriter.trTitle((Object)"Coalescing Write Queue", 1);
            this.coalesceQueue.spy(spyWriter);
        }
        if (this.proxyQueue != null) {
            spyWriter.trTitle((Object)"Proxy Queue", 1);
            this.proxyQueue.spy(spyWriter);
        }
        if (this.timedQueue != null) {
            spyWriter.trTitle((Object)"Delay Queue", 1);
            this.timedQueue.spy(spyWriter);
            ((TimedCoalesceQueue)this.timedQueue.getTodo()).spy(spyWriter);
        }
        if (this.nvManager != null) {
            spyWriter.trTitle((Object)"NvManager", 1);
            this.nvManager.spy(spyWriter);
        }
        if (this.addressManager != null) {
            spyWriter.trTitle((Object)"Address Manager", 1);
            ((NAddressManager)this.addressManager).spy(spyWriter);
        }
        NAppBuffer.spy(spyWriter);
        this.lonComm.spy(spyWriter);
    }

    public final Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)this.getLogName());
        }
        return this.log;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.firstPass = true;
        this.disabledAtStart = true;
        this.serviceRunning = false;
        this.workQueue = null;
        this.coalesceQueue = null;
        this.proxyQueue = null;
        this.timedQueue = null;
        this.dataPntMismatchCount = 0;
        this.log = null;
        this.netMessageReceiver = null;
        this.lonComm = null;
        this.nvManager = null;
        this.addressManager = null;
    }

    public BLonNetwork() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$lonworks$BLonNetwork;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonNetwork = BLonNetwork.class("[Ljavax.baja.lonworks.BLonNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        noWrite = BFacets.make((String)"noWrite", (boolean)true);
        noPropagate = BFacets.make((String)"noPropagate", (boolean)true);
        lonNoWrite = new BasicContext((Context)noWrite){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (object != null && object instanceof Context && ((Context)object).getFacets().getb("noWrite", false)) {
                    bl = true;
                }
                return bl;
            }
        };
        lonNoPropagate = new BasicContext((Context)noPropagate){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (object != null && object instanceof Context && ((Context)object).getFacets().getb("noPropagate", false)) {
                    bl = true;
                }
                return bl;
            }
        };
        lonNoPropagateNoWrite = new BasicContext((Context)BFacets.make((BFacets)noWrite, (BFacets)noPropagate));
    }
}

