/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.device.BDownloadJob;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.local.BPseudoNvContainer;
import com.tridium.lonworks.netmgmt.BChangeNvTypeAction;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import java.util.Vector;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.log.Log;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BILonLoadable;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BLonObjectFolder;
import javax.baja.lonworks.BMessageTag;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BConfigProps;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.enums.BLonObjectRequestEnum;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.proxy.BLonPointDeviceExt;
import javax.baja.lonworks.proxy.BLonPointFolder;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.lonworks.util.LonFile;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonDevice
extends BDevice
implements BINvContainer,
BILonLoadable {
    public static final Property deviceData = BLonDevice.newProperty((int)8, (BValue)new BDeviceData(), null);
    public static final Property points = BLonDevice.newProperty((int)0, (BValue)new BLonPointDeviceExt(), null);
    public static final Property messageIn = BLonDevice.newProperty((int)1024, (BValue)new BMessageTag(), null);
    public static final Action upload = BLonDevice.newAction((int)0, (BValue)new BUploadParameters(), null);
    public static final Action download = BLonDevice.newAction((int)0, (BValue)new BDownloadParameters(), null);
    public static final Action reset = BLonDevice.newAction((int)0, null);
    public static final Action renewProxies = BLonDevice.newAction((int)4, null);
    public static final Action initImport = BLonDevice.newAction((int)4, null);
    public static final Action closeImport = BLonDevice.newAction((int)4, null);
    public static final Type TYPE;
    private static final int FILE_STATE_INIT = 0;
    private static final int FILE_STATE_NO_FILES = 1;
    private static final int FILE_STATE_DOWNLOAD = 2;
    private static final int FILE_STATE_UPLOAD = 3;
    private static final int FILE_STATE_IDLE = 4;
    NvDev.SaveNv snv;
    BLink[] toLnks;
    Object nvSync;
    BINetworkVariable[] nvList;
    protected boolean staleNvList;
    boolean linkUpdateDone;
    private int fileState;
    private boolean hasReadOnly;
    private LonFile lonFile;
    private LonFile readWritefile;
    private LonFile readOnlyfile;
    private int maxInMessageSize;
    private int maxOutMessageSize;
    public int dataPntMismatchCount;
    protected Log log;
    private BLonNetwork net;
    private boolean downloading;
    private boolean uploading;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonDevice;
    static /* synthetic */ Class class$javax$baja$sys$BLink;
    static /* synthetic */ Class class$javax$baja$lonworks$BMessageTag;
    static /* synthetic */ Class class$javax$baja$lonworks$BINvContainer;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonObject;
    static /* synthetic */ Class class$javax$baja$lonworks$BNetworkConfig;
    static /* synthetic */ Class class$javax$baja$lonworks$BConfigParameter;
    static /* synthetic */ Class class$javax$baja$lonworks$BINetworkVariable;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;

    public BDeviceData getDeviceData() {
        return (BDeviceData)this.get(deviceData);
    }

    public void setDeviceData(BDeviceData bDeviceData) {
        this.set(deviceData, (BValue)bDeviceData, null);
    }

    public BLonPointDeviceExt getPoints() {
        return (BLonPointDeviceExt)this.get(points);
    }

    public void setPoints(BLonPointDeviceExt bLonPointDeviceExt) {
        this.set(points, (BValue)bLonPointDeviceExt, null);
    }

    public BMessageTag getMessageIn() {
        return (BMessageTag)this.get(messageIn);
    }

    public void setMessageIn(BMessageTag bMessageTag) {
        this.set(messageIn, (BValue)bMessageTag, null);
    }

    public void upload(BUploadParameters bUploadParameters) {
        this.invoke(upload, (BValue)bUploadParameters, null);
    }

    public void download(BDownloadParameters bDownloadParameters) {
        this.invoke(download, (BValue)bDownloadParameters, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void renewProxies() {
        this.invoke(renewProxies, null, null);
    }

    public void initImport() {
        this.invoke(initImport, null, null);
    }

    public void closeImport() {
        this.invoke(closeImport, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean authenticate() {
        return this.getDeviceData().getAuthenticate();
    }

    public boolean isLocal() {
        return false;
    }

    public boolean programIdChanges() {
        return false;
    }

    public final BNeuronId getNeuronIdAddress() {
        return this.getDeviceData().getNeuronId();
    }

    public final BSubnetNode getSubnetNodeAddress() {
        return this.getDeviceData().getSubnetNodeId();
    }

    public final boolean isConfigOnline() {
        boolean bl = false;
        if (this.getDeviceData().getNodeState() == BLonNodeState.configOnline) {
            bl = true;
        }
        return bl;
    }

    public final boolean isConfigOffline() {
        boolean bl = false;
        if (this.getDeviceData().getNodeState() == BLonNodeState.configOffline) {
            bl = true;
        }
        return bl;
    }

    public final boolean isConfigured() {
        boolean bl = false;
        if (this.isConfigOnline() || this.isConfigOffline()) {
            bl = true;
        }
        return bl;
    }

    public boolean isExtended() {
        return this.getDeviceData().isExtended();
    }

    public int getWorkingDomain() {
        return this.getDeviceData().getWorkingDomain();
    }

    public Type getNetworkType() {
        return BLonNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        BLonNetwork bLonNetwork = this.lonNetwork();
        if (!bLonNetwork.isServiceRunning() || this.isFatalFault()) {
            return;
        }
        if (this.lonComm() == null) {
            this.configFail("No LonComm stack available");
            this.log().warning("No LonComm stack available. Fix problems and restart station.");
            return;
        }
        DeviceFacets.moveDeviceFacets(this);
        this.lonDeviceInit();
        bLonNetwork.addressManager().registerLonDevice(this);
        this.lonDeviceStarted();
        this.changeableNvCheck();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.updateFaultCause();
    }

    public final void atSteadyState() {
        if (!this.lonNetwork().isServiceRunning() || this.isFatalFault()) {
            return;
        }
        this.ping();
        this.lonDeviceAtSteadyState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopped() throws Exception {
        try {
            block9: {
                block8: {
                    this.net = null;
                    this.log = null;
                    this.clearFiles();
                    Object object = this.nvSync;
                    synchronized (object) {
                        this.nvList = null;
                        this.staleNvList = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl10 : MonitorExitStatement: MONITOREXIT : var3_1
                        this.lonNetwork().addressManager().unregisterLonDevice(this);
                        if (!this.lonNetwork().isServiceRunning()) break block8;
                    }
                    if (!this.isFatalFault()) break block9;
                }
                Object var2_2 = null;
                super.stopped();
                return;
            }
            this.lonDeviceStopped();
            Object var2_4 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stopped();
            throw throwable;
        }
        super.stopped();
    }

    public void renamed(Property property, String string, Context context) {
        if (property.getType().is(BLonComponent.TYPE)) {
            BLonDevice.lonComponentRenamed(this, property.getName(), string, context);
        }
    }

    static void lonComponentRenamed(BLonDevice bLonDevice, String string, String string2, Context context) {
        BControlPoint[] bControlPointArray = bLonDevice.getLonProxies();
        int n = 0;
        while (n < bControlPointArray.length) {
            BLonProxyExt bLonProxyExt = (BLonProxyExt)bControlPointArray[n].getProxyExt();
            if (bLonProxyExt.getTargetComp().equals(string2)) {
                bLonProxyExt.setTargetComp(string);
                bLonProxyExt.renew();
            }
            ++n;
        }
    }

    public void updateDomainTable() {
        try {
            NmUtil.updateDomainTable(this.lonNetwork().getLonNetmgmt(), this);
        }
        catch (Throwable throwable) {
            this.log().error("Unable to update domain table in " + this.getDisplayName(null), throwable);
        }
    }

    public void updateNodeState() {
        try {
            BDeviceData bDeviceData = this.getDeviceData();
            BLonNodeState bLonNodeState = bDeviceData.getNodeState();
            if (bLonNodeState == BLonNodeState.applicationless && (bDeviceData.getHosted() || this.isLocal())) {
                try {
                    this.set(BDeviceData.nodeState, (BValue)NmUtil.getDeviceState(this), AddressManager.noDeviceChange);
                }
                catch (LonException lonException) {}
                throw new BajaRuntimeException("Changing this device to applicationless state will render it inoperable.");
            }
            if (Lon.d()) {
                NmUtil.setDeviceState(this, bLonNodeState);
            }
        }
        catch (Throwable throwable) {
            this.log().error("Unable to update nodeState in " + this.getDisplayName(null), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == status) {
            this.statusChanged();
        }
        if (!property.getType().is(BINetworkVariable.TYPE)) return;
        Object object = this.nvSync;
        synchronized (object) {
            this.staleNvList = true;
            return;
        }
    }

    private final void statusChanged() {
        this.updateFaultCause();
        BINetworkVariable[] bINetworkVariableArray = this.getNvList();
        int n = 0;
        while (n < bINetworkVariableArray.length) {
            if (bINetworkVariableArray[n] != null && bINetworkVariableArray[n].isNetworkVariable()) {
                ((BNetworkVariable)bINetworkVariableArray[n]).getTuning().transition();
            }
            ++n;
        }
    }

    protected void updateFaultCause() {
        if (this.isFault() && this.getFaultCause().length() == 0 && this.getLonNetwork().isFault()) {
            this.setFaultCause("Network fault: " + this.getLonNetwork().getFaultCause());
        }
        if (!this.isFault()) {
            this.setFaultCause("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void added(Property property, Context context) {
        super.added(property, context);
        if (!property.getType().is(BINetworkVariable.TYPE)) {
            if (!property.getType().is(BLonLink.TYPE)) return;
            BLonLink bLonLink = (BLonLink)this.get(property);
            if (!this.isRunning()) return;
            if (bLonLink.getMessageTag()) return;
            bLonLink.getDestinationNv().lonLinkAdded();
            return;
        }
        Object object = this.nvSync;
        synchronized (object) {
            this.staleNvList = true;
            return;
        }
    }

    public void checkRemove(Property property, Context context) {
        this.snv = NvDev.checkRemove((BComponent)this, property, context);
        super.checkRemove(property, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (property.getType().is(BINetworkVariable.TYPE)) {
            Object object = this.nvSync;
            synchronized (object) {
                this.staleNvList = true;
            }
        }
        NvDev.removed((BComponent)this, this.snv, property, bValue, context);
        this.snv = null;
    }

    public final void knobAdded(Knob knob, Context context) {
        NvDev.knobAdded((BComponent)this, knob, context);
    }

    public final void knobRemoved(Knob knob, Context context) {
        NvDev.knobRemoved((BComponent)this, knob, context);
    }

    public IFuture postAsync(Runnable runnable) {
        return ((BLonNetwork)this.getNetwork()).postAsync(runnable);
    }

    protected IFuture postPing() {
        return this.postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
    }

    public final void doUpload(BUploadParameters bUploadParameters, Context context) throws Exception {
        this.checkState();
        this.checkUpload();
        new BUploadJob(this, bUploadParameters, context).submit(context);
    }

    public final void doDownload(BDownloadParameters bDownloadParameters, Context context) throws Exception {
        this.checkState();
        this.checkDownload();
        new BDownloadJob(this, bDownloadParameters, context).submit(context);
    }

    public void checkState() {
        if (this.isDown()) {
            throw new LocalizableRuntimeException("lonworks", "check.down");
        }
        if (this.isDisabled()) {
            throw new LocalizableRuntimeException("lonworks", "check.disabled");
        }
        if (this.isFault()) {
            throw new LocalizableRuntimeException("lonworks", "check.fault");
        }
    }

    public void beginConfigWrite() {
    }

    public void endConfigWrite() {
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        if (this.getAction("ChangeNvTypeAction") == null) {
            agentList.remove("lonworks:ChangeableNvManager");
        }
        return NvDev.fixWireSheet(agentList, context);
    }

    public void doReset() {
        try {
            if (Lon.d()) {
                NmUtil.resetNode(this);
            }
        }
        catch (Throwable throwable) {
            this.log().error("Exception in LonDevice.reset()", throwable);
        }
    }

    public void doRenewProxies() {
        BControlPoint[] bControlPointArray = this.getLonProxies();
        int n = 0;
        while (n < bControlPointArray.length) {
            try {
                BLonProxyExt bLonProxyExt = (BLonProxyExt)bControlPointArray[n].getProxyExt();
                bLonProxyExt.renew(true);
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public void doInitImport() {
        BINvContainer[] bINvContainerArray = this.getNvContainers();
        Class clazz = class$javax$baja$sys$BLink;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BLink = BLonDevice.class("[Ljavax.baja.sys.BLink;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bINvContainerArray.length) {
            BLink[] bLinkArray = bINvContainerArray[n].asComponent().getLinks();
            int n2 = 0;
            while (n2 < bLinkArray.length) {
                if (bLinkArray[n2].getType().is(BLonLink.TYPE)) {
                    array.add((Object)bLinkArray[n2]);
                }
                ++n2;
            }
            Knob[] knobArray = bINvContainerArray[n].asComponent().getKnobs();
            int n3 = 0;
            while (n3 < knobArray.length) {
                BLink bLink = knobArray[n3].getLink();
                if (bLink.getType().is(BLonLink.TYPE)) {
                    array.add((Object)bLink);
                }
                ++n3;
            }
            ++n;
        }
        this.toLnks = (BLink[])array.trim();
    }

    public void doCloseImport() {
        this.doRenewProxies();
        if (this.toLnks == null) {
            return;
        }
        int n = 0;
        while (n < this.toLnks.length) {
            block4: {
                this.toLnks[n].deactivate();
                try {
                    this.toLnks[n].activate();
                }
                catch (Throwable throwable) {
                    if (this.toLnks[n].getParent() == null) break block4;
                    ((BComponent)this.toLnks[n].getParent()).remove((BComplex)this.toLnks[n]);
                }
            }
            ++n;
        }
        this.toLnks = null;
    }

    protected void lonDeviceInit() {
    }

    protected void lonDeviceStarted() {
    }

    protected void lonDeviceAtSteadyState() {
    }

    protected void lonDeviceStopped() {
    }

    public void deviceDataChanged(Property property, Context context) {
        if (property.equals((Object)BDeviceData.programId)) {
            this.changeableNvCheck();
        }
        if (property.equals((Object)BDeviceData.subnetNodeId)) {
            this.updateLocallyBoundNvs();
        }
        if (property == BDeviceData.neuronId) {
            this.clearMaxMessageLength();
        }
    }

    public void updateLocalState() {
    }

    public void beginCommission() {
    }

    public void postCommission() {
    }

    private final void changeableNvCheck() {
        boolean bl;
        if (this.isLocal()) {
            return;
        }
        boolean bl2 = false;
        if (this.getAction("ChangeNvTypeAction") != null) {
            bl2 = bl = true;
        }
        if (this.hasChangeableNvs()) {
            if (bl) {
                return;
            }
            this.add("ChangeNvTypeAction", (BValue)new BChangeNvTypeAction(), 4);
        } else if (bl) {
            this.remove("ChangeNvTypeAction");
        }
    }

    private final void updateLocallyBoundNvs() {
        BINetworkVariable[] bINetworkVariableArray = this.getNetworkVariables();
        int n = 0;
        while (n < bINetworkVariableArray.length) {
            if (bINetworkVariableArray[n] != null && bINetworkVariableArray[n].isNetworkVariable()) {
                ((BNetworkVariable)bINetworkVariableArray[n]).reregisterSelector();
            }
            ++n;
        }
    }

    public boolean hasChangeableNvs() {
        return this.getDeviceData().getProgramId().hasChangeableNvs();
    }

    public void bound(int n) {
    }

    public void unbound(int n) {
    }

    public void bindComplete() {
    }

    /*
     * Unable to fully structure code
     */
    public final BMessageTag getMessageTag(int var1_1) {
        if (var1_1 == -1) {
            return this.getMessageIn();
        }
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl8
        do {
            if ((var3_3 = (BMessageTag)var2_2.get()).getIndex() == var1_1) {
                return var3_3;
            }
lbl8:
            // 3 sources

            if ((v0 = BLonDevice.class$javax$baja$lonworks$BMessageTag) != null) continue;
            v0 = BLonDevice.class("[Ljavax.baja.lonworks.BMessageTag;", false);
        } while (var2_2.next(v0));
        return null;
    }

    public BLonDevice getLonDevice() {
        return this;
    }

    public BLonNetwork getLonNetwork() {
        return this.lonNetwork();
    }

    public boolean isLonObject() {
        return false;
    }

    public BINvContainer[] getNvContainers() {
        Class clazz = class$javax$baja$lonworks$BINvContainer;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BINvContainer = BLonDevice.class("[Ljavax.baja.lonworks.BINvContainer;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)this);
        this.doGetNvContainers((BComponent)this, array);
        return (BINvContainer[])array.trim();
    }

    private final void doGetNvContainers(BComponent bComponent, Array array) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = (BComponent)slotCursor.get();
            if (bComponent2.getType().is(BINvContainer.TYPE) && !bComponent2.getType().is(BPseudoNvContainer.TYPE)) {
                array.add((Object)bComponent2);
                continue;
            }
            if (!bComponent2.getType().is(BLonObjectFolder.TYPE)) continue;
            this.doGetNvContainers(bComponent2, array);
        }
    }

    public BLonObject[] getLonObjects() {
        Class clazz = class$javax$baja$lonworks$BLonObject;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonObject = BLonDevice.class("[Ljavax.baja.lonworks.BLonObject;", false);
        }
        Array array = new Array(clazz);
        this.doGetLonObjects((BComponent)this, array);
        return (BLonObject[])array.trim();
    }

    private final void doGetLonObjects(BComponent bComponent, Array array) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = (BComponent)slotCursor.get();
            if (bComponent2.getType().is(BLonObject.TYPE)) {
                array.add((Object)bComponent2);
                continue;
            }
            if (!bComponent2.getType().is(BLonObjectFolder.TYPE)) continue;
            this.doGetLonObjects(bComponent2, array);
        }
    }

    public BLonObject getLonObject(int n) {
        return this.doGetLonObject((BComponent)this, n);
    }

    private final BLonObject doGetLonObject(BComponent bComponent, int n) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = (BComponent)slotCursor.get();
            if (bComponent2.getType().is(BLonObject.TYPE)) {
                BLonObject bLonObject = (BLonObject)bComponent2;
                if (bLonObject.getObjectId() != n) continue;
                return bLonObject;
            }
            if (!bComponent2.getType().is(BLonObjectFolder.TYPE)) continue;
            return this.doGetLonObject(bComponent2, n);
        }
        return null;
    }

    public final BNetworkVariable getNetworkVariable(int n) {
        if (n < 0) {
            return null;
        }
        BINetworkVariable[] bINetworkVariableArray = this.getNvList();
        if (n >= bINetworkVariableArray.length || bINetworkVariableArray[n] == null || !bINetworkVariableArray[n].isNetworkVariable()) {
            return null;
        }
        return (BNetworkVariable)bINetworkVariableArray[n];
    }

    public final BNetworkConfig getNetworkConfig(int n) {
        if (n < 0) {
            return null;
        }
        BINetworkVariable[] bINetworkVariableArray = this.getNvList();
        if (n >= bINetworkVariableArray.length || bINetworkVariableArray[n] == null || !bINetworkVariableArray[n].isNetworkConfig()) {
            return null;
        }
        return (BNetworkConfig)bINetworkVariableArray[n];
    }

    public final Property findLonObjectNvProperty(int n, int n2, int n3) {
        BINetworkVariable[] bINetworkVariableArray = this.getNvList();
        int n4 = 0;
        while (n4 < bINetworkVariableArray.length) {
            BNetworkVariable bNetworkVariable;
            if (bINetworkVariableArray[n4] != null && bINetworkVariableArray[n4].isNetworkVariable() && (bNetworkVariable = (BNetworkVariable)bINetworkVariableArray[n4]).getNvProps().getObjectIndex() == n && bNetworkVariable.getNvProps().getMemberIndex() == n2) {
                if (n3 > 0 && bNetworkVariable.getSnvtType() != n3) {
                    throw new BajaRuntimeException("Invalid nvtype for object/member " + n + '|' + n2 + " snvtType=" + bNetworkVariable.getSnvtType() + ". Expected " + n3);
                }
                this.log().trace("found nv for " + n + "  " + n2 + " - " + bNetworkVariable.getDisplayName(null));
                return this.getProperty(bNetworkVariable.getName());
            }
            ++n4;
        }
        return null;
    }

    public final BINetworkVariable findSnvtType(int n) {
        BINetworkVariable[] bINetworkVariableArray = this.getNvList();
        int n2 = 0;
        while (n2 < bINetworkVariableArray.length) {
            if (bINetworkVariableArray[n2] != null && bINetworkVariableArray[n2].getSnvtType() == n) {
                return bINetworkVariableArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public final BINetworkVariable[] getNetworkVariables() {
        return this.getNvList();
    }

    public final BNetworkConfig[] getNetworkConfigs() {
        Class clazz = class$javax$baja$lonworks$BNetworkConfig;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BNetworkConfig = BLonDevice.class("[Ljavax.baja.lonworks.BNetworkConfig;", false);
        }
        return (BNetworkConfig[])NmUtil.getDecendantsByClass((BComponent)this, clazz);
    }

    public final BConfigParameter[] getConfigParameters() {
        Class clazz = class$javax$baja$lonworks$BConfigParameter;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BConfigParameter = BLonDevice.class("[Ljavax.baja.lonworks.BConfigParameter;", false);
        }
        return (BConfigParameter[])NmUtil.getDecendantsByClass((BComponent)this, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void refreshNvList() {
        Object object = this.nvSync;
        synchronized (object) {
            this.staleNvList = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BINetworkVariable[] getNvList() {
        var1_1 = this.nvSync;
        synchronized (var1_1) {
            block9: {
                if (!this.staleNvList) break block9;
                var4_2 = new Vector<BINetworkVariable>(100);
                var5_3 = -1;
                var6_4 = this.getNvContainers();
                var7_5 = 0;
                while (true) {
                    block10: {
                        if (var7_5 < var6_4.length) break block10;
                        this.nvList = new BINetworkVariable[var5_3 + 1];
                        var7_5 = 0;
                        if (true) ** GOTO lbl33
                    }
                    var8_6 = ((BComponent)var6_4[var7_5]).getProperties();
                    if (true) ** GOTO lbl25
                    do {
                        if ((var10_8 = (var9_7 = (BINetworkVariable)var8_6.get()).getNvIndex()) > var5_3) {
                            var5_3 = var10_8;
                        }
                        var4_2.add(var9_7);
lbl25:
                        // 2 sources

                        if ((v1 = BLonDevice.class$javax$baja$lonworks$BINetworkVariable) != null) continue;
                        v1 = BLonDevice.class("[Ljavax.baja.lonworks.BINetworkVariable;", false);
                    } while (var8_6.next(v1));
                    ++var7_5;
                }
                do {
                    this.nvList[var7_5] = null;
                    ++var7_5;
lbl33:
                    // 2 sources

                } while (var7_5 < this.nvList.length);
                var7_5 = 0;
                while (var7_5 < var4_2.size()) {
                    var8_6 = (BINetworkVariable)var4_2.elementAt(var7_5);
                    if (var8_6.getNvIndex() >= 0) {
                        this.nvList[var8_6.getNvIndex()] = var8_6;
                    }
                    ++var7_5;
                }
                this.staleNvList = false;
            }
            return this.nvList;
        }
    }

    public final BAliasConfigData getAlias(BNetworkVariable bNetworkVariable, int n) {
        BAliasTable bAliasTable = this.getDeviceData().getAliasTable();
        if (bAliasTable.getAliasCount() == 0) {
            return null;
        }
        int n2 = bNetworkVariable.getNvIndex();
        int n3 = n;
        while (n3 < bAliasTable.getAliasCount()) {
            BAliasConfigData bAliasConfigData = bAliasTable.getAliasEntry(n3);
            if (bAliasConfigData.getPrimary() == n2) {
                return bAliasConfigData;
            }
            ++n3;
        }
        return null;
    }

    public BControlPoint[] getLonProxies() {
        return this.getLonProxies(null);
    }

    public BControlPoint[] getLonProxies(BLonComponent bLonComponent) {
        Class clazz = class$javax$baja$control$BControlPoint;
        if (clazz == null) {
            clazz = class$javax$baja$control$BControlPoint = BLonDevice.class("[Ljavax.baja.control.BControlPoint;", false);
        }
        Array array = new Array(clazz);
        this.getLonProxies((BComponent)this, array, bLonComponent);
        return (BControlPoint[])array.trim();
    }

    private final void getLonProxies(BComponent bComponent, Array array, BLonComponent bLonComponent) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            BAbstractProxyExt bAbstractProxyExt;
            BComponent bComponent2 = (BComponent)slotCursor.get();
            if (bComponent2.getType().is(BLonPointFolder.TYPE) || bComponent2.getType().is(BLonPointDeviceExt.TYPE)) {
                this.getLonProxies(bComponent2, array, bLonComponent);
                continue;
            }
            if (!bComponent2.getType().is(BControlPoint.TYPE) || !((bAbstractProxyExt = ((BControlPoint)bComponent2).getProxyExt()) instanceof BLonProxyExt) || bLonComponent != null && !((BLonProxyExt)bAbstractProxyExt).getTargetComp().equals(bLonComponent.getName())) continue;
            array.add((Object)bComponent2);
        }
    }

    public void doPing() {
        if (!this.isRunning() || !this.getEnabled() || !this.lonNetwork().isServiceRunning() || this.isFatalFault()) {
            return;
        }
        this.pingImpl();
    }

    private final void pingImpl() {
        try {
            if (this.getNeuronIdAddress().isZero()) {
                throw new RuntimeException("Neuron id is zero");
            }
            if (this.getDeviceData().getNodeState() == BLonNodeState.unknown) {
                throw new RuntimeException("Unknown state - Device requires commissioning");
            }
            if (Lon.d()) {
                NmUtil.getDeviceState(this);
            }
            this.pingOk();
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)false));
        }
        catch (NotRunningException notRunningException) {
        }
        catch (Throwable throwable) {
            this.pingFail(throwable.getMessage());
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
        }
    }

    public boolean isReadyForNvUpdates() {
        boolean bl = false;
        if (Sys.atSteadyState() && this.getStatus().isValid() && this.isConfigOnline() && this.getEnabled()) {
            bl = true;
        }
        return bl;
    }

    protected LinkCheck doCheckLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        return NvDev.doNvCheckLink(bComponent, slot, (BComponent)this, slot2, context);
    }

    public void linkUpdate() {
        if (this.linkUpdateDone) {
            return;
        }
        this.getComponentSpace().update((BComponent)this, 1);
        this.getComponentSpace().update((BComponent)this.getDeviceData(), 2);
        this.linkUpdateDone = true;
        BINvContainer[] bINvContainerArray = this.getNvContainers();
        int n = 1;
        while (n < bINvContainerArray.length) {
            bINvContainerArray[n].linkUpdate();
            ++n;
        }
    }

    public final BLink makeLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        if (!NvDev.requiresLonLink(slot2)) {
            return super.makeLink(bComponent, slot, slot2, context);
        }
        return NvDev.makeLonLink(bComponent, slot, (BComponent)this, slot2, context);
    }

    final void initDownload(boolean bl) {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return;
            }
            if (this.readWritefile != null && !this.readWritefile.isOpen()) {
                if (!this.hasReadOnly && this.hasReadOnlyCp()) {
                    if (this.readWritefile.supportsRandomAccess()) {
                        this.readWritefile.open(1, true, true);
                    } else {
                        this.readWritefile.open(1, false, false);
                    }
                } else {
                    this.readWritefile.open(1, true, bl);
                }
            }
            if (this.readOnlyfile != null && !this.readOnlyfile.isOpen()) {
                this.readOnlyfile.open(2, true, bl);
            }
        }
        catch (LonException lonException) {
            this.close();
            this.clearFiles();
            throw new BajaRuntimeException("Unable to open files for download.", (Throwable)((Object)lonException));
        }
        this.fileState = 2;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasReadOnlyCp() {
        var1_1 = this.getNvContainers();
        var2_2 = 0;
        while (var2_2 < var1_1.length) {
            var3_3 = ((BComponent)var1_1[var2_2]).getProperties();
            if (true) ** GOTO lbl9
            do {
                if (!(var4_4 = (BConfigParameter)var3_3.get()).isWriteable()) {
                    return true;
                }
lbl9:
                // 3 sources

                if ((v0 = BLonDevice.class$javax$baja$lonworks$BConfigParameter) != null) continue;
                v0 = BLonDevice.class("[Ljavax.baja.lonworks.BConfigParameter;", false);
            } while (var3_3.next(v0));
            ++var2_2;
        }
        return false;
    }

    final void cleanupDownload() {
        this.close();
        this.fileState = 4;
    }

    public final boolean isDownLoadInProgress() {
        return this.downloading;
    }

    public final boolean isUpLoadInProgress() {
        return this.uploading;
    }

    public void checkUpload() {
    }

    public void beginUpload() {
        this.uploading = true;
        this.initUpload(false);
    }

    public void endUpload() {
        this.cleanupUpload();
        this.uploading = false;
    }

    public void checkChangeNvType() {
    }

    public void changeNvTypeComplete() {
    }

    public void checkDownload() {
    }

    public void beginDownload() {
        this.downloading = true;
        this.initDownload(false);
    }

    public void endDownload() {
        this.cleanupDownload();
        this.downloading = false;
    }

    final void initUpload(boolean bl) {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return;
            }
            if (this.readWritefile != null && !this.readWritefile.isOpen()) {
                this.readWritefile.open(1, false, bl);
            }
            if (this.readOnlyfile != null && !this.readOnlyfile.isOpen()) {
                this.readOnlyfile.open(2, false, bl);
            }
        }
        catch (LonException lonException) {
            this.close();
            this.clearFiles();
            throw new BajaRuntimeException("Unable to open files for upload.", (Throwable)((Object)lonException));
        }
        this.fileState = 3;
    }

    final void cleanupUpload() {
        this.close();
        this.fileState = 4;
    }

    public final LonFile getLonFileOpen(int n) {
        return this.getLonFileOpen(n, false, true);
    }

    public final LonFile getLonFileOpen(int n, boolean bl, boolean bl2) {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return null;
            }
            LonFile lonFile = this.lonFile.copy();
            if (n < 0) {
                return lonFile;
            }
            if (lonFile != null && !lonFile.isOpen()) {
                lonFile.open(n, bl, bl2);
            }
            return lonFile;
        }
        catch (LonException lonException) {
            lonException.printStackTrace();
            this.log().error("error accessing file " + n, (Throwable)((Object)lonException));
            return null;
        }
    }

    LonFile getReadWriteFile() {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return null;
            }
            LonFile lonFile = this.readWritefile;
            if (lonFile != null && !lonFile.isOpen()) {
                lonFile.open(1, false, true);
            }
            return lonFile;
        }
        catch (LonException lonException) {
            lonException.printStackTrace();
            this.log().error("error accessing file readOnly config file", (Throwable)((Object)lonException));
            return null;
        }
    }

    LonFile getReadOnlyFile() {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return null;
            }
            LonFile lonFile = this.readOnlyfile;
            int n = 2;
            if (!this.hasReadOnly) {
                lonFile = this.readWritefile;
                n = 1;
            }
            if (lonFile != null && !lonFile.isOpen()) {
                lonFile.open(n, false, true);
            }
            return lonFile;
        }
        catch (LonException lonException) {
            lonException.printStackTrace();
            this.log().error("error accessing file readOnly config file", (Throwable)((Object)lonException));
            return null;
        }
    }

    private final void createFiles() throws LonException {
        if (!this.getDeviceData().getHasNodeObject()) {
            this.fileState = 1;
            return;
        }
        this.lonFile = LonFile.createFile(this);
        if (this.lonFile == null) {
            this.fileState = 1;
            return;
        }
        if (this.lonFile.findFileNum(2) == 0) {
            this.readWritefile = this.lonFile;
            boolean bl = false;
            if (this.lonFile.findFileNum(1, 1) > 0) {
                bl = this.hasReadOnly = true;
            }
            if (this.hasReadOnly) {
                this.readOnlyfile = this.lonFile.copy();
            }
        }
        this.fileState = 4;
    }

    private final void close() {
        if (this.lonFile != null) {
            try {
                this.lonFile.close();
            }
            catch (LonException lonException) {}
        }
        if (this.readWritefile != null) {
            try {
                this.readWritefile.close();
            }
            catch (LonException lonException) {}
        }
        if (this.readOnlyfile != null) {
            try {
                this.readOnlyfile.close();
            }
            catch (LonException lonException) {}
        }
    }

    public final void clearFiles() {
        this.fileState = 0;
        this.lonFile = null;
        this.readWritefile = null;
        this.readOnlyfile = null;
    }

    public boolean disableObjectForCpWrite(BConfigProps bConfigProps) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public void enableObject(BConfigProps bConfigProps) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public final void resetDevice() {
        throw new UnsupportedOperationException("Deprecated : use doReset()");
    }

    public boolean isObjectDisabled(int n) {
        if (!this.isConfigOnline()) {
            return true;
        }
        Property property = this.findLonObjectNvProperty(0, 1, 92);
        int n2 = ((BNetworkVariable)this.get(property)).getNvIndex();
        if (n2 < 0) {
            throw new BajaRuntimeException("Can not find SNVT_OBJ_REQUEST in " + this.getDisplayName(null));
        }
        BNetworkVariable bNetworkVariable = this.getNetworkVariable(n2);
        Property property2 = this.findLonObjectNvProperty(0, 2, 93);
        if (property2 == null) {
            throw new BajaRuntimeException("Can not find nvoStatus.");
        }
        BNetworkVariable bNetworkVariable2 = (BNetworkVariable)this.get(property2);
        try {
            this.sendObjectRequest(BLonObjectRequestEnum.rqUpdateStatus, n, bNetworkVariable);
            NmUtil.wait(50);
            BNetworkVariable bNetworkVariable3 = this.getObjectStatus(n, bNetworkVariable2);
            return bNetworkVariable3.getData().getLonBoolean("disabled");
        }
        catch (LonException lonException) {
            throw new BajaRuntimeException("Unable to set object " + n + " status in " + this.getDisplayName(null), (Throwable)((Object)lonException));
        }
    }

    public boolean enableObject(int n, boolean bl) {
        if (n < 0) {
            return false;
        }
        Property property = this.findLonObjectNvProperty(0, 1, 92);
        int n2 = ((BNetworkVariable)this.get(property)).getNvIndex();
        if (n2 < 0) {
            return false;
        }
        BNetworkVariable bNetworkVariable = this.getNetworkVariable(n2);
        Property property2 = this.findLonObjectNvProperty(0, 2, 93);
        if (property2 == null) {
            return false;
        }
        BNetworkVariable bNetworkVariable2 = (BNetworkVariable)this.get(property2);
        int n3 = 3;
        while (n3 > 0) {
            try {
                BLonObjectRequestEnum bLonObjectRequestEnum = bl ? BLonObjectRequestEnum.rqEnable : BLonObjectRequestEnum.rqDisabled;
                this.sendObjectRequest(bLonObjectRequestEnum, n, bNetworkVariable);
                NmUtil.wait(50);
                BNetworkVariable bNetworkVariable3 = this.getObjectStatus(n, bNetworkVariable2);
                if (bNetworkVariable3.getData().getLonBoolean("invalidRequest")) {
                    return false;
                }
                if (bNetworkVariable3.getData().getLonBoolean("disabled") == bl) {
                    return true;
                }
            }
            catch (Exception exception) {
                System.out.println("enableObject() " + exception);
                exception.printStackTrace();
            }
            --n3;
        }
        return false;
    }

    private final void sendObjectRequest(BLonObjectRequestEnum bLonObjectRequestEnum, int n, BNetworkVariable bNetworkVariable) throws LonException {
        BLonData bLonData = bNetworkVariable.getData();
        bLonData.setLonInt("objectId", n, BLonNetwork.lonNoWrite);
        bLonData.setLonEnum("objectRequest", bLonObjectRequestEnum.getTag(), BLonNetwork.lonNoWrite);
        bNetworkVariable.doForceWrite();
    }

    private final BNetworkVariable getObjectStatus(int n, BNetworkVariable bNetworkVariable) throws LonException {
        int n2 = 0;
        while (n2 < 4) {
            int n3;
            if (!bNetworkVariable.getNvProps().getBoundToLocal()) {
                bNetworkVariable.doForceRead();
            }
            if ((n3 = bNetworkVariable.getData().getLonInt("objectId")) == n) {
                return bNetworkVariable;
            }
            NmUtil.wait(100);
            ++n2;
        }
        throw new LonException("Can not read status nv");
    }

    void disableObjectsForWrite(int[] nArray, boolean[] blArray) {
        if (this.isDownLoadInProgress() || !this.isConfigOnline()) {
            int n = 0;
            while (n < nArray.length) {
                blArray[n] = false;
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            if (this.isObjectDisabled(nArray[n])) {
                blArray[n] = false;
            } else {
                try {
                    blArray[n] = this.enableObject(nArray[n], false);
                }
                catch (Throwable throwable) {
                    blArray[n] = false;
                    System.out.println(throwable);
                }
            }
            ++n;
        }
    }

    void enableObjectsAfterWrite(int[] nArray, boolean[] blArray) {
        int n = 0;
        while (n < nArray.length) {
            if (blArray[n]) {
                try {
                    this.enableObject(nArray[n], true);
                }
                catch (Throwable throwable) {
                    System.out.println(throwable);
                }
            }
            ++n;
        }
    }

    public int getMaxMessageLengthOut() {
        if (this.maxOutMessageSize == 0) {
            this.updateMaxMessageLength();
        }
        return this.maxOutMessageSize;
    }

    public int getMaxMessageLengthIn() {
        if (this.maxInMessageSize == 0) {
            this.updateMaxMessageLength();
        }
        return this.maxInMessageSize;
    }

    private final void clearMaxMessageLength() {
        this.maxOutMessageSize = 0;
        this.maxInMessageSize = 0;
    }

    public final void updateMaxMessageLength() {
        try {
            if (!Lon.d()) {
                return;
            }
            byte[] byArray = Neuron.readMemory(this.lonComm(), 1, NmUtil.getSendAddress(this), 21, 5, this.authenticate(), false, 8);
            boolean bl = false;
            if ((byArray[0] >> 5 & 1) > 0) {
                bl = true;
            }
            boolean bl2 = bl;
            int n = Neuron.getBufferSize((byArray[3] & 0xF0) >> 4);
            int n2 = Neuron.getBufferSize(byArray[3] & 0xF);
            int n3 = Neuron.getBufferSize((byArray[4] & 0xF0) >> 4);
            int n4 = Neuron.getBufferSize(byArray[4] & 0xF);
            int n5 = bl2 ? 16 : 5;
            this.maxInMessageSize = Math.min(n2 - n5, n4 - 26);
            this.maxOutMessageSize = Math.min(n - n5, n3 - 26);
            if (!this.isLocal()) {
                BLocalLonDevice bLocalLonDevice = this.lonNetwork().getLocalLonDevice();
                this.maxInMessageSize = Math.min(this.maxInMessageSize, bLocalLonDevice.getMaxMessageLengthOut());
                this.maxOutMessageSize = Math.min(this.maxOutMessageSize, bLocalLonDevice.getMaxMessageLengthIn());
            }
            if (this.maxInMessageSize < 0) {
                this.maxInMessageSize = 8;
            }
            if (this.maxOutMessageSize < 0) {
                this.maxOutMessageSize = 8;
            }
        }
        catch (Exception exception) {
            this.maxInMessageSize = 8;
            this.maxOutMessageSize = 8;
            this.log().error("error reading buffer size ", (Throwable)exception);
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.trTitle((Object)"LonDevice", 1);
        spyWriter.startProps("Files");
        spyWriter.prop((Object)"Has node object", this.getDeviceData().getHasNodeObject());
        switch (this.fileState) {
            case 0: {
                spyWriter.prop((Object)"File state", (Object)"FILE_STATE_INIT    ");
                break;
            }
            case 1: {
                spyWriter.prop((Object)"File state", (Object)"FILE_STATE_NO_FILES");
                break;
            }
            case 2: {
                spyWriter.prop((Object)"File state", (Object)"FILE_STATE_DOWNLOAD");
                break;
            }
            case 3: {
                spyWriter.prop((Object)"File state", (Object)"FILE_STATE_UPLOAD  ");
                break;
            }
            case 4: {
                spyWriter.prop((Object)"File state", (Object)"FILE_STATE_IDLE    ");
                break;
            }
            default: {
                spyWriter.prop((Object)"File state", (Object)"unknown");
            }
        }
        boolean bl = false;
        if (this.readWritefile != null) {
            bl = true;
        }
        spyWriter.prop((Object)"Has readWrite file", bl);
        boolean bl2 = false;
        if (this.readOnlyfile != null) {
            bl2 = true;
        }
        spyWriter.prop((Object)"Has readOnly file", bl2);
        spyWriter.prop((Object)"maxMessageSizeIn", this.getMaxMessageLengthIn());
        spyWriter.prop((Object)"maxMessageSizeOut", this.getMaxMessageLengthOut());
        spyWriter.prop((Object)"dataPntMismatchCount", this.dataPntMismatchCount);
        spyWriter.prop((Object)"downloading", this.downloading);
        spyWriter.prop((Object)"uploading", this.uploading);
        spyWriter.endProps();
        DeviceFacets.spy(this, spyWriter);
    }

    public final LonComm lonComm() {
        return this.lonNetwork().lonComm();
    }

    public Log log() {
        if (this.log == null) {
            this.log = this.lonNetwork().log();
        }
        return this.log;
    }

    public final BLonNetwork lonNetwork() {
        if (this.net == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null && !(bComplex instanceof BLonNetwork)) {
                bComplex = bComplex.getParent();
            }
            if (bComplex != null) {
                this.net = (BLonNetwork)bComplex;
            }
        }
        return this.net;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.snv = null;
        this.toLnks = null;
        this.nvSync = new Object();
        this.staleNvList = true;
        this.linkUpdateDone = false;
        this.fileState = 0;
        this.hasReadOnly = false;
        this.lonFile = null;
        this.readWritefile = null;
        this.readOnlyfile = null;
        this.maxInMessageSize = 0;
        this.maxOutMessageSize = 0;
        this.dataPntMismatchCount = 0;
        this.log = null;
        this.net = null;
        this.downloading = false;
        this.uploading = false;
    }

    public BLonDevice() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$lonworks$BLonDevice;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonDevice = BLonDevice.class("[Ljavax.baja.lonworks.BLonDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

