/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.Lon;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BLonComponent
extends BLonData {
    public static final Action forceRead = BLonComponent.newAction((int)16, null);
    public static final Action forceWrite = BLonComponent.newAction((int)16, null);
    public static final Action update = BLonComponent.newAction((int)4, (BValue)new BLonData(), null);
    public static final Type TYPE;
    private BLonDevice dev;
    private BLonNetwork network;
    protected int subscribeCount;
    public boolean illegalLength;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonComponent;

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    public void update(BLonData bLonData) {
        this.invoke(update, (BValue)bLonData, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BLonDevice || bComponent instanceof BLonObject) {
            bl = true;
        }
        return bl;
    }

    public BLonDevice getDevice() {
        if (this.dev == null) {
            BLonComponent bLonComponent = this;
            while (this.dev == null && bLonComponent != null) {
                if (bLonComponent.getType().is(BLonDevice.TYPE)) {
                    this.dev = (BLonDevice)((Object)bLonComponent);
                }
                bLonComponent = bLonComponent.getParent();
            }
        }
        return this.dev;
    }

    private final BLonNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        BComplex bComplex = this.getParent();
        while (!(bComplex instanceof BLonNetwork)) {
            bComplex = bComplex.getParent();
        }
        this.network = (BLonNetwork)bComplex;
        return this.network;
    }

    public final void started() throws Exception {
        super.started();
        this.dev = null;
        this.network = null;
        if (!this.isWriteable()) {
            this.setFlags((Slot)forceWrite, this.getFlags((Slot)forceWrite) | 4);
        }
        if (this.isForeignPersistent()) {
            this.readOk();
        }
        if ((this.isNetworkVariable() || this.isNetworkConfig()) && this.getByteLength() > Lon.maxNvLength()) {
            this.getDevice().log().error(this.getDisplayName(null) + " disabled because length " + this.getByteLength() + " > " + Lon.maxNvLength() + " bytes");
            this.illegalLength = true;
        }
        this.lonComponentStarted();
    }

    public final void stopped() throws Exception {
        super.stopped();
        this.lonComponentStopped();
        this.dev = null;
        this.network = null;
    }

    public void lonComponentStarted() {
    }

    public void lonComponentStopped() {
    }

    public boolean isNavChild() {
        return Lon.lcInNavTree();
    }

    public BLonData getData() {
        BValue bValue = this.get("data");
        if (bValue != null && bValue instanceof BLonData) {
            return (BLonData)bValue;
        }
        return this;
    }

    public void setData(BLonData bLonData) {
        String string = bLonData.getType().getTypeName();
        if (!string.equals(BLonData.TYPE.getTypeName())) {
            if (this.get("data") != null) {
                this.set("data", (BValue)bLonData);
            } else {
                this.add("data", (BValue)bLonData);
            }
            return;
        }
        Property[] propertyArray = this.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            if (BLonComponent.isDataProp(propertyArray[n])) {
                this.remove(propertyArray[n]);
            }
            ++n;
        }
        propertyArray = bLonData.getPropertiesArray();
        n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (BLonComponent.isDataProp(property)) {
                this.add(property.getName(), bLonData.get(property), bLonData.getFlags((Slot)property), property.getFacets(), null);
            }
            ++n;
        }
    }

    public final BLonData copyData() {
        return (BLonData)this.getData().newCopy(true);
    }

    public final void updateData(BLonData bLonData, boolean bl) {
        if (this.isRunning()) {
            this.doUpdate(bLonData);
            if (bl) {
                this.doForceWrite();
            }
        } else {
            this.update(bLonData);
            if (bl) {
                this.forceWrite();
            }
        }
    }

    public final void doUpdate(BLonData bLonData) {
        BLonData bLonData2 = (BLonData)this.get("data");
        if (bLonData2 == null) {
            bLonData2 = this;
        }
        this.copyData(bLonData, bLonData2);
        this.dataChanged(BLonNetwork.lonNoWrite);
    }

    private final void copyData(BLonData bLonData, BLonData bLonData2) {
        Property[] propertyArray;
        Property[] propertyArray2 = bLonData.getPropertiesArray();
        if (propertyArray2.length != (propertyArray = bLonData2.getPropertiesArray()).length) {
            throw new BajaRuntimeException("Unmatched Type in doUpdate " + this.getDisplayName(null));
        }
        int n = 0;
        while (n < propertyArray2.length) {
            if (propertyArray2[n].getType() != propertyArray[n].getType()) {
                throw new BajaRuntimeException("Unmatched Type in doUpdate " + this.getDisplayName(null));
            }
            if (propertyArray2[n].getType().is(BLonPrimitive.TYPE)) {
                bLonData2.set(propertyArray[n], bLonData.get(propertyArray2[n]), BLonNetwork.lonNoPropagateNoWrite);
            } else if (propertyArray2[n].getType().is(BLonData.TYPE)) {
                this.copyData((BLonData)bLonData.get(propertyArray2[n]), (BLonData)bLonData2.get(propertyArray[n]));
            }
            ++n;
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)forceRead)) {
            return this.postForceRead(context);
        }
        if (action.equals((Object)forceWrite)) {
            return this.postForceWrite(context);
        }
        return super.post(action, bValue, context);
    }

    protected IFuture postForceRead(Context context) {
        return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, forceRead, null, context));
    }

    protected IFuture postForceWrite(Context context) {
        if (!this.isWriteable()) {
            throw new LocalizableRuntimeException("lonworks", "lonComponent.notWritable");
        }
        return this.getNetwork().postWrite((Runnable)new Invocation((BComponent)this, forceWrite, null, context));
    }

    public abstract void doForceWrite();

    public abstract void doForceRead();

    public boolean isForeignPersistent() {
        return false;
    }

    public boolean isWriteable() {
        return true;
    }

    public BLonDevice lonDevice() {
        return this.getDevice();
    }

    public BLonNetwork lonNetwork() {
        return this.getNetwork();
    }

    public boolean isNetworkVariable() {
        return false;
    }

    public boolean isNetworkConfig() {
        return false;
    }

    public boolean isConfigParameter() {
        return false;
    }

    public boolean isLocalNv() {
        return false;
    }

    public boolean isLocalNci() {
        return false;
    }

    public void subscribed() {
        this.readSubscribed();
    }

    public void unsubscribed() {
        this.readUnsubscribed();
    }

    public void readSubscribed() {
        ++this.subscribeCount;
        if (this.subscribeCount == 1) {
            this.lonComponentSubscribed();
        }
    }

    public String debugName() {
        return this.getParent().getDisplayName(null) + ':' + this.getDisplayName(null) + ' ';
    }

    public void readUnsubscribed() {
        --this.subscribeCount;
        if (this.subscribeCount == 0) {
            this.lonComponentUnsubscribed();
        }
    }

    protected void lonComponentSubscribed() {
    }

    protected void lonComponentUnsubscribed() {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dev = null;
        this.network = null;
        this.subscribeCount = 0;
        this.illegalLength = false;
    }

    public BLonComponent() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$lonworks$BLonComponent;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonComponent = BLonComponent.class("[Ljavax.baja.lonworks.BLonComponent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

