/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.local.BLocalNci;
import com.tridium.lonworks.local.BLocalNv;
import com.tridium.lonworks.local.LocalDev;
import com.tridium.lonworks.local.SnvtInfo;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.netmessages.QueryDomainResponse;
import com.tridium.lonworks.netmessages.UnprocessedNV;
import com.tridium.lonworks.netmessages.WriteMemRequest;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.xif.LocalToXif;
import javax.baja.agent.AgentList;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAuthenticationKey;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BExtDeviceData;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.BLocalExtractXifParameter;
import javax.baja.lonworks.datatypes.BLocalImportXmlParameter;
import javax.baja.lonworks.datatypes.BNcProps;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLocalLonDevice
extends BLonDevice {
    public static final Property externalConfig = BLocalLonDevice.newProperty((int)0, (boolean)false, null);
    public static final Property selfDoc = BLocalLonDevice.newProperty((int)0, (String)"&3.0@0;Niagara Server Node", null);
    public static final Action servicePin = BLocalLonDevice.newAction((int)0, null);
    public static final Action importXml = BLocalLonDevice.newAction((int)4, (BValue)new BLocalImportXmlParameter(), null);
    public static final Action extractXif = BLocalLonDevice.newAction((int)4, (BValue)new BLocalExtractXifParameter(), null);
    public static final Topic wink = BLocalLonDevice.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static BFacets noChange;
    public static final Context noInfoChange;
    private SnvtInfo snvtInfo;
    private Object syncSnvtInfo;
    static /* synthetic */ Class class$javax$baja$lonworks$BLocalLonDevice;

    public boolean getExternalConfig() {
        return this.getBoolean(externalConfig);
    }

    public void setExternalConfig(boolean bl) {
        this.setBoolean(externalConfig, bl, null);
    }

    public String getSelfDoc() {
        return this.getString(selfDoc);
    }

    public void setSelfDoc(String string) {
        this.setString(selfDoc, string, null);
    }

    public void servicePin() {
        this.invoke(servicePin, null, null);
    }

    public void importXml(BLocalImportXmlParameter bLocalImportXmlParameter) {
        this.invoke(importXml, (BValue)bLocalImportXmlParameter, null);
    }

    public BString extractXif(BLocalExtractXifParameter bLocalExtractXifParameter) {
        return (BString)this.invoke(extractXif, (BValue)bLocalExtractXifParameter, null);
    }

    public void fireWink(BValue bValue) {
        this.fire(wink, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean receiveNvUpdate(int n, UnprocessedNV unprocessedNV) {
        BINetworkVariable[] bINetworkVariableArray = this.getNetworkVariables();
        int n2 = 0;
        while (n2 < bINetworkVariableArray.length) {
            BINetworkVariable bINetworkVariable = bINetworkVariableArray[n2];
            if (bINetworkVariable != null && bINetworkVariable.getNvConfigData().getSelector() == n) {
                if (unprocessedNV.getDirection().equals((Object)BLonNvDirection.output)) {
                    if (bINetworkVariable.getNvConfigData().isOutput()) {
                        this.sendNvPollResponse(unprocessedNV, bINetworkVariable);
                    }
                } else if (bINetworkVariable.getNvConfigData().isInput()) {
                    bINetworkVariable.receiveUpdate(unprocessedNV.getData());
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private final void sendNvPollResponse(UnprocessedNV unprocessedNV, BINetworkVariable bINetworkVariable) {
        try {
            BNvConfigData bNvConfigData = bINetworkVariable.getNvConfigData();
            UnprocessedNV unprocessedNV2 = new UnprocessedNV(bNvConfigData.getDirection(), bNvConfigData.getSelector(), bINetworkVariable.getData().toNetBytes());
            this.lonComm().sendResponse(unprocessedNV, unprocessedNV2);
        }
        catch (LonException lonException) {
            this.lonNetwork().log().error("Unable to create or send nvPoll response.", (Throwable)((Object)lonException));
        }
    }

    public final boolean programIdChanges() {
        return true;
    }

    public final boolean isLocal() {
        return true;
    }

    public void doPing() {
        if (!(this.isRunning() && this.getEnabled() && this.lonNetwork().isServiceRunning())) {
            return;
        }
        if (this.getExternalConfig()) {
            try {
                BDeviceData bDeviceData = this.getDeviceData();
                bDeviceData.set(BDeviceData.nodeState, (BValue)NmUtil.getDeviceState(this), AddressManager.noDeviceChange);
                int n = 0;
                while (n < bDeviceData.getAddressCount()) {
                    bDeviceData.setAddressEntry(n, NmUtil.getBAddressTableEntry(this, n), AddressManager.noDeviceChange);
                    NmUtil.wait(600);
                    ++n;
                }
                QueryDomainResponse queryDomainResponse = NmUtil.queryDomain(this, 0);
                NmUtil.wait(600);
                QueryDomainResponse queryDomainResponse2 = NmUtil.queryDomain(this, 1);
                QueryDomainResponse queryDomainResponse3 = queryDomainResponse;
                int n2 = 0;
                if (queryDomainResponse2.inUse() && (!queryDomainResponse.inUse() || queryDomainResponse.getLen() == 0 && queryDomainResponse2.getLen() >= 1)) {
                    n2 = 1;
                    queryDomainResponse3 = queryDomainResponse2;
                }
                bDeviceData.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(queryDomainResponse3.getSubnet(), queryDomainResponse3.getNodeId()), AddressManager.noDeviceChange);
                bDeviceData.setInt(BDeviceData.workingDomain, n2, AddressManager.noDeviceChange);
                BLonNetmgmt bLonNetmgmt = this.lonNetwork().netmgmt();
                bLonNetmgmt.set(BLonNetmgmt.domainId, (BValue)BDomainId.make(queryDomainResponse3.getLen(), queryDomainResponse3.getDomainId()), BLonNetwork.lonNoWrite);
                bLonNetmgmt.set(BLonNetmgmt.authenticationKey, (BValue)BAuthenticationKey.make(queryDomainResponse3.getKey()), BLonNetwork.lonNoWrite);
            }
            catch (LonException lonException) {
                this.lonNetwork().log().error("Unable to initialize local lon interface.", (Throwable)((Object)lonException));
            }
        }
        this.pingOk();
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.remove("lonworks:NcManager");
        agentList.remove("lonworks:NvManager");
        return agentList;
    }

    public void started() throws Exception {
        super.started();
        this.verifyNvIndices();
        this.verifyLonMark();
        this.verifyNetmgmtEnable();
    }

    public void forceStart() {
        this.lonDeviceInit();
    }

    protected void lonDeviceInit() {
        if (this.getSubnetNodeAddress().equals(BSubnetNode.DEFAULT)) {
            this.getDeviceData().setSubnetNodeId(BSubnetNode.make(1, 127));
        }
        this.runAsyncUpdate();
    }

    private final void runAsyncUpdate() {
        Runnable runnable = new Runnable(){

            public final void run() {
                BLocalLonDevice.this.asyncUpdate();
            }
        };
        this.lonNetwork().postAsync(runnable);
    }

    private final void asyncUpdate() {
        try {
            BComponent bComponent;
            try {
                NmUtil.queryStatus(this, 0);
            }
            catch (LonException lonException) {
                try {
                    NmUtil.queryStatus(this, 0);
                }
                catch (LonException lonException2) {}
            }
            BDeviceData bDeviceData = this.getDeviceData();
            BNeuronId bNeuronId = Neuron.getNeuronId(this);
            if (!bDeviceData.getNeuronId().equals(bNeuronId)) {
                bDeviceData.set(BDeviceData.neuronId, (BValue)bNeuronId, AddressManager.noDeviceChange);
                bDeviceData.setBoolean(BDeviceData.twoDomains, Neuron.isTwoDomains(this.lonComm(), BLocal.local, false, false), AddressManager.noDeviceChange);
                bDeviceData.setInt(BDeviceData.channelId, 1, AddressManager.noDeviceChange);
                bDeviceData.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(1, 127), AddressManager.noDeviceChange);
                bDeviceData.setBoolean(BDeviceData.hosted, true, AddressManager.noDeviceChange);
                bDeviceData.set(BDeviceData.programId, (BValue)BProgramId.TRIDIUM_PID, AddressManager.noDeviceChange);
                bDeviceData.set(BDeviceData.nodeState, (BValue)BLonNodeState.configOnline, AddressManager.noDeviceChange);
            }
            bDeviceData.setInt(BDeviceData.addressCount, Neuron.getAddressCount(this.lonComm(), BLocal.local, false, false), AddressManager.noDeviceChange);
            if (bDeviceData.getAddressCount() > 15 && !(bDeviceData instanceof BExtDeviceData)) {
                bComponent = BExtDeviceData.make(bDeviceData);
                bComponent.setExtended(false);
                this.setDeviceData((BDeviceData)bComponent);
            }
            bComponent = this.lonNetwork().netmgmt();
            NmUtil.updateDomainTable(this, bComponent.getDomainId(), bComponent.getAuthenticationKey(), false);
            NmUtil.updateAddressTable(this);
            NmUtil.setDeviceState(this, this.getDeviceData().getNodeState());
            this.writeProgramId(this.getDeviceData().getProgramId());
            this.ping();
        }
        catch (LonException lonException) {
            this.lonNetwork().log().error("Error initializing local lon interface.", (Throwable)((Object)lonException));
            lonException.printStackTrace();
        }
        this.lonNetwork().netMessageReceiver().okToReceive();
        this.doReset();
    }

    public void deviceDataChanged(Property property, Context context) {
        if (property == BDeviceData.workingDomain) {
            ((NLonComm)this.getLonNetwork().lonComm()).updateWorkingDomain();
        }
        if (context == AddressManager.noDeviceChange) {
            return;
        }
        if (property == BDeviceData.authenticate || property == BDeviceData.addressTable || property == BDeviceData.subnetNodeId || property == BDeviceData.programId || property == BDeviceData.workingDomain) {
            this.runAsyncUpdate();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == externalConfig) {
            this.verifyNetmgmtEnable();
        }
    }

    private final void verifyNetmgmtEnable() {
        this.lonNetwork().netmgmt().setEnabled(this.getExternalConfig() ^ true);
    }

    public final void doServicePin() {
        try {
            NmUtil.sendServicePin(this);
        }
        catch (LonException lonException) {
            throw new BajaRuntimeException("Unable to do servicePin." + (Object)((Object)lonException));
        }
    }

    private final void writeProgramId(BProgramId bProgramId) throws LonException {
        byte[] byArray = bProgramId.getByteArray();
        WriteMemRequest writeMemRequest = new WriteMemRequest(1, 13, byArray.length, 3, byArray);
        this.lonComm().sendUnacknowledged(BLocal.local, writeMemRequest);
    }

    public final BIcon getIcon() {
        return icon;
    }

    public boolean isChildLegal(BComponent bComponent) {
        if (bComponent.getType().is(BINetworkVariable.TYPE) && !((BINetworkVariable)bComponent).isLocalNv() && !((BINetworkVariable)bComponent).isLocalNci()) {
            return false;
        }
        return super.isChildLegal(bComponent);
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (this.isRunning() && !noInfoChange.equals(context)) {
            if (property.getType().is(BINetworkVariable.TYPE)) {
                this.verifyNvIndices();
            }
            this.updateSnvtInfo();
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (this.isRunning() && !noInfoChange.equals(context)) {
            if (property.getType().is(BINetworkVariable.TYPE)) {
                this.verifyNvIndices();
            }
            this.updateSnvtInfo();
        }
    }

    private final void verifyLonMark() {
        BINetworkVariable[] bINetworkVariableArray = this.getNetworkVariables();
        if (bINetworkVariableArray.length > 0) {
            return;
        }
        BLocalNv bLocalNv = new BLocalNv(0, 92, 0, 1, 0, BLonNvDirection.input, "@0|1");
        this.add("nviRequest", (BValue)bLocalNv, 1024);
        bLocalNv = new BLocalNv(1, 93, 0, 2, 0, BLonNvDirection.output, "@0|1");
        this.add("nvoStatus", (BValue)bLocalNv, 0);
    }

    private final void verifyNvIndices() {
        BINetworkVariable[] bINetworkVariableArray = this.getNetworkVariables();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n < bINetworkVariableArray.length) {
            if (bINetworkVariableArray[n] == null) {
                bl = true;
            } else {
                if (bINetworkVariableArray[n].getNvIndex() != n2) {
                    if (bINetworkVariableArray[n].isLocalNv()) {
                        ((BLocalNv)bINetworkVariableArray[n]).getNvProps().setInt(BNvProps.nvIndex, n2, noInfoChange);
                    } else if (bINetworkVariableArray[n].isLocalNci()) {
                        ((BLocalNci)bINetworkVariableArray[n]).getNcProps().setInt(BNcProps.nvIndex, n2, noInfoChange);
                    }
                    bl = true;
                    BNvConfigData bNvConfigData = bINetworkVariableArray[n].getNvConfigData();
                    if (!bNvConfigData.isBoundNv()) {
                        bNvConfigData.setInt(BNvConfigData.selector, 16383 - n2, noInfoChange);
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            this.refreshNvList();
        }
    }

    public void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        super.checkAdd(string, bValue, n, bFacets, context);
        if (!this.isRunning()) {
            return;
        }
        if (!bValue.getType().is(BINetworkVariable.TYPE)) {
            return;
        }
        BINetworkVariable bINetworkVariable = (BINetworkVariable)bValue;
        if (bINetworkVariable.getNvConfigData().getSelector() >= 0) {
            return;
        }
        BINetworkVariable[] bINetworkVariableArray = this.getNetworkVariables();
        int n2 = 0;
        while (n2 < bINetworkVariableArray.length) {
            if (bINetworkVariableArray[n2] == null) break;
            ++n2;
        }
        if (n2 >= bINetworkVariableArray.length) {
            BINetworkVariable[] bINetworkVariableArray2 = new BINetworkVariable[n2 + 1];
            System.arraycopy(bINetworkVariableArray, 0, bINetworkVariableArray2, 0, bINetworkVariableArray.length);
            this.nvList = bINetworkVariableArray2;
            bINetworkVariableArray = bINetworkVariableArray2;
        }
        bINetworkVariableArray[n2] = bINetworkVariable;
        bINetworkVariable.setNvIndex(n2);
        bINetworkVariable.getNvConfigData().setUnbound(n2);
    }

    protected void lonDeviceAtSteadyState() {
        this.updateSnvtInfo();
    }

    public void renamed(Property property, String string, Context context) {
        super.renamed(property, string, context);
        if (!this.isRunning() || context == noInfoChange) {
            return;
        }
        if (property.getType().is(BINetworkVariable.TYPE)) {
            this.updateSnvtInfo();
        }
    }

    public void nvChanged(BINetworkVariable bINetworkVariable) {
        this.updateSnvtInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void updateSnvtInfo() {
        Object object = this.syncSnvtInfo;
        synchronized (object) {
            this.snvtInfo = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SnvtInfo getSnvtInfo() {
        Object object = this.syncSnvtInfo;
        synchronized (object) {
            if (this.snvtInfo == null) {
                this.snvtInfo = new SnvtInfo(this);
            }
            return this.snvtInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doImportXml(BLocalImportXmlParameter bLocalImportXmlParameter) {
        Object object = this.syncSnvtInfo;
        synchronized (object) {
            LocalDev.importXLon(this, bLocalImportXmlParameter);
            this.snvtInfo = null;
            this.verifyNvIndices();
            this.refreshNvList();
            return;
        }
    }

    public BString doExtractXif(BLocalExtractXifParameter bLocalExtractXifParameter) {
        String string = "error";
        try {
            string = LocalToXif.extractXif(this, bLocalExtractXifParameter);
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return BString.make((String)string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.snvtInfo = null;
        this.syncSnvtInfo = new Object();
    }

    public BLocalLonDevice() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$lonworks$BLocalLonDevice;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLocalLonDevice = BLocalLonDevice.class("[Ljavax.baja.lonworks.BLocalLonDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"deviceLocal.png");
        noChange = BFacets.make((String)"noChange", (boolean)true);
        noInfoChange = new BasicContext((Context)noChange){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (object != null && object instanceof Context && ((Context)object).getFacets().getb("noChange", false)) {
                    bl = true;
                }
                return bl;
            }

            public final int hashCode() {
                return super.hashCode();
            }
        };
    }
}

