/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BConfigProps;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.util.LonFile;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BConfigParameter
extends BLonComponent {
    public static final Property configProps = BConfigParameter.newProperty((int)0, (BValue)new BConfigProps(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$lonworks$BConfigParameter;

    public BConfigProps getConfigProps() {
        return (BConfigProps)this.get(configProps);
    }

    public void setConfigProps(BConfigProps bConfigProps) {
        this.set(configProps, (BValue)bConfigProps, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isConfigParameter() {
        return true;
    }

    public boolean isForeignPersistent() {
        return true;
    }

    public boolean isWriteable() {
        BModifyFlags bModifyFlags = this.getConfigProps().getModifyFlag();
        boolean bl = false;
        if (!bModifyFlags.isMfgOnly() && !bModifyFlags.isConst()) {
            bl = true;
        }
        return bl;
    }

    protected void dataChanged(Context context) {
        if (BLonNetwork.lonNoWrite.equals(context)) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        this.doForceWrite();
    }

    public void doForceWrite() {
        BConfigProps bConfigProps = this.getConfigProps();
        if (bConfigProps.getModifyFlag().isMfgOnly()) {
            throw new BajaRuntimeException("Can not write mfgOnly cp " + this.getDisplayName(null));
        }
        if (bConfigProps.getModifyFlag().isConst()) {
            throw new BajaRuntimeException("Can not write constant cp " + this.getDisplayName(null));
        }
        BLonDevice bLonDevice = this.lonDevice();
        bLonDevice.checkState();
        boolean bl = bLonDevice.isDownLoadInProgress();
        try {
            LonFile lonFile = bLonDevice.getReadWriteFile();
            if (lonFile == null) {
                throw new LonException("Error writing " + this.getDisplayName(null) + ": could not access file");
            }
            int[] nArray = null;
            boolean[] blArray = null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                bLonDevice.beginConfigWrite();
                if (bConfigProps.getModifyFlag().isDisabled() && bConfigProps.getScope() == BLonConfigScope.object) {
                    nArray = SelfDocUtil.selectToIntArray(bConfigProps.getSelect());
                    blArray = new boolean[nArray.length];
                    try {
                        bLonDevice.disableObjectsForWrite(nArray, blArray);
                    }
                    catch (Throwable throwable) {
                        this.lonNetwork().log().warning("Unable to disable object " + bConfigProps.getSelect(), throwable);
                        bl3 = true;
                    }
                }
                if (bConfigProps.getModifyFlag().isOffline() || bl3) {
                    try {
                        NmUtil.setDeviceState(bLonDevice, BLonNodeState.configOffline);
                    }
                    catch (LonException lonException) {
                        System.out.println((Object)lonException);
                    }
                    bl2 = true;
                }
            }
            lonFile.write(this.getData().toNetBytes(), bConfigProps.getOffset());
            if (!bl) {
                lonFile.flush();
                if (bl2) {
                    try {
                        NmUtil.setDeviceState(bLonDevice, BLonNodeState.configOnline);
                    }
                    catch (LonException lonException) {
                        System.out.println((Object)lonException);
                    }
                }
                if (nArray != null) {
                    bLonDevice.enableObjectsAfterWrite(nArray, blArray);
                }
                if (bConfigProps.getModifyFlag().isReset()) {
                    bLonDevice.doReset();
                }
                bLonDevice.endConfigWrite();
            }
            this.getData().writeOk();
        }
        catch (Throwable throwable) {
            this.getData().writeFail(throwable.toString());
            String string = "Unable to write " + this.debugName();
            this.lonNetwork().log().error(string, throwable);
            throw new BajaRuntimeException(string + ' ' + throwable.getMessage(), throwable);
        }
    }

    public void doForceRead() {
        LonFile lonFile;
        BLonDevice bLonDevice = this.lonDevice();
        bLonDevice.checkState();
        BConfigProps bConfigProps = this.getConfigProps();
        LonFile lonFile2 = lonFile = bConfigProps.getModifyFlag().isConst() ? bLonDevice.getReadOnlyFile() : bLonDevice.getReadWriteFile();
        if (lonFile == null) {
            throw new RuntimeException("Error reading " + this.getDisplayName(null) + ": could not access file");
        }
        try {
            this.getData().fromNetBytes(lonFile.read(bConfigProps.getOffset(), bConfigProps.getLength()));
            this.getData().readOk();
        }
        catch (Throwable throwable) {
            this.getData().readFail(throwable.toString());
            String string = "Unable to read " + this.debugName();
            this.lonNetwork().log().error(string, throwable);
            throw new BajaRuntimeException(string + ' ' + throwable.getMessage(), throwable);
        }
    }

    protected void lonComponentSubscribed() {
        BBoolean bBoolean = (BBoolean)this.getPropertyInParent().getFacets().get("deviceSpecific");
        if (bBoolean != null && bBoolean.getBoolean()) {
            this.forceRead();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BConfigParameter() {
    }

    public BConfigParameter(BLonData bLonData, int n, int n2, BModifyFlags bModifyFlags, BLonConfigScope bLonConfigScope, String string) {
        BConfigProps bConfigProps = this.getConfigProps();
        bConfigProps.setOffset(n);
        bConfigProps.setLength(n2);
        bConfigProps.setModifyFlag(bModifyFlags);
        bConfigProps.setScope(bLonConfigScope);
        bConfigProps.setSelect(string);
        this.setData(bLonData);
    }

    static {
        Class clazz = class$javax$baja$lonworks$BConfigParameter;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BConfigParameter = BConfigParameter.class("[Ljavax.baja.lonworks.BConfigParameter;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/cp.png");
    }
}

