/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUtil;
import java.util.Vector;

public class XLonDataUtil {
    private static String[] SnvtTypeNames = null;
    private static String[] ScptTypeNames = null;
    private static final String[] ApplicationTypes = new String[]{"unknown", "mip", "neuron", "hostSelect", "hostNISelect"};
    private static final String[] ServiceTypes = new String[]{"acked", "unackedRpt", "unacked", "request"};
    private static final String[] Scope = new String[]{"node", "object", "nv"};

    public static String snvtTypeToString(int n) {
        return XLonDataUtil.getString(XLonDataUtil.getSnvtTypeNames(), n, SnvtTypeNames[0]);
    }

    public static int snvtTypeFromString(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = string.indexOf(43);
        String string2 = n > 0 ? string.substring(0, n) : string;
        return XLonDataUtil.fromString(XLonDataUtil.getSnvtTypeNames(), string2, 0);
    }

    public static boolean isDiffQualifier(String string) {
        int n = string.indexOf(43);
        if (n < 0) {
            return false;
        }
        return string.substring(n + 1).equals("diff");
    }

    public static String getSnvtTypeName(int n, String string) {
        String[] stringArray = XLonDataUtil.getSnvtTypeNames();
        if (n < 1 || n >= stringArray.length) {
            return string;
        }
        return stringArray[n];
    }

    private static final String[] getSnvtTypeNames() {
        if (SnvtTypeNames == null) {
            int n;
            XTypeDef xTypeDef;
            Vector vector = XUtil.getStandard().types;
            int n2 = 0;
            int n3 = 0;
            while (n3 < vector.size()) {
                xTypeDef = (XTypeDef)vector.elementAt(n3);
                if (!xTypeDef.isCpType() && (n = xTypeDef.getTypeIndex()) > n2) {
                    n2 = n;
                }
                ++n3;
            }
            SnvtTypeNames = new String[n2 + 1];
            n3 = 0;
            while (n3 < vector.size()) {
                xTypeDef = (XTypeDef)vector.elementAt(n3);
                if (!xTypeDef.isCpType() && (n = xTypeDef.getTypeIndex()) >= 0) {
                    XLonDataUtil.SnvtTypeNames[n] = NameUtil.toJavaName(xTypeDef.getName(), false);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 <= n2) {
                if (SnvtTypeNames[n3] == null) {
                    XLonDataUtil.SnvtTypeNames[n3] = "xxx";
                }
                ++n3;
            }
        }
        return SnvtTypeNames;
    }

    public static String scptTypeToString(int n) {
        return XLonDataUtil.getString(XLonDataUtil.getScptTypeNames(), n, ScptTypeNames[0]);
    }

    public static int scptTypeFromString(String string) {
        return XLonDataUtil.fromString(XLonDataUtil.getScptTypeNames(), string, 0);
    }

    public static String getScptTypeName(int n, String string) {
        String[] stringArray = XLonDataUtil.getScptTypeNames();
        if (n < 1 || n >= stringArray.length) {
            return string;
        }
        return stringArray[n];
    }

    private static final String[] getScptTypeNames() {
        if (ScptTypeNames == null) {
            int n;
            XTypeDef xTypeDef;
            Vector vector = XUtil.getStandard().types;
            int n2 = 0;
            int n3 = 0;
            while (n3 < vector.size()) {
                xTypeDef = (XTypeDef)vector.elementAt(n3);
                if (xTypeDef.isCpType() && (n = xTypeDef.getTypeIndex()) > n2) {
                    n2 = n;
                }
                ++n3;
            }
            ScptTypeNames = new String[n2 + 1];
            n3 = 0;
            while (n3 < vector.size()) {
                xTypeDef = (XTypeDef)vector.elementAt(n3);
                if (xTypeDef.isCpType() && (n = xTypeDef.getTypeIndex()) >= 0) {
                    XLonDataUtil.ScptTypeNames[n] = NameUtil.toJavaName(xTypeDef.getName(), false);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 <= n2) {
                if (ScptTypeNames[n3] == null) {
                    XLonDataUtil.ScptTypeNames[n3] = "xxx";
                }
                ++n3;
            }
        }
        return ScptTypeNames;
    }

    public static String applicationTypeToString(int n) {
        return XLonDataUtil.getString(ApplicationTypes, n, ApplicationTypes[0]);
    }

    public static int applicationTypeFromString(String string) {
        return XLonDataUtil.fromString(ApplicationTypes, string, 0);
    }

    public static boolean isHostedApplication(String string) {
        boolean bl = false;
        if (string.equals("mip") || string.equals("hostSelect") || string.equals("hostNISelect")) {
            bl = true;
        }
        return bl;
    }

    public static String serviceTypeToString(int n) {
        return XLonDataUtil.getString(ServiceTypes, n, ServiceTypes[0]);
    }

    public static int serviceTypeFromString(String string) {
        return XLonDataUtil.fromString(ServiceTypes, string, 0);
    }

    public static String scopeToString(int n) {
        return XLonDataUtil.getString(Scope, n, Scope[0]);
    }

    public static int scopeFromString(String string) {
        return XLonDataUtil.fromString(Scope, string, 0);
    }

    public static String flagToString(int n) {
        String string = "";
        if (((n &= 0xFF) & 0x7F) == 0) {
            return "anytime";
        }
        if ((n & 1) != 0) {
            string = string + " objDisable";
        }
        if ((n & 2) != 0) {
            string = string + " offline";
        }
        if ((n & 4) != 0) {
            string = (n & 0x20) != 0 ? string + " deviceSpecific" : string + " constant";
        }
        if ((n & 8) != 0) {
            string = string + " reset";
        }
        if ((n & 0x10) != 0) {
            string = string + " mfgOnly";
        }
        if (string.startsWith(" ")) {
            string = string.substring(1);
        }
        return string;
    }

    public static int flagFromString(String string) {
        int n = 128;
        if (string.indexOf("anytime") != -1) {
            return n;
        }
        if (string.indexOf("objDisable") != -1) {
            n |= 1;
        }
        if (string.indexOf("offline") != -1) {
            n |= 2;
        }
        if (string.indexOf("constant") != -1) {
            n |= 4;
        }
        if (string.indexOf("reset") != -1) {
            n |= 8;
        }
        if (string.indexOf("mfgOnly") != -1) {
            n |= 0x10;
        }
        if (string.indexOf("deviceSpecific") != -1) {
            n |= 0x24;
        }
        return n;
    }

    public static boolean isReadOnly(String string) {
        boolean bl = false;
        if (string.indexOf("constant") >= 0 || string.indexOf("deviceSpecific") >= 0) {
            bl = true;
        }
        return bl;
    }

    public static String getString(String[] stringArray, int n, String string) {
        if (n >= stringArray.length) {
            return string;
        }
        return stringArray[n];
    }

    public static int fromString(String[] stringArray, String string, int n) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals(string)) {
                return n2;
            }
            ++n2;
        }
        return n;
    }
}

