/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.xml.XLonDataUtil;
import java.util.StringTokenizer;
import javax.baja.lonworks.londata.BLonElementQualifiers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XElementQualifier
implements Cloneable {
    private static final float DEFAULT_RESOLUTION = 1.0f;
    private static final float DEFAULT_OFFSET = 0.0f;
    public static final int C8 = 0;
    public static final int S8 = 1;
    public static final int U8 = 2;
    public static final int S16 = 3;
    public static final int U16 = 4;
    public static final int S32 = 5;
    public static final int B8 = 6;
    public static final int E8 = 7;
    public static final int F32 = 8;
    public static final int EB = 9;
    public static final int BB = 10;
    public static final int UB = 11;
    public static final int SB = 12;
    public static final int ST = 13;
    public static final int NA = 14;
    public static final int REF = 15;
    public static final int F64 = 16;
    public static final int U32 = 17;
    public static final int S64 = 18;
    public static final int U64 = 19;
    private static final String[] QualTypes = new String[]{"c8", "s8", "u8", "s16", "u16", "s32", "b8", "e8", "f32", "eb", "bb", "ub", "sb", "st", "na", "ref", "f64", "u32", "s64", "u64"};
    String enumDef;
    String defaultValue;
    String engUnit;
    String tag0;
    String tag1;
    public String name;
    public String branch;
    private String elemtype;
    private float resolution;
    private float offset;
    private boolean hasMinimum;
    private Number minimum;
    private boolean hasMaximum;
    private Number maximum;
    private boolean hasOffset;
    private int byteOffset;
    private int bitOffset;
    private boolean hasInvalid;
    private Number invalidValue;
    private int length;
    private String snvtType;
    private String typeDef;

    public XElementQualifier copy() {
        try {
            return (XElementQualifier)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getElementType() {
        return this.elemtype;
    }

    public void setElementType(String string) {
        this.elemtype = string;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void setResolution(float f) {
        this.resolution = f;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public boolean hasByteOffset() {
        return this.hasOffset;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(int n) {
        this.byteOffset = n;
        this.hasOffset = true;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public void setBitOffset(int n) {
        this.bitOffset = n;
        this.hasOffset = true;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int getSize() {
        return this.length;
    }

    public void setSize(int n) {
        this.length = n;
    }

    public String getEnumDef() {
        return this.enumDef;
    }

    public void setEnumDef(String string) {
        this.enumDef = string;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String string) {
        this.defaultValue = string;
    }

    public String getEngUnit() {
        return this.engUnit;
    }

    public void setEngUnit(String string) {
        this.engUnit = string;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Number number) {
        this.minimum = number;
        this.hasMinimum = true;
    }

    public boolean hasMinimum() {
        return this.hasMinimum;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Number number) {
        this.maximum = number;
        this.hasMaximum = true;
    }

    public boolean hasMaximum() {
        return this.hasMaximum;
    }

    public Number getInvalid() {
        return this.invalidValue;
    }

    public void setInvalid(Number number) {
        this.invalidValue = number;
        this.hasInvalid = true;
    }

    public boolean hasInvalid() {
        return this.hasInvalid;
    }

    public String getTag0() {
        return this.tag0;
    }

    public void setTag0(String string) {
        this.tag0 = string;
    }

    public String getTag1() {
        return this.tag1;
    }

    public void setTag1(String string) {
        this.tag1 = string;
    }

    public String getSnvtType() {
        return this.snvtType;
    }

    public void setSnvtType(String string) {
        this.snvtType = string;
    }

    public boolean isRef() {
        return this.elemtype.equals(QualTypes[15]);
    }

    public String getTypeDef() {
        return this.typeDef;
    }

    public void setTypeDef(String string) {
        this.typeDef = string;
    }

    public String getUnionBranch() {
        return this.branch;
    }

    public void setUnionBranch(String string) {
        this.branch = string;
    }

    public int accumulateByteCount(int n) {
        int n2;
        switch (XElementQualifier.qualTypeFromString(this.getElementType())) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 1;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
            case 5: 
            case 8: 
            case 17: {
                n2 = 4;
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                n2 = 8;
                break;
            }
            case 13: 
            case 14: {
                n2 = this.getLength();
                break;
            }
            default: {
                throw new RuntimeException("Attempt to accumlate Element type " + this.getElementType());
            }
        }
        if (this.hasOffset) {
            int n3 = n2 + this.getByteOffset();
            if (n3 > n) {
                return n3;
            }
            return n;
        }
        return n + n2;
    }

    public boolean equals(XElementQualifier xElementQualifier) {
        boolean bl = false;
        if (!(!this.elemtype.equals(xElementQualifier.elemtype) || this.resolution != xElementQualifier.resolution || this.offset != xElementQualifier.offset || this.hasMinimum != xElementQualifier.hasMinimum || this.hasMinimum && this.minimum != xElementQualifier.minimum || this.hasMaximum != xElementQualifier.hasMaximum || this.hasMaximum && this.maximum != xElementQualifier.maximum || this.hasInvalid != xElementQualifier.hasInvalid || this.hasInvalid && this.invalidValue != xElementQualifier.invalidValue || this.length != xElementQualifier.length)) {
            bl = true;
        }
        return bl;
    }

    public String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.elemtype);
        switch (XElementQualifier.qualTypeFromString(this.elemtype)) {
            case 0: 
            case 7: {
                if (this.hasOffset) {
                    stringBuffer.append(" byt=").append(this.byteOffset);
                }
                this.addResOffset(stringBuffer);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 16: 
            case 17: {
                if (this.hasOffset) {
                    stringBuffer.append(" byt=").append(this.byteOffset);
                }
                this.addResOffset(stringBuffer);
                this.addMinMax(stringBuffer);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                stringBuffer.append(" byt=").append(this.byteOffset);
                stringBuffer.append(" bit=").append(this.bitOffset);
                stringBuffer.append(" len=").append(this.length);
                this.addResOffset(stringBuffer);
                this.addMinMax(stringBuffer);
                break;
            }
            case 13: 
            case 14: {
                stringBuffer.append(" len=").append(this.length);
                break;
            }
            case 15: {
                stringBuffer.append(" type=").append(this.typeDef);
                if (!this.hasOffset) break;
                stringBuffer.append(" byt=").append(this.byteOffset);
                break;
            }
        }
        return stringBuffer.toString();
    }

    private final void addMinMax(StringBuffer stringBuffer) {
        if (this.hasMinimum) {
            stringBuffer.append(" min=").append(this.minimum.doubleValue());
        }
        if (this.hasMaximum) {
            stringBuffer.append(" max=").append(this.maximum.doubleValue());
        }
        if (this.hasInvalid) {
            stringBuffer.append(" invld=").append(this.invalidValue.longValue());
        }
    }

    private final void addResOffset(StringBuffer stringBuffer) {
        if (this.resolution != 1.0f) {
            stringBuffer.append(" res=").append(this.resolution);
        }
        if (this.offset != 0.0f) {
            stringBuffer.append(" off=").append(this.offset);
        }
    }

    public void decodeFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        this.elemtype = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n < 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equals("res")) {
                this.resolution = Float.valueOf(string4).floatValue();
                continue;
            }
            if (string3.equals("off")) {
                this.offset = Float.valueOf(string4).floatValue();
                continue;
            }
            if (string3.equals("min")) {
                try {
                    this.minimum = this.readNumber(string4);
                    this.hasMinimum = true;
                }
                catch (Exception exception) {}
                continue;
            }
            if (string3.equals("max")) {
                try {
                    this.maximum = this.readNumber(string4);
                    this.hasMaximum = true;
                }
                catch (Exception exception) {}
                continue;
            }
            if (string3.equals("byt")) {
                this.byteOffset = Integer.parseInt(string4);
                this.hasOffset = true;
                continue;
            }
            if (string3.equals("bit")) {
                this.bitOffset = Integer.parseInt(string4);
                this.hasOffset = true;
                continue;
            }
            if (string3.equals("len")) {
                this.length = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("invld")) {
                this.invalidValue = this.readNumber(string4);
                this.hasInvalid = true;
                continue;
            }
            if (string3.equals("type")) {
                this.typeDef = string4;
                continue;
            }
            if (!string3.equals("typ")) continue;
            this.snvtType = string4;
        }
    }

    private final Number readNumber(String string) {
        if (string.indexOf(46) > 0) {
            return Double.valueOf(string);
        }
        return Long.valueOf(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append(" ");
        if (this.enumDef != null) {
            stringBuffer.append(" enumDef=").append(this.enumDef);
        }
        if (this.engUnit != null) {
            stringBuffer.append(" engUnit=").append(this.engUnit);
        }
        if (this.defaultValue != null) {
            stringBuffer.append(" defaultValue=").append(this.defaultValue);
        }
        if (this.tag0 != null) {
            stringBuffer.append(" tag0=").append(this.tag0);
        }
        if (this.tag1 != null) {
            stringBuffer.append(" tag1=").append(this.tag1);
        }
        if (this.branch != null) {
            stringBuffer.append(" branch=").append(this.branch);
        }
        return stringBuffer.toString();
    }

    public static String qualTypeToString(int n) {
        return XLonDataUtil.getString(QualTypes, n, QualTypes[14]);
    }

    public static int qualTypeFromString(String string) {
        return XLonDataUtil.fromString(QualTypes, string, 0);
    }

    private final /* synthetic */ void this() {
        this.enumDef = null;
        this.defaultValue = null;
        this.engUnit = null;
        this.tag0 = null;
        this.tag1 = null;
        this.branch = null;
        this.elemtype = "na";
        this.resolution = 1.0f;
        this.offset = 0.0f;
        this.hasMinimum = false;
        this.minimum = null;
        this.hasMaximum = false;
        this.maximum = null;
        this.hasOffset = false;
        this.byteOffset = -1;
        this.bitOffset = -1;
        this.hasInvalid = false;
        this.invalidValue = new Long(0L);
        this.length = 0;
        this.snvtType = "";
        this.typeDef = "";
    }

    public XElementQualifier() {
        this.this();
    }

    public XElementQualifier(String string, String string2) {
        this.this();
        this.name = string;
        this.decodeFromString(string2);
    }

    public XElementQualifier(String string, BLonElementQualifiers bLonElementQualifiers) {
        this.this();
        this.name = string;
        this.elemtype = bLonElementQualifiers.getElemtype().getTag();
        this.hasMinimum = bLonElementQualifiers.hasMinimum();
        this.minimum = bLonElementQualifiers.getMinimumN();
        this.hasMaximum = bLonElementQualifiers.hasMaximum();
        this.maximum = bLonElementQualifiers.getMaximumN();
        this.resolution = bLonElementQualifiers.getResolution();
        this.offset = bLonElementQualifiers.getOffset();
        this.hasOffset = bLonElementQualifiers.hasOffset();
        this.byteOffset = bLonElementQualifiers.getByteOffset();
        this.bitOffset = bLonElementQualifiers.getBitOffset();
        this.hasInvalid = bLonElementQualifiers.hasInvalidValue();
        this.invalidValue = bLonElementQualifiers.getInvalidValueN();
        this.length = bLonElementQualifiers.getLength();
    }
}

