/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XDeviceData;
import com.tridium.lonworks.xml.XElementQualifier;
import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XLonTyped;
import com.tridium.lonworks.xml.XMessageTag;
import com.tridium.lonworks.xml.XNetworkConfig;
import com.tridium.lonworks.xml.XNetworkVariable;
import java.util.Vector;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BMessageTag;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BConfigProps;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.datatypes.BNcProps;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class DevToXLon {
    public static XLonInterfaceFile devToXLon(BLonDevice bLonDevice) {
        XLonInterfaceFile xLonInterfaceFile = new XLonInterfaceFile();
        XLonDevice xLonDevice = new XLonDevice();
        xLonDevice.setName(bLonDevice.getName());
        SlotCursor slotCursor = bLonDevice.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            if (bObject.getType().is(BNetworkVariable.TYPE)) {
                xLonDevice.addAttribute(slotCursor.property().getName(), DevToXLon.getXNetworkVariable(xLonInterfaceFile, (BNetworkVariable)bObject));
                continue;
            }
            if (bObject.getType().is(BNetworkConfig.TYPE)) {
                xLonDevice.addAttribute(slotCursor.property().getName(), DevToXLon.getXNetworkConfig(xLonInterfaceFile, (BNetworkConfig)bObject));
                continue;
            }
            if (bObject.getType().is(BConfigParameter.TYPE)) {
                xLonDevice.addAttribute(slotCursor.property().getName(), DevToXLon.getXConfigProperty(xLonInterfaceFile, (BConfigParameter)bObject));
                continue;
            }
            if (!bObject.getType().is(BMessageTag.TYPE) || !((BMessageTag)bObject).isOutput()) continue;
            xLonDevice.addAttribute(slotCursor.property().getName(), DevToXLon.getXMessageTag((BMessageTag)bObject));
        }
        xLonDevice.deviceData = DevToXLon.getXDeviceData(bLonDevice);
        xLonInterfaceFile.addAttribute(bLonDevice.getName(), xLonDevice);
        return xLonInterfaceFile;
    }

    private static final XDeviceData getXDeviceData(BLonDevice bLonDevice) {
        XDeviceData xDeviceData = new XDeviceData();
        xDeviceData.setName("deviceData");
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        xDeviceData.programID = bDeviceData.getProgramId().getByteArray();
        xDeviceData.aliasCount = bDeviceData.getAliasTable().getAliasArray().length;
        xDeviceData.bindingII = bDeviceData.getBindingII();
        xDeviceData.applicationType = bDeviceData.getHosted() ? "hostSelect" : "unknown";
        xDeviceData.domains = bDeviceData.getTwoDomains() + 1;
        xDeviceData.addressTableEntries = bDeviceData.getAddressCount();
        xDeviceData.nodeSelfID = bDeviceData.getSelfDoc();
        xDeviceData.freezeChannelPriorities = bDeviceData.getFreezeChannelPriorities();
        return xDeviceData;
    }

    private static final XNetworkVariable getXNetworkVariable(XLonInterfaceFile xLonInterfaceFile, BNetworkVariable bNetworkVariable) {
        BNvProps bNvProps = bNetworkVariable.getNvProps();
        XNetworkVariable xNetworkVariable = new XNetworkVariable();
        xNetworkVariable.setName(bNetworkVariable.getName());
        int n = bNvProps.getSnvtType();
        xNetworkVariable.snvtType = XLonDataUtil.getSnvtTypeName(n, "");
        xNetworkVariable.index = bNvProps.getNvIndex();
        xNetworkVariable.objectIndex = DevToXLon.getObjectIndex(bNvProps.getObjectIndex());
        xNetworkVariable.memberIndex = bNvProps.getMemberIndex();
        xNetworkVariable.polled = bNvProps.getPolled();
        xNetworkVariable.authenticatedConfigurable = bNvProps.getAuthConf();
        xNetworkVariable.serviceTypeConfigurable = bNvProps.getServiceConf();
        xNetworkVariable.priorityConfigurable = bNvProps.getPriorityConf();
        xNetworkVariable.offline = bNvProps.getModifyOffline();
        xNetworkVariable.sync = bNvProps.getSync();
        xNetworkVariable.changeType = bNvProps.getChangeableType();
        BNvConfigData bNvConfigData = bNetworkVariable.getNvConfigData();
        xNetworkVariable.priority = bNvConfigData.getPriority();
        xNetworkVariable.direction = bNvConfigData.getDirection().getTag();
        xNetworkVariable.serviceType = bNvConfigData.getServiceType().getTag();
        xNetworkVariable.authenticated = bNvConfigData.getAuthenticated();
        if (n <= 0) {
            DevToXLon.addData(xLonInterfaceFile, xNetworkVariable, bNetworkVariable.getData());
        }
        return xNetworkVariable;
    }

    private static final String getObjectIndex(int n) {
        if (n >= 0) {
            return Integer.toString(n);
        }
        return "";
    }

    private static final XNetworkConfig getXNetworkConfig(XLonInterfaceFile xLonInterfaceFile, BNetworkConfig bNetworkConfig) {
        XNetworkConfig xNetworkConfig = new XNetworkConfig();
        xNetworkConfig.setName(bNetworkConfig.getName());
        BNcProps bNcProps = bNetworkConfig.getNcProps();
        xNetworkConfig.index = bNcProps.getNvIndex();
        int n = bNcProps.getSnvtType();
        xNetworkConfig.snvtType = XLonDataUtil.getSnvtTypeName(n, "");
        int n2 = bNcProps.getConfigIndex();
        xNetworkConfig.scptType = XLonDataUtil.getScptTypeName(n2, "");
        xNetworkConfig.modifyFlag = DevToXLon.getModifyFlags(bNcProps.getModifyFlag());
        xNetworkConfig.scope = bNcProps.getScope().getTag();
        xNetworkConfig.select = bNcProps.getSelect();
        BNvConfigData bNvConfigData = bNetworkConfig.getNvConfigData();
        xNetworkConfig.priority = bNvConfigData.getPriority();
        xNetworkConfig.direction = bNvConfigData.getDirection().getTag();
        xNetworkConfig.serviceType = bNvConfigData.getServiceType().getTag();
        xNetworkConfig.authenticated = bNvConfigData.getAuthenticated();
        xNetworkConfig.config = true;
        if (n <= 0 && n2 <= 0) {
            DevToXLon.addData(xLonInterfaceFile, xNetworkConfig, bNetworkConfig.getData());
        }
        return xNetworkConfig;
    }

    private static final XConfigProperty getXConfigProperty(XLonInterfaceFile xLonInterfaceFile, BConfigParameter bConfigParameter) {
        XConfigProperty xConfigProperty = new XConfigProperty();
        xConfigProperty.setName(bConfigParameter.getName());
        BConfigProps bConfigProps = bConfigParameter.getConfigProps();
        int n = bConfigProps.getConfigIndex();
        xConfigProperty.scptType = XLonDataUtil.getScptTypeName(n, "");
        xConfigProperty.length = bConfigProps.getLength();
        xConfigProperty.modifyFlag = DevToXLon.getModifyFlags(bConfigProps.getModifyFlag());
        xConfigProperty.scope = bConfigProps.getScope().getTag();
        xConfigProperty.select = bConfigProps.getSelect();
        if (n <= 0) {
            DevToXLon.addData(xLonInterfaceFile, xConfigProperty, bConfigParameter.getData());
        }
        return xConfigProperty;
    }

    private static final void addData(XLonInterfaceFile xLonInterfaceFile, XLonTyped xLonTyped, BLonData bLonData) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Type type = bObject.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                BUnit bUnit;
                Property property = slotCursor.property();
                BFacets bFacets = property.getFacets();
                BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(bFacets);
                XElementQualifier xElementQualifier = new XElementQualifier(property.getName(), bLonElementQualifiers);
                if (type.is(BLonEnum.TYPE)) {
                    xElementQualifier.setEnumDef(DevToXLon.addEnum(xLonInterfaceFile, ((BLonEnum)bObject).getEnum()));
                }
                if ((bUnit = (BUnit)bFacets.get("units")) != null) {
                    xElementQualifier.setEngUnit(bUnit.getUnitName());
                }
                xLonTyped.addAttribute(property.getName(), xElementQualifier);
                continue;
            }
            if (!type.is(BLonData.TYPE)) continue;
            DevToXLon.addData(xLonInterfaceFile, xLonTyped, (BLonData)bObject);
        }
    }

    private static final String addEnum(XLonInterfaceFile xLonInterfaceFile, BEnum bEnum) {
        XEnumDef xEnumDef = new XEnumDef();
        BEnumRange bEnumRange = bEnum.getRange();
        int[] nArray = bEnumRange.getOrdinals();
        int n = 0;
        while (n < nArray.length) {
            xEnumDef.addEnum(bEnumRange.get(nArray[n]).getTag(), Integer.toString(nArray[n]));
            ++n;
        }
        Vector vector = xLonInterfaceFile.enums;
        int n2 = 0;
        while (n2 < vector.size()) {
            XEnumDef xEnumDef2 = (XEnumDef)vector.elementAt(n2);
            if (xEnumDef.equals(xEnumDef2)) {
                return xEnumDef2.getName();
            }
            ++n2;
        }
        String string = "enum" + vector.size();
        xEnumDef.setName(string);
        vector.addElement(xEnumDef);
        return string;
    }

    private static final String getModifyFlags(BModifyFlags bModifyFlags) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (bModifyFlags.isDisabled()) {
            stringBuffer.append("objDisable ");
        }
        if (bModifyFlags.isOffline()) {
            stringBuffer.append("offline ");
        }
        if (bModifyFlags.isConst()) {
            stringBuffer.append("constant ");
        }
        if (bModifyFlags.isReset()) {
            stringBuffer.append("reset ");
        }
        if (bModifyFlags.isMfgOnly()) {
            stringBuffer.append("mfgOnly ");
        }
        if ((n = stringBuffer.length()) > 0) {
            return stringBuffer.toString().substring(0, n - 1);
        }
        return "anytime";
    }

    private static final XMessageTag getXMessageTag(BMessageTag bMessageTag) {
        XMessageTag xMessageTag = new XMessageTag();
        xMessageTag.setName(bMessageTag.getName());
        return xMessageTag;
    }
}

