/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.xif;

import com.tridium.lonworks.resource.CrossReference;
import com.tridium.lonworks.util.selfdoc.NodeSelfDoc;
import com.tridium.lonworks.util.xif.ConfigFileParser;
import com.tridium.lonworks.util.xif.DeviceDataParser;
import com.tridium.lonworks.util.xif.NvParser;
import com.tridium.lonworks.util.xif.XifLineReader;
import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XLonData;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XNetworkConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.file.BIFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XifToXDevice {
    Hashtable nameHash;
    private XifLineReader reader;
    private PrintStream out;
    private boolean readElems;
    private CrossReference cr;
    private byte[] valFile1;
    private byte[] valFile2;

    public static XLonDevice convert(String string, CrossReference crossReference) {
        XifLineReader xifLineReader;
        try {
            xifLineReader = new XifLineReader(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to access file " + string);
        }
        return XifToXDevice.convert(xifLineReader, System.out, crossReference);
    }

    public static XLonDevice convert(BIFile bIFile, CrossReference crossReference) {
        return XifToXDevice.convert(bIFile, System.out, crossReference);
    }

    public static XLonDevice convert(BIFile bIFile, PrintStream printStream, CrossReference crossReference) {
        XifLineReader xifLineReader;
        try {
            xifLineReader = new XifLineReader(bIFile.getInputStream());
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to access file.");
        }
        return XifToXDevice.convert(xifLineReader, printStream, crossReference);
    }

    private static final XLonDevice convert(XifLineReader xifLineReader, PrintStream printStream, CrossReference crossReference) {
        XifToXDevice xifToXDevice = new XifToXDevice(xifLineReader, printStream, crossReference);
        return xifToXDevice.parse();
    }

    private final XLonDevice parse() {
        XLonDevice xLonDevice = new XLonDevice();
        if (this.cr == null) {
            this.cr = new CrossReference(this.out);
        }
        DeviceDataParser deviceDataParser = new DeviceDataParser(this.reader, this.out);
        xLonDevice.deviceData = deviceDataParser.parse();
        String string = xLonDevice.deviceData.nodeSelfID;
        NodeSelfDoc nodeSelfDoc = new NodeSelfDoc(string);
        NvParser nvParser = new NvParser(this.reader, this.out, this.readElems, this.cr, nodeSelfDoc);
        try {
            while (true) {
                String string2;
                if ((string2 = this.reader.readXifLine()).startsWith("VAR")) {
                    this.setXdata(nvParser.parseNetwork(string2), xLonDevice);
                }
                if (string2.startsWith("TAG")) {
                    this.setXdata(nvParser.parseTag(string2), xLonDevice);
                }
                if (string2.startsWith("FILE")) {
                    this.parseFile(xLonDevice, string2, string);
                }
                if (!string2.startsWith("NVVAL")) continue;
                this.parseNciVal(xLonDevice);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.valFile1 != null) {
            this.setInitValues(xLonDevice);
        }
        return xLonDevice;
    }

    private final void setXdata(XLonData xLonData, XLonDevice xLonDevice) {
        if (xLonData == null) {
            return;
        }
        xLonData.setName(this.getUniqueName(xLonData.getName()));
        xLonDevice.addAttribute(xLonData.getName(), xLonData);
    }

    private final void parseNciVal(XLonDevice xLonDevice) throws EOFException, IOException {
        XNetworkConfig[] xNetworkConfigArray = xLonDevice.getNetworkConfigs();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        String string = this.reader.readLine();
        int n = 0;
        while (n < xNetworkConfigArray.length) {
            if (string == null || string.length() == 0) {
                System.out.println("Not enough entries in NVVAL");
                return;
            }
            byteArrayOutputStream.reset();
            do {
                this.parseBytes(byteArrayOutputStream, string);
            } while ((string = this.reader.readLine()) != null && string.startsWith("\t"));
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (!this.isZeros(byArray)) {
                xNetworkConfigArray[n].init = byArray;
            }
            ++n;
        }
    }

    private final boolean isZeros(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final void parseBytes(ByteArrayOutputStream byteArrayOutputStream, String string) {
        boolean bl = false;
        if (string.indexOf(120) >= 0) {
            bl = true;
        }
        boolean bl2 = bl;
        int n = 0;
        int n2 = 0;
        boolean bl3 = bl2;
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '\\' || Character.isWhitespace(c) || c == ',') {
                if (n2 > 0) {
                    byteArrayOutputStream.write(n);
                }
                n = 0;
                n2 = 0;
                if (bl2) {
                    bl3 = true;
                }
            } else if (c == 'x' || c == 'X') {
                bl3 = false;
            } else {
                if (Character.digit(c, 16) < 0) break;
                if (!bl3) {
                    n = (n << 4) + Character.digit(c, 16);
                    if (++n2 == 2) {
                        byteArrayOutputStream.write(n);
                        n2 = 0;
                    }
                }
            }
            ++n3;
        }
        if (n2 != 0) {
            byteArrayOutputStream.write(n);
        }
    }

    private final void parseFile(XLonDevice xLonDevice, String string, String string2) throws EOFException, IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        int n = Integer.decode(stringTokenizer.nextToken());
        int n2 = Integer.decode(stringTokenizer.nextToken());
        if (n == 0) {
            this.reader.readXifLine();
            ConfigFileParser configFileParser = new ConfigFileParser(this.reader, this.out, this.cr, string2);
            Vector vector = configFileParser.parse();
            int n3 = 0;
            while (n3 < vector.size()) {
                XConfigProperty xConfigProperty = (XConfigProperty)vector.elementAt(n3);
                xConfigProperty.setName(this.getUniqueName(xConfigProperty.getName()));
                xLonDevice.addAttribute(xConfigProperty.getName(), xConfigProperty);
                ++n3;
            }
        } else if (n2 == 1) {
            if (n == 1) {
                this.valFile1 = this.parseValueFile();
            }
            if (n == 2) {
                this.valFile2 = this.parseValueFile();
            }
        }
    }

    private final byte[] parseValueFile() throws EOFException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        String string = this.reader.readLine();
        while (string != null && string.length() > 0) {
            this.parseBytes(byteArrayOutputStream, string);
            string = this.reader.readLine();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private final void setInitValues(XLonDevice xLonDevice) {
        boolean bl;
        boolean bl2 = false;
        if (this.valFile2 != null) {
            bl2 = true;
        }
        if (bl = bl2) {
            xLonDevice.hasReadOnlyFile = true;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.valFile1);
        ByteArrayInputStream byteArrayInputStream2 = bl ? new ByteArrayInputStream(this.valFile2) : null;
        XConfigProperty[] xConfigPropertyArray = xLonDevice.getConfigProperties();
        int n = 0;
        while (n < xConfigPropertyArray.length) {
            int n2 = xConfigPropertyArray[n].length * xConfigPropertyArray[n].dimension;
            byte[] byArray = XLonDataUtil.isReadOnly(xConfigPropertyArray[n].modifyFlag) && bl ? this.readBytes(byteArrayInputStream2, n2) : this.readBytes(byteArrayInputStream, n2);
            if (!this.isZeros(byArray)) {
                xConfigPropertyArray[n].init = byArray;
            }
            ++n;
        }
    }

    private final byte[] readBytes(ByteArrayInputStream byteArrayInputStream, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)byteArrayInputStream.read();
            ++n2;
        }
        return byArray;
    }

    private final String getUniqueName(String string) {
        String string2 = string;
        int n = 1;
        while (this.nameHash.get(string2) != null) {
            string2 = string + '_' + n++;
        }
        this.nameHash.put(string2, string2);
        if (n > 1) {
            this.out.println("Duplicate name " + string + " changed to " + string2);
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        if (string == null) {
            System.out.println("must specify file to parse");
        }
        XifToXDevice.convert(string, null);
    }

    private final /* synthetic */ void this() {
        this.nameHash = new Hashtable();
        this.valFile1 = null;
        this.valFile2 = null;
    }

    private XifToXDevice(XifLineReader xifLineReader, PrintStream printStream, CrossReference crossReference) {
        this.this();
        this.reader = xifLineReader;
        this.out = printStream;
        this.readElems = true;
        this.cr = crossReference;
    }
}

