/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.xif;

import com.tridium.lonworks.util.xif.XifLineReader;
import com.tridium.lonworks.xml.XDeviceData;
import com.tridium.lonworks.xml.XLonDataUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DeviceDataParser {
    private XifLineReader reader;
    private PrintStream out;
    private XDeviceData deviceData;

    public XDeviceData parse() {
        this.deviceData = new XDeviceData();
        this.deviceData.setName("deviceData");
        try {
            this.parseLn1(this.reader.readXifLine());
            this.reader.readXifLine();
            this.reader.readXifLine();
            String string = this.reader.readXifLine();
            this.deviceData.setProgramID(string);
            this.parseLn6(this.reader.readXifLine());
            this.parseLn7(this.reader.readXifLine());
            if (this.deviceData.majorVersion >= 3) {
                this.parseLn8(this.reader.readXifLine());
                this.parseLn9(this.reader.readXifLine());
                this.parseLn10(this.reader.readXifLine());
            }
            this.reader.readXifLine();
            StringBuffer stringBuffer = new StringBuffer();
            string = this.reader.readLine();
            while (string != null && string.startsWith("\"")) {
                stringBuffer.append(string.substring(1));
                string = this.reader.readXifLine(false);
            }
            this.deviceData.nodeSelfID = stringBuffer.toString();
            if (this.deviceData.nodeSelfID.startsWith("&")) {
                this.deviceData.nodeSelfID = this.deviceData.nodeSelfID.substring(1);
            }
        }
        catch (IOException iOException) {}
        return this.deviceData;
    }

    private final void parseLn1(String string) {
        int n = string.indexOf("XIF Version ") + "XIF Version ".length();
        String string2 = string.substring(n).trim();
        int n2 = string2.indexOf(".");
        try {
            if (n2 != -1) {
                this.deviceData.majorVersion = Integer.parseInt(string2.substring(0, n2));
                this.deviceData.minorVersion = Integer.parseInt(string2.substring(n2 + 1));
            } else {
                this.deviceData.majorVersion = Integer.parseInt(string2);
                this.deviceData.minorVersion = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.out.println("invalid characters " + string2 + " in place of version number");
        }
    }

    private final void parseLn6(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        try {
            this.deviceData.domains = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.addressTableEntries = Integer.parseInt(stringTokenizer.nextToken());
            boolean bl = false;
            if (Integer.parseInt(stringTokenizer.nextToken()) == 1) {
                bl = true;
            }
            this.deviceData.handlesIncomingExplicitMessages = bl;
            this.deviceData.numNvDeclarations = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.numExplicitMessageTags = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.networkInputBuffers = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.networkOutputBuffers = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.priorityNetworkOutputBuffers = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.priorityApplicationOutputBuffers = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.applicationOutputBuffers = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.applicationInputBuffers = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.sizeNetworkInputBuffer = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.sizeNetworkOutputBuffer = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.sizeAppOutputBuffer = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.sizeAppInputBuffer = Integer.parseInt(stringTokenizer.nextToken());
            if (this.deviceData.majorVersion < 2) {
                return;
            }
            this.deviceData.applicationType = XLonDataUtil.applicationTypeToString(Integer.parseInt(stringTokenizer.nextToken()));
            this.deviceData.numNetworkVariablesNISelect = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.rcvTransactionBuffers = Integer.parseInt(stringTokenizer.nextToken());
            if (this.deviceData.majorVersion < 3 || this.deviceData.majorVersion == 3 && this.deviceData.minorVersion < 1) {
                return;
            }
            this.deviceData.aliasCount = Integer.parseInt(stringTokenizer.nextToken());
            boolean bl2 = false;
            if (Integer.parseInt(stringTokenizer.nextToken()) == 1) {
                bl2 = true;
            }
            this.deviceData.bindingII = bl2;
            boolean bl3 = false;
            if (Integer.parseInt(stringTokenizer.nextToken()) == 1) {
                bl3 = true;
            }
            this.deviceData.allowStatRelativeAddressing = bl3;
            this.deviceData.maxSizeWrite = Integer.parseInt(stringTokenizer.nextToken());
            if (this.deviceData.majorVersion < 4) {
                return;
            }
            try {
                this.deviceData.maxNumNvSupported = Integer.parseInt(stringTokenizer.nextToken());
                if (this.deviceData.majorVersion == 4 && this.deviceData.minorVersion < 2) {
                    return;
                }
                this.deviceData.minNetMgmtVer = Integer.parseInt(stringTokenizer.nextToken());
                this.deviceData.maxNetMgmtVer = Integer.parseInt(stringTokenizer.nextToken());
                this.deviceData.bindingConstraintLevel = Integer.parseInt(stringTokenizer.nextToken());
                int n = 0;
                while (n < 6) {
                    this.deviceData.ecsFlags[n] = Integer.parseInt(stringTokenizer.nextToken());
                    ++n;
                }
                this.deviceData.numEcsDomains = Integer.parseInt(stringTokenizer.nextToken());
                this.deviceData.numEcsAddressEntries = Integer.parseInt(stringTokenizer.nextToken());
                this.deviceData.numEcsMessageTags = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("not all expected fields were present in line six of the header.");
        }
    }

    private final void parseLn7(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            this.deviceData.neuronChipType = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.clockRate = Integer.parseInt(stringTokenizer.nextToken());
            if (this.deviceData.majorVersion < 3) {
                return;
            }
            this.deviceData.firmwareRevision = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.rcvTransactionBlockSize = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.transControlBlockSize = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.neuronFreeRam = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.offChipFreeRam = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.domainTableEntrySize = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.addressTableEntrySize = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.nvConfigTableEntrySize = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.domainToUserSize = Integer.parseInt(stringTokenizer.nextToken());
            if (this.deviceData.majorVersion == 3 && this.deviceData.minorVersion < 1) {
                return;
            }
            this.deviceData.nvAliasTableEntrySize = Integer.parseInt(stringTokenizer.nextToken());
            if (this.deviceData.majorVersion == 4 && this.deviceData.minorVersion < 4) {
                return;
            }
            this.deviceData.baseClockRateFactor = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("not all expected fields were present in the neuron chip configuration");
        }
    }

    private final void parseLn8(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            boolean bl = false;
            if (Integer.parseInt(stringTokenizer.nextToken()) == 1) {
                bl = true;
            }
            this.deviceData.standardTransceiverTypeUsed = bl;
            this.deviceData.standardTransceiverTypeId = Integer.parseInt(stringTokenizer.nextToken());
            stringTokenizer.nextToken();
            this.deviceData.transceiverType = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.transceiverInterfaceRate = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.numPrioritySlots = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.minimumClockRate = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.averagePacketSize = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.oscillatorAccuracy = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.oscillatorWakeupTime = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("not all expected fields were present in the channel parameters");
        }
    }

    private final void parseLn9(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            this.deviceData.channelBitRate = Integer.parseInt(stringTokenizer.nextToken());
            boolean bl = false;
            if (Integer.parseInt(stringTokenizer.nextToken()) == 1) {
                bl = true;
            }
            this.deviceData.specialBitRate = bl;
            boolean bl2 = false;
            if (Integer.parseInt(stringTokenizer.nextToken()) == 1) {
                bl2 = true;
            }
            this.deviceData.specialPreambleControl = bl2;
            this.deviceData.specialWakeupDirection = Integer.parseInt(stringTokenizer.nextToken()) == 1 ? "output" : "input";
            boolean bl3 = false;
            if (Integer.parseInt(stringTokenizer.nextToken()) == 1) {
                bl3 = true;
            }
            this.deviceData.overridesGenPurposeData = bl3;
            this.deviceData.generalPurposeData1 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.generalPurposeData2 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.generalPurposeData3 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.generalPurposeData4 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.generalPurposeData5 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.generalPurposeData6 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.generalPurposeData7 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("not all expected fields were present in the transciever parameters");
        }
    }

    private final void parseLn10(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            this.deviceData.rcvStartDelay = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.rcvEndDelay = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.indeterminateTime = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.minInterpacketTime = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.preambleLength = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.turnaroundTime = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.missedPreambleTime = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.packetQualificationTime = Integer.parseInt(stringTokenizer.nextToken());
            boolean bl = false;
            if (Integer.parseInt(stringTokenizer.nextToken()) == 1) {
                bl = true;
            }
            this.deviceData.rawDataOverrides = bl;
            this.deviceData.rawDataClockRate = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.rawData1 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.rawData2 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.rawData3 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.rawData4 = Integer.parseInt(stringTokenizer.nextToken());
            this.deviceData.rawData5 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("not all expected fields were present in the channel timing parameters");
        }
    }

    public DeviceDataParser(XifLineReader xifLineReader, PrintStream printStream) {
        this.reader = xifLineReader;
        this.out = printStream;
    }
}

