/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.selfdoc;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.io.LonInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SnvtStruct
implements NetMessages {
    private LonComm lonComm;
    private LonAddress sendAddr;
    private boolean auth;
    public boolean hasSelfDoc;
    public byte[] data;
    public int hdrLength;
    public int snvtPtr;
    public int numNvsDocs;
    public int version;
    public int docLength;
    public int mtagCount;
    public int maxMumNvs;
    public int staticNvCount;
    public int currentNvCount;
    public int maxNvInUse;
    public int aliasCount;
    public int nodeSelfDocLen;
    public boolean bindingII;
    public boolean queryStats;

    private final byte[] getData(int n, boolean bl) throws LonException {
        byte[] byArray = this.snvtPtr == (char)-1 ? Neuron.querySnvt(this.lonComm, this.sendAddr, 0, n, bl, 11) : Neuron.readMemory(this.lonComm, 0, this.sendAddr, this.snvtPtr, n, bl, false, 11);
        return byArray;
    }

    private final Log log() {
        return this.lonComm.lonNetwork().log();
    }

    private final /* synthetic */ void this() {
        this.hasSelfDoc = false;
        this.data = null;
        this.numNvsDocs = 0;
        this.mtagCount = 0;
        this.staticNvCount = 0;
        this.currentNvCount = 0;
        this.maxNvInUse = (char)-1;
        this.aliasCount = 0;
        this.nodeSelfDocLen = 0;
        this.bindingII = false;
        this.queryStats = false;
    }

    public SnvtStruct(BLonDevice bLonDevice) throws LonException {
        this(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate());
    }

    public SnvtStruct(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        this.this();
        this.lonComm = lonComm;
        this.sendAddr = lonAddress;
        this.auth = bl;
        this.snvtPtr = Neuron.getSnvtPtr(lonComm, this.sendAddr, this.auth);
        if (this.snvtPtr == 0) {
            return;
        }
        try {
            this.data = this.getData(17, this.auth);
        }
        catch (LonException lonException) {
            return;
        }
        this.hasSelfDoc = true;
        LonInputStream lonInputStream = new LonInputStream(this.data);
        this.docLength = lonInputStream.readUnsigned16();
        this.numNvsDocs = lonInputStream.readUnsigned8();
        this.version = lonInputStream.readUnsigned8();
        switch (this.version) {
            case 0: {
                this.hdrLength = 5;
                break;
            }
            case 1: {
                this.hdrLength = 6;
                this.numNvsDocs = (lonInputStream.readUnsigned8() << 8) + this.numNvsDocs;
                break;
            }
            case 2: {
                this.hdrLength = 17;
                this.maxMumNvs = this.numNvsDocs = (lonInputStream.readUnsigned8() << 8) + this.numNvsDocs;
                break;
            }
            default: {
                throw new LonException("Unknown selfdoc header version {" + this.version + "}.");
            }
        }
        this.mtagCount = lonInputStream.readUnsigned8();
        if (this.log().isTraceOn()) {
            System.out.println("numNvsDocs = " + this.numNvsDocs);
            System.out.println("mtagCount = " + this.mtagCount);
        }
        if (this.version != 2) {
            return;
        }
        this.staticNvCount = lonInputStream.readUnsigned16();
        this.currentNvCount = lonInputStream.readUnsigned16();
        this.maxNvInUse = lonInputStream.readUnsigned16();
        this.aliasCount = lonInputStream.readUnsigned16();
        this.nodeSelfDocLen = lonInputStream.readUnsigned16();
        int n = lonInputStream.readUnsigned8();
        boolean bl2 = false;
        if ((n & 0x80) > 0) {
            bl2 = true;
        }
        this.bindingII = bl2;
        boolean bl3 = false;
        if ((n & 0x40) > 0) {
            bl3 = this.queryStats = true;
        }
        if (this.log().isTraceOn()) {
            System.out.println("staticNvCount = " + this.staticNvCount);
            System.out.println("currentNvCount = " + this.currentNvCount);
            System.out.println("maxNvInUse = " + this.maxNvInUse);
            System.out.println("aliasCount = " + this.aliasCount);
            System.out.println("nodeSelfDocLen = " + this.nodeSelfDocLen);
            System.out.println("bindingII = " + this.bindingII);
            System.out.println("queryStats = " + this.queryStats);
        }
    }
}

