/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.selfdoc;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.InstallUtil;
import com.tridium.lonworks.util.selfdoc.NvSelfDoc;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.LonInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NvDoc
implements NetMessages {
    public int origin;
    private boolean hasExtension;
    private boolean sychronous;
    private boolean polled;
    private boolean updateOffline;
    private boolean servTypeConfig;
    private boolean priorityConfig;
    private boolean authConfigurable;
    private boolean configNv;
    private int snvtType;
    private int ver01Desc;
    private BLonNvDirection direction;
    private BLonServiceType serviceType;
    private boolean authenticated;
    private boolean priority;
    private String name;
    public NvSelfDoc selfDoc;
    private int arraySize;
    private int nvIndex;
    private int nvLength;
    public boolean extended;

    public static NvDoc makeNvDocVersion01(LonInputStream lonInputStream, LonInputStream lonInputStream2, BNvConfigData bNvConfigData, int n, boolean bl) {
        NvDoc nvDoc = new NvDoc();
        int n2 = lonInputStream.readUnsigned16();
        boolean bl2 = false;
        if ((n2 & 0x8000) != 0) {
            bl2 = true;
        }
        nvDoc.hasExtension = bl2;
        boolean bl3 = false;
        if ((n2 & 0x4000) != 0) {
            bl3 = true;
        }
        nvDoc.sychronous = bl3;
        boolean bl4 = false;
        if ((n2 & 0x2000) != 0) {
            bl4 = true;
        }
        nvDoc.polled = bl4;
        boolean bl5 = false;
        if ((n2 & 0x1000) != 0) {
            bl5 = true;
        }
        nvDoc.updateOffline = bl5;
        boolean bl6 = false;
        if ((n2 & 0x800) != 0) {
            bl6 = true;
        }
        nvDoc.servTypeConfig = bl6;
        boolean bl7 = false;
        if ((n2 & 0x400) != 0) {
            bl7 = true;
        }
        nvDoc.priorityConfig = bl7;
        boolean bl8 = false;
        if ((n2 & 0x200) != 0) {
            bl8 = true;
        }
        nvDoc.authConfigurable = bl8;
        boolean bl9 = false;
        if ((n2 & 0x100) != 0) {
            bl9 = true;
        }
        nvDoc.configNv = bl9;
        nvDoc.snvtType = n2 & 0xFF;
        nvDoc.ver01Desc = n2;
        nvDoc.extended = bl;
        if (nvDoc.hasExtension) {
            int n3 = lonInputStream2.readUnsigned8();
            if ((n3 & 0x80) != 0) {
                lonInputStream2.readUnsigned8();
            }
            if ((n3 & 0x40) != 0) {
                lonInputStream2.readUnsigned8();
            }
            if ((n3 & 0x20) != 0) {
                nvDoc.name = lonInputStream2.readString();
            }
            if ((n3 & 0x10) != 0) {
                nvDoc.selfDoc = new NvSelfDoc(lonInputStream2.readString());
            }
            if ((n3 & 8) != 0) {
                nvDoc.arraySize = lonInputStream2.readUnsigned16();
            }
        }
        nvDoc.direction = bNvConfigData.getDirection();
        nvDoc.serviceType = bNvConfigData.getServiceType();
        nvDoc.authenticated = bNvConfigData.getAuthenticated();
        nvDoc.priority = bNvConfigData.getPriority();
        nvDoc.nvIndex = n;
        return nvDoc;
    }

    public static NvDoc makeNvDocVersion2(LonComm lonComm, LonAddress lonAddress, int n, boolean bl, boolean bl2) throws LonException {
        Object object;
        NvDoc nvDoc = new NvDoc();
        byte[] byArray = InstallUtil.getNvInfo(lonComm, lonAddress, bl, n, 0);
        nvDoc.nvLength = byArray[0] >> 3 & 0x1F;
        nvDoc.origin = byArray[0] & 3;
        nvDoc.direction = (byArray[1] & 0x10) != 0 ? BLonNvDirection.output : BLonNvDirection.input;
        nvDoc.serviceType = BLonServiceType.make(byArray[1] & 3);
        boolean bl3 = false;
        if ((byArray[2] & 0x40) != 0) {
            bl3 = true;
        }
        nvDoc.sychronous = bl3;
        boolean bl4 = false;
        if ((byArray[2] & 0x20) != 0) {
            bl4 = true;
        }
        nvDoc.polled = bl4;
        boolean bl5 = false;
        if ((byArray[2] & 0x10) != 0) {
            bl5 = true;
        }
        nvDoc.updateOffline = bl5;
        boolean bl6 = false;
        if ((byArray[2] & 8) != 0) {
            bl6 = true;
        }
        nvDoc.servTypeConfig = bl6;
        boolean bl7 = false;
        if ((byArray[2] & 4) != 0) {
            bl7 = true;
        }
        nvDoc.priorityConfig = bl7;
        boolean bl8 = false;
        if ((byArray[2] & 2) != 0) {
            bl8 = true;
        }
        nvDoc.authConfigurable = bl8;
        boolean bl9 = false;
        if ((byArray[2] & 1) != 0) {
            bl9 = true;
        }
        nvDoc.configNv = bl9;
        nvDoc.snvtType = byArray[3] & 0xFF;
        if ((byArray[4] & 8) != 0 && (byArray[4] & 0x20) != 0) {
            object = new StringBuffer();
            int n2 = 9;
            while (n2 < byArray.length && byArray[n2] != 0) {
                ((StringBuffer)object).append((char)byArray[n2]);
                ++n2;
            }
            nvDoc.name = ((StringBuffer)object).toString();
        } else if ((byArray[4] & 0x20) != 0) {
            object = new StringBuffer();
            byte[] byArray2 = InstallUtil.getNvInfo(lonComm, lonAddress, bl, n, 2);
            int n3 = 0;
            while (n3 < byArray2.length && byArray2[n3] != 0) {
                ((StringBuffer)object).append((char)byArray2[n3]);
                ++n3;
            }
            nvDoc.name = ((StringBuffer)object).toString();
        }
        if ((byArray[4] & 0x10) != 0) {
            nvDoc.selfDoc = new NvSelfDoc(InstallUtil.getNvSdInfo(lonComm, lonAddress, bl, n));
        }
        nvDoc.arraySize = ((byArray[5] & 0xFF) << 8) + (byArray[6] & 0xFF);
        nvDoc.nvIndex = n;
        object = NmUtil.queryNvConfigData(lonComm, lonAddress, n, bl, bl2);
        nvDoc.direction = ((BNvConfigData)((Object)object)).getDirection();
        nvDoc.serviceType = ((BNvConfigData)((Object)object)).getServiceType();
        nvDoc.authenticated = ((BNvConfigData)((Object)object)).getAuthenticated();
        nvDoc.priority = ((BNvConfigData)((Object)object)).getPriority();
        return nvDoc;
    }

    public boolean hasExtension() {
        return this.hasExtension;
    }

    public boolean isSychronous() {
        return this.sychronous;
    }

    public boolean isPolled() {
        return this.polled;
    }

    public boolean isUpdateOffline() {
        return this.updateOffline;
    }

    public boolean isServTypeConfig() {
        return this.servTypeConfig;
    }

    public boolean isPriorityConfig() {
        return this.priorityConfig;
    }

    public boolean isAuthConfigurable() {
        return this.authConfigurable;
    }

    public boolean isConfigNv() {
        return this.configNv;
    }

    public int getSnvtType() {
        return this.snvtType;
    }

    public boolean getAuthenticated() {
        return this.authenticated;
    }

    public boolean getPriority() {
        return this.priority;
    }

    public BLonServiceType getServiceType() {
        return this.serviceType;
    }

    public BLonNvDirection getDirection() {
        return this.direction;
    }

    public boolean isArray() {
        boolean bl = false;
        if (this.arraySize > 0) {
            bl = true;
        }
        return bl;
    }

    public int getVer01Desc() {
        return this.ver01Desc;
    }

    public int getNvIndex() {
        return this.nvIndex;
    }

    public int getNvLength() {
        return this.nvLength;
    }

    public int getArraySize() {
        int n = 1;
        if (this.arraySize > 0) {
            n = this.arraySize;
        }
        return n;
    }

    public int getObjectIndex(int n) {
        return this.selfDoc != null ? this.selfDoc.getObjectIndex(n) : -1;
    }

    public String getObjectIndexString() {
        return this.selfDoc != null ? this.selfDoc.getObjectIndexString() : "";
    }

    public int getMemberIndex(int n) {
        return this.selfDoc != null ? this.selfDoc.getMemberIndex(n) : -1;
    }

    public boolean isMfrMember() {
        boolean bl = false;
        if (this.selfDoc != null) {
            bl = this.selfDoc.isMfrMember();
        }
        return bl;
    }

    public int getConfigIndex() {
        return this.selfDoc != null ? this.selfDoc.getConfigIndex() : -1;
    }

    public boolean isChangeableType() {
        boolean bl = false;
        if (this.selfDoc != null) {
            bl = this.selfDoc.isChangeableType();
        }
        return bl;
    }

    public BModifyFlags getModifyFlag() {
        return this.selfDoc != null ? this.selfDoc.getModifyFlag() : BModifyFlags.DEFAULT;
    }

    public BLonConfigScope getScope() {
        return this.selfDoc != null ? this.selfDoc.getScope() : BLonConfigScope.node;
    }

    public String getSelect() {
        return this.selfDoc != null ? this.selfDoc.getSelect() : "";
    }

    public String getName() {
        if (this.name == null) {
            return "var_" + this.nvIndex;
        }
        return this.name;
    }

    public void setNvIndex(int n) {
        this.nvIndex = n;
    }

    public void setNvLength(int n) {
        this.nvLength = n;
    }

    public String toString() {
        return "\nname = " + this.getName() + "\nDirection = " + (Object)((Object)this.getDirection()) + "\nnvIndex = " + this.getNvIndex() + "\nconfig nv = " + this.isConfigNv() + "\narraySize = " + this.arraySize + "\nselfDoc = " + this.selfDoc + '\n';
    }

    private final /* synthetic */ void this() {
        this.name = null;
        this.selfDoc = null;
        this.arraySize = 0;
        this.nvIndex = 0;
        this.nvLength = 0;
    }

    public NvDoc() {
        this.this();
    }
}

