/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.selfdoc;

import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.XLonFile;
import com.tridium.lonworks.util.selfdoc.ConfigStruct;
import com.tridium.lonworks.util.selfdoc.ConfigTemplateFile;
import com.tridium.lonworks.util.selfdoc.ConfigTemplateRecord;
import com.tridium.lonworks.util.selfdoc.ExtendedSelfDoc;
import com.tridium.lonworks.util.selfdoc.NodeSelfDoc;
import com.tridium.lonworks.util.selfdoc.NvDoc;
import com.tridium.lonworks.util.selfdoc.ReadOnlyStruct;
import com.tridium.lonworks.util.selfdoc.SelfDoc;
import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XDeviceData;
import com.tridium.lonworks.xml.XElementQualifier;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XMessageTag;
import com.tridium.lonworks.xml.XNetVariable;
import com.tridium.lonworks.xml.XNetworkConfig;
import com.tridium.lonworks.xml.XNetworkVariable;
import java.util.Vector;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonScptType;
import javax.baja.lonworks.util.LonFile;

public class DocToXDevice {
    public static XLonDevice extract(LonAddress lonAddress, LonComm lonComm, boolean bl) throws Exception {
        ConfigTemplateRecord[] configTemplateRecordArray;
        Object object;
        boolean bl2;
        XLonDevice xLonDevice = new XLonDevice();
        boolean bl3 = NmUtil.isExtended(lonComm, lonAddress, bl);
        xLonDevice.deviceData = DocToXDevice.getDeviceData(lonAddress, lonComm, bl, bl3);
        SelfDoc selfDoc = new SelfDoc(lonComm, lonAddress, bl, bl3);
        NodeSelfDoc nodeSelfDoc = selfDoc.getNodeDoc();
        boolean bl4 = false;
        if (nodeSelfDoc != null && nodeSelfDoc.isValid()) {
            bl4 = true;
        }
        if (bl2 = bl4) {
            xLonDevice.deviceData.nodeSelfID = nodeSelfDoc.selfDocString;
        }
        if (selfDoc.hasNvs()) {
            object = selfDoc.getNvDocs();
            int n = 0;
            while (n < ((NvDoc[])object).length) {
                DocToXDevice.addNetVariable(xLonDevice, object[n], nodeSelfDoc);
                ++n;
            }
        }
        object = null;
        try {
            object = XLonFile.createFile(lonAddress, lonComm, xLonDevice);
        }
        catch (Throwable throwable) {
            System.out.println("Error attempting to access file in devices: " + throwable);
            throwable.printStackTrace();
        }
        if (object != null && ((LonFile)object).findFileNum(2) == 0) {
            ((LonFile)object).open(0, false, false);
            ConfigTemplateFile configTemplateFile = new ConfigTemplateFile(((LonFile)object).read());
            configTemplateRecordArray = configTemplateFile.getRecords();
            int n = ((LonFile)object).findFileNum(1);
            boolean bl5 = false;
            if (((LonFile)object).findFileNum(1, n) > 0) {
                bl5 = true;
            }
            xLonDevice.hasReadOnlyFile = bl5;
            Vector vector = new Vector(configTemplateRecordArray.length);
            int n2 = 0;
            while (n2 < configTemplateRecordArray.length) {
                Object object2;
                ConfigTemplateRecord configTemplateRecord = configTemplateRecordArray[n2];
                XConfigProperty xConfigProperty = new XConfigProperty();
                xConfigProperty.scope = XLonDataUtil.scopeToString(configTemplateRecord.getHdr());
                xConfigProperty.select = configTemplateRecord.getSelect();
                xConfigProperty.modifyFlag = XLonDataUtil.flagToString(configTemplateRecord.getFlags());
                xConfigProperty.length = configTemplateRecord.getLength();
                xConfigProperty.dimension = configTemplateRecord.getDimension();
                if (configTemplateRecord.hasMin()) {
                    xConfigProperty.min = configTemplateRecord.getMin();
                }
                if (configTemplateRecord.hasMax()) {
                    xConfigProperty.max = configTemplateRecord.getMax();
                }
                if (configTemplateRecord.getTypeScope() == 0) {
                    object2 = null;
                    try {
                        object2 = BLonScptType.make(configTemplateRecord.getConfigIndex());
                    }
                    catch (Throwable throwable) {
                        System.out.println("Can't parse scpt type " + configTemplateRecord.getConfigIndex());
                    }
                    if (object2 != null) {
                        xConfigProperty.scptType = "Cp" + object2.getTag().substring(4);
                    }
                }
                object2 = xConfigProperty.scptType.length() > 0 ? xConfigProperty.scptType : "Config" + n2;
                xConfigProperty.setName(NameUtil.uniqueName(vector, (String)object2));
                xLonDevice.addAttribute(xConfigProperty.getName(), xConfigProperty);
                ++n2;
            }
        }
        int n = 0;
        while (n < selfDoc.getMsgtagCount()) {
            configTemplateRecordArray = new XMessageTag();
            configTemplateRecordArray.index = n;
            configTemplateRecordArray.setName("mtag" + n);
            xLonDevice.addAttribute(configTemplateRecordArray.getName(), configTemplateRecordArray);
            ++n;
        }
        return xLonDevice;
    }

    private static final void addNetVariable(XLonDevice xLonDevice, NvDoc nvDoc, NodeSelfDoc nodeSelfDoc) {
        Object object;
        boolean bl = nvDoc.isConfigNv();
        XNetVariable xNetVariable = !bl ? new XNetworkVariable() : new XNetworkConfig();
        xNetVariable.setName(nvDoc.getName());
        int n = nvDoc.getSnvtType();
        if (n > 0) {
            xNetVariable.snvtType = XLonDataUtil.snvtTypeToString(n);
        } else {
            object = new XElementQualifier("rawData", "na len=" + nvDoc.getNvLength());
            xNetVariable.addAttribute("data", object);
        }
        xNetVariable.index = nvDoc.getNvIndex();
        xNetVariable.arraySize = nvDoc.getArraySize();
        xNetVariable.offline = nvDoc.isUpdateOffline();
        xNetVariable.bindable = true;
        xNetVariable.direction = nvDoc.getDirection().getTag();
        xNetVariable.serviceType = nvDoc.getServiceType().getTag();
        xNetVariable.serviceTypeConfigurable = nvDoc.isServTypeConfig();
        xNetVariable.authenticated = nvDoc.getAuthenticated();
        xNetVariable.authenticatedConfigurable = nvDoc.isAuthConfigurable();
        xNetVariable.priority = nvDoc.getPriority();
        xNetVariable.priorityConfigurable = nvDoc.isPriorityConfig();
        xNetVariable.polled = nvDoc.isPolled();
        xNetVariable.sync = nvDoc.isSychronous();
        xNetVariable.config = bl;
        if (!bl) {
            object = (XNetworkVariable)xNetVariable;
            ((XNetworkVariable)object).objectIndex = nvDoc.getObjectIndexString();
            ((XNetworkVariable)object).memberIndex = nvDoc.getMemberIndex(0);
            ((XNetworkVariable)object).memberArraySize = nvDoc.getArraySize();
            ((XNetworkVariable)object).mfgMember = nvDoc.isMfrMember();
            ((XNetworkVariable)object).changeType = nvDoc.isChangeableType();
        } else {
            object = (XNetworkConfig)xNetVariable;
            ((XNetworkConfig)object).scptType = "";
            ((XNetworkConfig)object).scope = nvDoc.getScope().getTag();
            ((XNetworkConfig)object).select = nvDoc.getSelect();
            ((XNetworkConfig)object).modifyFlag = nvDoc.getModifyFlag().encodeToString();
            ((XNetworkConfig)object).max = "";
            ((XNetworkConfig)object).min = "";
            ((XNetworkConfig)object).changeType = nvDoc.isChangeableType();
        }
        xLonDevice.addAttribute(xNetVariable.getName(), xNetVariable);
    }

    public static XDeviceData getDeviceData(LonAddress lonAddress, LonComm lonComm, boolean bl, boolean bl2) throws LonException {
        ReadOnlyStruct readOnlyStruct = ReadOnlyStruct.make(lonAddress, lonComm, bl, false);
        ConfigStruct configStruct = ConfigStruct.make(lonAddress, lonComm, bl, false);
        XDeviceData xDeviceData = new XDeviceData();
        xDeviceData.setName("deviceData");
        xDeviceData.majorVersion = 0;
        xDeviceData.minorVersion = 0;
        xDeviceData.programID = readOnlyStruct.getProgramId().getByteArray();
        xDeviceData.domains = readOnlyStruct.getTwoDomains() + 1;
        xDeviceData.addressTableEntries = readOnlyStruct.getAddressCount();
        xDeviceData.handlesIncomingExplicitMessages = readOnlyStruct.getExplicitAddressing();
        xDeviceData.numNvDeclarations = readOnlyStruct.getNvCount();
        xDeviceData.numExplicitMessageTags = readOnlyStruct.getMessageTagCount();
        xDeviceData.networkInputBuffers = readOnlyStruct.getNetBufInCount();
        xDeviceData.networkOutputBuffers = readOnlyStruct.getNetBufOutCount();
        xDeviceData.priorityNetworkOutputBuffers = readOnlyStruct.getNetBufOutPriorityCount();
        xDeviceData.priorityApplicationOutputBuffers = readOnlyStruct.getAppBufOutPriorityCount();
        xDeviceData.applicationOutputBuffers = readOnlyStruct.getAppBufOutCount();
        xDeviceData.applicationInputBuffers = readOnlyStruct.getAppBufInCount();
        xDeviceData.sizeNetworkInputBuffer = readOnlyStruct.getNetBufInSize();
        xDeviceData.sizeNetworkOutputBuffer = readOnlyStruct.getNetBufOutSize();
        xDeviceData.sizeAppOutputBuffer = readOnlyStruct.getAppBufOutSize();
        xDeviceData.sizeAppInputBuffer = readOnlyStruct.getAppBufInSize();
        xDeviceData.applicationType = "unknown";
        xDeviceData.numNetworkVariablesNISelect = 0;
        xDeviceData.rcvTransactionBuffers = readOnlyStruct.getRcvTransCount() + 1;
        xDeviceData.aliasCount = readOnlyStruct.getAliasCount();
        xDeviceData.bindingII = false;
        xDeviceData.allowStatRelativeAddressing = false;
        xDeviceData.maxSizeWrite = 11;
        xDeviceData.maxNumNvSupported = 0;
        xDeviceData.neuronChipType = readOnlyStruct.getModelNumber();
        xDeviceData.clockRate = configStruct.getInputClock();
        xDeviceData.firmwareRevision = Neuron.getVersion(lonComm, lonAddress, bl);
        xDeviceData.rcvTransactionBlockSize = 13;
        xDeviceData.transControlBlockSize = 28;
        xDeviceData.neuronFreeRam = 0;
        xDeviceData.offChipFreeRam = 0;
        xDeviceData.domainTableEntrySize = 15;
        xDeviceData.addressTableEntrySize = 5;
        xDeviceData.nvConfigTableEntrySize = 3;
        xDeviceData.domainToUserSize = 112;
        xDeviceData.nvAliasTableEntrySize = 0;
        xDeviceData.standardTransceiverTypeUsed = false;
        xDeviceData.standardTransceiverTypeId = 0;
        xDeviceData.transceiverType = configStruct.getCommType();
        xDeviceData.transceiverInterfaceRate = 4;
        xDeviceData.numPrioritySlots = 0;
        xDeviceData.minimumClockRate = 4;
        xDeviceData.averagePacketSize = 15;
        xDeviceData.oscillatorAccuracy = 200;
        xDeviceData.oscillatorWakeupTime = 0;
        xDeviceData.channelBitRate = configStruct.getInputClockFreq() / configStruct.getCommClockRatio();
        xDeviceData.specialBitRate = false;
        xDeviceData.specialPreambleControl = false;
        xDeviceData.specialWakeupDirection = "input";
        xDeviceData.overridesGenPurposeData = false;
        xDeviceData.generalPurposeData1 = 0;
        xDeviceData.generalPurposeData2 = 0;
        xDeviceData.generalPurposeData3 = 0;
        xDeviceData.generalPurposeData4 = 0;
        xDeviceData.generalPurposeData5 = 0;
        xDeviceData.generalPurposeData6 = 0;
        xDeviceData.generalPurposeData7 = 0;
        xDeviceData.rcvStartDelay = 0;
        xDeviceData.rcvEndDelay = 0;
        xDeviceData.indeterminateTime = 0;
        xDeviceData.minInterpacketTime = 0;
        xDeviceData.preambleLength = configStruct.getPreambleLength();
        xDeviceData.turnaroundTime = 0;
        xDeviceData.missedPreambleTime = 0;
        xDeviceData.packetQualificationTime = 0;
        xDeviceData.rawDataOverrides = true;
        xDeviceData.rawDataClockRate = configStruct.getInputClock();
        xDeviceData.rawData1 = 50;
        xDeviceData.rawData2 = 19;
        xDeviceData.rawData3 = 54;
        xDeviceData.rawData4 = 100;
        xDeviceData.rawData5 = 103;
        try {
            ExtendedSelfDoc extendedSelfDoc = ExtendedSelfDoc.make(lonComm, lonAddress, bl);
            xDeviceData.minNetMgmtVer = extendedSelfDoc.getVerNmMin();
            xDeviceData.maxNetMgmtVer = extendedSelfDoc.getVerNmMax();
            xDeviceData.bindingConstraintLevel = extendedSelfDoc.getVerBinding();
            xDeviceData.ecsFlags = extendedSelfDoc.getFlags();
            xDeviceData.numEcsDomains = extendedSelfDoc.getDomainCapacity();
            xDeviceData.numEcsAddressEntries = extendedSelfDoc.getAddressCapacity();
            xDeviceData.numEcsMessageTags = extendedSelfDoc.getStaticMtagCapacity();
            xDeviceData.aliasCount = extendedSelfDoc.getAliasCount();
        }
        catch (Exception exception) {}
        return xDeviceData;
    }
}

