/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.file.LonFileReadWrite;
import com.tridium.lonworks.file.LonFileTransfer;
import com.tridium.lonworks.file.NoDirectoryException;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XNetworkVariable;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.util.LonFile;

public class XLonFile {
    public static LonFile createFile(LonAddress lonAddress, LonComm lonComm, XLonDevice xLonDevice) throws LonException {
        LonFile lonFile = null;
        int n = XLonFile.findLonObjectNvProperty(xLonDevice, 0, 8, 114);
        if (n != -1) {
            lonFile = new LonFileReadWrite(lonAddress, lonComm, n);
        } else {
            int n2;
            int n3 = XLonFile.findLonObjectNvProperty(xLonDevice, 0, 5, 73);
            if (n3 != -1 && (n2 = XLonFile.findLonObjectNvProperty(xLonDevice, 0, 6, 74)) != -1) {
                int n4 = XLonFile.findLonObjectNvProperty(xLonDevice, 0, 7, 90);
                try {
                    lonFile = new LonFileTransfer(lonAddress, lonComm, n3, n2, n4);
                }
                catch (NoDirectoryException noDirectoryException) {
                    lonComm.lonNetwork().log().warning("Device has file snvts but reports no file directory");
                    return null;
                }
            } else {
                return null;
            }
        }
        return lonFile;
    }

    public static int findLonObjectNvProperty(XLonDevice xLonDevice, int n, int n2, int n3) throws LonException {
        XNetworkVariable[] xNetworkVariableArray = xLonDevice.getNetworkVariables();
        int n4 = 0;
        while (n4 < xNetworkVariableArray.length) {
            XNetworkVariable xNetworkVariable = xNetworkVariableArray[n4];
            try {
                if (xNetworkVariable.objectIndex.length() > 0 && Integer.parseInt(xNetworkVariable.objectIndex) == n && xNetworkVariable.memberIndex == n2 && !xNetworkVariable.mfgMember && XLonDataUtil.snvtTypeFromString(xNetworkVariable.snvtType) == n3) {
                    return xNetworkVariable.index;
                }
            }
            catch (Throwable throwable) {}
            ++n4;
        }
        return -1;
    }
}

