/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.device.DeviceFacets;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;
import javax.baja.util.ICoalesceable;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimedCoalesceQueue
implements Worker.ITodo {
    Entry[] table;
    int hashSize;
    int threshold;
    float loadFactor;
    Entry head;
    Entry tail;
    int size;
    int maxSize;
    long fullCount;
    int rehashCnt;

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isFull() {
        boolean bl = false;
        if (this.size == this.maxSize) {
            bl = true;
        }
        return bl;
    }

    public synchronized Object peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.value;
    }

    public synchronized Object dequeue() throws InterruptedException {
        if (this.head == null) {
            return null;
        }
        long l = ((ITimed)this.head.value).getTime();
        long l2 = Clock.ticks();
        while (l > l2) {
            this.wait(l - l2);
            l = ((ITimed)this.head.value).getTime();
            l2 = Clock.ticks();
        }
        Entry entry = this.head;
        this.head = entry.next;
        if (this.head == null) {
            this.tail = null;
        }
        entry.next = null;
        --this.size;
        if (entry.value instanceof ICoalesceable) {
            this.remove((ICoalesceable)entry.value);
        }
        return entry.value;
    }

    public synchronized Object dequeue(int n) throws InterruptedException {
        while (this.size == 0) {
            if (n == -1) {
                this.wait();
                continue;
            }
            this.wait(n);
            break;
        }
        return this.dequeue();
    }

    public synchronized boolean enqueue(ITimed iTimed) throws QueueFullException {
        ICoalesceable iCoalesceable;
        Entry entry;
        if (iTimed instanceof ICoalesceable && (entry = this.get(iCoalesceable = (ICoalesceable)iTimed)) != null) {
            return false;
        }
        if (this.size >= this.maxSize) {
            ++this.fullCount;
            throw new QueueFullException();
        }
        if (iTimed == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        entry = this.newEntry(iTimed);
        entry.next = null;
        if (this.tail == null) {
            this.head = this.tail = entry;
            bl = true;
        } else {
            long l = iTimed.getTime();
            if (((ITimed)this.tail.value).getTime() <= l) {
                this.tail.next = entry;
                this.tail = entry;
            } else if (((ITimed)this.head.value).getTime() > l) {
                entry.next = this.head;
                this.head = entry;
                bl = true;
            } else {
                Entry entry2 = this.head;
                while (entry2.next != null) {
                    if (((ITimed)entry2.value).getTime() <= l && ((ITimed)entry2.next.value).getTime() > l) {
                        entry.next = entry2.next;
                        entry2.next = entry;
                        break;
                    }
                    entry2 = entry2.next;
                }
            }
        }
        ++this.size;
        if (bl) {
            this.notifyAll();
        }
        return true;
    }

    Entry newEntry(ITimed iTimed) {
        if (iTimed instanceof ICoalesceable) {
            return this.put((ICoalesceable)iTimed);
        }
        return new Entry(iTimed);
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        Entry entry = this.head;
        int n = 0;
        while (entry != null) {
            objectArray[n] = entry.value;
            entry = entry.next;
            ++n;
        }
        return objectArray;
    }

    public synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public Runnable todo(int n) throws InterruptedException {
        return (Runnable)this.dequeue(n);
    }

    Entry get(ICoalesceable iCoalesceable) {
        Object object = iCoalesceable.getCoalesceKey();
        int n = object.hashCode();
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && ((ICoalesceable)entry.value).getCoalesceKey().equals(object)) {
                return entry;
            }
            entry = entry.hashNext;
        }
        return null;
    }

    void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.hashNext;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.hashNext = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
        ++this.rehashCnt;
    }

    Entry put(ICoalesceable iCoalesceable) {
        if (this.hashSize >= this.threshold) {
            this.rehash();
            return this.put(iCoalesceable);
        }
        Object object = iCoalesceable.getCoalesceKey();
        int n = object.hashCode();
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = new Entry(iCoalesceable);
        entry.hash = n;
        entry.hashNext = entryArray[n2];
        entryArray[n2] = entry;
        ++this.hashSize;
        return entry;
    }

    Object remove(ICoalesceable iCoalesceable) {
        Object object = iCoalesceable.getCoalesceKey();
        int n = object.hashCode();
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && ((ICoalesceable)entry.value).getCoalesceKey().equals(object)) {
                if (entry2 != null) {
                    entry2.hashNext = entry.hashNext;
                } else {
                    entryArray[n2] = entry.hashNext;
                }
                --this.hashSize;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.hashNext;
        }
        throw new IllegalStateException();
    }

    public synchronized void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.trTitle((Object)"TimedCoalesceQueue", 1);
        spyWriter.startProps("Queue");
        spyWriter.prop((Object)"size", this.size);
        spyWriter.prop((Object)"maxSize", this.maxSize);
        spyWriter.prop((Object)"fullCount", (Object)Long.toString(this.fullCount));
        Entry entry = this.head;
        while (entry != null) {
            DeviceFacets.TimedInvocation timedInvocation = (DeviceFacets.TimedInvocation)entry.value;
            spyWriter.prop((Object)timedInvocation.getName(), (Object)Long.toString(timedInvocation.getTime()));
            entry = entry.next;
        }
        spyWriter.endProps();
        spyWriter.startProps("CoalesceQueue");
        spyWriter.prop((Object)"hashSize", this.hashSize);
        spyWriter.prop((Object)"threshold", this.threshold);
        spyWriter.prop((Object)"rehashCnt", this.rehashCnt);
        int n = 0;
        while (n < this.table.length) {
            entry = this.table[n];
            while (entry != null) {
                DeviceFacets.TimedInvocation timedInvocation = (DeviceFacets.TimedInvocation)entry.value;
                spyWriter.prop((Object)Integer.toString(n, 16), (Object)timedInvocation.getName());
                entry = entry.hashNext;
            }
            ++n;
        }
        spyWriter.endProps();
    }

    private final /* synthetic */ void this() {
        this.loadFactor = 0.75f;
        this.rehashCnt = 0;
    }

    public TimedCoalesceQueue(int n) {
        this.this();
        this.maxSize = n;
        this.table = new Entry[n / 3];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    public TimedCoalesceQueue() {
        this(Integer.MAX_VALUE);
    }

    static class Entry {
        Entry next;
        Object value;
        int hash;
        Entry hashNext;

        Entry(Object object) {
            this.value = object;
        }
    }

    public static interface ITimed {
        public long getTime();
    }
}

