/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BLonRouteTable;
import com.tridium.lonworks.enums.BLonRouterMode;
import com.tridium.lonworks.enums.BLonRouterType;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryStatusResponse;
import com.tridium.lonworks.netmessages.RouterStatusRequest;
import com.tridium.lonworks.netmessages.RouterStatusResponse;
import com.tridium.lonworks.netmessages.SetRouterModeRequest;
import com.tridium.lonworks.netmessages.TableClear;
import com.tridium.lonworks.netmessages.TableDownload;
import com.tridium.lonworks.netmessages.TableReportRequest;
import com.tridium.lonworks.netmessages.TableReportResponse;
import com.tridium.lonworks.netmessages.UpdateDomainRequest;
import com.tridium.lonworks.netmessages.WriteMemRequest;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAuthenticationKey;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.sys.BValue;

public class RouterUtil
implements NetMessages,
NetMgmtConst {
    public static void setTemporaryBridge(BLonNetwork bLonNetwork) {
        BLonRouter[] bLonRouterArray = bLonNetwork.getLonRouters();
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < bLonRouterArray.length) {
                if (bLonRouterArray[n] != null) {
                    try {
                        RouterUtil.setRouterMode(bLonRouterArray[n], BLonRouterMode.temporaryBridge);
                        bl = true;
                        bLonRouterArray[n] = null;
                    }
                    catch (Throwable throwable) {}
                }
                ++n;
            }
        }
    }

    public static void clearTemporaryBridge(BLonNetwork bLonNetwork) {
        BLonRouter[] bLonRouterArray = bLonNetwork.addressManager().getRouterList();
        int n = 0;
        while (n < bLonRouterArray.length) {
            try {
                RouterUtil.setRouterMode(bLonRouterArray[n], bLonRouterArray[n].getRouterMode());
            }
            catch (Throwable throwable) {}
            ++n;
        }
    }

    public static void setRouterType(BLonRouter bLonRouter, BLonRouterType bLonRouterType) throws LonException {
        RouterUtil.setRouterType(bLonRouter.lonComm(), bLonRouter.getNeuronIdAddress(), bLonRouterType, bLonRouter.getNearDeviceData().getAuthenticate(), false);
        RouterUtil.setRouterType(bLonRouter.lonComm(), bLonRouter.getNeuronIdAddress(), bLonRouterType, bLonRouter.getNearDeviceData().getAuthenticate(), true);
    }

    public static void setRouterType(LonComm lonComm, LonAddress lonAddress, BLonRouterType bLonRouterType, boolean bl, boolean bl2) throws LonException {
        byte[] byArray = new byte[]{(byte)bLonRouterType.getOrdinal()};
        WriteMemRequest writeMemRequest = new WriteMemRequest(2, 55, 1, 4, byArray);
        writeMemRequest.setAuthenticate(bl);
        if (bl2) {
            writeMemRequest.setFarSide();
        }
        writeMemRequest.setTransmitTimer(BLonRepeatTimer.milliSec256);
        lonComm.sendRequest(lonAddress, writeMemRequest);
    }

    public static void setRouterMode(BLonRouter bLonRouter, BLonRouterMode bLonRouterMode) throws LonException {
        RouterUtil.setRouterMode(bLonRouter.lonComm(), bLonRouter.getNeuronIdAddress(), bLonRouterMode, bLonRouter.getNearDeviceData().getAuthenticate());
    }

    public static void setRouterMode(LonComm lonComm, LonAddress lonAddress, BLonRouterMode bLonRouterMode, boolean bl) throws LonException {
        SetRouterModeRequest setRouterModeRequest = new SetRouterModeRequest(bLonRouterMode.getOrdinal());
        setRouterModeRequest.setAuthenticate(bl);
        setRouterModeRequest.setTransmitTimer(BLonRepeatTimer.milliSec256);
        lonComm.sendRequest(lonAddress, setRouterModeRequest);
    }

    public static BLonRouterType getRouterType(BLonRouter bLonRouter, boolean bl) throws LonException {
        int n = RouterUtil.getRouterStatus(bLonRouter, bl).getType();
        return BLonRouterType.make(n);
    }

    public static BLonRouterMode getRouterMode(BLonRouter bLonRouter, boolean bl) throws LonException {
        int n = RouterUtil.getRouterStatus(bLonRouter, bl).getMode();
        return BLonRouterMode.make(n);
    }

    public static void uploadTypeAndMode(BLonRouter bLonRouter) throws LonException {
        RouterStatusResponse routerStatusResponse = RouterUtil.getRouterStatus(bLonRouter, false);
        bLonRouter.set(BLonRouter.routerType, (BValue)BLonRouterType.make(routerStatusResponse.getType()), BLonNetwork.lonNoWrite);
        bLonRouter.set(BLonRouter.routerMode, (BValue)BLonRouterMode.make(routerStatusResponse.getMode()), BLonNetwork.lonNoWrite);
    }

    public static RouterStatusResponse getRouterStatus(BLonRouter bLonRouter, boolean bl) throws LonException {
        return RouterUtil.getRouterStatus(bLonRouter.lonComm(), bLonRouter.getNeuronIdAddress(), bLonRouter.getNearDeviceData().getAuthenticate(), bl);
    }

    public static RouterStatusResponse getRouterStatus(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        RouterStatusRequest routerStatusRequest = new RouterStatusRequest();
        if (bl2) {
            routerStatusRequest.setFarSide();
        }
        routerStatusRequest.setAuthenticate(bl);
        routerStatusRequest.setTransmitTimer(BLonRepeatTimer.milliSec256);
        return (RouterStatusResponse)lonComm.sendRequest(lonAddress, routerStatusRequest);
    }

    public static void uploadRouterTables(BLonRouter bLonRouter) throws LonException {
        BNeuronId bNeuronId = bLonRouter.getNeuronIdAddress();
        LonComm lonComm = bLonRouter.lonComm();
        boolean bl = bLonRouter.getNearDeviceData().getAuthenticate();
        QueryStatusResponse queryStatusResponse = NmUtil.queryStatus(lonComm, bNeuronId, 1, bl, false);
        if (queryStatusResponse.versionNumber < 5) {
            return;
        }
        int n = bLonRouter.getNearDeviceData().getWorkingDomain();
        byte[] byArray = RouterUtil.getRouterTable(lonComm, bNeuronId, n, 1, 0, bl, false);
        bLonRouter.setNearGroupTable(BLonRouteTable.make(byArray));
        byArray = RouterUtil.getRouterTable(lonComm, bNeuronId, n, 0, 0, bl, false);
        bLonRouter.setNearSubnetTable(BLonRouteTable.make(byArray));
        byArray = RouterUtil.getRouterTable(lonComm, bNeuronId, n, 1, 0, bl, true);
        bLonRouter.setFarGroupTable(BLonRouteTable.make(byArray));
        byArray = RouterUtil.getRouterTable(lonComm, bNeuronId, n, 0, 0, bl, true);
        bLonRouter.setFarSubnetTable(BLonRouteTable.make(byArray));
    }

    public static byte[] getRouterTable(LonComm lonComm, LonAddress lonAddress, int n, int n2, int n3, boolean bl, boolean bl2) throws LonException {
        byte[] byArray = new byte[32];
        int n4 = 0;
        while (n4 < 4) {
            TableReportRequest tableReportRequest = new TableReportRequest(n2, n, n3, n4);
            if (bl2) {
                tableReportRequest.setFarSide();
            }
            tableReportRequest.setAuthenticate(bl);
            tableReportRequest.setTransmitTimer(BLonRepeatTimer.milliSec256);
            TableReportResponse tableReportResponse = (TableReportResponse)lonComm.sendRequest(lonAddress, tableReportRequest);
            System.arraycopy(tableReportResponse.getTable(), 0, byArray, 8 * n4, 8);
            ++n4;
        }
        return byArray;
    }

    public static void downloadRouterTables(BLonRouter bLonRouter) throws LonException {
        BNeuronId bNeuronId = bLonRouter.getNeuronIdAddress();
        boolean bl = bLonRouter.getNearDeviceData().getAuthenticate();
        int n = bLonRouter.getNearDeviceData().getWorkingDomain();
        LonComm lonComm = bLonRouter.lonComm();
        RouterUtil.downloadTable(lonComm, bNeuronId, n, 1, bl, false, bLonRouter.getNearGroupTable());
        RouterUtil.downloadTable(lonComm, bNeuronId, n, 0, bl, false, bLonRouter.getNearSubnetTable());
        RouterUtil.downloadTable(lonComm, bNeuronId, n, 1, bl, true, bLonRouter.getFarGroupTable());
        RouterUtil.downloadTable(lonComm, bNeuronId, n, 0, bl, true, bLonRouter.getFarSubnetTable());
        RouterUtil.setRouterMode(bLonRouter, BLonRouterMode.initRouterTable);
        RouterUtil.setRouterMode(bLonRouter, BLonRouterMode.normal);
    }

    public static void downloadTable(LonComm lonComm, LonAddress lonAddress, int n, int n2, boolean bl, boolean bl2, BLonRouteTable bLonRouteTable) throws LonException {
        int n3 = 0;
        while (n3 < 4) {
            byte[] byArray = bLonRouteTable.getSection(n3);
            TableDownload tableDownload = new TableDownload(n2, n, n3, byArray);
            if (bl2) {
                tableDownload.setFarSide();
            }
            tableDownload.setAuthenticate(bl);
            tableDownload.setTransmitTimer(BLonRepeatTimer.milliSec256);
            lonComm.sendRequest(lonAddress, tableDownload);
            ++n3;
        }
    }

    public static void updateTable(BLonRouter bLonRouter, int n, boolean bl, BLonRouteTable bLonRouteTable, BLonRouteTable bLonRouteTable2) throws LonException {
        BNeuronId bNeuronId = bLonRouter.getNeuronIdAddress();
        boolean bl2 = bLonRouter.getNearDeviceData().getAuthenticate();
        int n2 = bLonRouter.getNearDeviceData().getWorkingDomain();
        int n3 = 0;
        while (n3 < 4) {
            if (!bLonRouteTable2.sectionsEqual(bLonRouteTable, n3)) {
                byte[] byArray = bLonRouteTable.getSection(n3);
                TableDownload tableDownload = new TableDownload(n, n2, n3, byArray);
                if (bl) {
                    tableDownload.setFarSide();
                }
                tableDownload.setAuthenticate(bl2);
                tableDownload.setTransmitTimer(BLonRepeatTimer.milliSec256);
                bLonRouter.lonComm().sendRequest(bNeuronId, tableDownload);
            }
            ++n3;
        }
    }

    public static void clearRouterTables(BLonRouter bLonRouter) throws LonException {
        BNeuronId bNeuronId = bLonRouter.getNeuronIdAddress();
        boolean bl = bLonRouter.getNearDeviceData().getAuthenticate();
        int n = bLonRouter.getNearDeviceData().getWorkingDomain();
        LonComm lonComm = bLonRouter.lonComm();
        RouterUtil.clearTable(lonComm, bNeuronId, n, 1, bl, false);
        RouterUtil.clearTable(lonComm, bNeuronId, n, 0, bl, false);
        RouterUtil.clearTable(lonComm, bNeuronId, n, 1, bl, true);
        RouterUtil.clearTable(lonComm, bNeuronId, n, 0, bl, true);
        bLonRouter.setNearGroupTable(BLonRouteTable.DEFAULT);
        bLonRouter.setNearSubnetTable(BLonRouteTable.DEFAULT);
        bLonRouter.setFarGroupTable(BLonRouteTable.DEFAULT);
        bLonRouter.setFarSubnetTable(BLonRouteTable.DEFAULT);
    }

    public static void clearTable(LonComm lonComm, LonAddress lonAddress, int n, int n2, boolean bl, boolean bl2) throws LonException {
        int n3 = 0;
        while (n3 < 4) {
            TableClear tableClear = new TableClear(n2, n, n3);
            if (bl2) {
                tableClear.setFarSide();
            }
            tableClear.setAuthenticate(bl);
            tableClear.setTransmitTimer(BLonRepeatTimer.milliSec256);
            lonComm.sendRequest(lonAddress, tableClear);
            ++n3;
        }
    }

    public static void updateDomainTable(BLonNetmgmt bLonNetmgmt, BLonRouter bLonRouter) throws LonException {
        boolean bl = bLonRouter.getNearDeviceData().getAuthenticate();
        BDomainId bDomainId = bLonNetmgmt.getDomainId();
        BAuthenticationKey bAuthenticationKey = bLonNetmgmt.getAuthenticationKey();
        BNeuronId bNeuronId = bLonRouter.getNeuronIdAddress();
        LonComm lonComm = bLonRouter.lonComm();
        BDeviceData bDeviceData = bLonRouter.getNearDeviceData();
        int n = bDeviceData.getWorkingDomain();
        int n2 = 0;
        if (n == 0) {
            n2 = 1;
        }
        int n3 = n2;
        boolean bl2 = bDeviceData.getTwoDomains();
        int n4 = bDeviceData.getSubnetNodeId().getSubnetId();
        int n5 = bDeviceData.getSubnetNodeId().getNodeId();
        UpdateDomainRequest updateDomainRequest = new UpdateDomainRequest(n, bDomainId.getDomainId(), n4, n5, bDomainId.getLength(), bAuthenticationKey.getByteArray());
        updateDomainRequest.setAuthenticate(bl);
        updateDomainRequest.setTransmitTimer(BLonRepeatTimer.milliSec256);
        lonComm.sendRequest(bNeuronId, updateDomainRequest);
        if (bl2) {
            updateDomainRequest = bDomainId.isZeroLength() ? new UpdateDomainRequest(n3) : new UpdateDomainRequest(n3, new byte[6], n4, n5, 0, bAuthenticationKey.getByteArray());
            updateDomainRequest.setAuthenticate(bl);
            updateDomainRequest.setTransmitTimer(BLonRepeatTimer.milliSec256);
            lonComm.sendRequest(bNeuronId, updateDomainRequest);
        }
        bDeviceData = bLonRouter.getFarDeviceData();
        n4 = bDeviceData.getSubnetNodeId().getSubnetId();
        n5 = bDeviceData.getSubnetNodeId().getNodeId();
        updateDomainRequest = new UpdateDomainRequest(n, bDomainId.getDomainId(), n4, n5, bDomainId.getLength(), bAuthenticationKey.getByteArray());
        updateDomainRequest.setFarSide();
        updateDomainRequest.setAuthenticate(bl);
        updateDomainRequest.setTransmitTimer(BLonRepeatTimer.milliSec256);
        lonComm.sendRequest(bNeuronId, updateDomainRequest);
        if (bl2) {
            updateDomainRequest = bDomainId.isZeroLength() ? new UpdateDomainRequest(n3) : new UpdateDomainRequest(n3, new byte[6], n4, n5, 0, bAuthenticationKey.getByteArray());
            updateDomainRequest.setFarSide();
            updateDomainRequest.setAuthenticate(bl);
            updateDomainRequest.setTransmitTimer(BLonRepeatTimer.milliSec256);
            lonComm.sendRequest(bNeuronId, updateDomainRequest);
        }
    }
}

