/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QuerySNVTRequest;
import com.tridium.lonworks.netmessages.QuerySNVTResponse;
import com.tridium.lonworks.netmessages.ReadMemRequest;
import com.tridium.lonworks.netmessages.ReadMemResponse;
import com.tridium.lonworks.netmessages.WriteMemRequest;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.ExtendedSelfDoc;
import com.tridium.lonworks.util.selfdoc.SelfDoc;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonRepeatTimer;

public class Neuron
implements NetMessages,
NetMgmtConst {
    private static int MAX_DATA_LENGTH = 8;
    public static final int LOCATION_LENGTH = 6;

    public static void uploadDeviceData(BLonDevice bLonDevice) throws LonException {
        int n = 10;
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        byte[] byArray = Neuron.readMemory(1, bLonDevice, n, 16);
        int n2 = (byArray[11 - n] & 0xFF) << 8 | byArray[12 - n] & 0xFF;
        boolean bl = false;
        if (n2 == (char)-1) {
            bl = true;
        }
        bDeviceData.setBoolean(BDeviceData.hosted, bl, AddressManager.noDeviceChange);
        boolean bl2 = false;
        if ((byArray[21 - n] & 0x40) != 0) {
            bl2 = true;
        }
        bDeviceData.setBoolean(BDeviceData.twoDomains, bl2, AddressManager.noDeviceChange);
        int n3 = (byArray[22 - n] & 0xF0) >> 4;
        if (bLonDevice.isExtended()) {
            n3 = ExtendedSelfDoc.make(bLonDevice).getAddressCapacity();
        }
        bDeviceData.setInt(BDeviceData.addressCount, n3, AddressManager.noDeviceChange);
    }

    public static BProgramId getProgramId(BLonDevice bLonDevice) throws LonException {
        byte[] byArray = Neuron.readMemory(1, bLonDevice, 13, 8);
        return BProgramId.make(byArray);
    }

    public static BProgramId getProgramId(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 1, lonAddress, 13, 8, bl);
        return BProgramId.make(byArray);
    }

    public static BProgramId getProgramId(BLonRouter bLonRouter, boolean bl) throws LonException {
        byte[] byArray = Neuron.readMemory(bLonRouter.lonComm(), 1, NmUtil.getSendAddress(bLonRouter), 13, 8, Neuron.isAuth(bLonRouter, bl), bl);
        return BProgramId.make(byArray);
    }

    public static BNeuronId getNeuronId(BLonDevice bLonDevice) throws LonException {
        byte[] byArray = Neuron.readMemory(1, bLonDevice, 0, 6);
        return BNeuronId.make(byArray);
    }

    public static BNeuronId getNeuronId(BLonRouter bLonRouter, boolean bl) throws LonException {
        return Neuron.getNeuronId(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), Neuron.isAuth(bLonRouter, bl), bl);
    }

    public static BNeuronId getNeuronId(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 1, lonAddress, 0, 6, bl, bl2);
        return BNeuronId.make(byArray);
    }

    public static int getSnvtPtr(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 1, lonAddress, 11, 2, bl);
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public static int getVersion(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 0, lonAddress, 0, 1, bl);
        return byArray[0] & 0xFF;
    }

    public static boolean isHostedNode(BLonDevice bLonDevice) throws LonException {
        return Neuron.isHostedNode(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate());
    }

    public static boolean isHostedNode(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        int n = Neuron.getSnvtPtr(lonComm, lonAddress, bl);
        boolean bl2 = false;
        if (n == (char)-1) {
            bl2 = true;
        }
        return bl2;
    }

    public static boolean isTwoDomains(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 1, lonAddress, 21, 1, bl, bl2);
        boolean bl3 = false;
        if ((byArray[0] & 0x40) != 0) {
            bl3 = true;
        }
        return bl3;
    }

    public static int getNvCount(BLonDevice bLonDevice) throws LonException {
        return Neuron.getNvCount(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate());
    }

    public static int getNvCount(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 1, lonAddress, 10, 1, bl);
        return byArray[0] & 0x3F;
    }

    public static int getAliasOffset(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        if (Neuron.getSnvtPtr(lonComm, lonAddress, bl) != (char)-1) {
            return Neuron.getNvCount(lonComm, lonAddress, bl);
        }
        SelfDoc selfDoc = new SelfDoc(lonComm, lonAddress, bl, true, bl2);
        return selfDoc.getAliasOffset();
    }

    public static int getAddressCount(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        if (bl2) {
            return ExtendedSelfDoc.make(lonComm, lonAddress, bl).getAddressCapacity();
        }
        byte[] byArray = Neuron.readMemory(lonComm, 1, lonAddress, 22, 1, bl);
        int n = (byArray[0] & 0xF0) >> 4;
        if (Neuron.getVersion(lonComm, lonAddress, bl) >= 21) {
            byArray = Neuron.readMemory(lonComm, 1, lonAddress, 46, 1, bl);
            n = byArray[0] & 0xFF;
        }
        return n;
    }

    public static int getAliasCount(BLonDevice bLonDevice) throws LonException {
        return Neuron.getAliasCount(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate());
    }

    public static int getAliasCount(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 1, lonAddress, 36, 1, bl);
        return byArray[0] & 0x3F;
    }

    public static int getChannelId(BLonDevice bLonDevice) throws LonException {
        return Neuron.getChannelId(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate(), false);
    }

    public static int getChannelId(BLonRouter bLonRouter, boolean bl) throws LonException {
        return Neuron.getChannelId(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), Neuron.isAuth(bLonRouter, bl), bl);
    }

    public static int getChannelId(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 2, lonAddress, 0, 2, bl, bl2);
        return (0xFF & byArray[0]) << 8 | 0xFF & byArray[1];
    }

    public static byte[] getReadOnlyStruct(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        return Neuron.readTable(lonComm, lonAddress, 1, 38, bl, bl2);
    }

    public static byte[] getConfigStruct(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        return Neuron.readTable(lonComm, lonAddress, 2, 25, bl, bl2);
    }

    public static byte[] readTable(LonComm lonComm, LonAddress lonAddress, int n, int n2, boolean bl, boolean bl2) throws LonException {
        int n3 = 16;
        int n4 = 0;
        byte[] byArray = new byte[n2];
        while (n4 < n2) {
            if (n3 > n2 - n4) {
                n3 = n2 - n4;
            }
            byte[] byArray2 = Neuron.readMemory(lonComm, n, lonAddress, n4, n3, bl, bl2);
            System.arraycopy(byArray2, 0, byArray, n4, n3);
            n4 += n3;
        }
        return byArray;
    }

    public static void updateConfigData(BLonNetmgmt bLonNetmgmt, BLonDevice bLonDevice) throws LonException {
        Neuron.updateConfigData(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonNetmgmt, bLonDevice.getDeviceData(), false);
    }

    public static void updateConfigData(BLonNetmgmt bLonNetmgmt, BLonRouter bLonRouter, boolean bl) throws LonException {
        BDeviceData bDeviceData = bl ? bLonRouter.getFarDeviceData() : bLonRouter.getNearDeviceData();
        Neuron.updateConfigData(bLonRouter.lonComm(), bLonRouter.getNearDeviceData().getNeuronId(), bLonNetmgmt, bDeviceData, bl);
    }

    public static void updateConfigData(LonComm lonComm, LonAddress lonAddress, BLonNetmgmt bLonNetmgmt, BDeviceData bDeviceData, boolean bl) throws LonException {
        byte[] byArray;
        int n = bDeviceData.getChannelId();
        boolean bl2 = bDeviceData.getAuthenticate();
        byte[] byArray2 = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        Neuron.writeMemory(lonComm, 2, lonAddress, 0, 4, byArray2, bl2, bl);
        if (bDeviceData.getFreezeChannelPriorities()) {
            byArray = new byte[1];
        } else {
            byArray = new byte[2];
            byArray[1] = (byte)bLonNetmgmt.getChannelPriorities();
        }
        byArray[0] = (byte)bDeviceData.getPrioritySlot();
        Neuron.writeMemory(lonComm, 2, lonAddress, 15, 4, byArray, bl2, bl);
        Neuron.setLocation(lonComm, lonAddress, bDeviceData.getLocation(), bl2, bl);
        boolean bl3 = bLonNetmgmt.getAuthenticate();
        byte[] byArray3 = new byte[]{(byte)(bLonNetmgmt.getNonGroupTimer() << 4)};
        byArray3[0] = Neuron.setNMAuthenticateBit(byArray3[0], bl3);
        Neuron.writeMemory(lonComm, 2, lonAddress, 24, 4, byArray3, bl2, bl);
        bDeviceData.setAuthenticate(bl3);
    }

    public static void setNMAuthenticate(BLonDevice bLonDevice, boolean bl) throws LonException {
        Neuron.setNMAuthenticate(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bl);
    }

    public static void setNMAuthenticate(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 2, lonAddress, 24, 1, true);
        if (Neuron.isAuthBitSet(byArray[0]) == bl) {
            return;
        }
        byArray[0] = Neuron.setNMAuthenticateBit(byArray[0], bl);
        Neuron.writeMemory(lonComm, 2, lonAddress, 24, 4, byArray, true, false);
    }

    public static void verifyAuthenticate(BLonDevice bLonDevice) throws LonException {
        bLonDevice.getDeviceData().setAuthenticate(Neuron.isNMAuthSet(bLonDevice));
    }

    public static boolean isNMAuthSet(BLonDevice bLonDevice) throws LonException {
        return Neuron.isNMAuthSet(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate(), false);
    }

    public static boolean isNMAuthSet(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        byte[] byArray;
        try {
            byArray = Neuron.readMemory(lonComm, 2, lonAddress, 24, 1, bl, bl2);
        }
        catch (LonException lonException) {
            byArray = Neuron.readMemory(lonComm, 2, lonAddress, 24, 1, bl ^ true, bl2);
        }
        return Neuron.isAuthBitSet(byArray[0]);
    }

    public static boolean isAuthBitSet(byte by) throws LonException {
        boolean bl = false;
        if ((by & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    private static final byte setNMAuthenticateBit(byte by, boolean bl) {
        by = bl ? (byte)(by | 8) : (byte)(by & 0xFFFFFFF7);
        return by;
    }

    public static void setNodePriority(BLonDevice bLonDevice, int n) throws LonException {
        byte[] byArray = new byte[]{(byte)n};
        Neuron.writeMemory(2, bLonDevice, 15, 4, byArray);
    }

    public static int getNodePriority(BLonDevice bLonDevice) throws LonException {
        byte[] byArray = Neuron.readMemory(2, bLonDevice, 15, 1);
        return byArray[0] & 0xFF;
    }

    public static void setNodePriorityInfo(BLonDevice bLonDevice, int n, int n2) throws LonException {
        byte[] byArray = new byte[]{(byte)n, (byte)n2};
        Neuron.writeMemory(2, bLonDevice, 15, 4, byArray);
    }

    public static void setLocation(BLonDevice bLonDevice, String string) throws LonException {
        Neuron.setLocation(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), string, bLonDevice.getDeviceData().getAuthenticate(), false);
    }

    public static void setLocation(BLonRouter bLonRouter, String string, boolean bl) throws LonException {
        Neuron.setLocation(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), string, Neuron.isAuth(bLonRouter, bl), bl);
    }

    private static final boolean isAuth(BLonRouter bLonRouter, boolean bl) {
        return bl ? bLonRouter.getFarDeviceData().getAuthenticate() : bLonRouter.getNearDeviceData().getAuthenticate();
    }

    public static void setLocation(LonComm lonComm, LonAddress lonAddress, String string, boolean bl, boolean bl2) throws LonException {
        byte[] byArray;
        byte[] byArray2 = new byte[6];
        System.arraycopy(byArray, 0, byArray2, 0, (byArray = string.getBytes()).length <= 6 ? byArray.length : 6);
        Neuron.writeMemory(lonComm, 2, lonAddress, 2, 4, byArray2, bl, bl2);
    }

    public static String getLocation(BLonDevice bLonDevice) throws LonException {
        byte[] byArray = Neuron.readMemory(2, bLonDevice, 2, 6);
        return Neuron.getString(byArray, 0, 6);
    }

    public static String getLocation(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        byte[] byArray = Neuron.readMemory(lonComm, 2, lonAddress, 2, 6, bl);
        return Neuron.getString(byArray, 0, 6);
    }

    private static final String getString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            byte by;
            if ((by = byArray[n + n3++]) < 48 || by > 122) continue;
            stringBuffer.append((char)by);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : "";
    }

    public static byte[] readMemory(int n, BLonDevice bLonDevice, int n2, int n3) throws LonException {
        int n4 = bLonDevice.getMaxMessageLengthOut() - 1;
        if (n4 < MAX_DATA_LENGTH) {
            n4 = MAX_DATA_LENGTH;
        }
        return Neuron.readMemory(bLonDevice.lonComm(), n, NmUtil.getSendAddress(bLonDevice), n2, n3, bLonDevice.authenticate(), false, n4);
    }

    public static byte[] readMemory(LonComm lonComm, int n, LonAddress lonAddress, int n2, int n3, boolean bl) throws LonException {
        return Neuron.readMemory(lonComm, n, lonAddress, n2, n3, bl, false, MAX_DATA_LENGTH);
    }

    public static byte[] readMemory(LonComm lonComm, int n, LonAddress lonAddress, int n2, int n3, boolean bl, boolean bl2) throws LonException {
        return Neuron.readMemory(lonComm, n, lonAddress, n2, n3, bl, bl2, MAX_DATA_LENGTH);
    }

    public static byte[] readMemory(LonComm lonComm, int n, LonAddress lonAddress, int n2, int n3, boolean bl, boolean bl2, int n4) throws LonException {
        int n5 = 0;
        byte[] byArray = new byte[n3];
        while (n5 < n3) {
            int n6 = n3 - n5;
            if (n6 > n4) {
                n6 = n4;
            }
            ReadMemRequest readMemRequest = new ReadMemRequest(n, n2 + n5, n6);
            if (bl2) {
                readMemRequest.setFarSide();
            }
            readMemRequest.setAuthenticate(bl);
            ReadMemResponse readMemResponse = (ReadMemResponse)lonComm.sendRequest(lonAddress, readMemRequest);
            System.arraycopy(readMemResponse.getData(), 0, byArray, n5, n6);
            n5 += n6;
        }
        return byArray;
    }

    public static void writeMemory(int n, BLonDevice bLonDevice, int n2, int n3, byte[] byArray) throws LonException {
        int n4 = bLonDevice.getMaxMessageLengthIn() - 6;
        if (n4 < MAX_DATA_LENGTH) {
            n4 = MAX_DATA_LENGTH;
        }
        Neuron.writeMemory(bLonDevice.lonComm(), n, NmUtil.getSendAddress(bLonDevice), n2, n3, byArray, bLonDevice.authenticate(), false, n4);
    }

    public static void writeMemory(LonComm lonComm, int n, LonAddress lonAddress, int n2, int n3, byte[] byArray, boolean bl, boolean bl2) throws LonException {
        Neuron.writeMemory(lonComm, n, lonAddress, n2, n3, byArray, bl, bl2, MAX_DATA_LENGTH);
    }

    private static final void writeMemory(LonComm lonComm, int n, LonAddress lonAddress, int n2, int n3, byte[] byArray, boolean bl, boolean bl2, int n4) throws LonException {
        int n5 = 0;
        while (n5 < byArray.length) {
            int n6 = byArray.length - n5;
            if (n6 > n4) {
                n6 = n4;
            }
            WriteMemRequest writeMemRequest = new WriteMemRequest(n, n2 + n5, n6, n3, byArray, n6, n5);
            if (bl2) {
                writeMemRequest.setFarSide();
            }
            writeMemRequest.setAuthenticate(bl);
            writeMemRequest.setTransmitTimer(BLonRepeatTimer.milliSec384);
            writeMemRequest.setRetryCount(6);
            lonComm.sendRequest(lonAddress, writeMemRequest);
            n5 += n6;
        }
    }

    public static byte[] querySnvt(LonComm lonComm, LonAddress lonAddress, int n, int n2, boolean bl, int n3) throws LonException {
        int n4 = 0;
        byte[] byArray = new byte[n2];
        while (n4 < n2) {
            int n5 = n2 - n4;
            if (n5 > n3) {
                n5 = n3;
            }
            QuerySNVTRequest querySNVTRequest = new QuerySNVTRequest(n + n4, n5);
            querySNVTRequest.setAuthenticate(bl);
            QuerySNVTResponse querySNVTResponse = (QuerySNVTResponse)lonComm.sendRequest(lonAddress, querySNVTRequest);
            System.arraycopy(querySNVTResponse.getData(), 0, byArray, n4, n5);
            n4 += n5;
        }
        return byArray;
    }

    public static int getBufferCount(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 6: {
                n2 = 7;
                break;
            }
            case 7: {
                n2 = 11;
                break;
            }
            case 8: {
                n2 = 15;
                break;
            }
            case 9: {
                n2 = 23;
                break;
            }
            case 10: {
                n2 = 31;
                break;
            }
            case 11: {
                n2 = 47;
                break;
            }
            case 12: {
                n2 = 63;
                break;
            }
            case 13: {
                n2 = 95;
                break;
            }
            case 14: {
                n2 = 127;
                break;
            }
            case 15: {
                n2 = 191;
                break;
            }
        }
        return n2;
    }

    public static int getBufferSize(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 255;
                break;
            }
            case 2: {
                n2 = 20;
                break;
            }
            case 3: {
                n2 = 21;
                break;
            }
            case 4: {
                n2 = 22;
                break;
            }
            case 5: {
                n2 = 24;
                break;
            }
            case 6: {
                n2 = 26;
                break;
            }
            case 7: {
                n2 = 30;
                break;
            }
            case 8: {
                n2 = 34;
                break;
            }
            case 9: {
                n2 = 42;
                break;
            }
            case 10: {
                n2 = 50;
                break;
            }
            case 11: {
                n2 = 66;
                break;
            }
            case 12: {
                n2 = 82;
                break;
            }
            case 13: {
                n2 = 114;
                break;
            }
            case 14: {
                n2 = 146;
                break;
            }
            case 15: {
                n2 = 210;
                break;
            }
        }
        return n2;
    }

    public static void verifyChannelPriorities(BLonNetwork bLonNetwork) {
        int n;
        BLonNetmgmt bLonNetmgmt = bLonNetwork.netmgmt();
        BLonDevice[] bLonDeviceArray = bLonNetwork.getLonDevices();
        BLonDevice[] bLonDeviceArray2 = new BLonDevice[255];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        while (n4 < bLonDeviceArray.length) {
            BLonDevice bLonDevice = bLonDeviceArray[n4];
            n = bLonDevice.getDeviceData().getPrioritySlot();
            if (n > 0) {
                ++n2;
                if (bLonDeviceArray2[n] != null) {
                    bl = true;
                } else {
                    bLonDeviceArray2[n] = bLonDevice;
                }
                if (n > n3) {
                    n3 = n;
                }
            }
            ++n4;
        }
        try {
            boolean bl2;
            int n5 = 0;
            if (bl || n3 != n2) {
                n5 = 1;
            }
            n4 = n5;
            boolean bl3 = false;
            if (n2 != bLonNetmgmt.getChannelPriorities()) {
                bl3 = true;
            }
            if (bl2 = bl3) {
                bLonNetmgmt.setChannelPriorities(n2);
            }
            if (bl2 || n4 != 0) {
                n = 2;
                int n6 = 0;
                while (n6 < bLonDeviceArray.length) {
                    BLonDevice bLonDevice = bLonDeviceArray[n6];
                    BDeviceData bDeviceData = bLonDevice.getDeviceData();
                    if (!bLonDevice.isLocal() && bDeviceData.getPrioritySlot() > 0) {
                        bDeviceData.setPrioritySlot(n++);
                    }
                    Neuron.setNodePriorityInfo(bLonDevice, bDeviceData.getPrioritySlot(), n2);
                    ++n6;
                }
            }
        }
        catch (LonException lonException) {
            System.out.println("Failure in verifyChannelPriorities()" + (Object)((Object)lonException));
        }
    }
}

