/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.sys.BajaRuntimeException;

public class LonFileUtil {
    public static BIFile getFile(String string) {
        try {
            return (BIFile)BOrd.make((String)LonFileUtil.fixFilename(string)).resolve().get();
        }
        catch (Throwable throwable) {
            throw new BajaRuntimeException("Unable to access file " + string, throwable);
        }
    }

    public static BIFile getFile(BDirectory bDirectory, String string) {
        try {
            return bDirectory.getFileSpace().findFile(LonFileUtil.getFilePath(bDirectory, string));
        }
        catch (Throwable throwable) {
            throw new BajaRuntimeException("Unable to access file " + string + " in " + bDirectory.getFilePath().getBody(), throwable);
        }
    }

    private static final FilePath getFilePath(BDirectory bDirectory, String string) {
        return new FilePath(bDirectory.getFilePath().getBody() + '/' + string);
    }

    public static BDirectory getDirectory(String string) {
        try {
            BAbstractFile bAbstractFile = (BAbstractFile)BOrd.make((String)LonFileUtil.fixFilename(string)).resolve().get();
            if (!bAbstractFile.isDirectory()) {
                throw new RuntimeException(string + " is not a directory.");
            }
            return (BDirectory)bAbstractFile;
        }
        catch (Throwable throwable) {
            throw new BajaRuntimeException("Unable to access directory " + string, throwable);
        }
    }

    public static BIFile getOrMakeFile(BDirectory bDirectory, String string) {
        try {
            FilePath filePath = LonFileUtil.getFilePath(bDirectory, string);
            BIFile bIFile = bDirectory.getFileSpace().makeFile(filePath);
            return bIFile;
        }
        catch (Throwable throwable) {
            throw new BajaRuntimeException("Unable to create directory " + string, throwable);
        }
    }

    private static final String fixFilename(String string) {
        String string2 = string.replace('\\', '/');
        return "file:/" + string2;
    }
}

