/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.tool;

import com.tridium.lonworks.CancelOperationException;
import com.tridium.lonworks.resource.Conversion;
import com.tridium.lonworks.resource.CrossReference;
import com.tridium.lonworks.resource.ResourceFileUtil;
import com.tridium.lonworks.resource.TypeFile;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.util.XLonUtil;
import com.tridium.lonworks.util.xif.XifToXDevice;
import com.tridium.lonworks.xml.LonXMLWriter;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.SortUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonXmlCreate {
    static OutputStream nullStream = new OutputStream(){

        public final void close() {
        }

        public final void flush() {
        }

        public final void write(byte[] byArray) {
        }

        public final void write(byte[] byArray, int n, int n2) {
        }

        public final void write(int n) {
        }
    };
    static PrintStream nullOut = new PrintStream(nullStream);
    static String[] unitStrings = null;
    static String[] symbolStrings = null;
    static Hashtable convStringMap = new Hashtable();
    static final UiLexicon lex;
    BDirectory workDir;
    BDataFile xifFile;
    BDirectory resDir;
    boolean useZero;
    PrintStream out;
    BWidget parent;
    static /* synthetic */ Class class$com$tridium$lonworks$ui$tool$BLonXmlCreate;
    static /* synthetic */ Class class$java$lang$String;

    public static void createLnml(BDirectory bDirectory, BDataFile bDataFile, BDirectory bDirectory2, PrintStream printStream, BWidget bWidget, boolean bl) {
        LonXmlCreate lonXmlCreate = new LonXmlCreate(bDirectory, bDataFile, bDirectory2, printStream, bWidget, bl);
        lonXmlCreate.create();
    }

    private final void create() {
        try {
            String string = this.xifFile.getFileName();
            string = NameUtil.toJavaName(string.substring(0, string.lastIndexOf(".")), true);
            this.out.println("Parse xif file : " + this.xifFile.getFileName());
            XLonDevice xLonDevice = XifToXDevice.convert((BIFile)this.xifFile, nullOut, null);
            byte[] byArray = xLonDevice.deviceData.programID;
            this.out.println("Program id : " + LonByteArrayUtil.toString(byArray) + '\n');
            CrossReference crossReference = null;
            if (this.resDir != null) {
                this.out.println("Create cross reference ");
                crossReference = new CrossReference(this.out);
                crossReference.setUnitPrompt(new UnitDialog(crossReference));
                this.findDataFiles(byArray, crossReference);
                xLonDevice = XifToXDevice.convert((BIFile)this.xifFile, this.out, crossReference);
                this.out.println();
            }
            xLonDevice.setName(string);
            xLonDevice.useZeroBasedArrays = this.useZero;
            XLonInterfaceFile xLonInterfaceFile = new XLonInterfaceFile();
            xLonInterfaceFile.setName(xLonDevice.getName());
            xLonInterfaceFile.addAttribute("", xLonDevice);
            if (crossReference != null) {
                this.processDataFile(xLonInterfaceFile, crossReference);
            }
            BIFile bIFile = this.workDir.getFileSpace().makeFile(this.workDir.getFilePath().merge(new FilePath(string + ".lnml")));
            this.out.println("create device file : " + bIFile.getFilePath().getBody());
            OutputStream outputStream = null;
            try {
                outputStream = bIFile.getOutputStream();
                LonXMLWriter lonXMLWriter = new LonXMLWriter(outputStream, false);
                lonXMLWriter.encode(xLonInterfaceFile);
                outputStream.close();
            }
            catch (IOException iOException) {
                if (outputStream != null) {
                    outputStream.close();
                }
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            this.out.println(throwable);
            throwable.printStackTrace();
        }
    }

    private final void findDataFiles(byte[] byArray, CrossReference crossReference) {
        BIFile[] bIFileArray = this.resDir.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            String string = bIFileArray[n].getExtension();
            if (string != null && string.equalsIgnoreCase("typ")) {
                int n2;
                TypeFile typeFile = null;
                try {
                    typeFile = (TypeFile)ResourceFileUtil.getResourceFile(bIFileArray[n]);
                }
                catch (Throwable throwable) {
                    this.out.println(throwable);
                }
                if (typeFile != null && this.compareArray(typeFile.refId, byArray, n2 = this.getLengthToComp(typeFile.scope))) {
                    String string2 = bIFileArray[n].getFileName();
                    this.out.println("Add resouceFile " + string2);
                    try {
                        crossReference.addResource(this.resDir, string2, typeFile);
                    }
                    catch (CrossReference.DuplicateResourceException duplicateResourceException) {
                        throw new BajaRuntimeException((Throwable)duplicateResourceException);
                    }
                }
            }
            ++n;
        }
    }

    private final void processDataFile(XLonInterfaceFile xLonInterfaceFile, CrossReference crossReference) {
        try {
            BDirectory bDirectory = this.workDir.getFileSpace().makeDir(this.workDir.getFilePath().merge(new FilePath("datatypes")));
            TypeFile[] typeFileArray = crossReference.getTypeFiles(true);
            int n = 0;
            while (n < typeFileArray.length) {
                TypeFile typeFile = typeFileArray[n];
                String string = NameUtil.getFileNameFromPath(typeFile.fileName, true);
                string = NameUtil.toJavaName(string, true);
                XLonInterfaceFile xLonInterfaceFile2 = XLonUtil.resourceToXLonFile(typeFile, crossReference, this.out);
                xLonInterfaceFile2.setName(string);
                BIFile bIFile = bDirectory.getFileSpace().makeFile(bDirectory.getFilePath().merge(new FilePath(string + ".lnml")));
                this.out.println("create data file : " + bIFile.getFilePath().getBody());
                OutputStream outputStream = bIFile.getOutputStream();
                LonXMLWriter lonXMLWriter = new LonXMLWriter(outputStream, false);
                lonXMLWriter.encode(xLonInterfaceFile2);
                outputStream.close();
                xLonInterfaceFile2.setFile("datatypes/" + string + ".lnml");
                xLonInterfaceFile.addAttribute(string, xLonInterfaceFile2);
                crossReference.flush();
                crossReference.clearMarks();
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final boolean compareArray(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        if (n == 0) {
            return true;
        }
        if (byArray[0] != 15) {
            if ((byArray[0] & 0xF) != (byArray2[0] & 0xF)) {
                return false;
            }
            n2 = byArray[0] >> 4 & 0xF;
            int n3 = byArray2[0] >> 4 & 0xF;
            if (n2 != 8 && n2 != 9 || n3 != 8 && n3 != 9) {
                return false;
            }
        }
        n2 = 1;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final int getLengthToComp(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 8;
            }
        }
        throw new RuntimeException("Invalid scope " + n);
    }

    void addUnitStrings(BList bList) {
        if (unitStrings == null) {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = LonXmlCreate.class("[Ljava.lang.String;", false);
            }
            Array array = new Array(clazz);
            Class clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = LonXmlCreate.class("[Ljava.lang.String;", false);
            }
            Array array2 = new Array(clazz2);
            UnitDatabase.Quantity[] quantityArray = UnitDatabase.getDefault().getQuantities();
            int n = 0;
            while (n < quantityArray.length) {
                BUnit[] bUnitArray = quantityArray[n].getUnits();
                int n2 = 0;
                while (n2 < bUnitArray.length) {
                    array.add((Object)bUnitArray[n2].getUnitName());
                    array2.add((Object)bUnitArray[n2].getSymbol());
                    ++n2;
                }
                ++n;
            }
            unitStrings = (String[])array.trim();
            symbolStrings = (String[])array2.trim();
            SortUtil.sort((Object[])unitStrings, (Object[])symbolStrings);
        }
        int n = 0;
        while (n < unitStrings.length) {
            bList.addItem((Object)unitStrings[n]);
            ++n;
        }
    }

    int bestQuess(String string) {
        int n;
        if (unitStrings.length != symbolStrings.length) {
            return 0;
        }
        String string2 = string.toLowerCase();
        if (string2.endsWith("s")) {
            string2 = string2.substring(0, string2.length() - 1);
            n = 0;
            while (n < unitStrings.length) {
                if (string2.equals(unitStrings[n])) {
                    return n;
                }
                ++n;
            }
        }
        n = 0;
        while (n < symbolStrings.length) {
            if (string2.equalsIgnoreCase(symbolStrings[n])) {
                return n;
            }
            ++n;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " -_");
        String string3 = stringTokenizer.nextToken();
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        int n4 = 0;
        while (n4 < unitStrings.length) {
            int n5 = unitStrings[n4].indexOf(string3);
            if (n5 >= 0 && n5 < n2) {
                n2 = n5;
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private LonXmlCreate(BDirectory bDirectory, BDataFile bDataFile, BDirectory bDirectory2, PrintStream printStream, BWidget bWidget, boolean bl) {
        this.workDir = bDirectory;
        this.xifFile = bDataFile;
        this.resDir = bDirectory2;
        this.out = printStream;
        this.parent = bWidget;
        this.useZero = bl;
    }

    static {
        Class clazz = class$com$tridium$lonworks$ui$tool$BLonXmlCreate;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$ui$tool$BLonXmlCreate = LonXmlCreate.class("[Lcom.tridium.lonworks.ui.tool.BLonXmlCreate;", false);
        }
        lex = new UiLexicon(clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UnitDialog
    extends Conversion.UnitPrompt {
        CrossReference cr;

        public String getUserString(int n, int n2, String string) {
            String string2;
            BListDropDown bListDropDown = new BListDropDown();
            BList bList = bListDropDown.getList();
            bList.removeAllItems();
            bList.addItem((Object)"");
            LonXmlCreate.this.addUnitStrings(bList);
            if (convStringMap.containsKey(string)) {
                string2 = (String)convStringMap.get(string);
                bList.setSelectedIndex(bList.indexOfItem((Object)string2));
            } else {
                bList.setSelectedIndex(LonXmlCreate.this.bestQuess(string) + 1);
            }
            string2 = "unknown";
            try {
                string2 = this.cr.getLanguageFile((int)n).fileName;
            }
            catch (Throwable throwable) {}
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("lonXmlEngUnit.file")));
            bGridPane.add(null, (BValue)new BTextField(string2, 40, false));
            bGridPane.add(null, (BValue)new BLabel(lex.getText("lonXmlEngUnit.scopeIndex")));
            bGridPane.add(null, (BValue)new BTextField(Integer.toString(n) + '/' + n2, 40, false));
            bGridPane.add(null, (BValue)new BLabel(lex.getText("lonXmlEngUnit.original")));
            bGridPane.add(null, (BValue)new BTextField(string, 40, false));
            bGridPane.add(null, (BValue)new BLabel(lex.getText("lonXmlEngUnit.newText")));
            bGridPane.add(null, (BValue)bListDropDown);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane);
            int n3 = BDialog.open((BWidget)LonXmlCreate.this.parent, (String)lex.getText("lonXmlEngUnit.title"), (Object)bBorderPane, (int)3, null, (String)lex.getText("lonXmlEngUnit.explain"));
            String string3 = "???";
            if (n3 == 1) {
                string3 = (String)bList.getSelectedItem();
            }
            if (n3 == 2) {
                throw new CancelOperationException();
            }
            LonXmlCreate.this.out.println("Convert eu \"" + string + "\" to \"" + string3 + '\"');
            convStringMap.put(string, string3);
            return string3;
        }

        UnitDialog(CrossReference crossReference) {
            this.cr = crossReference;
        }
    }
}

