/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.device;

import com.tridium.lonworks.datatypes.BAppDownloadParameter;
import com.tridium.lonworks.datatypes.BCommissionParameter;
import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.datatypes.BMatchParameter;
import com.tridium.lonworks.netmgmt.BLonCommissionJob;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonReplaceJob;
import com.tridium.lonworks.netmgmt.BLonServicePinJob;
import com.tridium.lonworks.ui.BCommReplDialog;
import com.tridium.lonworks.ui.ServicePinMonitor;
import com.tridium.lonworks.ui.device.BAppDownLoadPane;
import com.tridium.lonworks.ui.device.BLonDeviceManager;
import com.tridium.lonworks.ui.tool.BLonXmlOptions;
import com.tridium.lonworks.util.DeviceDef;
import com.tridium.lonworks.util.LonStringUtil;
import com.tridium.lonworks.util.NxeUtil;
import com.tridium.lonworks.util.XLonUtil;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.ui.BOptionDialog;
import java.util.ArrayList;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonDeviceController
extends DeviceController {
    public final MgrController.MgrCommand lonDiscover;
    public final MgrController.MgrCommand commission;
    public final MgrController.MgrCommand replace;
    public final MgrController.MgrCommand quikLearn;
    public final MgrController.MgrCommand appDownLoad;
    public final MgrController.MgrCommand clearTable;
    public final UseNetAddressToggle useNetAddrToggle;
    public final UseDbAddressToggle useDbAddrToggle;
    BLonXmlOptions opts;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonDevice;

    protected MgrController.IMgrCommand[] makeCommands() {
        return new MgrController.IMgrCommand[]{this.newFolder, this.allDescendants, this.newCommand, this.edit, this.learnMode, this.lonDiscover, this.cancel, this.add, this.match, this.quickMatch, this.quickAdd, this.commission, this.replace, this.quikLearn, this.appDownLoad, this.useNetAddrToggle, this.useDbAddrToggle, this.clearTable};
    }

    public void updateCommands() {
        super.updateCommands();
        BLonDevice[] bLonDeviceArray = this.getSelectedDevices();
        boolean bl = false;
        if (bLonDeviceArray.length > 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.netmgmt().getEnabled() && this.getNetwork().getEnabled()) {
            bl4 = true;
        }
        boolean bl5 = bl4 ^ true;
        boolean bl6 = true;
        if (bl2) {
            BProgramId bProgramId = bLonDeviceArray[0].getDeviceData().getProgramId();
            int n = 0;
            while (n < bLonDeviceArray.length) {
                BLonDevice bLonDevice = bLonDeviceArray[n];
                BDeviceData bDeviceData = bLonDevice.getDeviceData();
                BStatus bStatus = bLonDevice.getStatus();
                if (bStatus.isDown()) {
                    bl6 = false;
                }
                if (bStatus.isFault() || bStatus.isDisabled()) {
                    bl6 = false;
                    bl5 = true;
                }
                if (bDeviceData.getNeuronId().isZero() || bLonDevice.isLocal() || bDeviceData.getHosted() || n > 0 && !bProgramId.getMfgId().equals((Object)bDeviceData.getProgramId().getMfgId())) {
                    bl6 = false;
                }
                if (bLonDevice.isLocal()) {
                    bl3 = true;
                }
                ++n;
            }
        }
        boolean bl7 = false;
        if (!bl5 && bl2 && bl6) {
            bl7 = true;
        }
        this.appDownLoad.setEnabled(bl7);
        boolean bl8 = false;
        if (!bl5 && bl2) {
            bl8 = true;
        }
        this.commission.setEnabled(bl8);
        boolean bl9 = false;
        if (!bl5 && bl2 && !bl3) {
            bl9 = true;
        }
        this.replace.setEnabled(bl9);
        boolean bl10 = false;
        if (!bl5 && !bl3) {
            bl10 = true;
        }
        this.quikLearn.setEnabled(bl10);
        this.lonDiscover.setEnabled(this.getNetwork().getEnabled());
    }

    public BWidget makeActionBar() {
        MgrController.IMgrCommand[] iMgrCommandArray = new MgrController.IMgrCommand[]{this.newFolder, this.newCommand, this.edit, this.learnMode, this.lonDiscover, this.cancel, this.add, this.match};
        MgrController.IMgrCommand[] iMgrCommandArray2 = new MgrController.IMgrCommand[]{this.commission, this.replace, this.quikLearn, this.appDownLoad};
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop(this.makeActionPane(iMgrCommandArray));
        bEdgePane.setCenter((BWidget)new BBorderPane(this.makeActionPane(iMgrCommandArray2)));
        return bEdgePane;
    }

    public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand iMgrCommand) {
        if (iMgrCommand == this.match) {
            return new MgrController.IMgrCommand[]{this.useNetAddrToggle, this.useDbAddrToggle};
        }
        return null;
    }

    protected CommandArtifact doMatch(final Object object, final BComponent bComponent, Context context) throws Exception {
        MgrEdit mgrEdit = new MgrEdit(this.getManager(), this.match.getLabel()){

            public final CommandArtifact commit() throws Exception {
                return LonDeviceController.this.doMatchCommit(object, bComponent, this);
            }
        };
        MgrEditRow mgrEditRow = mgrEdit.addRow(bComponent);
        this.getManager().getLearn().toRow(object, mgrEditRow);
        return mgrEdit.invoke(context);
    }

    private final CommandArtifact doMatchCommit(Object object, BComponent bComponent, MgrEdit mgrEdit) throws Exception {
        BLonDeviceManager bLonDeviceManager = (BLonDeviceManager)this.getManager();
        MgrEditRow mgrEditRow = mgrEdit.getRows()[0];
        BLonDevice bLonDevice = (BLonDevice)bComponent;
        int n = ((BInteger)mgrEditRow.getCell(bLonDeviceManager.colSubnet)).getInt();
        int n2 = ((BInteger)mgrEditRow.getCell(bLonDeviceManager.colNode)).getInt();
        BProgramId bProgramId = (BProgramId)mgrEditRow.getCell(bLonDeviceManager.colProgramId);
        boolean bl = ((BDeviceEntry)((Object)object)).getAuthenticate();
        BDeviceEntry bDeviceEntry = new BDeviceEntry(mgrEditRow.getName(), (BLonNodeState)mgrEditRow.getCell(bLonDeviceManager.colState), n, n2, (BNeuronId)mgrEditRow.getCell(bLonDeviceManager.colNeuronId), bProgramId, ((BInteger)mgrEditRow.getCell(bLonDeviceManager.colChannelId)).getInt(), bl, ((BInteger)mgrEditRow.getCell(bLonDeviceManager.colWorkDomain)).getInt());
        BSubnetNode bSubnetNode = bLonDevice.getDeviceData().getSubnetNodeId();
        BMatchParameter bMatchParameter = new BMatchParameter(bSubnetNode, bDeviceEntry);
        if (!this.netmgmt().match(bMatchParameter).getBoolean()) {
            throw new BajaRuntimeException("Address " + n + '/' + n2 + " already in use.");
        }
        BDeviceEntryTable bDeviceEntryTable = this.netmgmt().getDeviceDiscoverTable();
        bDeviceEntryTable.removeEntry((BDeviceEntry)((Object)object));
        if (bLonDevice.getType().is(BDynamicDevice.TYPE)) {
            BDynamicDevice bDynamicDevice = (BDynamicDevice)bLonDevice;
            bDynamicDevice.getDeviceData().setAuthenticate(bl);
            if (bDynamicDevice.getXmlFile() == BOrd.NULL) {
                DeviceDef deviceDef = new DeviceDef(bProgramId);
                BOrd bOrd = null;
                if (deviceDef.isXml()) {
                    bOrd = deviceDef.getXmlOrd();
                }
                if (bOrd != null) {
                    bDynamicDevice.setXmlFile(bOrd);
                    BProgramId bProgramId2 = bDynamicDevice.getDeviceData().getProgramId();
                    BImportParameters bImportParameters = new BImportParameters(false, this.netmgmt().getUseLonObjects());
                    bDynamicDevice.doImportXml(bImportParameters, this.getNetwork().log());
                    if (!bProgramId2.isZero()) {
                        bDynamicDevice.getDeviceData().setProgramId(bProgramId2);
                    }
                    bLonDeviceManager.registerForComponentEvents(bDynamicDevice.getDeviceData(), 0);
                }
            }
        }
        bLonDeviceManager.reloadValue();
        return null;
    }

    public void doAllDescendants(boolean bl) {
        if (bl) {
            ((BLonDeviceManager)this.getManager()).loadDescendants();
        }
        ((BLonDeviceManager)this.getManager()).getModel().getTable().reload();
    }

    public CommandArtifact doClearDiscover() {
        this.netmgmt().getDeviceDiscoverTable().clearEntries();
        ((BLonDeviceManager)this.getManager()).updateDiscoveryRows(this.netmgmt().getDeviceDiscoverTable());
        return null;
    }

    public CommandArtifact doCommission() {
        BLonNetmgmt bLonNetmgmt = this.netmgmt();
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        BLonDevice[] bLonDeviceArray = this.getSelectedDevices();
        if (bLonDeviceArray.length == 1) {
            Object object;
            BNeuronId bNeuronId;
            int n;
            BLonDevice bLonDevice = bLonDeviceArray[0];
            BDeviceData bDeviceData = bLonDevice.getDeviceData();
            if (bLonDevice.isLocal()) {
                n = 1;
                bNeuronId = bDeviceData.getNeuronId();
            } else {
                object = this.devicePopup("Commission", bDeviceData);
                n = object.getResult();
                bNeuronId = object.getSelectedNeuronId();
            }
            if (n == 1) {
                this.setJob(bLonNetmgmt.commissionDevice(new BCommissionParameter(bDeviceData.getSubnetNodeId(), bNeuronId, false)));
            } else if (n == BCommReplDialog.SERVICE_PIN) {
                object = (BLonCommissionJob)this.setJob(bLonNetmgmt.commissionDevice(new BCommissionParameter(bDeviceData.getSubnetNodeId(), true)));
                this.getManager().attach((BWbComponentView.Attachable)new ServicePinMonitor((BWbComponentView)this.getManager(), (BLonServicePinJob)object));
            }
        } else {
            BSubnetNode[] bSubnetNodeArray = this.getSubnetNodes(bLonDeviceArray);
            this.setJob(bLonNetmgmt.commissionDevice(new BCommissionParameter(bSubnetNodeArray)));
        }
        return null;
    }

    public CommandArtifact doReplace() {
        BLonNetmgmt bLonNetmgmt = this.netmgmt();
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        BLonDevice[] bLonDeviceArray = this.getSelectedDevices();
        if (bLonDeviceArray.length == 1) {
            BLonDevice bLonDevice = bLonDeviceArray[0];
            BDeviceData bDeviceData = bLonDevice.getDeviceData();
            BCommReplDialog bCommReplDialog = this.devicePopup("Replace", bDeviceData);
            int n = bCommReplDialog.getResult();
            BNeuronId bNeuronId = bCommReplDialog.getSelectedNeuronId();
            if (n == 1) {
                this.setJob(bLonNetmgmt.replaceDevice(new BCommissionParameter(bDeviceData.getSubnetNodeId(), bNeuronId, false)));
            } else if (n == BCommReplDialog.SERVICE_PIN) {
                BLonReplaceJob bLonReplaceJob = (BLonReplaceJob)this.setJob(bLonNetmgmt.replaceDevice(new BCommissionParameter(bDeviceData.getSubnetNodeId(), true)));
                this.getManager().attach((BWbComponentView.Attachable)new ServicePinMonitor((BWbComponentView)this.getManager(), bLonReplaceJob));
            }
        } else {
            BSubnetNode[] bSubnetNodeArray = new BSubnetNode[bLonDeviceArray.length];
            int n = 0;
            while (n < bLonDeviceArray.length) {
                bSubnetNodeArray[n] = bLonDeviceArray[n].getDeviceData().getSubnetNodeId();
                ++n;
            }
            this.setJob(bLonNetmgmt.replaceDevice(new BCommissionParameter(bSubnetNodeArray)));
        }
        return null;
    }

    public CommandArtifact doAppDownLoad() {
        BLonNetmgmt bLonNetmgmt = this.netmgmt();
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        BLonDevice[] bLonDeviceArray = this.getSelectedDevices();
        try {
            BProgramId bProgramId;
            Object object;
            BAppDownLoadPane bAppDownLoadPane = new BAppDownLoadPane(this.lex(), this.opts);
            int n = BDialog.open((BWidget)this.getManager(), (String)"Enter Download Files", (Object)((Object)bAppDownLoadPane), (int)3);
            if (n == 2) {
                return null;
            }
            BOrd bOrd = bAppDownLoadPane.getAppOrd();
            BOrd bOrd2 = bAppDownLoadPane.getXifOrd();
            BOrd bOrd3 = bAppDownLoadPane.getLnmlOrd();
            BIFile bIFile = null;
            BIFile bIFile2 = null;
            BIFile bIFile3 = null;
            if (bOrd != BOrd.NULL && !this.verifyFileType(bIFile = (BIFile)bOrd.resolve().get(), "nxe")) {
                bIFile = null;
            }
            if (bOrd2 != BOrd.NULL && !this.verifyFileType(bIFile2 = (BIFile)bOrd2.resolve().get(), "xif")) {
                bIFile2 = null;
            }
            if (bOrd3 != BOrd.NULL && !this.verifyFileType(bIFile3 = (BIFile)bOrd3.resolve().get(), "lnml")) {
                bIFile3 = null;
            }
            boolean bl = bAppDownLoadPane.useZeroCb();
            this.opts.setUseZeroBased(bl);
            this.opts.save();
            if (bIFile == null) {
                return null;
            }
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setRowGap(10.0);
            if (bIFile != null) {
                bGridPane.add(null, (BValue)new BLabel("This action will download " + bIFile.getFileName() + '.'));
            }
            if (bIFile2 != null) {
                bGridPane.add(null, (BValue)new BLabel("This action will update device from " + bIFile2.getFileName() + '.'));
            } else if (bIFile3 != null) {
                bGridPane.add(null, (BValue)new BLabel("This action will update device from " + bIFile3.getFileName() + '.'));
            }
            bGridPane.add(null, (BValue)new BLabel("This is an irreversible action."));
            bGridPane.add(null, (BValue)new BLabel("Is this the desired operation and correct file(s) ."));
            if (BDialog.confirm((BWidget)this.getManager(), (String)"Confirm Application Download", (Object)bGridPane) != 4) {
                return null;
            }
            BSubnetNode[] bSubnetNodeArray = this.getSubnetNodes(bLonDeviceArray);
            BAppDownloadParameter bAppDownloadParameter = new BAppDownloadParameter(bSubnetNodeArray);
            byte[] byArray = NxeUtil.nxeFileToByteArray(bIFile);
            BProgramId bProgramId2 = NxeUtil.findProgramId(byArray);
            bAppDownloadParameter.setAppFile(BBlob.make((byte[])byArray));
            XLonInterfaceFile xLonInterfaceFile = null;
            XLonDevice xLonDevice = null;
            if (bIFile2 != null) {
                xLonDevice = XLonUtil.xifToXDevice(bIFile2);
                xLonDevice.useZeroBasedArrays = bl;
                object = BProgramId.make(xLonDevice.deviceData.programID);
                if (!bProgramId2.equals(object)) {
                    BDialog.error((BWidget)this.getManager(), (Object)"Specified files are for different device types.");
                    return null;
                }
                bAppDownloadParameter.setNvDirFile(BBlob.make((byte[])NxeUtil.getNvDirectionByteArray(xLonDevice)));
            } else if (bIFile3 != null) {
                xLonInterfaceFile = LonXMLReader.decode(bIFile3);
                object = xLonInterfaceFile.getLonDevice();
                bProgramId = BProgramId.make(object.deviceData.programID);
                if (!bProgramId2.equals((Object)bProgramId)) {
                    BDialog.error((BWidget)this.getManager(), (Object)"Specified files are for different device types.");
                    return null;
                }
                bAppDownloadParameter.setNvDirFile(BBlob.make((byte[])NxeUtil.getNvDirectionByteArray(object)));
            }
            if (!this.verifyProgramId(bProgramId2, bLonDeviceArray)) {
                return null;
            }
            int n2 = 0;
            while (n2 < bLonDeviceArray.length) {
                bProgramId = bLonDeviceArray[n2].getDeviceData().getProgramId();
                if (xLonDevice != null) {
                    NxeUtil.updateDevice(bLonDeviceArray[n2], xLonDevice);
                } else if (xLonInterfaceFile != null) {
                    NxeUtil.updateDevice(bLonDeviceArray[n2], xLonInterfaceFile);
                } else {
                    bLonDeviceArray[n2].getDeviceData().setProgramId(bProgramId2);
                }
                if (bLonDeviceArray[n2] instanceof BDynamicDevice && !bProgramId.equals((Object)bProgramId2)) {
                    ((BDynamicDevice)bLonDeviceArray[n2]).setXmlFile(bOrd3);
                }
                ++n2;
            }
            bAppDownloadParameter.setBind(bAppDownLoadPane.isBindSelected());
            this.setJob(bLonNetmgmt.appDownLoad(bAppDownloadParameter));
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this.getManager(), (String)"Error:", (Object)exception, (Throwable)exception);
            return null;
        }
        return null;
    }

    private final boolean verifyFileType(BIFile bIFile, String string) {
        if (!bIFile.getExtension().equalsIgnoreCase(string)) {
            BDialog.error((BWidget)this.getManager(), (Object)("Invalid file extension. Expected \"." + string + '\"'));
            return false;
        }
        return true;
    }

    private final boolean verifyProgramId(BProgramId bProgramId, BLonDevice[] bLonDeviceArray) {
        int n = 0;
        while (n < bLonDeviceArray.length) {
            BProgramId bProgramId2 = bLonDeviceArray[n].getDeviceData().getProgramId();
            if (!bProgramId.equals((Object)bProgramId2)) {
                int n2;
                if (!bProgramId.getMfgId().equals((Object)bProgramId2.getMfgId())) {
                    n2 = this.confirm((BWidget)this.getManager(), "Confirm Manufacturers Change", "Application for " + bLonDeviceArray[n].getDisplayName(null) + " is by diferent Manufacturer\nThe device may not be able to execute this application.\n\nContinue operation.");
                    if (n2 == 8) {
                        return false;
                    }
                    if (n2 == 2) {
                        return true;
                    }
                } else {
                    n2 = this.confirm((BWidget)this.getManager(), "Confirm ProgramId Change", "Application for " + bLonDeviceArray[n].getDisplayName(null) + " has different ProgramId than device.\n\nContinue operation.");
                    if (n2 == 8) {
                        return false;
                    }
                    if (n2 == 2) {
                        return true;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    private final int confirm(BWidget bWidget, String string, Object object) {
        int n = 14;
        BImage bImage = BDialog.QUESTION_ICON;
        String string2 = null;
        BLabel bLabel = new BLabel(String.valueOf(object), BHalign.left);
        BOptionDialog bOptionDialog = new BOptionDialog(bWidget, string, (BWidget)bLabel, n, bImage, string2);
        bOptionDialog.getCancelButton().setText("Yes To All");
        bOptionDialog.setBoundsCenteredOnOwner();
        bOptionDialog.open();
        return bOptionDialog.getResult();
    }

    public CommandArtifact doQuikLearn() {
        BLonNetmgmt bLonNetmgmt = this.netmgmt();
        int[] nArray = this.getSelectedRows();
        boolean bl = false;
        if (nArray.length > 0) {
            bl = true;
        }
        boolean bl2 = bl;
        BGridPane bGridPane = new BGridPane(1);
        BCheckBox bCheckBox = new BCheckBox(this.lex().getText("learnPopup.unmanaged"));
        BCheckBox bCheckBox2 = new BCheckBox(this.lex().getText("learnPopup.learnLinks"));
        BCheckBox bCheckBox3 = new BCheckBox(this.lex().getText("learnPopup.upload"), true);
        if (bl2) {
            bGridPane.add(null, (BValue)new BLabel(this.lex().getText("learnPopup.learnLinksSelected")));
        } else {
            bGridPane.add(null, (BValue)bCheckBox);
            bGridPane.add(null, (BValue)bCheckBox2);
            bGridPane.add(null, (BValue)bCheckBox3);
        }
        int n = BDialog.open((BWidget)this.getManager(), (String)"Learn", (Object)bGridPane, (int)3);
        if (n == 2) {
            return null;
        }
        BLearnParameter bLearnParameter = new BLearnParameter();
        bLearnParameter.setUnmanagedNetwork(bCheckBox.isSelected());
        bLearnParameter.setLearnLinks(bCheckBox2.isSelected());
        bLearnParameter.setUploadConfigData(bCheckBox3.isSelected());
        bLearnParameter.setContainer(((BComponent)this.getManager().getCurrentValue()).getOrdInSession());
        if (bl2) {
            BLonDevice[] bLonDeviceArray = this.getSelectedDevices();
            BSimple[] bSimpleArray = new BSubnetNode[bLonDeviceArray.length];
            int n2 = 0;
            while (n2 < bLonDeviceArray.length) {
                bSimpleArray[n2] = bLonDeviceArray[n2].getDeviceData().getSubnetNodeId();
                ++n2;
            }
            bLearnParameter.setSubnetNodeArray(LonStringUtil.toString(bSimpleArray));
            this.setJob(bLonNetmgmt.learn(bLearnParameter));
        } else {
            this.setJob(bLonNetmgmt.learn(bLearnParameter));
        }
        return null;
    }

    public void setUseNetAddress(boolean bl) {
        ((BLonDeviceManager)this.getManager()).setUseNetAddress(bl);
        this.useNetAddrToggle.doSetSelected(bl);
        this.useDbAddrToggle.doSetSelected(bl ^ true);
    }

    private final BLonNetmgmt netmgmt() {
        return ((BLonDeviceManager)this.getManager()).getNetwork().netmgmt();
    }

    private final BLonNetwork getNetwork() {
        return ((BLonDeviceManager)this.getManager()).getNetwork();
    }

    private final BSubnetNode[] getSubnetNodes(BLonDevice[] bLonDeviceArray) {
        BSubnetNode[] bSubnetNodeArray = new BSubnetNode[bLonDeviceArray.length];
        int n = 0;
        while (n < bLonDeviceArray.length) {
            bSubnetNodeArray[n] = bLonDeviceArray[n].getDeviceData().getSubnetNodeId();
            ++n;
        }
        return bSubnetNodeArray;
    }

    private final UiLexicon lex() {
        return BLonDeviceManager.lexicon;
    }

    private final BCommReplDialog devicePopup(String string, BDeviceData bDeviceData) {
        Object object;
        BNeuronId[] bNeuronIdArray;
        BNeuronId bNeuronId = bDeviceData.getNeuronId();
        BProgramId bProgramId = bDeviceData.getProgramId();
        if (!bNeuronId.equals(BNeuronId.DEFAULT)) {
            bNeuronIdArray = new BNeuronId[]{bNeuronId};
        } else {
            object = new ArrayList();
            BDeviceEntry[] bDeviceEntryArray = this.netmgmt().getDeviceDiscoverTable().getDeviceEntries();
            int n = 0;
            while (n < bDeviceEntryArray.length) {
                BDeviceEntry bDeviceEntry = bDeviceEntryArray[n];
                if ((bDeviceEntry.getDevName() == null || bDeviceEntry.getDevName().equals("")) && (bProgramId == null || bDeviceEntry.getProgramId().equals((Object)bProgramId))) {
                    ((ArrayList)object).add(bDeviceEntry.getNeuronId());
                }
                ++n;
            }
            BNeuronId[] bNeuronIdArray2 = new BNeuronId[((ArrayList)object).size()];
            bNeuronIdArray = ((ArrayList)object).toArray(bNeuronIdArray2);
        }
        object = new BCommReplDialog((BWidget)this.getManager(), string, bNeuronIdArray);
        object.setBoundsCenteredOnOwner();
        object.open();
        return object;
    }

    private final BJob setJob(BOrd bOrd) {
        try {
            BComponent bComponent = (BComponent)this.getManager().getCurrentValue();
            bComponent.getComponentSpace().sync();
            BJob bJob = (BJob)bOrd.get((BObject)bComponent);
            this.getManager().registerForComponentEvents((BComponent)bJob);
            ((BLonDeviceManager)this.getManager()).getJobBar().load(bJob);
            return bJob;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    private final BLonDevice[] getSelectedDevices() {
        if (this.getTable() == null) {
            return new BLonDevice[0];
        }
        BComponent[] bComponentArray = this.getTable().getSelectedComponents();
        Class clazz = class$javax$baja$lonworks$BLonDevice;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonDevice = LonDeviceController.class("[Ljavax.baja.lonworks.BLonDevice;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n].getType().is(BLonDevice.TYPE)) {
                array.add((Object)bComponentArray[n]);
            }
            ++n;
        }
        return (BLonDevice[])array.trim();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.opts = BLonXmlOptions.make();
    }

    LonDeviceController(BLonDeviceManager bLonDeviceManager) {
        super((BDeviceManager)bLonDeviceManager);
        this.this();
        this.commission = new Commission((BWidget)bLonDeviceManager);
        this.replace = new Replace((BWidget)bLonDeviceManager);
        this.quikLearn = new QuikLearn((BWidget)bLonDeviceManager);
        this.appDownLoad = new AppDownLoad((BWidget)bLonDeviceManager);
        this.useNetAddrToggle = new UseNetAddressToggle((BWidget)bLonDeviceManager);
        this.useDbAddrToggle = new UseDbAddressToggle((BWidget)bLonDeviceManager);
        this.clearTable = new ClearTable((BWidget)bLonDeviceManager);
        this.lonDiscover = new LonDiscover((BWidget)bLonDeviceManager);
        this.lonDiscover.setFlags(7);
        this.commission.setFlags(7);
        this.replace.setFlags(7);
        this.quikLearn.setFlags(7);
        this.appDownLoad.setFlags(7);
        this.useNetAddrToggle.setFlags(1);
        this.useDbAddrToggle.setFlags(1);
        this.clearTable.setFlags(16);
        this.setUseNetAddress(bLonDeviceManager.isUseNetAddress());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UseNetAddressToggle
    extends MgrController.MgrToggleCommand {
        public void setSelected(boolean bl) {
            LonDeviceController.this.setUseNetAddress(bl);
        }

        public void doSetSelected(boolean bl) {
            super.setSelected(bl);
        }

        UseNetAddressToggle(BWidget bWidget) {
            super(bWidget, (Lexicon)LonDeviceController.this.lex(), "commands.useNetAddress");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UseDbAddressToggle
    extends MgrController.MgrToggleCommand {
        public void setSelected(boolean bl) {
            LonDeviceController.this.setUseNetAddress(bl ^ true);
        }

        public void doSetSelected(boolean bl) {
            super.setSelected(bl);
        }

        UseDbAddressToggle(BWidget bWidget) {
            super(bWidget, (Lexicon)LonDeviceController.this.lex(), "commands.useDbAddress");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Commission
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doCommission();
        }

        Commission(BWidget bWidget) {
            super(bWidget, (Lexicon)LonDeviceController.this.lex(), "commands.commission");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Replace
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doReplace();
        }

        Replace(BWidget bWidget) {
            super(bWidget, (Lexicon)LonDeviceController.this.lex(), "commands.replace");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class QuikLearn
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doQuikLearn();
        }

        QuikLearn(BWidget bWidget) {
            super(bWidget, (Lexicon)LonDeviceController.this.lex(), "commands.quikLearn");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AppDownLoad
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doAppDownLoad();
        }

        AppDownLoad(BWidget bWidget) {
            super(bWidget, (Lexicon)LonDeviceController.this.lex(), "commands.appDownLoad");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ClearTable
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doClearDiscover();
        }

        ClearTable(BWidget bWidget) {
            super(bWidget, (Lexicon)LonDeviceController.this.lex(), "commands.clearDiscoverTable");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LonDiscover
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            LonDeviceController.this.learnMode.setSelected(true);
            LonDeviceController.this.setJob(LonDeviceController.this.netmgmt().discover());
            return null;
        }

        LonDiscover(BWidget bWidget) {
            super(bWidget, (Lexicon)LonDeviceController.this.lex(), "commands.discover");
        }
    }
}

