/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.device;

import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.ui.device.BLonDeviceManager;
import com.tridium.lonworks.util.DeviceDef;
import javax.baja.gx.BImage;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class DeviceLearn
extends MgrLearn {
    static Lexicon lex = BLonDeviceManager.lexicon;
    static BImage deviceIcon = BImage.make((BIcon)BIcon.std((String)"device.png"));

    protected final BWidget makeJobBar() {
        return null;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(lex.getText("device.columnTitle.state"), BDeviceEntry.state, 0), new MgrColumn.Prop(lex.getText("device.columnTitle.channelId"), BDeviceEntry.channelId, 3), new MgrColumn.Prop(lex.getText("device.columnTitle.subnet"), BDeviceEntry.subnet, 1), new MgrColumn.Prop(lex.getText("device.columnTitle.node"), BDeviceEntry.node, 1), new MfgIdColumn(), new MgrColumn.Prop(lex.getText("device.columnTitle.programId"), BDeviceEntry.programId, 0), new MgrColumn.Prop(lex.getText("device.columnTitle.neuronId"), BDeviceEntry.neuronId, 0)};
    }

    public boolean isMatchable(Object object, BComponent bComponent) {
        BLonDevice bLonDevice = (BLonDevice)bComponent;
        if (bLonDevice.isLocal()) {
            return false;
        }
        BProgramId bProgramId = ((BDeviceEntry)((Object)object)).getProgramId();
        BProgramId bProgramId2 = bLonDevice.getDeviceData().getProgramId();
        return this.programIdsMatch(bProgramId, bProgramId2);
    }

    private final boolean programIdsMatch(BProgramId bProgramId, BProgramId bProgramId2) {
        if (bProgramId.isZero() || bProgramId2.isZero() || bProgramId.equals((Object)bProgramId2)) {
            return true;
        }
        DeviceDef deviceDef = new DeviceDef(bProgramId);
        return deviceDef.wildCardMatch(bProgramId2);
    }

    public BImage getIcon(Object object) {
        return deviceIcon;
    }

    public MgrTypeInfo[] toTypes(Object object) {
        BProgramId bProgramId = ((BDeviceEntry)((Object)object)).getProgramId();
        return ((BLonDeviceManager.LonDeviceModel)this.getManager().getModel()).getNewTypes(bProgramId);
    }

    public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
        int n;
        int n2;
        int n3;
        BDeviceEntry bDeviceEntry = (BDeviceEntry)((Object)object);
        BDeviceData bDeviceData = ((BLonDevice)mgrEditRow.getTarget()).getDeviceData();
        BLonDeviceManager bLonDeviceManager = (BLonDeviceManager)mgrEditRow.getManager();
        if (bLonDeviceManager.isUseNetAddress()) {
            n3 = bDeviceEntry.getSubnet();
            n2 = bDeviceEntry.getNode();
            n = bDeviceEntry.getChannelId();
            mgrEditRow.setCell(bLonDeviceManager.colState, (BValue)bDeviceEntry.getState());
        } else {
            BSubnetNode bSubnetNode = bDeviceData.getSubnetNodeId();
            n3 = bSubnetNode.getSubnetId();
            n2 = bSubnetNode.getNodeId();
            n = bDeviceData.getChannelId();
            mgrEditRow.setCell(bLonDeviceManager.colState, (BValue)bDeviceData.getNodeState());
        }
        mgrEditRow.setDefaultName(mgrEditRow.getType().getDisplayName());
        mgrEditRow.setCell(bLonDeviceManager.colChannelId, (BValue)BInteger.make((int)n));
        mgrEditRow.setCell(bLonDeviceManager.colSubnet, (BValue)BInteger.make((int)n3));
        mgrEditRow.setCell(bLonDeviceManager.colNode, (BValue)BInteger.make((int)n2));
        mgrEditRow.setCell(bLonDeviceManager.colProgramId, (BValue)bDeviceEntry.getProgramId());
        mgrEditRow.setCell(bLonDeviceManager.colNeuronId, (BValue)bDeviceEntry.getNeuronId());
        mgrEditRow.setCell(bLonDeviceManager.colWorkDomain, (BValue)BInteger.make((int)bDeviceEntry.getWorkingDomain()));
    }

    DeviceLearn(BLonDeviceManager bLonDeviceManager) {
        super((BAbstractManager)bLonDeviceManager);
    }

    static class MfgIdColumn
    extends MgrColumn {
        public Object get(Object object) {
            return ((BDeviceEntry)((Object)object)).getMfgId().getConvertedName();
        }

        public MfgIdColumn() {
            super(lex.getText("device.columnTitle.mfgId"), 0);
        }
    }
}

